/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.pilots.html4.CSSAttribs;
import ice.pilots.html4.DAttr;
import ice.pilots.html4.DElement;
import ice.pilots.html4.DIFrameElement;
import ice.pilots.html4.ObjectBox;
import ice.pilots.html4.ObjectPainter;
import ice.pilots.html4.ObjectPool;
import ice.storm.LPilot;
import ice.storm.Pilot;
import ice.storm.StormBase;
import ice.storm.Viewport;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;

public class EmbeddedObject
extends Viewport
implements ObjectPainter {
    private static int embed_counter = 0;
    private DElement element;
    ObjectBox box;
    private int defaultHeight = 10;
    private int defaultWidth = 10;

    EmbeddedObject(StormBase storm, DElement e) {
        super(storm, EmbeddedObject.getViewportName(e));
        this.element = e;
        this.element.getPilot().getPilotViewport().addChild(this);
    }

    private static String getViewportName(DElement e) {
        ++embed_counter;
        String vname = e.getAttribute(63);
        if (vname == null && (vname = e.getAttribute(50)) == null) {
            vname = "embed" + embed_counter;
        }
        return vname;
    }

    void setDefaultSize(int w, int h) {
        this.defaultWidth = w;
        this.defaultHeight = h;
    }

    public void dispose() {
        Container c;
        if (this.container != null && (c = this.container.getParent()) != null) {
            c.remove(this.container);
        }
        this.element = null;
        this.box = null;
        super.dispose();
    }

    public void setForeground(Color c) {
    }

    public void setBackground(Color c) {
    }

    public void setBorderVisible(boolean aDrawBorder) {
    }

    public void setFontHints(CSSAttribs css) {
    }

    public void setBox(ObjectBox box) {
        this.box = box;
        if (this.container != null) {
            this.element.getPilot().getCSSLayout().docPane.checkAwtTree(box, this.container);
        }
    }

    public ObjectBox getBox() {
        return this.box;
    }

    public void setPainterSize(int w, int h) {
        if (this.container != null) {
            this.container.setSize(w, h);
            return;
        }
        Pilot pilot = this.getPilot();
        if (pilot instanceof LPilot) {
            ((LPilot)pilot).setSize(w, h);
        }
    }

    public int getPrefWidth() {
        if (this.container != null) {
            Dimension d = this.container.getPreferredSize();
            if (d != null) {
                return d.width;
            }
        } else {
            Pilot pilot = this.getPilot();
            if (pilot instanceof LPilot) {
                return ((LPilot)pilot).getWidth();
            }
        }
        return this.defaultWidth;
    }

    public int getPrefHeight() {
        if (this.container != null) {
            Dimension d = this.container.getPreferredSize();
            if (d != null) {
                return d.height;
            }
        } else {
            Pilot pilot = this.getPilot();
            if (pilot instanceof LPilot) {
                return ((LPilot)pilot).getHeight();
            }
        }
        return this.defaultHeight;
    }

    public void draw(Graphics g) {
        if (this.container != null) {
            if (this.container.isVisible()) {
                return;
            }
            g.setColor(Color.lightGray);
            Dimension d = this.container.getSize();
            g.drawRect(0, 0, d.width - 1, d.height - 1);
        } else {
            Pilot pilot = this.getPilot();
            if (pilot instanceof LPilot) {
                ((LPilot)pilot).paint(g);
            }
        }
    }

    public void setPilot(Pilot p) {
        if (p instanceof LPilot) {
            if (this.pilot != null) {
                this.removePilot();
            }
            this.pilot = p;
        } else {
            super.setPilot(p);
            Component c = this.getPilotComponent();
            if (c != null && this.container == null) {
                this.container = this.element.getPilot().getCSSLayout().docPane.createEmbeddedContainer(this, c);
            }
        }
    }

    public Container getContainer() {
        if (this.container == null) {
            return this.element.getPilot().getViewportContainer();
        }
        return this.container;
    }

    public void onElementAttrChange(DElement elem, DAttr attr) {
        if (attr.nameId == 119 || attr.nameId == 45) {
            this.element.doc.mutate();
            this.element.doc.pilot.getCSSLayout().validateLayout();
        } else if (elem.tagId == 45) {
            DIFrameElement iframeElem = (DIFrameElement)elem;
            ObjectPool objectPool = iframeElem.getPilot().objectPool;
            objectPool.loadIFrame(iframeElem, this);
        }
    }

    public int getClientWidth() {
        return this.container.getSize().width;
    }

    public int getClientHeight() {
        return this.container.getSize().height;
    }
}

