/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.pilots.html4.CSSUtil;
import ice.pilots.html4.DDocument;
import ice.pilots.html4.DOMEvent;
import ice.pilots.html4.FormSubmitData;
import ice.pilots.html4.FormTypeElement;
import ice.storm.DynEnv;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.w3c.dom.html.HTMLTextAreaElement;

public class DTextAreaElement
extends FormTypeElement
implements HTMLTextAreaElement {
    private String defaultValue;
    public static final int DEFAULT_ROWS_COUNT = 3;
    public static final int DEFAULT_COLS_COUNT = 20;
    private static final int Field_accessKey = 1;
    private static final int Field_cols = 2;
    private static final int Field_defaultValue = 3;
    private static final int Field_disabled = 4;
    private static final int Field_form = 5;
    private static final int Field_readOnly = 7;
    private static final int Field_rows = 8;
    private static final int Field_tabIndex = 9;
    private static final int Field_type = 10;
    private static final int Field_value = 11;
    private static final int Method_blur = -1;
    private static final int Method_focus = -2;
    private static final int Method_select = -3;

    protected DTextAreaElement(DDocument doc, int id) {
        super(doc, id);
    }

    public String getDefaultValue() {
        if (this.defaultValue == null) {
            this.recordDefaultValue();
        }
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String getAccessKey() {
        return this.getAttribute(4);
    }

    public void setAccessKey(String accessKey) {
        this.setAttribute(4, accessKey);
    }

    public boolean getDisabled() {
        return this.getAttribute(38) != null;
    }

    public void setDisabled(boolean disabled) {
        this.setAttribute(38, disabled ? "disabled" : null);
    }

    public boolean getReadOnly() {
        return this.getAttribute(89) != null;
    }

    public void setReadOnly(boolean readOnly) {
        this.setAttribute(89, readOnly ? "readonly" : null);
    }

    public int getTabIndex() {
        return -1;
    }

    public void setTabIndex(int tabIndex) {
    }

    public String getType() {
        return "textarea";
    }

    public String getValue() {
        if (this.defaultValue == null) {
            this.recordDefaultValue();
        }
        return this.getAttribute(114);
    }

    private String script_getValue() {
        String result = this.getValue();
        if (result == null) {
            result = "";
        }
        return result;
    }

    public void setValue(String value) {
        this.setAttribute(114, value);
    }

    public void dispatchSelection(int start, int end) {
        DOMEvent de = this.doc.createDOMEvent(17);
        de.target = this;
        this.doc.processEvent(de);
    }

    public int getCols() {
        int cols = 20;
        String colsStr = this.getAttribute(28);
        if (colsStr != null) {
            cols = CSSUtil.parseInt(colsStr, cols);
        }
        return cols;
    }

    public void setCols(int value) {
        this.setAttribute(28, Integer.toString(value));
    }

    public int getRows() {
        int rows = 3;
        String rowsStr = this.getAttribute(92);
        if (rowsStr != null) {
            rows = CSSUtil.parseInt(rowsStr, rows);
        }
        return rows;
    }

    public void setRows(int value) {
        this.setAttribute(92, Integer.toString(value));
    }

    public void blur() {
        this.doc.getDomView().processBlurCall(this);
    }

    public void focus() {
        this.doc.getDomView().processFocusCall(this);
    }

    public void select() {
        this.doc.getDomView().processSelectCall(this);
    }

    void recordData(FormSubmitData data, Object submitSource) {
        if (!this.getDisabled()) {
            data.appendData(this.getNameForServer(), this.fixValue(this.getValue()));
        }
    }

    void reset() {
        this.setValue(this.getDefaultValue());
    }

    private void recordDefaultValue() {
        Node n = this.getFirstChild();
        if (n != null && n instanceof Text) {
            String s = ((Text)n).getData();
            this.setDefaultValue(s);
            this.setValue(s);
        } else {
            this.setDefaultValue("");
            this.setValue("");
        }
    }

    public void dispatchChange() {
        DOMEvent de = this.doc.createDOMEvent(18);
        de.target = this;
        this.doc.processEvent(de);
    }

    public Object getDynamicValue(String name, DynEnv env) {
        int id = DTextAreaElement.toDynamicId(name);
        if (id < 0) {
            return env.wrapMethod(this, name);
        }
        if (id > 0) {
            return this.getDynamicValue(id, env);
        }
        return super.getDynamicValue(name, env);
    }

    public int setDynamicValue(String name, Object value, DynEnv env) {
        int id = DTextAreaElement.toDynamicId(name);
        if (id < 0) {
            return 2;
        }
        if (id > 0) {
            return this.setDynamicValue(id, value, env);
        }
        return super.setDynamicValue(name, value, env);
    }

    public Object execDynamicMethod(String name, Object[] args, DynEnv env) {
        int id = DTextAreaElement.toDynamicId(name);
        if (id < 0) {
            return this.execDynamicMethod(id, args, env);
        }
        return super.execDynamicMethod(name, args, env);
    }

    private Object getDynamicValue(int key_id, DynEnv env) {
        switch (key_id) {
            case 1: {
                return this.getAccessKey();
            }
            case 2: {
                return env.wrapInt(this.getCols());
            }
            case 3: {
                return this.getDefaultValue();
            }
            case 4: {
                return env.wrapBoolean(this.getDisabled());
            }
            case 5: {
                return this.getDForm();
            }
            case 7: {
                return env.wrapBoolean(this.getReadOnly());
            }
            case 8: {
                return env.wrapInt(this.getRows());
            }
            case 9: {
                return env.wrapInt(this.getTabIndex());
            }
            case 10: {
                return this.getType();
            }
            case 11: {
                return this.script_getValue();
            }
        }
        return null;
    }

    private int setDynamicValue(int key_id, Object value, DynEnv env) {
        switch (key_id) {
            case 1: {
                this.setAccessKey(env.toStr(value));
                return 1;
            }
            case 2: {
                this.setCols(env.toInt(value));
                return 1;
            }
            case 3: {
                this.setDefaultValue(env.toStr(value));
                return 1;
            }
            case 4: {
                this.setDisabled(env.toBoolean(value));
                return 1;
            }
            case 5: {
                return 2;
            }
            case 7: {
                this.setReadOnly(env.toBoolean(value));
                return 1;
            }
            case 8: {
                this.setRows(env.toInt(value));
                return 1;
            }
            case 9: {
                this.setTabIndex(env.toInt(value));
                return 1;
            }
            case 11: {
                this.setValue(env.toStr(value));
                return 1;
            }
        }
        return 2;
    }

    private Object execDynamicMethod(int key_id, Object[] args, DynEnv env) {
        switch (key_id) {
            case -1: {
                this.blur();
                break;
            }
            case -2: {
                this.focus();
                break;
            }
            case -3: {
                this.select();
            }
        }
        return env.wrapVoid();
    }

    private static int toDynamicId(String s) {
        int id = 0;
        String guess = null;
        block0 : switch (s.length()) {
            case 4: {
                switch (s.charAt(0)) {
                    case 'b': {
                        guess = "blur";
                        id = -1;
                        break block0;
                    }
                    case 'c': {
                        guess = "cols";
                        id = 2;
                        break block0;
                    }
                    case 'f': {
                        guess = "form";
                        id = 5;
                        break block0;
                    }
                    case 'r': {
                        guess = "rows";
                        id = 8;
                        break block0;
                    }
                    case 't': {
                        guess = "type";
                        id = 10;
                        break block0;
                    }
                }
                break;
            }
            case 5: {
                char c = s.charAt(0);
                if (c == 'f') {
                    guess = "focus";
                    id = -2;
                    break;
                }
                if (c != 'v') break;
                guess = "value";
                id = 11;
                break;
            }
            case 6: {
                guess = "select";
                id = -3;
                break;
            }
            case 8: {
                char c = s.charAt(0);
                if (c == 'd') {
                    guess = "disabled";
                    id = 4;
                    break;
                }
                if (c == 'r') {
                    guess = "readOnly";
                    id = 7;
                    break;
                }
                if (c != 't') break;
                guess = "tabIndex";
                id = 9;
                break;
            }
            case 9: {
                guess = "accessKey";
                id = 1;
                break;
            }
            case 12: {
                guess = "defaultValue";
                id = 3;
                break;
            }
        }
        if (guess != null && (guess == s || guess.equals(s))) {
            return id;
        }
        return 0;
    }
}

