/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.net.exchange;

import coldfusion.exchange.ExchangeConnection;
import coldfusion.exchange.ExchangeFolder;
import coldfusion.exchange.ExchangeFolderExtendedInfo;
import coldfusion.exchange.FolderFilterInfo;
import coldfusion.exchange.webdav.Utils;
import coldfusion.tagext.net.exchange.ExchangeExceptions;
import coldfusion.tagext.net.exchange.ExchangeFolderExtendedInfoQuery;
import coldfusion.tagext.net.exchange.ExchangeFolderQuery;
import coldfusion.tagext.net.exchange.ExchangeFolderTag;
import coldfusion.tagext.net.exchange.FolderConstants;
import coldfusion.tagext.validation.RequiredAttributesException;
import java.util.ArrayList;
import java.util.Map;

public class FolderTagHelper
implements FolderConstants {
    public static void getFolderInfo(ExchangeFolderTag tag) {
        ExchangeConnection con = null;
        boolean getTempConnection = false;
        con = tag.getConnection(false);
        if (con == null) {
            con = tag.createConnection();
            getTempConnection = true;
        }
        Object results = null;
        try {
            String folderIdentifier = null;
            boolean needsResolution = false;
            String id = tag.getUid();
            String pathSeparatorRegex = null;
            if (null != id) {
                folderIdentifier = id;
                needsResolution = false;
            } else {
                folderIdentifier = tag.getFolderPath();
                needsResolution = true;
                pathSeparatorRegex = tag.getPathDelimitter();
            }
            ExchangeFolder folderInfo = con.getExchangeFolderInfo(folderIdentifier, needsResolution, pathSeparatorRegex);
            ArrayList<ExchangeFolder> list = new ArrayList<ExchangeFolder>();
            list.add(folderInfo);
            ExchangeFolderQuery query = new ExchangeFolderQuery();
            query.populate(list);
            tag.getPageContext().setAttribute(tag.getName(), (Object)query);
        }
        catch (Throwable t) {
            tag.processException(t);
        }
        if (getTempConnection) {
            con.closeConnection();
        }
    }

    public static void getFolderExtendedInfo(ExchangeFolderTag tag) {
        ExchangeConnection con = null;
        boolean getTempConnection = false;
        con = tag.getConnection(false);
        if (con == null) {
            con = tag.createConnection();
            getTempConnection = true;
        }
        Object results = null;
        try {
            String folderIdentifier = null;
            boolean needsResolution = false;
            String id = tag.getUid();
            String pathSeparatorRegex = null;
            if (null != id) {
                folderIdentifier = id;
                needsResolution = false;
            } else {
                folderIdentifier = tag.getFolderPath();
                needsResolution = true;
                pathSeparatorRegex = tag.getPathDelimitter();
            }
            ExchangeFolderExtendedInfo folderInfo = con.getExchangeExtendedFolderInfo(folderIdentifier, needsResolution, pathSeparatorRegex);
            ArrayList<ExchangeFolderExtendedInfo> list = new ArrayList<ExchangeFolderExtendedInfo>();
            list.add(folderInfo);
            ExchangeFolderExtendedInfoQuery query = new ExchangeFolderExtendedInfoQuery();
            query.populate(list);
            tag.getPageContext().setAttribute(tag.getName(), (Object)query);
        }
        catch (Throwable t) {
            tag.processException(t);
        }
        if (getTempConnection) {
            con.closeConnection();
        }
    }

    public static void saveFolder(ExchangeFolderTag tag, Map folder, boolean isNew) {
        String uidVarName;
        if (!isNew && tag.getUid() != null && tag.getUid().indexOf(44) != -1) {
            ExchangeExceptions.throwMultipleUIDsInModifyActionException("cfexchangefolder");
        }
        ExchangeConnection con = null;
        boolean getTempConnection = false;
        con = tag.getConnection(false);
        if (con == null) {
            con = tag.createConnection();
            getTempConnection = true;
        }
        ExchangeFolderExtendedInfo exchgFolder = new ExchangeFolderExtendedInfo();
        exchgFolder.setDisplayName(tag.getStringAttribute(folder, "DisplayName", false));
        exchgFolder.setFolderClass(tag.getStringAttribute(folder, "FolderClass", false));
        if (!isNew) {
            String id = tag.getUid();
            if (id == null) {
                throw new RequiredAttributesException(tag.getTagPublicName(), "uid");
            }
            exchgFolder.setId(id);
        }
        try {
            if (isNew) {
                String parentFolderId = tag.getParentFolderId();
                if (parentFolderId == null) {
                    throw new RequiredAttributesException(tag.getTagPublicName(), "ParentFolderId");
                }
                if (exchgFolder.getDisplayName() == null) {
                    throw new RequiredAttributesException(tag.getTagPublicName(), "DisplayName");
                }
                con.createFolder(parentFolderId, exchgFolder);
            } else {
                con.updateFolder(exchgFolder.getId(), exchgFolder);
            }
        }
        catch (Throwable t) {
            tag.processException(t);
        }
        if (isNew && (uidVarName = tag.getResult()) != null) {
            tag.getPageContext().setAttribute(uidVarName, (Object)exchgFolder.getId());
        }
        if (getTempConnection) {
            con.closeConnection();
        }
    }

    public static void deleteFolder(ExchangeFolderTag tag) {
        String uids;
        ExchangeConnection con = null;
        boolean getTempConnection = false;
        con = tag.getConnection(false);
        if (con == null) {
            con = tag.createConnection();
            getTempConnection = true;
        }
        if ((uids = tag.getUid()) == null) {
            throw new RequiredAttributesException(tag.getTagPublicName(), "uid");
        }
        String[] uidArray = Utils.splitString(uids);
        try {
            con.deleteFolder(uidArray, tag.getDeleteType());
        }
        catch (Throwable t) {
            tag.processException(t);
        }
        if (getTempConnection) {
            con.closeConnection();
        }
    }

    public static void findSubFolders(ExchangeFolderTag tag) {
        String uid;
        ExchangeConnection con = null;
        boolean getTempConnection = false;
        con = tag.getConnection(false);
        if (con == null) {
            con = tag.createConnection();
            getTempConnection = true;
        }
        if ((uid = tag.getUid()) == null) {
            throw new RequiredAttributesException(tag.getTagPublicName(), "uid");
        }
        FolderFilterInfo filter = tag.getFilterInfo();
        try {
            ArrayList subFolders = con.getSubFolders(uid, filter);
            ExchangeFolderQuery queryResult = new ExchangeFolderQuery();
            queryResult.populate(subFolders);
            tag.getPageContext().setAttribute(tag.getName(), (Object)queryResult);
        }
        catch (Throwable t) {
            tag.processException(t);
        }
        if (getTempConnection) {
            con.closeConnection();
        }
    }

    public static void emptyFolder(ExchangeFolderTag tag) {
        String uid;
        ExchangeConnection con = null;
        boolean getTempConnection = false;
        con = tag.getConnection(false);
        if (con == null) {
            con = tag.createConnection();
            getTempConnection = true;
        }
        if ((uid = tag.getUid()) == null) {
            throw new RequiredAttributesException(tag.getTagPublicName(), "uid");
        }
        try {
            con.emptyFolder(uid, tag.getDeleteType(), tag.getDeleteSubFolders());
        }
        catch (Throwable t) {
            tag.processException(t);
        }
        if (getTempConnection) {
            con.closeConnection();
        }
    }

    public static void copyFolder(ExchangeFolderTag tag) {
        ExchangeConnection con = null;
        boolean getTempConnection = false;
        con = tag.getConnection(false);
        if (con == null) {
            con = tag.createConnection();
            getTempConnection = true;
        }
        try {
            String folderId = con.copyFolder(tag.getSourceFolderId(), tag.getDestinationFolderId());
            String uidVarName = tag.getResult();
            if (uidVarName != null) {
                tag.getPageContext().setAttribute(uidVarName, (Object)folderId);
            }
        }
        catch (Throwable t) {
            tag.processException(t);
        }
        if (getTempConnection) {
            con.closeConnection();
        }
    }

    public static void moveFolder(ExchangeFolderTag tag) {
        ExchangeConnection con = null;
        boolean getTempConnection = false;
        con = tag.getConnection(false);
        if (con == null) {
            con = tag.createConnection();
            getTempConnection = true;
        }
        try {
            String folderId = con.moveFolder(tag.getSourceFolderId(), tag.getDestinationFolderId());
            String uidVarName = tag.getResult();
            if (uidVarName != null) {
                tag.getPageContext().setAttribute(uidVarName, (Object)folderId);
            }
        }
        catch (Throwable t) {
            tag.processException(t);
        }
        if (getTempConnection) {
            con.closeConnection();
        }
    }
}

