/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.net.exchange;

import coldfusion.exchange.ContactAddress;
import coldfusion.exchange.ContactFilterInfo;
import coldfusion.exchange.ContactOtherDetails;
import coldfusion.runtime.Struct;
import coldfusion.tagext.net.exchange.ContactConstants;
import coldfusion.tagext.net.exchange.ContactTagHelper;
import coldfusion.tagext.net.exchange.ExchangeExceptions;
import coldfusion.tagext.net.exchange.ExchangeFilterable;
import coldfusion.tagext.net.exchange.ExchangeTag;
import coldfusion.tagext.validation.RequiredAttributesException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;

public class ExchangeContactTag
extends ExchangeTag
implements ExchangeFilterable,
ContactConstants {
    private static HashMap validFilterAttributes = new HashMap();
    private static HashMap validContactAttributes = new HashMap();
    private static HashMap validAddressAttributes = new HashMap();
    private ContactFilterInfo filterInfo = new ContactFilterInfo();
    private Map contact = null;

    @Override
    public void addFilter(String attribName, HashMap values) {
        if (!this.isValidAttributeKey(attribName, validFilterAttributes)) {
            ExchangeExceptions.throwInvalidFilterAttributeKeyException(attribName, "cfexchangecontact");
        }
        Object value = values.get("value");
        boolean isStringValue = value instanceof String;
        if (attribName.equalsIgnoreCase("MaxRows")) {
            int tmpInt;
            if (!isStringValue) {
                ExchangeExceptions.throwInvalidStringValueException(attribName);
            }
            if ((tmpInt = ExchangeTag.castInt(value, "MaxRows")) <= 0 && tmpInt != -1) {
                ExchangeExceptions.throwNonPositiveValueException("MaxRows");
            }
            this.filterInfo.setMaxRows(tmpInt);
        } else if (attribName.equalsIgnoreCase("FirstName")) {
            if (!isStringValue) {
                ExchangeExceptions.throwInvalidStringValueException(attribName);
            }
            this.filterInfo.setFirstName(value.toString());
        } else if (attribName.equalsIgnoreCase("LastName")) {
            if (!isStringValue) {
                ExchangeExceptions.throwInvalidStringValueException(attribName);
            }
            this.filterInfo.setLastName(value.toString());
        } else if (attribName.equalsIgnoreCase("MiddleName")) {
            if (!isStringValue) {
                ExchangeExceptions.throwInvalidStringValueException(attribName);
            }
            this.filterInfo.setMiddleName(value.toString());
        } else if (attribName.equalsIgnoreCase("DisplayAs")) {
            if (!isStringValue) {
                ExchangeExceptions.throwInvalidStringValueException(attribName);
            }
            this.filterInfo.setDislpayName(value.toString());
        } else if (attribName.equalsIgnoreCase("JobTitle")) {
            if (!isStringValue) {
                ExchangeExceptions.throwInvalidStringValueException(attribName);
            }
            this.filterInfo.setJobTitle(value.toString());
        } else if (attribName.equalsIgnoreCase("Company")) {
            if (!isStringValue) {
                ExchangeExceptions.throwInvalidStringValueException(attribName);
            }
            this.filterInfo.setCompany(value.toString());
        } else if (attribName.equalsIgnoreCase("WebPage")) {
            if (!isStringValue) {
                ExchangeExceptions.throwInvalidStringValueException(attribName);
            }
            this.filterInfo.setBusinessHomePage(value.toString());
        } else if (attribName.equalsIgnoreCase("Email1")) {
            if (!isStringValue) {
                ExchangeExceptions.throwInvalidStringValueException(attribName);
            }
            this.filterInfo.setEMail1(value.toString());
        } else if (attribName.equalsIgnoreCase("Email2")) {
            if (!isStringValue) {
                ExchangeExceptions.throwInvalidStringValueException(attribName);
            }
            this.filterInfo.setEMail2(value.toString());
        } else if (attribName.equalsIgnoreCase("Email3")) {
            if (!isStringValue) {
                ExchangeExceptions.throwInvalidStringValueException(attribName);
            }
            this.filterInfo.setEMail3(value.toString());
        } else if (attribName.equalsIgnoreCase("HomePhoneNumber")) {
            if (!isStringValue) {
                ExchangeExceptions.throwInvalidStringValueException(attribName);
            }
            this.filterInfo.setHomePhone(value.toString());
        } else if (attribName.equalsIgnoreCase("BusinessPhoneNumber")) {
            if (!isStringValue) {
                ExchangeExceptions.throwInvalidStringValueException(attribName);
            }
            this.filterInfo.setBusinessPhone(value.toString());
        } else if (attribName.equalsIgnoreCase("OtherPhoneNumber")) {
            if (!isStringValue) {
                ExchangeExceptions.throwInvalidStringValueException(attribName);
            }
            this.filterInfo.setOtherPhone(value.toString());
        } else if (attribName.equalsIgnoreCase("MobilePhoneNumber")) {
            if (!isStringValue) {
                ExchangeExceptions.throwInvalidStringValueException(attribName);
            }
            this.filterInfo.setMobilePhone(value.toString());
        } else if (attribName.equalsIgnoreCase("Pager")) {
            if (!isStringValue) {
                ExchangeExceptions.throwInvalidStringValueException(attribName);
            }
            this.filterInfo.setPager(value.toString());
        } else if (attribName.equalsIgnoreCase("Categories")) {
            if (!isStringValue) {
                ExchangeExceptions.throwInvalidStringValueException(attribName);
            }
            this.filterInfo.setCategories(value.toString());
        } else if (attribName.equalsIgnoreCase("businessFax")) {
            if (!isStringValue) {
                ExchangeExceptions.throwInvalidStringValueException(attribName);
            }
            this.filterInfo.setBusinessFax(value.toString());
        } else if (attribName.equalsIgnoreCase("mailingAddressType")) {
            if (!isStringValue) {
                ExchangeExceptions.throwInvalidStringValueException(attribName);
            }
            int type = -1;
            type = ExchangeContactTag.parseMailingAddressType(value.toString());
            if (type == -1) {
                ExchangeExceptions.throwInvalidMailingAddressType("mailingAddressType");
            }
            this.filterInfo.setMailingAdressType(type);
        } else if (attribName.equalsIgnoreCase("Office")) {
            if (!isStringValue) {
                ExchangeExceptions.throwInvalidStringValueException(attribName);
            }
            if (this.filterInfo.getDetails() == null) {
                this.filterInfo.setDetails(new ContactOtherDetails());
            }
            this.filterInfo.getDetails().setOffice(value.toString());
        } else if (attribName.equalsIgnoreCase("Profession")) {
            if (!isStringValue) {
                ExchangeExceptions.throwInvalidStringValueException(attribName);
            }
            if (this.filterInfo.getDetails() == null) {
                this.filterInfo.setDetails(new ContactOtherDetails());
            }
            this.filterInfo.getDetails().setProfession(value.toString());
        } else if (attribName.equalsIgnoreCase("Manager")) {
            if (!isStringValue) {
                ExchangeExceptions.throwInvalidStringValueException(attribName);
            }
            if (this.filterInfo.getDetails() == null) {
                this.filterInfo.setDetails(new ContactOtherDetails());
            }
            this.filterInfo.getDetails().setManager(value.toString());
        } else if (attribName.equalsIgnoreCase("Assistant")) {
            if (!isStringValue) {
                ExchangeExceptions.throwInvalidStringValueException(attribName);
            }
            if (this.filterInfo.getDetails() == null) {
                this.filterInfo.setDetails(new ContactOtherDetails());
            }
            this.filterInfo.getDetails().setAssistant(value.toString());
        } else if (attribName.equalsIgnoreCase("NickName")) {
            if (!isStringValue) {
                ExchangeExceptions.throwInvalidStringValueException(attribName);
            }
            if (this.filterInfo.getDetails() == null) {
                this.filterInfo.setDetails(new ContactOtherDetails());
            }
            this.filterInfo.getDetails().setNickname(value.toString());
        } else if (attribName.equalsIgnoreCase("SpouseName")) {
            if (!isStringValue) {
                ExchangeExceptions.throwInvalidStringValueException(attribName);
            }
            if (this.filterInfo.getDetails() == null) {
                this.filterInfo.setDetails(new ContactOtherDetails());
            }
            this.filterInfo.getDetails().setPartner(value.toString());
        } else if (attribName.equalsIgnoreCase("HomeAddress")) {
            if (!(value instanceof Struct)) {
                ExchangeExceptions.throwInvalidStructValueException("HomeAddress");
            }
            this.filterInfo.setHomeAddress(this.mapToContactAddress((Map)((Struct)value), "HomeAddress"));
        } else if (attribName.equalsIgnoreCase("BusinessAddress")) {
            if (!(value instanceof Struct)) {
                ExchangeExceptions.throwInvalidStructValueException("BusinessAddress");
            }
            this.filterInfo.setBusinessAddress(this.mapToContactAddress((Map)((Struct)value), "BusinessAddress"));
        } else if (attribName.equalsIgnoreCase("OtherAddress")) {
            if (!(value instanceof Struct)) {
                ExchangeExceptions.throwInvalidStructValueException("OtherAddress");
            }
            this.filterInfo.setOtherAddress(this.mapToContactAddress((Map)((Struct)value), "OtherAddress"));
        } else if (attribName.equalsIgnoreCase("uid")) {
            if (!isStringValue) {
                ExchangeExceptions.throwInvalidStringValueException(attribName);
            }
            if (value == null || value.toString().trim().length() == 0) {
                ExchangeExceptions.throwInvalidAttributeValueException("uid");
            }
            this.filterInfo.setId(value.toString());
        } else if (attribName.equalsIgnoreCase("lastModified")) {
            Date fromDate = null;
            Date toDate = null;
            if (values.containsKey("from")) {
                fromDate = ExchangeTag.castDate(values.get("from"), "from");
            }
            if (values.containsKey("to")) {
                toDate = ExchangeTag.castDate(values.get("to"), "to");
            }
            if (fromDate != null && toDate != null && toDate.compareTo(fromDate) < 0) {
                ExchangeExceptions.throwInvalidStartEndTimeException();
            }
            if (fromDate != null || toDate != null) {
                this.filterInfo.setFromLastModifiedDate(fromDate);
                this.filterInfo.setToLastModifiedDate(toDate);
            } else {
                if (value != null) {
                    ExchangeExceptions.throwInvalidFilterAttributesForDateExcpetion();
                }
                ExchangeExceptions.throwInvalidAttributeValueException("lastModified");
            }
            return;
        }
    }

    public static int parseMailingAddressType(String type) {
        if (type.equalsIgnoreCase("home")) {
            return 1;
        }
        if (type.equalsIgnoreCase("business")) {
            return 2;
        }
        if (type.equalsIgnoreCase("other")) {
            return 3;
        }
        return -1;
    }

    ContactAddress mapToContactAddress(Map addressMap, String attribName) {
        if (addressMap == null || addressMap.size() == 0) {
            ExchangeExceptions.throwInvalidStructValueException(attribName);
        }
        this.validateStruct(addressMap, validAddressAttributes, "cfexchangecontact", attribName);
        ContactAddress addr = new ContactAddress();
        addr.setCity(this.getStringAttribute(addressMap, "City", false));
        addr.setCountry(this.getStringAttribute(addressMap, "Country", false));
        addr.setPostalCode(this.getStringAttribute(addressMap, "Zip", false));
        addr.setState(this.getStringAttribute(addressMap, "State", false));
        addr.setStreet(this.getStringAttribute(addressMap, "Street", false));
        return addr;
    }

    PageContext getPageContext() {
        return this.pageContext;
    }

    public Map getContact() {
        return this.contact;
    }

    public ContactFilterInfo getFilterInfo() {
        return this.filterInfo;
    }

    public void setContact(Map contact) {
        this.validateStruct(contact, validContactAttributes, "cfexchangecontact", "contact");
        this.contact = contact;
    }

    public void setFilterInfo(ContactFilterInfo filterInfo) {
        this.filterInfo = filterInfo;
    }

    @Override
    public int doStartTag() throws JspException {
        super.doStartTag();
        this.onTagStart();
        if ((this.action.equalsIgnoreCase("create") || this.action.equalsIgnoreCase("modify")) && this.getContact() == null) {
            throw new RequiredAttributesException(this.getTagPublicName(), "contact");
        }
        return 6;
    }

    @Override
    public int doEndTag() throws JspException {
        super.doEndTag();
        if (this.action.equalsIgnoreCase("get")) {
            if (this.getName() == null) {
                throw new RequiredAttributesException(this.getTagPublicName(), "name");
            }
            ContactTagHelper.getContacts(this);
        } else if (this.action.equalsIgnoreCase("create")) {
            ContactTagHelper.saveContact(this, this.getContact(), true);
        } else if (this.action.equalsIgnoreCase("modify")) {
            ContactTagHelper.saveContact(this, this.getContact(), false);
        } else if (this.action.equalsIgnoreCase("delete")) {
            ContactTagHelper.deleteContacts(this);
        } else if (this.action.equalsIgnoreCase("getAttachments")) {
            this.getAttachments(2);
        } else if (this.action.equalsIgnoreCase("deleteAttachments")) {
            this.deleteAttachments(2);
        }
        this.release();
        this.onTagEnd();
        return 6;
    }

    @Override
    public void release() {
        super.release();
        this.contact = null;
        this.filterInfo = new ContactFilterInfo();
    }

    static {
        validContactAttributes.put("FirstName".toUpperCase(), "FirstName".toUpperCase());
        validContactAttributes.put("LastName".toUpperCase(), "LastName".toUpperCase());
        validContactAttributes.put("MiddleName".toUpperCase(), "MiddleName".toUpperCase());
        validContactAttributes.put("DisplayAs".toUpperCase(), "DisplayAs".toUpperCase());
        validContactAttributes.put("JobTitle".toUpperCase(), "JobTitle".toUpperCase());
        validContactAttributes.put("Company".toUpperCase(), "Company".toUpperCase());
        validContactAttributes.put("WebPage".toUpperCase(), "WebPage".toUpperCase());
        validContactAttributes.put("Email1".toUpperCase(), "Email1".toUpperCase());
        validContactAttributes.put("Email2".toUpperCase(), "Email2".toUpperCase());
        validContactAttributes.put("Email3".toUpperCase(), "Email3".toUpperCase());
        validContactAttributes.put("HomePhoneNumber".toUpperCase(), "HomePhoneNumber".toUpperCase());
        validContactAttributes.put("BusinessPhoneNumber".toUpperCase(), "BusinessPhoneNumber".toUpperCase());
        validContactAttributes.put("OtherPhoneNumber".toUpperCase(), "OtherPhoneNumber".toUpperCase());
        validContactAttributes.put("MobilePhoneNumber".toUpperCase(), "MobilePhoneNumber".toUpperCase());
        validContactAttributes.put("Pager".toUpperCase(), "Pager".toUpperCase());
        validContactAttributes.put("Categories".toUpperCase(), "Categories".toUpperCase());
        validContactAttributes.put("Description".toUpperCase(), "Description".toUpperCase());
        validContactAttributes.put("Department".toUpperCase(), "Department".toUpperCase());
        validContactAttributes.put("Office".toUpperCase(), "Office".toUpperCase());
        validContactAttributes.put("Profession".toUpperCase(), "Profession".toUpperCase());
        validContactAttributes.put("Manager".toUpperCase(), "Manager".toUpperCase());
        validContactAttributes.put("Assistant".toUpperCase(), "Assistant".toUpperCase());
        validContactAttributes.put("NickName".toUpperCase(), "NickName".toUpperCase());
        validContactAttributes.put("SpouseName".toUpperCase(), "SpouseName".toUpperCase());
        validContactAttributes.put("HomeAddress".toUpperCase(), "HomeAddress".toUpperCase());
        validContactAttributes.put("BusinessAddress".toUpperCase(), "BusinessAddress".toUpperCase());
        validContactAttributes.put("OtherAddress".toUpperCase(), "OtherAddress".toUpperCase());
        validContactAttributes.put("HasAttachment".toUpperCase(), "HasAttachment".toUpperCase());
        validContactAttributes.put("businessFax".toUpperCase(), "businessFax".toUpperCase());
        validContactAttributes.put("attachments".toUpperCase(), "attachments".toUpperCase());
        validContactAttributes.put("mailingAddressType".toUpperCase(), "mailingAddressType".toUpperCase());
        validFilterAttributes.put("FirstName".toUpperCase(), "FirstName".toUpperCase());
        validFilterAttributes.put("LastName".toUpperCase(), "LastName".toUpperCase());
        validFilterAttributes.put("MiddleName".toUpperCase(), "MiddleName".toUpperCase());
        validFilterAttributes.put("DisplayAs".toUpperCase(), "DisplayAs".toUpperCase());
        validFilterAttributes.put("JobTitle".toUpperCase(), "JobTitle".toUpperCase());
        validFilterAttributes.put("Company".toUpperCase(), "Company".toUpperCase());
        validFilterAttributes.put("WebPage".toUpperCase(), "WebPage".toUpperCase());
        validFilterAttributes.put("Email1".toUpperCase(), "Email1".toUpperCase());
        validFilterAttributes.put("Email2".toUpperCase(), "Email2".toUpperCase());
        validFilterAttributes.put("Email3".toUpperCase(), "Email3".toUpperCase());
        validFilterAttributes.put("HomePhoneNumber".toUpperCase(), "HomePhoneNumber".toUpperCase());
        validFilterAttributes.put("BusinessPhoneNumber".toUpperCase(), "BusinessPhoneNumber".toUpperCase());
        validFilterAttributes.put("OtherPhoneNumber".toUpperCase(), "OtherPhoneNumber".toUpperCase());
        validFilterAttributes.put("MobilePhoneNumber".toUpperCase(), "MobilePhoneNumber".toUpperCase());
        validFilterAttributes.put("Pager".toUpperCase(), "Pager".toUpperCase());
        validFilterAttributes.put("Categories".toUpperCase(), "Categories".toUpperCase());
        validFilterAttributes.put("Description".toUpperCase(), "Description".toUpperCase());
        validFilterAttributes.put("Department".toUpperCase(), "Department".toUpperCase());
        validFilterAttributes.put("Office".toUpperCase(), "Office".toUpperCase());
        validFilterAttributes.put("Profession".toUpperCase(), "Profession".toUpperCase());
        validFilterAttributes.put("Manager".toUpperCase(), "Manager".toUpperCase());
        validFilterAttributes.put("Assistant".toUpperCase(), "Assistant".toUpperCase());
        validFilterAttributes.put("NickName".toUpperCase(), "NickName".toUpperCase());
        validFilterAttributes.put("SpouseName".toUpperCase(), "SpouseName".toUpperCase());
        validFilterAttributes.put("HomeAddress".toUpperCase(), "HomeAddress".toUpperCase());
        validFilterAttributes.put("BusinessAddress".toUpperCase(), "BusinessAddress".toUpperCase());
        validFilterAttributes.put("OtherAddress".toUpperCase(), "OtherAddress".toUpperCase());
        validFilterAttributes.put("HasAttachment".toUpperCase(), "HasAttachment".toUpperCase());
        validFilterAttributes.put("businessFax".toUpperCase(), "businessFax".toUpperCase());
        validFilterAttributes.put("MaxRows".toUpperCase(), "MaxRows".toUpperCase());
        validFilterAttributes.put("value".toUpperCase(), "value".toUpperCase());
        validFilterAttributes.put("mailingAddressType".toUpperCase(), "mailingAddressType".toUpperCase());
        validFilterAttributes.put("uid".toUpperCase(), "uid".toUpperCase());
        validFilterAttributes.put("lastModified".toUpperCase(), "lastModified".toUpperCase());
        validFilterAttributes.put("from".toUpperCase(), "from".toUpperCase());
        validFilterAttributes.put("to".toUpperCase(), "to".toUpperCase());
        validAddressAttributes.put("City".toUpperCase(), "City".toUpperCase());
        validAddressAttributes.put("Country".toUpperCase(), "Country".toUpperCase());
        validAddressAttributes.put("Zip".toUpperCase(), "Zip".toUpperCase());
        validAddressAttributes.put("State".toUpperCase(), "State".toUpperCase());
        validAddressAttributes.put("Street".toUpperCase(), "Street".toUpperCase());
    }
}

