/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.net.exchange;

import coldfusion.exchange.ExchangeConnection;
import coldfusion.tagext.net.exchange.ConversationQuery;
import coldfusion.tagext.net.exchange.ExchangeConversationTag;
import java.util.ArrayList;

public class ConversationTagHelper {
    public static void getConversations(ExchangeConversationTag tag) {
        ExchangeConnection con = null;
        boolean getTempConnection = false;
        con = tag.getConnection(false);
        if (con == null) {
            con = tag.createConnection();
            getTempConnection = true;
        }
        Object results = null;
        try {
            String id = tag.getFolderId();
            ArrayList conversations = con.getConversations(id, tag.getFilterInfo());
            ConversationQuery query = new ConversationQuery();
            query.populate(conversations);
            tag.getPageContext().setAttribute(tag.getName(), (Object)query);
        }
        catch (Throwable t) {
            tag.processException(t);
        }
        if (getTempConnection) {
            con.closeConnection();
        }
    }

    public static void copy(ExchangeConversationTag tag) {
        ExchangeConnection con = null;
        boolean getTempConnection = false;
        con = tag.getConnection(false);
        if (con == null) {
            con = tag.createConnection();
            getTempConnection = true;
        }
        Object results = null;
        try {
            String conversationFolderId = tag.getFolderId();
            String destinationFolderId = tag.getDestinationFolderId();
            String conversationId = tag.getConversationId();
            con.copyConversations(conversationFolderId, destinationFolderId, conversationId);
        }
        catch (Throwable t) {
            tag.processException(t);
        }
        if (getTempConnection) {
            con.closeConnection();
        }
    }

    public static void move(ExchangeConversationTag tag) {
        ExchangeConnection con = null;
        boolean getTempConnection = false;
        con = tag.getConnection(false);
        if (con == null) {
            con = tag.createConnection();
            getTempConnection = true;
        }
        Object results = null;
        try {
            String conversationFolderId = tag.getFolderId();
            String destinationFolderId = tag.getDestinationFolderId();
            String conversationId = tag.getConversationId();
            con.moveConversations(conversationFolderId, destinationFolderId, conversationId);
        }
        catch (Throwable t) {
            tag.processException(t);
        }
        if (getTempConnection) {
            con.closeConnection();
        }
    }

    public static void setReadState(ExchangeConversationTag tag) {
        ExchangeConnection con = null;
        boolean getTempConnection = false;
        con = tag.getConnection(false);
        if (con == null) {
            con = tag.createConnection();
            getTempConnection = true;
        }
        Object results = null;
        try {
            String conversationFolderId = tag.getFolderId();
            String conversationId = tag.getConversationId();
            con.setReadStateToConversations(conversationFolderId, conversationId, tag.isRead());
        }
        catch (Throwable t) {
            tag.processException(t);
        }
        if (getTempConnection) {
            con.closeConnection();
        }
    }

    public static void delete(ExchangeConversationTag tag) {
        ExchangeConnection con = null;
        boolean getTempConnection = false;
        con = tag.getConnection(false);
        if (con == null) {
            con = tag.createConnection();
            getTempConnection = true;
        }
        Object results = null;
        try {
            String conversationFolderId = tag.getFolderId();
            String conversationId = tag.getConversationId();
            con.deleteConversations(conversationFolderId, conversationId, tag.getDeleteType());
        }
        catch (Throwable t) {
            tag.processException(t);
        }
        if (getTempConnection) {
            con.closeConnection();
        }
    }
}

