/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.exchange.webdav;

import coldfusion.exchange.ExchangeFolderInfo;
import coldfusion.exchange.webdav.FolderMappingCache;
import coldfusion.exchange.webdav.Utils;
import coldfusion.exchange.webdav.WebDAVConnection;
import coldfusion.exchange.webdav.WebDAVConstants;
import coldfusion.exchange.webdav.WebDAVExceptions;
import coldfusion.exchange.webdav.WebDAVLoginInfo;
import coldfusion.log.CFLogs;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpURL;
import org.apache.webdav.lib.BaseProperty;
import org.apache.webdav.lib.ResponseEntity;
import org.apache.webdav.lib.methods.DeleteMethod;
import org.apache.webdav.lib.methods.PropFindMethod;
import org.apache.webdav.lib.methods.SearchMethod;
import org.apache.webdav.lib.methods.XMLResponseMethodBase;

public class WebDAVFolderManager
implements WebDAVConstants {
    protected WebDAVConnection connection = null;
    protected HttpClient client = null;
    protected WebDAVLoginInfo loginInfo = null;
    private Map folderUrlMapping = null;
    private String inboxFolderName = null;

    protected WebDAVFolderManager(WebDAVConnection con) {
        this.connection = con;
        this.loginInfo = (WebDAVLoginInfo)con.getLoginInfo();
        Map folderMapping = this.loginInfo.getFolderNameMapping();
        if (folderMapping != null) {
            this.folderUrlMapping = this.createFolderUrlMapping(folderMapping);
            FolderMappingCache.getInstance().putFolderMapping(con, this.folderUrlMapping);
        } else if (!this.loginInfo.isEnglishExchangeServer()) {
            this.folderUrlMapping = FolderMappingCache.getInstance().getFolderMapping(con);
            if (this.folderUrlMapping == null) {
                this.folderUrlMapping = this.getFolderUrlMappingFromExchangeServer();
                FolderMappingCache.getInstance().putFolderMapping(con, this.folderUrlMapping);
            }
        }
    }

    protected HttpClient getHttpClient() throws Throwable {
        if (this.client != null) {
            return this.client;
        }
        HttpURL url = this.connection.webDavResource.getHttpURL();
        this.client = this.connection.webDavResource.getSessionInstance(url);
        if (this.loginInfo.getProxyHost() != null && this.loginInfo.getProxyPort() != -1) {
            HostConfiguration hostConfig = this.client.getHostConfiguration();
            hostConfig.setProxy(this.loginInfo.getProxyHost(), this.loginInfo.getProxyPort());
        }
        return this.client;
    }

    protected static boolean stringToBoolean(String intValue) {
        try {
            int i = Integer.parseInt(intValue);
            return i == 1;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    protected String encodeXMLContent(String xmlData) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < xmlData.length(); ++i) {
            char aChar = xmlData.charAt(i);
            if (aChar == '<') {
                buf.append("&lt;");
                continue;
            }
            if (aChar == '>') {
                buf.append("&gt;");
                continue;
            }
            if (aChar == '&') {
                buf.append("&amp;");
                continue;
            }
            buf.append(aChar);
        }
        return buf.toString();
    }

    protected void deleteAtHref(String href) throws Throwable {
        int code = this.executeWebDAVMethod(DeleteMethod.class, this.getHttpClient(), href, null, true);
        if (code < 200 || code > 300) {
            throw new WebDAVExceptions(2, code, null, "Error deleting a contact");
        }
    }

    protected int executeWebDAVMethod(Class methodClass, HttpClient client, String uri, String requestContent, boolean retry) throws Throwable {
        Object[] results = this.executWebDAVMethodHelper(methodClass, client, uri, requestContent, retry);
        return (Integer)results[0];
    }

    protected Object[] executWebDAVMethodHelper(Class methodClass, HttpClient client, String uri, String requestContent, boolean retry) throws Throwable {
        if (methodClass.isAssignableFrom(XMLResponseMethodBase.class)) {
            throw new IllegalArgumentException();
        }
        try {
            uri = this.encodeUrl(uri);
            Constructor ct = methodClass.getConstructor(String.class);
            XMLResponseMethodBase method = (XMLResponseMethodBase)ct.newInstance(uri);
            if (requestContent != null) {
                method.setRequestBody(requestContent);
            }
            int code = client.executeMethod((HttpMethod)method);
            return new Object[]{new Integer(code), method};
        }
        catch (IllegalArgumentException ie) {
            return this.executWebDAVMethodHelper(methodClass, client, Utils.getEncodedHref(uri), requestContent, false);
        }
        catch (InvocationTargetException te) {
            return this.executWebDAVMethodHelper(methodClass, client, Utils.getEncodedHref(uri), requestContent, false);
        }
    }

    private String encodeUrl(String uri) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < uri.length(); ++i) {
            char aChar = uri.charAt(i);
            if (aChar == '{') {
                buf.append("%7B");
                continue;
            }
            if (aChar == '}') {
                buf.append("%7D");
                continue;
            }
            buf.append(aChar);
        }
        return buf.toString();
    }

    protected Object[] executeHttpMethod(Class methodClass, HttpClient client, String uri, boolean retry) throws Throwable {
        if (methodClass.isAssignableFrom(HttpMethod.class)) {
            throw new IllegalArgumentException();
        }
        try {
            uri = this.encodeUrl(uri);
            Constructor ct = methodClass.getConstructor(String.class);
            HttpMethod method = (HttpMethod)ct.newInstance(uri);
            int code = client.executeMethod(method);
            return new Object[]{new Integer(code), method};
        }
        catch (IllegalArgumentException ie) {
            return this.executeHttpMethod(methodClass, client, Utils.getEncodedHref(uri), false);
        }
        catch (InvocationTargetException te) {
            return this.executeHttpMethod(methodClass, client, Utils.getEncodedHref(uri), false);
        }
    }

    public ArrayList getFolders(WebDAVConnection con, String folderName, boolean recurse) throws Throwable {
        String searchPath;
        String searchFolderUrl = searchPath = this.loginInfo.getExchangeUrl() + "/";
        if (folderName != null && folderName.trim().length() > 0) {
            searchFolderUrl = searchPath + Utils.getEncodedHref(folderName) + "/";
        }
        String sql = "<?xml version=\"1.0\"?><D:searchrequest xmlns:D = \"DAV:\">   <D:sql>";
        sql = sql + " SELECT \"DAV:href\" as folderURL,  \"http://schemas.microsoft.com/exchange/foldersize\" as folderSize";
        sql = sql + " FROM SCOPE('hierarchical traversal of \"" + searchFolderUrl + "\"')";
        sql = sql + " </D:sql>  </D:searchrequest>";
        SearchMethod method = new SearchMethod(searchPath, sql);
        method.setRequestHeader(new Header("Depth", "1"));
        method.setRequestHeader(new Header("Translate", "f"));
        HttpClient client = this.getHttpClient();
        int code = client.executeMethod((HttpMethod)method);
        if (code < 200 || code > 300) {
            throw new WebDAVExceptions(2, code, null, "Error getting appointments");
        }
        Enumeration enm = method.getResponses();
        ArrayList<ExchangeFolderInfo> subFolders = new ArrayList<ExchangeFolderInfo>();
        while (enm.hasMoreElements()) {
            Object obj = enm.nextElement();
            ResponseEntity entity = (ResponseEntity)obj;
            ExchangeFolderInfo folderInfo = new ExchangeFolderInfo();
            String name = null;
            Enumeration enm1 = entity.getProperties();
            while (enm1.hasMoreElements()) {
                BaseProperty prop = (BaseProperty)enm1.nextElement();
                String propName = prop.getLocalName();
                String propValue = prop.getPropertyAsString();
                if (propValue == null || propValue.length() == 0) continue;
                if (propName.equals("folderURL")) {
                    try {
                        propValue = URLDecoder.decode(propValue, "UTF-8");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    name = this.extractFolderName(propValue);
                    folderInfo.setFolderName(name);
                    folderInfo.setFolderPath(this.extractFolderPath(propValue));
                    folderInfo.setFolderUrl(propValue);
                    continue;
                }
                if (!propName.equals("folderSize") || name == null) continue;
                folderInfo.setFolderSize(Integer.parseInt(propValue));
            }
            if (name == null) continue;
            String folderPath = folderInfo.getFolderPath();
            if (recurse && folderPath != null) {
                folderInfo.setSubFolders(this.getFolders(con, folderPath, recurse));
            }
            subFolders.add(folderInfo);
        }
        return subFolders.size() == 0 ? null : subFolders;
    }

    private String extractFolderName(String folderUrl) {
        int index;
        String mailBoxName = this.loginInfo.getMailBoxName();
        int i1 = folderUrl.indexOf(mailBoxName + "/");
        i1 += mailBoxName.length() + 1;
        String tmpUrl = folderUrl;
        if (folderUrl.charAt(folderUrl.length() - 1) == '/') {
            tmpUrl = folderUrl.substring(0, folderUrl.length() - 1);
        }
        if ((index = tmpUrl.lastIndexOf("/")) < 0) {
            return null;
        }
        return tmpUrl.substring(index + 1);
    }

    private String extractFolderPath(String folderUrl) {
        int index;
        String exchangeUser = "exchange/" + this.loginInfo.getMailBoxName() + "/";
        String tmpUrl = folderUrl;
        if (folderUrl.charAt(folderUrl.length() - 1) == '/') {
            tmpUrl = folderUrl.substring(0, folderUrl.length() - 1);
        }
        if ((index = tmpUrl.indexOf(exchangeUser)) < 0) {
            return null;
        }
        return tmpUrl.substring(index + exchangeUser.length());
    }

    private Map createFolderUrlMapping(Map nameMap) {
        HashMap<String, String> folderUrlMap = new HashMap<String, String>();
        HashMap folderNameMap = new HashMap();
        for (Object key : nameMap.keySet()) {
            folderNameMap.put(key.toString().toLowerCase(), nameMap.get(key));
        }
        Object folderName = folderNameMap.get("inbox");
        if (folderName != null) {
            folderUrlMap.put("inbox", this.connection.webDavResource.getHttpURL().toString() + "/" + folderName);
        }
        if ((folderName = folderNameMap.get("calendar")) != null) {
            folderUrlMap.put("calendar", this.connection.webDavResource.getHttpURL().toString() + "/" + folderName);
        }
        if ((folderName = folderNameMap.get("contacts")) != null) {
            folderUrlMap.put("contacts", this.connection.webDavResource.getHttpURL().toString() + "/" + folderName);
        }
        if ((folderName = folderNameMap.get("tasks")) != null) {
            folderUrlMap.put("tasks", this.connection.webDavResource.getHttpURL().toString() + "/" + folderName);
        }
        if ((folderName = folderNameMap.get("drafts")) != null) {
            folderUrlMap.put("drafts", this.connection.webDavResource.getHttpURL().toString() + "/" + folderName);
        }
        if ((folderName = folderNameMap.get("deleteditems")) != null) {
            folderUrlMap.put("deleteditems", this.connection.webDavResource.getHttpURL().toString() + "/" + folderName);
        }
        return folderUrlMap;
    }

    private Map getFolderUrlMappingFromExchangeServer() {
        StringBuffer query = new StringBuffer("<?xml version=\"1.0\" ?>");
        query.append("<a:propfind xmlns:a=\"DAV:\" xmlns:n0=\"urn:schemas:httpmail:\">");
        query.append("    <a:prop>");
        query.append("        <n0:calendar></n0:calendar>");
        query.append("        <n0:contacts></n0:contacts>");
        query.append("        <n0:inbox></n0:inbox>");
        query.append("        <n0:drafts></n0:drafts>");
        query.append("        <n0:tasks></n0:tasks>");
        query.append("    </a:prop>");
        query.append("</a:propfind>");
        String uri = this.connection.webDavResource.getHttpURL().toString();
        try {
            PropFindMethod method = new PropFindMethod(uri);
            method.setRequestHeader(new Header("Depth", "0"));
            method.setRequestHeader(new Header("Brief", "t"));
            method.setRequestHeader(new Header("Translate", "f"));
            method.setRequestBody(query.toString());
            HttpClient client = this.getHttpClient();
            int retCode = client.executeMethod((HttpMethod)method);
            if (retCode < 200 || retCode >= 300) {
                return null;
            }
            Enumeration enm = method.getResponses();
            HashMap<String, String> folderMap = new HashMap<String, String>();
            boolean mappingFound = false;
            while (enm.hasMoreElements() && !mappingFound) {
                Object obj = enm.nextElement();
                ResponseEntity entity = (ResponseEntity)obj;
                Enumeration enm1 = entity.getProperties();
                while (enm1.hasMoreElements()) {
                    BaseProperty prop = (BaseProperty)enm1.nextElement();
                    String propName = prop.getLocalName();
                    String propValue = prop.getPropertyAsString();
                    if (propValue == null || propValue.length() == 0) continue;
                    if (propName.endsWith("calendar")) {
                        folderMap.put("calendar", propValue);
                        continue;
                    }
                    if (propName.endsWith("inbox")) {
                        folderMap.put("inbox", propValue);
                        continue;
                    }
                    if (propName.endsWith("contacts")) {
                        folderMap.put("contacts", propValue);
                        continue;
                    }
                    if (propName.endsWith("deleteditems")) {
                        folderMap.put("deleteditems", propValue);
                        continue;
                    }
                    if (propName.endsWith("tasks")) {
                        folderMap.put("tasks", propValue);
                        continue;
                    }
                    if (!propName.endsWith("drafts")) continue;
                    folderMap.put("drafts", propValue);
                }
                Object calendarUrl = folderMap.get("calendar");
                if (calendarUrl == null || calendarUrl.toString().trim().length() <= 0) continue;
                mappingFound = true;
                break;
            }
            return folderMap;
        }
        catch (Throwable t) {
            CFLogs.APPLICATION_LOG.error(t);
            return null;
        }
    }

    protected String getCalendarFolderUrl() {
        Object folderUrl;
        if (this.folderUrlMapping != null && (folderUrl = this.folderUrlMapping.get("calendar")) != null) {
            return folderUrl.toString();
        }
        return this.connection.webDavResource.getHttpURL().toString() + "/Calendar";
    }

    protected String getInboxFolderUrl() {
        Object folderUrl;
        if (this.folderUrlMapping != null && (folderUrl = this.folderUrlMapping.get("inbox")) != null) {
            return folderUrl.toString();
        }
        return this.connection.webDavResource.getHttpURL().toString() + "/Inbox";
    }

    protected String getDraftFolderUrl() {
        Object folderUrl;
        if (this.folderUrlMapping != null && (folderUrl = this.folderUrlMapping.get("drafts")) != null) {
            return folderUrl.toString();
        }
        return this.connection.webDavResource.getHttpURL().toString() + "/Drafts";
    }

    protected String getContactFolderUrl() {
        Object folderUrl;
        if (this.folderUrlMapping != null && (folderUrl = this.folderUrlMapping.get("contacts")) != null) {
            return folderUrl.toString();
        }
        return this.connection.webDavResource.getHttpURL().toString() + "/Contacts";
    }

    protected String getTaskFolderUrl() {
        Object folderUrl;
        if (this.folderUrlMapping != null && (folderUrl = this.folderUrlMapping.get("tasks")) != null) {
            return folderUrl.toString();
        }
        return this.connection.webDavResource.getHttpURL().toString() + "/Tasks";
    }

    protected String getInboxFolderName() {
        if (this.inboxFolderName != null) {
            return this.inboxFolderName;
        }
        String url = this.getInboxFolderUrl();
        this.inboxFolderName = url.substring(url.lastIndexOf(47) + 1);
        return this.inboxFolderName;
    }

    protected String getCalendarFolderName() {
        String folderUrl = this.getCalendarFolderUrl();
        return folderUrl.substring(folderUrl.lastIndexOf(47) + 1);
    }
}

