/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.exchange.webdav;

import coldfusion.exchange.webdav.WebDAVExceptions;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.SimpleTimeZone;
import java.util.StringTokenizer;
import java.util.TimeZone;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpURL;
import org.apache.commons.httpclient.HttpsURL;
import org.apache.webdav.lib.BaseProperty;
import org.apache.webdav.lib.ResponseEntity;
import org.apache.webdav.lib.methods.PropFindMethod;

public class Utils {
    static SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy h:m aaa");
    static SimpleDateFormat exchangeDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public static String localToExchangeDate(String localDate) {
        try {
            Date aDate = dateFormat.parse(localDate);
            return Utils.localToExchangeDate(aDate);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String localToExchangeDate(Date localDate) {
        try {
            SimpleDateFormat format1 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            format1.setTimeZone(TimeZone.getTimeZone("GMT"));
            String gmtDate = format1.format(localDate);
            return gmtDate;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String localToLongExchangeDate(Date localDate) {
        return Utils.localToLongExchangeDate(localDate, false);
    }

    public static String localToLongExchangeDate(Date localDate, boolean forWebService) {
        try {
            String gmtStrDate = Utils.localToExchangeDate(localDate);
            int i1 = gmtStrDate.indexOf(32);
            if (i1 < 0) {
                return "";
            }
            String datePart = gmtStrDate.substring(0, i1);
            String timePart = gmtStrDate.substring(i1 + 1);
            if (!forWebService) {
                return datePart + "T" + timePart + ".000Z";
            }
            return datePart + "T" + timePart + "Z";
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String localDateToRuleDateString(Date localDate) {
        String gmtDateStr = Utils.localToExchangeDate(localDate);
        int year = 0;
        int month = 0;
        int day = 0;
        int hour = 0;
        int minutes = 0;
        int sec = 0;
        if (gmtDateStr != null) {
            try {
                gmtDateStr = gmtDateStr.trim();
                int i1 = gmtDateStr.indexOf(32);
                if (i1 > 0) {
                    String datePart = gmtDateStr.substring(0, i1).trim();
                    String timePart = gmtDateStr.substring(i1 + 1).trim();
                    year = Integer.parseInt(datePart.substring(0, 4));
                    month = Integer.parseInt(datePart.substring(5, 7));
                    day = Integer.parseInt(datePart.substring(8));
                    hour = Integer.parseInt(timePart.substring(0, 2));
                    minutes = Integer.parseInt(timePart.substring(3, 5));
                    sec = Integer.parseInt(timePart.substring(6));
                }
            }
            catch (Exception i1) {
                // empty catch block
            }
        }
        String ruleDateStr = "" + year + Utils.padInteger(month, 2, '0') + Utils.padInteger(day, 2, '0') + "T" + Utils.padInteger(hour, 2, '0') + Utils.padInteger(minutes, 2, '0') + "00Z";
        return ruleDateStr;
    }

    public static String getEncodedHref(String href) {
        if (href == null) {
            return "";
        }
        try {
            Object url = href.toLowerCase().startsWith("https") ? new HttpsURL(href) : new HttpURL(href);
            String strUrl = url.getEscapedURI();
            int index = href.indexOf(35);
            if (index >= 0 && strUrl.indexOf(35) == -1) {
                String str1 = href.substring(index + 1);
                StringTokenizer tkn = new StringTokenizer(str1, "#");
                while (tkn.hasMoreTokens()) {
                    strUrl = strUrl + "%23" + new HttpURL(tkn.nextToken()).getEscapedURI();
                }
            }
            String encodedURl = "";
            int length = strUrl.length();
            for (int i = 0; i < length; ++i) {
                char c = strUrl.charAt(i);
                encodedURl = c == '$' ? encodedURl + "%24" : (c == '&' ? encodedURl + "%26" : (c == '@' ? encodedURl + "%40" : encodedURl + c));
            }
            return encodedURl;
        }
        catch (Exception e) {
            return "";
        }
    }

    public static String encodeForBracket(String href) {
        int length = href.length();
        String encodedURl = "";
        block14: for (int i = 0; i < length; ++i) {
            char c = href.charAt(i);
            switch (c) {
                case '!': {
                    encodedURl = encodedURl + "%21";
                    continue block14;
                }
                case '#': {
                    encodedURl = encodedURl + "%23";
                    continue block14;
                }
                case '*': {
                    encodedURl = encodedURl + "%2a";
                    continue block14;
                }
                case ',': {
                    encodedURl = encodedURl + "%2c";
                    continue block14;
                }
                case '@': {
                    encodedURl = encodedURl + "%40";
                    continue block14;
                }
                case '[': {
                    encodedURl = encodedURl + "%5b";
                    continue block14;
                }
                case ']': {
                    encodedURl = encodedURl + "%5d";
                    continue block14;
                }
                case '^': {
                    encodedURl = encodedURl + "%5e";
                    continue block14;
                }
                case '`': {
                    encodedURl = encodedURl + "%60";
                    continue block14;
                }
                case '{': {
                    encodedURl = encodedURl + "%7b";
                    continue block14;
                }
                case '|': {
                    encodedURl = encodedURl + "%7c";
                    continue block14;
                }
                case '}': {
                    encodedURl = encodedURl + "%7d";
                    continue block14;
                }
                default: {
                    encodedURl = encodedURl + c;
                }
            }
        }
        return encodedURl;
    }

    private static String padInteger(int value, int padding, char padWith) {
        String valueStr = String.valueOf(value).trim();
        int diff = padding - valueStr.length();
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < diff; ++i) {
            buf.append(padWith);
        }
        return buf.toString() + value;
    }

    public static Date exchangeToLocalDate(String exchangeDate) {
        return Utils.exchangeWSToLocalDate(exchangeDate, false);
    }

    public static Date exchangeWSToLocalDate(String exchangeDate, boolean isWebServiceDate) {
        SimpleDateFormat longDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        int i1 = exchangeDate.indexOf(84);
        if (i1 < 0) {
            return null;
        }
        int i2 = -1;
        if (!isWebServiceDate) {
            i2 = exchangeDate.lastIndexOf(46);
            i2 = i1 < 0 ? exchangeDate.length() : i2;
        }
        String datePart = exchangeDate.substring(0, i1);
        String timePart = null;
        timePart = !isWebServiceDate ? exchangeDate.substring(i1 + 1, i2) : exchangeDate.substring(i1 + 1);
        try {
            String exchangeDateStr = datePart + " " + timePart;
            longDateFormat.setTimeZone(new SimpleTimeZone(0, "GMT"));
            Date dtExchange = longDateFormat.parse(exchangeDateStr);
            return new Date(dtExchange.getTime());
        }
        catch (Exception e) {
            return null;
        }
    }

    static String findProperty(String uri, String propLocalName, String propNamespaceUri, HttpClient client) throws Throwable {
        PropFindMethod findMethod = new PropFindMethod(uri);
        String strUIDRequest = "<?xml version='1.0'?><a:propfind xmlns:a='DAV:'><a:prop xmlns:" + propLocalName + "='" + propNamespaceUri + "'><" + propLocalName + ":" + propLocalName + "/></a:prop></a:propfind>";
        findMethod.setRequestBody(strUIDRequest);
        int code = client.executeMethod((HttpMethod)findMethod);
        if (code < 200 && code >= 300) {
            throw new WebDAVExceptions(2, code, null, "Error executing finProperty method");
        }
        Enumeration responses = findMethod.getResponses();
        while (responses.hasMoreElements()) {
            ResponseEntity obj = (ResponseEntity)responses.nextElement();
            Enumeration enum1 = obj.getProperties();
            while (enum1.hasMoreElements()) {
                BaseProperty prop = (BaseProperty)enum1.nextElement();
                if (!prop.getNamespaceURI().equalsIgnoreCase(propNamespaceUri) || !prop.getLocalName().equalsIgnoreCase(propLocalName)) continue;
                return prop.getPropertyAsString();
            }
        }
        return null;
    }

    public static String[] splitString(String commaDelimitedString) {
        StringTokenizer tokenizer = new StringTokenizer(commaDelimitedString, ",");
        int tokenCounts = tokenizer.countTokens();
        if (tokenCounts == 0) {
            return new String[]{commaDelimitedString};
        }
        String[] splitStrings = new String[tokenCounts];
        int i = 0;
        while (tokenizer.hasMoreElements()) {
            splitStrings[i++] = tokenizer.nextElement().toString();
        }
        return splitStrings;
    }

    public static int guessCDOTimeZoneId(TimeZone zone) {
        double offset = (double)zone.getRawOffset() / 3600000.0;
        String javaTimeZoneId = zone.getID();
        if (offset == 0.0) {
            return 1;
        }
        if (offset == 1.0) {
            if (javaTimeZoneId.equalsIgnoreCase("Europe/Amsterdam") || javaTimeZoneId.equalsIgnoreCase("Europe/Berlin") || javaTimeZoneId.equalsIgnoreCase("Europe/Rome") || javaTimeZoneId.equalsIgnoreCase("Europe/Stockholm") || javaTimeZoneId.equalsIgnoreCase("Europe/Vienna")) {
                return 4;
            }
            if (javaTimeZoneId.equalsIgnoreCase("Europe/Belgrade") || javaTimeZoneId.equalsIgnoreCase("Europe/Budapest") || javaTimeZoneId.equalsIgnoreCase("Europe/Ljubljana") || javaTimeZoneId.equalsIgnoreCase("Europe/Prague")) {
                return 6;
            }
            if (javaTimeZoneId.equalsIgnoreCase("Europe/Brussels") || javaTimeZoneId.equalsIgnoreCase("Europe/Copenhagen") || javaTimeZoneId.equalsIgnoreCase("Europe/Madrid") || javaTimeZoneId.equalsIgnoreCase("Europe/Paris")) {
                return 3;
            }
            if (javaTimeZoneId.equalsIgnoreCase("Europe/Sarajevo") || javaTimeZoneId.equalsIgnoreCase("Europe/Skopje") || javaTimeZoneId.equalsIgnoreCase("Europe/Warsaw") || javaTimeZoneId.equalsIgnoreCase("Europe/Zagreb")) {
                return 2;
            }
            return 3;
        }
        if (offset == 2.0) {
            if (javaTimeZoneId.equalsIgnoreCase("Europe/Athens") || javaTimeZoneId.equalsIgnoreCase("Asia/Istanbul") || javaTimeZoneId.equalsIgnoreCase("Europe/Minsk")) {
                return 7;
            }
            if (javaTimeZoneId.equalsIgnoreCase("Europe/Bucharest")) {
                return 5;
            }
            if (javaTimeZoneId.equalsIgnoreCase("Africa/Cairo")) {
                return 49;
            }
            if (javaTimeZoneId.equalsIgnoreCase("Africa/Harare") || javaTimeZoneId.equalsIgnoreCase("Africa/Johannesburg")) {
                return 50;
            }
            if (javaTimeZoneId.equalsIgnoreCase("Europe/Helsinki") || javaTimeZoneId.equalsIgnoreCase("Europe/Riga") || javaTimeZoneId.equalsIgnoreCase("Europe/Tallinn")) {
                return 59;
            }
            return 27;
        }
        if (offset == 3.0) {
            if (javaTimeZoneId.equalsIgnoreCase("Asia/Baghdad")) {
                return 26;
            }
            if (javaTimeZoneId.equalsIgnoreCase("Asia/Kuwait") || javaTimeZoneId.equalsIgnoreCase("Asia/Riyadh")) {
                return 74;
            }
            if (javaTimeZoneId.equalsIgnoreCase("Europe/Moscow")) {
                return 51;
            }
            if (javaTimeZoneId.equalsIgnoreCase("Africa/Nairobi")) {
                return 56;
            }
            if (javaTimeZoneId.equalsIgnoreCase("Asia/Tehran")) {
                return 25;
            }
            return 51;
        }
        if (offset == 4.0) {
            if (javaTimeZoneId.equalsIgnoreCase("Asia/Muscat")) {
                return 24;
            }
            if (javaTimeZoneId.equalsIgnoreCase("Asia/Baku") || javaTimeZoneId.equalsIgnoreCase("Asia/Tbilisi") || javaTimeZoneId.equalsIgnoreCase("Asia/Yerevan")) {
                return 54;
            }
        } else {
            if (offset == 4.3) {
                return 48;
            }
            if (offset == 5.0) {
                if (javaTimeZoneId.equalsIgnoreCase("Asia/Yekaterinburg")) {
                    return 58;
                }
                if (javaTimeZoneId.equalsIgnoreCase("Asia/Karachi") || javaTimeZoneId.equalsIgnoreCase("Asia/Tashkent")) {
                    return 47;
                }
            } else {
                if (offset == 5.5) {
                    return 23;
                }
                if (offset == 5.75) {
                    return 62;
                }
                if (offset == 6.0) {
                    if (javaTimeZoneId.equalsIgnoreCase("Asia/Almaty") || javaTimeZoneId.equalsIgnoreCase("Asia/Novosibirsk")) {
                        return 46;
                    }
                    if (javaTimeZoneId.equalsIgnoreCase("Asia/Asia/Dhaka")) {
                        return 71;
                    }
                    return 66;
                }
                if (offset == 6.5) {
                    return 61;
                }
                if (offset == 7.0) {
                    if (javaTimeZoneId.equalsIgnoreCase("Asia/Krasnoyarsk")) {
                        return 64;
                    }
                    return 22;
                }
                if (offset == 8.0) {
                    if (javaTimeZoneId.equalsIgnoreCase("Asia/Irkutsk") || javaTimeZoneId.equalsIgnoreCase("Asia/Ulaanbaatar")) {
                        return 63;
                    }
                    if (javaTimeZoneId.equalsIgnoreCase("Asia/Kuala_Lumpur") || javaTimeZoneId.equalsIgnoreCase("Asia/Singapore")) {
                        return 21;
                    }
                    if (javaTimeZoneId.equalsIgnoreCase("Australia/Perth") || javaTimeZoneId.equalsIgnoreCase("Australia/West")) {
                        return 73;
                    }
                    if (javaTimeZoneId.equalsIgnoreCase("Asia/Taipei")) {
                        return 75;
                    }
                    return 45;
                }
                if (offset == 9.0) {
                    if (javaTimeZoneId.equalsIgnoreCase("Asia/Tokyo")) {
                        return 20;
                    }
                    if (javaTimeZoneId.equalsIgnoreCase("Asia/Seoul")) {
                        return 72;
                    }
                    if (javaTimeZoneId.equalsIgnoreCase("Asia/Yakutsk")) {
                        return 70;
                    }
                    return 20;
                }
                if (offset == 9.5) {
                    if (javaTimeZoneId.equalsIgnoreCase("Australia/Darwin")) {
                        return 44;
                    }
                    return 19;
                }
                if (offset == 10.0) {
                    if (javaTimeZoneId.equalsIgnoreCase("Australia/Canberra") || javaTimeZoneId.equalsIgnoreCase("Australia/Melbourne") || javaTimeZoneId.equalsIgnoreCase("Australia/Sydney") || javaTimeZoneId.equalsIgnoreCase("Australia/Hobart")) {
                        return 76;
                    }
                    if (javaTimeZoneId.equalsIgnoreCase("Pacific/Guam") || javaTimeZoneId.equalsIgnoreCase("Pacific/Port_Moresby")) {
                        return 43;
                    }
                    if (javaTimeZoneId.equalsIgnoreCase("Australia/Hobart") || javaTimeZoneId.equalsIgnoreCase("Australia/Tasmania")) {
                        return 42;
                    }
                    if (javaTimeZoneId.equalsIgnoreCase("Asia/Vladivostok")) {
                        return 68;
                    }
                    return 18;
                }
                if (offset == 11.0) {
                    return 41;
                }
                if (offset == 12.0) {
                    if (javaTimeZoneId.equalsIgnoreCase("Pacific/Auckland")) {
                        return 17;
                    }
                    return 40;
                }
                if (offset == 13.0) {
                    return 67;
                }
                if (offset == -1.0) {
                    if (javaTimeZoneId.equalsIgnoreCase("Pacific/Auckland")) {
                        return 17;
                    }
                    return 53;
                }
                if (offset == -2.0) {
                    return 30;
                }
                if (offset == -3.0) {
                    if (javaTimeZoneId.equalsIgnoreCase("America/Buenos_Aires")) {
                        return 17;
                    }
                    return 60;
                }
                if (offset == -3.5) {
                    return 28;
                }
                if (offset == -4.0) {
                    if (javaTimeZoneId.equalsIgnoreCase("America/Caracas") || javaTimeZoneId.equalsIgnoreCase("America/La_Paz")) {
                        return 33;
                    }
                    if (javaTimeZoneId.equalsIgnoreCase("America/Santiago")) {
                        return 65;
                    }
                    return 9;
                }
                if (offset == -5.0) {
                    if (javaTimeZoneId.equalsIgnoreCase("America/Bogota") || javaTimeZoneId.equalsIgnoreCase("America/Lima")) {
                        return 35;
                    }
                    if (javaTimeZoneId.equalsIgnoreCase("US/East-Indiana")) {
                        return 34;
                    }
                    return 10;
                }
                if (offset == -6.0) {
                    if (javaTimeZoneId.equalsIgnoreCase("US/Central")) {
                        return 11;
                    }
                    if (javaTimeZoneId.equalsIgnoreCase("America/Mexico_City") || javaTimeZoneId.equalsIgnoreCase("America/Tegucigalpa")) {
                        return 37;
                    }
                    if (javaTimeZoneId.equalsIgnoreCase("Canada/East-Saskatchewan")) {
                        return 36;
                    }
                    return 55;
                }
                if (offset == -7.0) {
                    if (javaTimeZoneId.equalsIgnoreCase("US/Arizona")) {
                        return 38;
                    }
                    return 12;
                }
                if (offset == -8.0) {
                    return 13;
                }
                if (offset == -9.0) {
                    return 14;
                }
                if (offset == -10.0) {
                    return 15;
                }
                if (offset == -11.0) {
                    return 16;
                }
                if (offset == -12.0) {
                    return 39;
                }
            }
        }
        return -1;
    }
}

