/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.cloud.azure.servicebus.metadata;

import coldfusion.cloud.CloudServiceName;
import coldfusion.cloud.azure.servicebus.ServiceBusConfig;
import coldfusion.cloud.util.ConsumerMap;
import coldfusion.cloud.util.ConsumerValidator;
import coldfusion.cloud.util.FieldTypecastUtil;
import coldfusion.cloud.validator.EnumValidator;
import com.microsoft.azure.servicebus.primitives.RetryPolicy;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class SBConfigMetadata {
    static SBConfigMetadata instance = null;
    ConsumerMap<ServiceBusConfig> consumerMap = new ConsumerMap();
    String[] allowedServiceNames = new String[]{"SERVICE_BUS"};
    Set<String> allowedServicesSet = new HashSet<String>(Arrays.asList(this.allowedServiceNames));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SBConfigMetadata getInstance() {
        if (instance != null) return instance;
        Class<SBConfigMetadata> clazz = SBConfigMetadata.class;
        synchronized (SBConfigMetadata.class) {
            instance = new SBConfigMetadata();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public ConsumerMap<ServiceBusConfig> getConsumerMap() {
        return this.consumerMap;
    }

    public void setConsumerMap(ConsumerMap<ServiceBusConfig> consumerMap) {
        this.consumerMap = consumerMap;
    }

    private SBConfigMetadata() {
        this.consumerMap.put((Object)"operationTimeout", new ConsumerValidator((filler, val) -> filler.setOperationTimeout(FieldTypecastUtil.INSTANCE.getDurationProperty(val)), null));
        this.consumerMap.put((Object)"serviceName", new ConsumerValidator((filler, val) -> filler.serviceName(CloudServiceName.valueOf((String)FieldTypecastUtil.INSTANCE.getStringProperty(val))), Arrays.asList(new EnumValidator(this.allowedServicesSet, "serviceName"))));
        this.consumerMap.put((Object)"alias", new ConsumerValidator((filler, val) -> filler.setConfigAlias(FieldTypecastUtil.INSTANCE.getStringProperty(val)), null));
        this.consumerMap.put((Object)"retryPolicy", new ConsumerValidator((filler, val) -> {
            String policyString = FieldTypecastUtil.INSTANCE.getStringProperty(val);
            RetryPolicy retryPolicy = RetryPolicy.getDefault();
            if ("NoRetry".equals(policyString)) {
                retryPolicy = RetryPolicy.getNoRetry();
            }
            filler.setRetryPolicy(retryPolicy);
        }, null));
    }
}

