/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.cloud.azure.servicebus;

import coldfusion.cloud.azure.servicebus.ServiceBusAPIException;
import coldfusion.cloud.azure.servicebus.ServiceBusClient;
import coldfusion.cloud.azure.servicebus.ServiceBusClientImpl;
import coldfusion.cloud.azure.servicebus.ServiceBusSubscription;
import coldfusion.cloud.util.CloudDeserializationUtil;
import coldfusion.log.Logger;
import coldfusion.runtime.ArgumentCollection;
import coldfusion.runtime.Cast;
import coldfusion.runtime.CfJspPage;
import coldfusion.runtime.GenerateCFInvoke;
import coldfusion.runtime.GenerateCFNamedInvoke;
import coldfusion.runtime.InvokeNamedMethodInvocationMap;
import coldfusion.runtime.NamedInvokable;
import coldfusion.runtime.NamedMethodInvoker;
import coldfusion.runtime.Struct;
import coldfusion.server.ServiceFactory;
import com.microsoft.azure.servicebus.management.EntityNameHelper;
import com.microsoft.azure.servicebus.management.SubscriptionDescription;
import java.util.Map;
import javax.servlet.jsp.PageContext;

@GenerateCFInvoke
@GenerateCFNamedInvoke
public class ServiceBusSubscriptionImpl
implements ServiceBusSubscription,
NamedInvokable {
    ServiceBusClient serviceBusClient;
    String subscriptionName;
    String topicPath;
    String formattedSubscriptionPath;
    SubscriptionDescription description;
    private Logger logger = ServiceFactory.getLoggingService().getLogger("coldfusion.servicebus");
    private static InvokeNamedMethodInvocationMap<ServiceBusSubscriptionImpl> __InvokeNamedMethodInvocationMap = new InvokeNamedMethodInvocationMap();

    public ServiceBusSubscriptionImpl(ServiceBusClient serviceBusClient, String subscriptionName, String topicPath) {
        this.serviceBusClient = serviceBusClient;
        this.subscriptionName = subscriptionName;
        this.topicPath = topicPath;
        this.formattedSubscriptionPath = EntityNameHelper.formatSubscriptionPath((String)topicPath, (String)subscriptionName);
    }

    public ServiceBusSubscriptionImpl(ServiceBusClientImpl serviceBusClient, String subscriptionName, String topicPath, SubscriptionDescription description) {
        this.serviceBusClient = serviceBusClient;
        this.subscriptionName = subscriptionName;
        this.topicPath = topicPath;
        this.formattedSubscriptionPath = EntityNameHelper.formatSubscriptionPath((String)topicPath, (String)subscriptionName);
        this.description = description;
    }

    @Override
    public Struct abandonMessage(Map message) throws ServiceBusAPIException {
        return this.serviceBusClient.abandonSubscriptionMessage(this.formattedSubscriptionPath, message);
    }

    @Override
    public Struct deadLetterMessage(Map message) throws ServiceBusAPIException {
        return this.serviceBusClient.deadLetterSubscriptionMessage(this.formattedSubscriptionPath, message);
    }

    @Override
    public Struct completeMessage(Map message) throws ServiceBusAPIException {
        return this.serviceBusClient.completeSubscriptionMessage(this.formattedSubscriptionPath, message);
    }

    @Override
    public Struct setPrefetchCount(int prefetchCount) throws ServiceBusAPIException {
        return this.serviceBusClient.setSubscriptionPrefetchCount(this.formattedSubscriptionPath, prefetchCount);
    }

    @Override
    public Struct getPrefetchCount() throws ServiceBusAPIException {
        return this.serviceBusClient.getSubscriptionPrefetchCount(this.formattedSubscriptionPath);
    }

    @Override
    public Struct getRules() throws ServiceBusAPIException {
        return this.serviceBusClient.getSubscriptionRules(this.formattedSubscriptionPath);
    }

    @Override
    public void registerMessageHandler(Map messageHandler) throws ServiceBusAPIException {
        this.serviceBusClient.registerMessageHandler(this.topicPath, this.subscriptionName, messageHandler);
    }

    @Override
    public Struct addRule(Map rule) throws ServiceBusAPIException {
        return this.serviceBusClient.addSubscriptionRule(this.topicPath, this.subscriptionName, rule);
    }

    @Override
    public Struct removeRule(String ruleName) throws ServiceBusAPIException {
        return this.serviceBusClient.removeSubscriptionRule(this.topicPath, this.subscriptionName, ruleName);
    }

    @Override
    public String getTopicName() throws ServiceBusAPIException {
        return this.topicPath;
    }

    @Override
    public String getSubscriptionName() throws ServiceBusAPIException {
        return this.subscriptionName;
    }

    @Override
    public Struct getDescription() {
        return CloudDeserializationUtil.INSTANCE.beanToStruct((Object)this.description);
    }

    @Override
    public String getDeadletterQueuePath() {
        return this.serviceBusClient.getDeadletterQueuePath(this.subscriptionName);
    }

    @Override
    public Struct peekMessage(Map peekMessageOptions) throws ServiceBusAPIException {
        return this.serviceBusClient.peekMessage(this.formattedSubscriptionPath, peekMessageOptions, "subscription");
    }

    @Override
    public Struct getRuntimeInfo() throws ServiceBusAPIException {
        return this.serviceBusClient.getSubscriptionRuntimeInfo(this.topicPath, this.subscriptionName);
    }

    public Object invoke(String methodName, Map args, PageContext pageContext) throws Throwable {
        NamedMethodInvoker NamedMethodInvoker2 = __InvokeNamedMethodInvocationMap.get((Object)methodName);
        if (NamedMethodInvoker2 == null) {
            throw new CfJspPage.UnsupportedBaseTypeException(methodName, (Object)this);
        }
        this.logger.info((Object)("servicebus service method " + methodName + " invoked and started excecution... "));
        long startTime = System.currentTimeMillis();
        Object invokeObject = NamedMethodInvoker2.invoke((Object)this, args);
        long endTime = System.currentTimeMillis();
        long timeElapsed = endTime - startTime;
        this.logger.info((Object)("servicebus service method " + methodName + " finished execution successfully. Turn around time : " + timeElapsed + " milli secs"));
        return invokeObject;
    }

    static {
        __InvokeNamedMethodInvocationMap.put((Object)"abandonMessage", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"message"}, args);
                    return obj.abandonMessage(Cast._Map((Object)argColl.get((Object)"message")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("abandonMessage", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"deadLetterMessage", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"message"}, args);
                    return obj.deadLetterMessage(Cast._Map((Object)argColl.get((Object)"message")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("deadLetterMessage", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"completeMessage", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"message"}, args);
                    return obj.completeMessage(Cast._Map((Object)argColl.get((Object)"message")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("completeMessage", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"setPrefetchCount", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"prefetchCount"}, args);
                    return obj.setPrefetchCount(Cast._int((Object)argColl.get((Object)"prefetchCount"), (boolean)false));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("setPrefetchCount", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"getPrefetchCount", (obj, args) -> {
            Object argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.getPrefetchCount();
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("getPrefetchCount", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"getRules", (obj, args) -> {
            Object argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.getRules();
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("getRules", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"registerMessageHandler", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"messageHandler"}, args);
                    obj.registerMessageHandler(Cast._Map((Object)argColl.get((Object)"messageHandler")));
                    return null;
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("registerMessageHandler", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"addRule", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"rule"}, args);
                    return obj.addRule(Cast._Map((Object)argColl.get((Object)"rule")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("addRule", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"removeRule", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"ruleName"}, args);
                    return obj.removeRule(Cast._String((Object)argColl.get((Object)"ruleName")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("removeRule", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"getTopicName", (obj, args) -> {
            Object argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.getTopicName();
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("getTopicName", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"getSubscriptionName", (obj, args) -> {
            Object argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.getSubscriptionName();
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("getSubscriptionName", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"getDescription", (obj, args) -> {
            Object argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.getDescription();
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("getDescription", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"getDeadletterQueuePath", (obj, args) -> {
            Object argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.getDeadletterQueuePath();
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("getDeadletterQueuePath", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"peekMessage", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"peekMessageOptions"}, args);
                    return obj.peekMessage(Cast._Map((Object)argColl.get((Object)"peekMessageOptions")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("peekMessage", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"getRuntimeInfo", (obj, args) -> {
            Object argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.getRuntimeInfo();
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("getRuntimeInfo", obj);
        });
    }
}

