/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.pdfg.jetty;

import coldfusion.log.CFLogs;
import coldfusion.monitor.jetty.xml.JettyXmlHandler;
import coldfusion.server.ServiceFactory;
import coldfusion.util.RB;
import java.io.File;
import java.io.IOException;
import java.net.ServerSocket;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.xml.XmlConfiguration;

public class PDFGServer {
    private static PDFGServer instance = null;
    private int serverPort = 0;
    private String protocol;
    private Server server;
    private File jettyFile = new File(ServiceFactory.getRuntimeService().getLibDir(), "jetty.xml");
    private JettyXmlHandler xmlHandler;
    private String serverHost;
    private static final String JETTY_XML = "jetty.xml";

    public static PDFGServer getInstance() {
        if (instance == null) {
            instance = new PDFGServer();
        }
        return instance;
    }

    private PDFGServer() {
        if (this.xmlHandler == null) {
            this.xmlHandler = JettyXmlHandler.getInstance((File)this.jettyFile);
        }
    }

    public void startServer() throws Exception {
        if (this.isRunning()) {
            return;
        }
        this.server = this.configureServer();
        CFLogs.MONITOR_LOG.info((Object)RB.getString((Object)this, (String)"startServerMsg", (Object)String.valueOf(this.serverPort)));
        try {
            if (this.server == null) {
                String error = RB.getString((Object)this, (String)"errorServerStart");
                CFLogs.SERVER_LOG.error((Object)error);
                throw new Exception(error);
            }
            this.server.start();
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    PDFGServer.this.stopServer();
                }
            });
        }
        catch (Exception e) {
            CFLogs.SERVER_LOG.error((Throwable)e);
            throw e;
        }
    }

    private Server configureServer() throws Exception {
        Server server = null;
        try {
            Connector[] connectors;
            XmlConfiguration configuration;
            if (this.jettyFile != null && this.jettyFile.exists() && (configuration = new XmlConfiguration(Resource.newResource((File)this.jettyFile))) != null && (connectors = (server = (Server)configuration.configure()).getConnectors()) != null && connectors.length > 0) {
                ServerConnector serverConnector = (ServerConnector)connectors[0];
                this.serverHost = serverConnector.getHost();
                int port = this.getPort(true);
                this.serverPort = this.getPortToRun(port);
                serverConnector.setPort(this.serverPort);
            }
        }
        catch (Exception e) {
            CFLogs.SERVER_LOG.error((Throwable)e);
            throw e;
        }
        return server;
    }

    private int getPortToRun(int defaultPort) throws Exception {
        int port = defaultPort;
        try {
            this.checkIfPortFree(defaultPort);
        }
        catch (Exception e) {
            CFLogs.SERVER_LOG.error((Throwable)e);
            try {
                port = this.getFreeSocketPort(0);
            }
            catch (Exception e1) {
                CFLogs.SERVER_LOG.error((Throwable)e1);
                throw e1;
            }
        }
        return port;
    }

    private synchronized void checkIfPortFree(final int portToTry) throws Exception {
        if (System.getSecurityManager() == null) {
            this.portCheck(portToTry);
        } else {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Integer>(){

                    @Override
                    public Integer run() throws Exception {
                        PDFGServer.this.portCheck(portToTry);
                        return 0;
                    }
                });
            }
            catch (PrivilegedActionException ex) {
                throw ex.getException();
            }
        }
    }

    private void portCheck(int portToTry) throws IOException {
        ServerSocket soc = new ServerSocket(portToTry);
        soc.close();
    }

    public int getFreeSocketPort(final int portToTry) throws Exception {
        if (System.getSecurityManager() == null) {
            ServerSocket soc = new ServerSocket(portToTry);
            int serverPort = soc.getLocalPort();
            soc.close();
            return serverPort;
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Integer>(){

                @Override
                public Integer run() throws Exception {
                    ServerSocket soc = new ServerSocket(portToTry);
                    int serverPort = soc.getLocalPort();
                    soc.close();
                    return serverPort;
                }
            });
        }
        catch (PrivilegedActionException ex) {
            throw ex.getException();
        }
    }

    public boolean isRunning() {
        return this.server != null && (this.server.isRunning() || this.server.isStarted() || this.server.isStarting());
    }

    public void stopServer() {
        try {
            if (this.server != null) {
                CFLogs.MONITOR_LOG.info((Object)RB.getString((Object)this, (String)"stopServerMsg"));
                this.server.stop();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public int getPort() {
        return this.getPort(false);
    }

    private int getPort(boolean readXML) {
        if (this.serverPort == 0 || readXML) {
            this.serverPort = new Integer(this.xmlHandler.getPortValue());
        }
        return this.serverPort;
    }

    public String getProtocol() {
        if (this.protocol == null) {
            this.protocol = this.xmlHandler.getProtocol();
        }
        return this.protocol;
    }

    public String getHost() {
        return this.serverHost;
    }
}

