/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.syndication;

import coldfusion.log.Logger;
import coldfusion.runtime.Cast;
import coldfusion.runtime.OleDateTime;
import coldfusion.runtime.Struct;
import coldfusion.runtime.StructUtils;
import coldfusion.server.ServiceFactory;
import coldfusion.sql.QueryTable;
import coldfusion.syndication.AtomGenerator;
import coldfusion.syndication.FeedSyndicationException;
import coldfusion.syndication.FeedTable;
import coldfusion.syndication.RSSGenerator;
import coldfusion.wddx.SpecialCharInfo;
import coldfusion.wddx.UTF8Converter;
import com.sun.syndication.feed.WireFeed;
import com.sun.syndication.io.FeedException;
import com.sun.syndication.io.WireFeedOutput;
import com.sun.syndication.io.impl.DateParser;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class FeedGenerator {
    WireFeed resultFeed = null;
    public static boolean escapeChars = false;
    static final Set validColumns = new HashSet(FeedTable.columnNames.length);
    private static Logger feedGeneratorLog = ServiceFactory.getLoggingService().getLogger("coldfusion.feed");

    public WireFeed createFeed(Struct feedStruct) {
        String feedType = (String)feedStruct.get((Object)"version");
        if (feedType == null) {
            feedType = "atom_1.0";
        }
        long startTime = System.currentTimeMillis();
        if (feedType.equalsIgnoreCase("rss_2.0")) {
            feedGeneratorLog.info((Object)"Generating rss FEED");
            RSSGenerator rssFeed = new RSSGenerator();
            rssFeed.createRSSChannel(feedStruct, feedType);
            this.resultFeed = rssFeed;
            feedGeneratorLog.info((Object)("FEED generation completed {Time taken=" + (System.currentTimeMillis() - startTime) + " ms}"));
        } else if (feedType.equalsIgnoreCase("atom_1.0")) {
            feedGeneratorLog.info((Object)"Generating atom FEED");
            AtomGenerator atomFeed = new AtomGenerator();
            atomFeed.createATOMFeed(feedStruct, feedType);
            this.resultFeed = atomFeed;
            feedGeneratorLog.info((Object)("FEED generation completed {Time taken=" + (System.currentTimeMillis() - startTime) + " ms}"));
        } else {
            throw new UnsupportedFeedTypeException(feedType);
        }
        return this.resultFeed;
    }

    public WireFeed createFeed(QueryTable feedQuery, Struct feedMetadata, Struct columnMap) {
        String feedType = (String)feedMetadata.get((Object)"version");
        long startTime = System.currentTimeMillis();
        columnMap = FeedGenerator.setupColumnMap(columnMap, feedQuery);
        if (feedType == null) {
            feedType = "atom_1.0";
        }
        if (feedType.equalsIgnoreCase("rss_2.0")) {
            feedGeneratorLog.info((Object)"Generating rss FEED");
            RSSGenerator rssFeed = new RSSGenerator();
            rssFeed.createRSSChannel(feedMetadata, feedQuery, columnMap, feedType);
            this.resultFeed = rssFeed;
            feedGeneratorLog.info((Object)("FEED generation completed {Time taken=" + (System.currentTimeMillis() - startTime) + " ms}"));
        } else if (feedType.equalsIgnoreCase("atom_1.0")) {
            feedGeneratorLog.info((Object)"Generating atom FEED");
            AtomGenerator atomFeed = new AtomGenerator();
            atomFeed.createATOMFeed(feedMetadata, feedQuery, columnMap, feedType);
            this.resultFeed = atomFeed;
            feedGeneratorLog.info((Object)("FEED generation completed {Time taken=" + (System.currentTimeMillis() - startTime) + " ms}"));
        } else {
            throw new UnsupportedFeedTypeException(feedType);
        }
        return this.resultFeed;
    }

    public String getFeedXML() {
        if (this.resultFeed != null) {
            WireFeedOutput wfo = new WireFeedOutput();
            try {
                return wfo.outputString(this.resultFeed);
            }
            catch (IllegalArgumentException e) {
                throw new FeedCreationException(e.getMessage());
            }
            catch (FeedException e) {
                throw new FeedCreationException(e.getMessage());
            }
        }
        return null;
    }

    static Struct setupColumnMap(Struct columnMap, QueryTable feedQuery) {
        int i;
        Struct newColumnMap = new Struct();
        if (feedQuery.getColumn("ITUNES_AUTHOR") != null) {
            for (i = 0; i < FeedTable.iTunesColumnNames.length; ++i) {
                StructUtils.StructInsert((Map)newColumnMap, (String)FeedTable.iTunesColumnNames[i], (Object)FeedTable.iTunesColumnNames[i], (boolean)false);
            }
        } else {
            for (i = 0; i < FeedTable.columnNames.length; ++i) {
                StructUtils.StructInsert((Map)newColumnMap, (String)FeedTable.columnNames[i], (Object)FeedTable.columnNames[i], (boolean)false);
            }
        }
        if (columnMap != null && columnMap.size() > 0) {
            String[] queryColumnNames = feedQuery.getColumnList();
            HashSet<String> queryColumns = new HashSet<String>(columnMap.size());
            for (int i2 = 0; i2 < queryColumnNames.length; ++i2) {
                queryColumns.add(queryColumnNames[i2]);
            }
            for (Object key : columnMap.keySet()) {
                if (!validColumns.contains(key)) {
                    throw new InvalidColumnNameMapping((String)key);
                }
                Object value = columnMap.get(key);
                boolean containsKey = false;
                if (value != null) {
                    Iterator itr = queryColumns.iterator();
                    while (itr.hasNext()) {
                        if (!value.toString().equalsIgnoreCase(itr.next().toString())) continue;
                        containsKey = true;
                    }
                }
                if (containsKey) continue;
                throw new ColumnDoesNotExistInQueryException((String)value);
            }
            newColumnMap.putAll((Map)columnMap);
        }
        return newColumnMap;
    }

    static String checkBlankValue(String value) {
        return FeedGenerator.checkBlankValue(value, true);
    }

    static String checkBlankValue(String value, boolean isNotDate) {
        String str;
        if (value == null || value.length() == 0) {
            return null;
        }
        String string = str = value.equals(" ") ? null : value;
        if (str == null) {
            return null;
        }
        StringBuffer out = new StringBuffer((int)(1.5 * (double)str.length()));
        if (escapeChars) {
            FeedGenerator.escapeXML(str, out, isNotDate);
        } else {
            out.append(value);
        }
        return out.toString();
    }

    static String getColumnValue(QueryTable feedQuery, String colName, Struct columnMap) {
        return FeedGenerator.getColumnValue(feedQuery, colName, columnMap, true);
    }

    static String getColumnValue(QueryTable feedQuery, String colName, Struct columnMap, boolean isNotDate) {
        Object obj = feedQuery.getObject((String)columnMap.get((Object)colName));
        if (obj == null) {
            return null;
        }
        String value = null;
        value = obj instanceof char[] ? new String((char[])obj) : obj.toString();
        StringBuffer out = new StringBuffer((int)(1.5 * (double)value.length()));
        if (escapeChars) {
            FeedGenerator.escapeXML(value, out, isNotDate);
        } else {
            out.append(value);
        }
        return out.toString();
    }

    static String getString(Struct struct, String attributeName) {
        Object value = struct.get((Object)attributeName);
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            StringBuffer out = new StringBuffer((int)(1.5 * (double)((String)value).length()));
            if (escapeChars) {
                FeedGenerator.escapeXML((String)value, out, true);
            } else {
                out.append((String)value);
            }
            return out.toString();
        }
        throw new InvalidAttributeTypeException(attributeName, "String");
    }

    static Date getDate(Struct struct, String attributeName) {
        Object dateObj = struct.get((Object)attributeName);
        if (dateObj == null) {
            return null;
        }
        Object parseDate = null;
        if (dateObj instanceof OleDateTime) {
            parseDate = (OleDateTime)dateObj;
        } else if (dateObj instanceof String) {
            parseDate = FeedGenerator.getDate((String)dateObj, attributeName);
        } else {
            throw new InvalidAttributeTypeException(attributeName, "Valid date");
        }
        return parseDate;
    }

    static Date getDate(String value, String attributeName) {
        if (value == null) {
            return null;
        }
        Date parseDate = null;
        try {
            parseDate = DateParser.parseDate((String)value);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (parseDate == null) {
            try {
                parseDate = Cast._Date((String)value);
            }
            catch (RuntimeException e) {
                throw new UnparseableDateException(e.getMessage(), attributeName);
            }
        }
        if (parseDate == null) {
            throw new UnparseableDateException("Unable to convert " + attributeName + " to a date.", attributeName);
        }
        return parseDate;
    }

    static Integer getInteger(Struct struct, String attributeName) {
        Object value = struct.get((Object)attributeName);
        if (value == null) {
            return null;
        }
        try {
            return new Integer(Cast._int((Object)value));
        }
        catch (Cast.NumberConversionException e) {
            throw new InvalidAttributeTypeException(attributeName, "Number");
        }
    }

    static Long getLong(Struct struct, String attributeName) {
        Object value = struct.get((Object)attributeName);
        if (value == null) {
            return null;
        }
        try {
            return new Long(Cast._long((Object)value));
        }
        catch (Cast.NumberConversionException e) {
            throw new InvalidAttributeTypeException(attributeName, "Number");
        }
    }

    private static void escapeXML(String in, StringBuffer out, boolean escapeNewSet) {
        int length = in.length();
        SpecialCharInfo[] chars = null;
        if (escapeNewSet) {
            chars = UTF8Converter.getAttrCharInfo();
        }
        for (int i = 0; i < length; ++i) {
            char c = in.charAt(i);
            if (escapeNewSet && c > '\u009f' && c < '\u0100') {
                out.append(chars[c].encoding);
                continue;
            }
            if (escapeNewSet && (c > '\u0000' && c < '\t' || c == '\u000b' || c == '\f' || c > '\r' && c < ' ' || c > '~' && c < '\u0085' || c > '\u0085' && c < '\u00a0' || c > '\ufdcf' && c < '\ufde0' || c > '\ufffd' && c < '\u10000' || c > '\u1fffd' && c < '\u20000' || c > '\u2fffd' && c < '\u30000' || c > '\u3fffd' && c < '\u40000' || c > '\u4fffd' && c < '\u50000' || c > '\u5fffd' && c < '\u60000' || c > '\u6fffd' && c < '\u70000' || c > '\u7fffd' && c < '\u80000' || c > '\u8fffd' && c < '\u90000' || c > '\u9fffd' && c < '\ua0000' || c > '\uafffd' && c < '\ub0000' || c > '\ubfffd' && c < '\uc0000' || c > '\ucfffd' && c < '\ud0000' || c > '\udfffd' && c < '\ue0000' || c > '\uefffd' && c < '\uf0000' || c > '\uffffd' && c < '\u100000' || c > '\u10fffd' && c < '\u110000')) continue;
            out.append(c);
        }
    }

    static {
        for (int i = 0; i < FeedTable.columnNames.length; ++i) {
            validColumns.add(FeedTable.columnNames[i]);
        }
    }

    public static class ColumnDoesNotExistInQueryException
    extends FeedSyndicationException {
        public String columnName;

        public ColumnDoesNotExistInQueryException(String columnName) {
            this.columnName = columnName;
        }
    }

    public static class InvalidColumnNameMapping
    extends FeedSyndicationException {
        public String columnName;

        public InvalidColumnNameMapping(String columnName) {
            this.columnName = columnName;
        }
    }

    public static class UnparseableDateException
    extends FeedSyndicationException {
        public String message;
        public String attributeName;

        public UnparseableDateException(String message, String attributeName) {
            this.message = message;
            this.attributeName = attributeName;
        }
    }

    public static class InvalidLinkAttributeTypeException
    extends FeedSyndicationException {
        public String attribute;

        public InvalidLinkAttributeTypeException(String attribute) {
            this.attribute = attribute;
        }
    }

    public static class InvalidAttributeTypeException
    extends FeedSyndicationException {
        public String attribute;
        public String attributeType;

        public InvalidAttributeTypeException(String attribute, String attributeType) {
            this.attribute = attribute;
            this.attributeType = attributeType;
        }
    }

    public static class UnequalColumnValuesException
    extends FeedSyndicationException {
        public String field;

        public UnequalColumnValuesException(String field) {
            this.field = field;
        }
    }

    public static class FeedCreationException
    extends FeedSyndicationException {
        public String message;

        public FeedCreationException(String message) {
            this.message = message;
        }
    }

    public class UnsupportedFeedTypeException
    extends FeedSyndicationException {
        public String feedType;

        public UnsupportedFeedTypeException(String feedType) {
            this.feedType = feedType;
        }
    }
}

