/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.nosql.mongo.codecs;

import coldfusion.nosql.mongo.bson.BsonUtils;
import coldfusion.nosql.mongo.bson.types.CFBsonJS;
import coldfusion.nosql.mongo.codecs.CFMongoCodec;
import coldfusion.runtime.Array;
import coldfusion.runtime.Struct;
import java.util.Map;
import java.util.UUID;
import org.bson.BsonBinarySubType;
import org.bson.BsonDocument;
import org.bson.BsonReader;
import org.bson.BsonType;
import org.bson.BsonWriter;
import org.bson.codecs.BsonTypeCodecMap;
import org.bson.codecs.Codec;
import org.bson.codecs.Decoder;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.configuration.CodecRegistry;

public class CFBsonJSCodec
implements Codec<CFBsonJS> {
    private Codec<BsonDocument> bsonDocumentCodec;
    private CodecRegistry registry;
    private BsonTypeCodecMap bsonTypeCodecMap;

    public CFBsonJSCodec(CodecRegistry codecRegistry) {
        this.registry = codecRegistry;
        this.bsonDocumentCodec = codecRegistry.get(BsonDocument.class);
        this.bsonTypeCodecMap = new BsonTypeCodecMap(CFMongoCodec.bsonTypeClassMap, codecRegistry);
    }

    public void encode(BsonWriter writer, CFBsonJS value, EncoderContext encoderContext) {
        if (value.getScope() == null) {
            writer.writeJavaScript(value.getCode());
        } else {
            writer.writeJavaScriptWithScope(value.getCode());
            BsonDocument bsonDocument = BsonUtils.to(value.getScope());
            this.bsonDocumentCodec.encode(writer, (Object)bsonDocument, encoderContext);
        }
    }

    public Class<CFBsonJS> getEncoderClass() {
        return CFBsonJS.class;
    }

    public CFBsonJS decode(BsonReader reader, DecoderContext decoderContext) {
        BsonType currentBsonType = reader.getCurrentBsonType();
        if (currentBsonType == BsonType.JAVASCRIPT) {
            return new CFBsonJS(reader.readJavaScript());
        }
        String code = reader.readJavaScriptWithScope();
        Struct s = new Struct();
        reader.readStartDocument();
        while (reader.readBsonType() != BsonType.END_OF_DOCUMENT) {
            String fieldName = reader.readName();
            s.put((Object)fieldName, this.readValue(reader, decoderContext));
        }
        reader.readEndDocument();
        return new CFBsonJS(code, (Map)s);
    }

    private Object readValue(BsonReader reader, DecoderContext decoderContext) {
        BsonType bsonType = reader.getCurrentBsonType();
        if (bsonType == BsonType.NULL) {
            reader.readNull();
            return null;
        }
        if (bsonType == BsonType.ARRAY) {
            return decoderContext.decodeWithChildContext((Decoder)this.registry.get(Array.class), reader);
        }
        if (bsonType == BsonType.BINARY && BsonBinarySubType.isUuid((byte)reader.peekBinarySubType()) && reader.peekBinarySize() == 16) {
            return decoderContext.decodeWithChildContext((Decoder)this.registry.get(UUID.class), reader);
        }
        return this.bsonTypeCodecMap.get(bsonType).decode(reader, decoderContext);
    }
}

