/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util;

import java.io.File;
import java.lang.invoke.MethodHandles;
import java.nio.file.Paths;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.io.FileUtils;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.lucene.util.SuppressForbidden;
import org.apache.solr.client.solrj.impl.HttpClientUtil;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.Pair;
import org.apache.solr.packagemanager.PackageManager;
import org.apache.solr.packagemanager.PackageUtils;
import org.apache.solr.packagemanager.RepositoryManager;
import org.apache.solr.packagemanager.SolrPackage;
import org.apache.solr.packagemanager.SolrPackageInstance;
import org.apache.solr.util.SolrCLI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PackageTool
extends SolrCLI.ToolBase {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static String solrUrl = null;
    public static String solrBaseUrl = null;
    public PackageManager packageManager;
    public RepositoryManager repositoryManager;

    @SuppressForbidden(reason="Need to turn off logging, and SLF4J doesn't seem to provide for a way.")
    public PackageTool() {
        Configurator.setRootLevel((Level)Level.OFF);
    }

    @Override
    public String getName() {
        return "package";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    @SuppressForbidden(reason="We really need to print the stacktrace here, otherwise there shall be little else information to debug problems. Other SolrCLI tools don't print stack traces, hence special treatment is needed here.")
    protected void runImpl(CommandLine cli) throws Exception {
        try {
            block53: {
                PackageTool.solrUrl = cli.getOptionValues("solrUrl")[cli.getOptionValues("solrUrl").length - 1];
                PackageTool.solrBaseUrl = PackageTool.solrUrl.replaceAll("\\/solr$", "");
                PackageTool.log.info("Solr url:{}, solr base url: {}", (Object)PackageTool.solrUrl, (Object)PackageTool.solrBaseUrl);
                zkHost = this.getZkHost(cli);
                PackageTool.log.info("ZK: {}", (Object)zkHost);
                cmd = cli.getArgList().size() == 0 ? "help" : cli.getArgs()[0];
                solrClient = new HttpSolrClient.Builder(PackageTool.solrBaseUrl).build();
                try {
                    if (cmd == null) break block53;
                    this.packageManager = new PackageManager(solrClient, PackageTool.solrBaseUrl, zkHost);
                    try {
                        this.repositoryManager = new RepositoryManager(solrClient, this.packageManager);
                        var5_6 = cmd;
                        var6_8 = -1;
                        switch (var5_6.hashCode()) {
                            case -1282064098: {
                                if (!var5_6.equals("add-repo")) break;
                                var6_8 = 0;
                                break;
                            }
                            case -1149742285: {
                                if (!var5_6.equals("add-key")) break;
                                var6_8 = 1;
                                break;
                            }
                            case -60744437: {
                                if (!var5_6.equals("list-installed")) break;
                                var6_8 = 2;
                                break;
                            }
                            case -823693222: {
                                if (!var5_6.equals("list-available")) break;
                                var6_8 = 3;
                                break;
                            }
                            case -1556184043: {
                                if (!var5_6.equals("list-deployed")) break;
                                var6_8 = 4;
                                break;
                            }
                            case 1957569947: {
                                if (!var5_6.equals("install")) break;
                                var6_8 = 5;
                                break;
                            }
                            case -1335332633: {
                                if (!var5_6.equals("deploy")) break;
                                var6_8 = 6;
                                break;
                            }
                            case -448829248: {
                                if (!var5_6.equals("undeploy")) break;
                                var6_8 = 7;
                                break;
                            }
                            case -625596190: {
                                if (!var5_6.equals("uninstall")) break;
                                var6_8 = 8;
                                break;
                            }
                            case 3198785: {
                                if (!var5_6.equals("help")) break;
                                var6_8 = 9;
                                break;
                            }
                            case 111574433: {
                                if (!var5_6.equals("usage")) break;
                                var6_8 = 10;
                            }
                        }
                        switch (var6_8) {
                            case 0: {
                                repoName = cli.getArgs()[1];
                                repoUrl = cli.getArgs()[2];
                                this.repositoryManager.addRepository(repoName, repoUrl);
                                PackageUtils.printGreen("Added repository: " + repoName);
                                ** break;
lbl67:
                                // 1 sources

                                break;
                            }
                            case 1: {
                                keyFilename = cli.getArgs()[1];
                                this.repositoryManager.addKey(FileUtils.readFileToByteArray((File)new File(keyFilename)), Paths.get(keyFilename, new String[0]).getFileName().toString());
                                ** break;
lbl72:
                                // 1 sources

                                break;
                            }
                            case 2: {
                                PackageUtils.printGreen("Installed packages:\n-----");
                                for (SolrPackageInstance pkg : this.packageManager.fetchInstalledPackageInstances()) {
                                    PackageUtils.printGreen(pkg);
                                }
                                break;
                            }
                            case 3: {
                                PackageUtils.printGreen("Available packages:\n-----");
                                for (SolrPackage pkg : this.repositoryManager.getPackages()) {
                                    PackageUtils.printGreen(pkg.name + " \t\t" + pkg.description);
                                    for (SolrPackage.SolrPackageRelease version : pkg.versions) {
                                        PackageUtils.printGreen("\tVersion: " + version.version);
                                    }
                                }
                                break;
                            }
                            case 4: {
                                if (cli.hasOption('c')) {
                                    collection = cli.getArgs()[1];
                                    packages = this.packageManager.getPackagesDeployed(collection);
                                    PackageUtils.printGreen("Packages deployed on " + collection + ":");
                                    for (String packageName : packages.keySet()) {
                                        PackageUtils.printGreen("\t" + packages.get(packageName));
                                    }
                                } else {
                                    packageName = cli.getArgs()[1];
                                    deployedCollections = this.packageManager.getDeployedCollections(packageName);
                                    if (!deployedCollections.isEmpty()) {
                                        PackageUtils.printGreen("Collections on which package " + packageName + " was deployed:");
                                        for (String collection : deployedCollections.keySet()) {
                                            PackageUtils.printGreen("\t" + collection + "(" + packageName + ":" + deployedCollections.get(collection) + ")");
                                        }
                                    } else {
                                        PackageUtils.printGreen("Package " + packageName + " not deployed on any collection.");
                                        ** break;
                                    }
                                }
lbl107:
                                // 1 sources

                                break;
                            }
                            case 5: {
                                parsedVersion = this.parsePackageVersion(((String)cli.getArgList().get(1)).toString());
                                packageName = (String)parsedVersion.first();
                                version = (String)parsedVersion.second();
                                success = this.repositoryManager.install(packageName, version);
                                if (success) {
                                    PackageUtils.printGreen(packageName + " installed.");
                                    ** break;
lbl116:
                                    // 1 sources

                                } else {
                                    PackageUtils.printRed(packageName + " installation failed.");
                                    ** break;
                                }
lbl119:
                                // 1 sources

                                break;
                            }
                            case 6: {
                                if (cli.hasOption("cluster") || cli.hasOption("collections")) {
                                    parsedVersion = this.parsePackageVersion(((String)cli.getArgList().get(1)).toString());
                                    packageName = (String)parsedVersion.first();
                                    version = (String)parsedVersion.second();
                                    noprompt = cli.hasOption('y');
                                    isUpdate = cli.hasOption("update") != false || cli.hasOption('u') != false;
                                    collections = cli.hasOption("collections") != false ? PackageUtils.validateCollections(cli.getOptionValue("collections").split(",")) : new String[]{};
                                    this.packageManager.deploy(packageName, version, collections, cli.hasOption("cluster"), cli.getOptionValues("param"), isUpdate, noprompt);
                                    ** break;
lbl130:
                                    // 1 sources

                                } else {
                                    PackageUtils.printRed("Either specify -cluster to deploy cluster level plugins or -collections <list-of-collections> to deploy collection level plugins");
                                    ** break;
                                }
lbl133:
                                // 1 sources

                                break;
                            }
                            case 7: {
                                if (cli.hasOption("cluster") || cli.hasOption("collections")) {
                                    parsedVersion = this.parsePackageVersion(((String)cli.getArgList().get(1)).toString());
                                    if (parsedVersion.second() != null) {
                                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Only package name expected, without a version. Actual: " + (String)cli.getArgList().get(1));
                                    }
                                    packageName = (String)parsedVersion.first();
                                    collections = cli.hasOption("collections") != false ? PackageUtils.validateCollections(cli.getOptionValue("collections").split(",")) : new String[]{};
                                    this.packageManager.undeploy(packageName, collections, cli.hasOption("cluster"));
                                    ** break;
lbl143:
                                    // 1 sources

                                } else {
                                    PackageUtils.printRed("Either specify -cluster to undeploy cluster level plugins or -collections <list-of-collections> to undeploy collection level plugins");
                                    ** break;
                                }
lbl146:
                                // 1 sources

                                break;
                            }
                            case 8: {
                                parsedVersion = this.parsePackageVersion(((String)cli.getArgList().get(1)).toString());
                                if (parsedVersion.second() == null) {
                                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Package name and version are both required. Actual: " + (String)cli.getArgList().get(1));
                                }
                                packageName = (String)parsedVersion.first();
                                version = (String)parsedVersion.second();
                                this.packageManager.uninstall(packageName, version);
                                ** break;
lbl155:
                                // 1 sources

                                break;
                            }
                            case 9: 
                            case 10: {
                                PackageUtils.print("Package Manager\n---------------");
                                PackageUtils.printGreen("./solr package add-repo <repository-name> <repository-url>");
                                PackageUtils.print("Add a repository to Solr.");
                                PackageUtils.print("");
                                PackageUtils.printGreen("./solr package add-key <file-containing-trusted-key>");
                                PackageUtils.print("Add a trusted key to Solr.");
                                PackageUtils.print("");
                                PackageUtils.printGreen("./solr package install <package-name>[:<version>] ");
                                PackageUtils.print("Install a package into Solr. This copies over the artifacts from the repository into Solr's internal package store and sets up classloader for this package to be used.");
                                PackageUtils.print("");
                                PackageUtils.printGreen("./solr package deploy <package-name>[:<version>] [-y] [--update] -collections <comma-separated-collections> [-p <param1>=<val1> -p <param2>=<val2> ...] ");
                                PackageUtils.print("Bootstraps a previously installed package into the specified collections. It the package accepts parameters for its setup commands, they can be specified (as per package documentation).");
                                PackageUtils.print("");
                                PackageUtils.printGreen("./solr package list-installed");
                                PackageUtils.print("Print a list of packages installed in Solr.");
                                PackageUtils.print("");
                                PackageUtils.printGreen("./solr package list-available");
                                PackageUtils.print("Print a list of packages available in the repositories.");
                                PackageUtils.print("");
                                PackageUtils.printGreen("./solr package list-deployed -c <collection>");
                                PackageUtils.print("Print a list of packages deployed on a given collection.");
                                PackageUtils.print("");
                                PackageUtils.printGreen("./solr package list-deployed <package-name>");
                                PackageUtils.print("Print a list of collections on which a given package has been deployed.");
                                PackageUtils.print("");
                                PackageUtils.printGreen("./solr package undeploy <package-name> -collections <comma-separated-collections>");
                                PackageUtils.print("Undeploys a package from specified collection(s)");
                                PackageUtils.print("");
                                PackageUtils.printGreen("./solr package uninstall <package-name>:<version>");
                                PackageUtils.print("Uninstall an unused package with specified version from Solr. Both package name and version are required.");
                                PackageUtils.print("\n");
                                PackageUtils.print("Note: (a) Please add '-solrUrl http://host:port' parameter if needed (usually on Windows).");
                                PackageUtils.print("      (b) Please make sure that all Solr nodes are started with '-Denable.packages=true' parameter.");
                                PackageUtils.print("\n");
                                ** break;
lbl192:
                                // 1 sources

                                break;
                            }
                            default: {
                                throw new RuntimeException("Unrecognized command: " + cmd);
                            }
                        }
                    }
                    finally {
                        this.packageManager.close();
                    }
                }
                finally {
                    if (solrClient != null) {
                        solrClient.close();
                    }
                }
            }
            PackageTool.log.info("Finished: {}", (Object)cmd);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
    }

    private Pair<String, String> parsePackageVersion(String arg) {
        String[] splits = arg.split(":");
        if (splits.length > 2) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Invalid package name: " + arg + ". Didn't match the pattern: <packagename>:<version> or <packagename>");
        }
        String packageName = splits[0];
        String version = splits.length == 2 ? splits[1] : null;
        return new Pair((Object)packageName, (Object)version);
    }

    @Override
    public Option[] getOptions() {
        return new Option[]{Option.builder((String)"solrUrl").argName("URL").hasArg().required(true).desc("Address of the Solr Web application, defaults to: http://localhost:8983/solr.").build(), Option.builder((String)"collections").argName("COLLECTIONS").hasArg().required(false).desc("Specifies that this action should affect plugins for the given collections only, excluding cluster level plugins.").build(), Option.builder((String)"cluster").required(false).desc("Specifies that this action should affect cluster-level plugins only.").build(), Option.builder((String)"p").argName("PARAMS").hasArgs().required(false).desc("List of parameters to be used with deploy command.").longOpt("param").build(), Option.builder((String)"u").required(false).desc("If a deployment is an update over a previous deployment.").longOpt("update").build(), Option.builder((String)"c").required(false).desc("The collection to apply the package to, not required.").longOpt("collection").build(), Option.builder((String)"y").required(false).desc("Don't prompt for input; accept all default choices, defaults to false.").longOpt("noprompt").build()};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getZkHost(CommandLine cli) throws Exception {
        String zkHost = cli.getOptionValue("zkHost");
        if (zkHost != null) {
            return zkHost;
        }
        String systemInfoUrl = solrUrl + "/admin/info/system";
        CloseableHttpClient httpClient = SolrCLI.getHttpClient();
        try {
            Map<String, Object> systemInfo = SolrCLI.getJson((HttpClient)httpClient, systemInfoUrl, 2, true);
            SolrCLI.StatusTool statusTool = new SolrCLI.StatusTool();
            Map<String, Object> status = statusTool.reportStatus(solrUrl + "/", systemInfo, (HttpClient)httpClient);
            Map cloud = (Map)status.get("cloud");
            if (cloud != null) {
                String zookeeper = (String)cloud.get("ZooKeeper");
                if (zookeeper.endsWith("(embedded)")) {
                    zookeeper = zookeeper.substring(0, zookeeper.length() - "(embedded)".length());
                }
                zkHost = zookeeper;
            }
        }
        finally {
            HttpClientUtil.close((HttpClient)httpClient);
        }
        return zkHost;
    }
}

