/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.file.NoSuchFileException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.util.CharFilterFactory;
import org.apache.lucene.analysis.util.TokenFilterFactory;
import org.apache.lucene.analysis.util.TokenizerFactory;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FilterLeafReader;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.MultiTerms;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.similarities.Similarity;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.CharsRefBuilder;
import org.apache.lucene.util.PriorityQueue;
import org.apache.solr.analysis.TokenizerChain;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.luke.FieldFlag;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.Base64;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.core.SolrInfoBean;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.schema.CopyField;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.SolrIndexSearcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LukeRequestHandler
extends RequestHandlerBase {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String NUMTERMS = "numTerms";
    public static final String INCLUDE_INDEX_FIELD_FLAGS = "includeIndexFieldFlags";
    public static final String DOC_ID = "docId";
    public static final String ID = "id";
    public static final int DEFAULT_COUNT = 10;
    static final int HIST_ARRAY_SIZE = 33;

    @Override
    public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        IndexSchema schema = req.getSchema();
        SolrIndexSearcher searcher = req.getSearcher();
        DirectoryReader reader = searcher.getIndexReader();
        SolrParams params = req.getParams();
        ShowStyle style = ShowStyle.get(params.get("show"));
        rsp.add("index", LukeRequestHandler.getIndexInfo(reader));
        if (ShowStyle.INDEX == style) {
            return;
        }
        Integer docId = params.getInt(DOC_ID);
        if (docId == null && params.get(ID) != null) {
            SchemaField uniqueKey = schema.getUniqueKeyField();
            String v = uniqueKey.getType().toInternal(params.get(ID));
            Term t = new Term(uniqueKey.getName(), v);
            docId = searcher.getFirstMatch(t);
            if (docId < 0) {
                throw new SolrException(SolrException.ErrorCode.NOT_FOUND, "Can't find document: " + params.get(ID));
            }
        }
        if (docId != null) {
            if (style != null && style != ShowStyle.DOC) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "missing doc param for doc style");
            }
            Document doc = null;
            try {
                doc = reader.document(docId.intValue());
            }
            catch (Exception v) {
                // empty catch block
            }
            if (doc == null) {
                throw new SolrException(SolrException.ErrorCode.NOT_FOUND, "Can't find document: " + docId);
            }
            SimpleOrderedMap<Object> info = LukeRequestHandler.getDocumentFieldsInfo(doc, docId, (IndexReader)reader, schema);
            SimpleOrderedMap docinfo = new SimpleOrderedMap();
            docinfo.add(DOC_ID, (Object)docId);
            docinfo.add("lucene", info);
            docinfo.add("solr", (Object)doc);
            rsp.add("doc", docinfo);
        } else if (ShowStyle.SCHEMA == style) {
            rsp.add("schema", LukeRequestHandler.getSchemaInfo(req.getSchema()));
        } else {
            rsp.add("fields", LukeRequestHandler.getIndexedFieldsInfo(req));
        }
        SimpleOrderedMap info = new SimpleOrderedMap();
        info.add("key", LukeRequestHandler.getFieldFlagsKey());
        info.add("NOTE", (Object)"Document Frequency (df) is not updated when a document is marked for deletion.  df values include deleted documents.");
        rsp.add("info", info);
        rsp.setHttpCaching(false);
    }

    private static String getFieldFlags(IndexableField f) {
        IndexOptions opts = f == null ? null : f.fieldType().indexOptions();
        StringBuilder flags = new StringBuilder();
        flags.append(f != null && f.fieldType().indexOptions() != IndexOptions.NONE ? FieldFlag.INDEXED.getAbbreviation() : (char)'-');
        flags.append(f != null && f.fieldType().tokenized() ? FieldFlag.TOKENIZED.getAbbreviation() : (char)'-');
        flags.append(f != null && f.fieldType().stored() ? FieldFlag.STORED.getAbbreviation() : (char)'-');
        flags.append(f != null && f.fieldType().docValuesType() != DocValuesType.NONE ? Character.valueOf(FieldFlag.DOC_VALUES.getAbbreviation()) : "-");
        flags.append('-');
        flags.append('-');
        flags.append(f != null && f.fieldType().storeTermVectors() ? FieldFlag.TERM_VECTOR_STORED.getAbbreviation() : (char)'-');
        flags.append(f != null && f.fieldType().storeTermVectorOffsets() ? FieldFlag.TERM_VECTOR_OFFSET.getAbbreviation() : (char)'-');
        flags.append(f != null && f.fieldType().storeTermVectorPositions() ? FieldFlag.TERM_VECTOR_POSITION.getAbbreviation() : (char)'-');
        flags.append(f != null && f.fieldType().storeTermVectorPayloads() ? FieldFlag.TERM_VECTOR_PAYLOADS.getAbbreviation() : (char)'-');
        flags.append(f != null && f.fieldType().omitNorms() ? FieldFlag.OMIT_NORMS.getAbbreviation() : (char)'-');
        flags.append(f != null && IndexOptions.DOCS == opts ? FieldFlag.OMIT_TF.getAbbreviation() : (char)'-');
        flags.append(f != null && IndexOptions.DOCS_AND_FREQS == opts ? FieldFlag.OMIT_POSITIONS.getAbbreviation() : (char)'-');
        flags.append(f != null && IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS == opts ? FieldFlag.STORE_OFFSETS_WITH_POSITIONS.getAbbreviation() : (char)'-');
        flags.append(f != null && f.getClass().getSimpleName().equals("LazyField") ? FieldFlag.LAZY.getAbbreviation() : (char)'-');
        flags.append(f != null && f.binaryValue() != null ? FieldFlag.BINARY.getAbbreviation() : (char)'-');
        flags.append('-');
        flags.append('-');
        return flags.toString();
    }

    private static String getFieldFlags(SchemaField f) {
        FieldType t = f == null ? null : f.getType();
        boolean lazy = false;
        boolean binary = false;
        StringBuilder flags = new StringBuilder();
        flags.append(f != null && f.indexed() ? FieldFlag.INDEXED.getAbbreviation() : (char)'-');
        flags.append(t != null && t.isTokenized() ? FieldFlag.TOKENIZED.getAbbreviation() : (char)'-');
        flags.append(f != null && f.stored() ? FieldFlag.STORED.getAbbreviation() : (char)'-');
        flags.append(f != null && f.hasDocValues() ? Character.valueOf(FieldFlag.DOC_VALUES.getAbbreviation()) : "-");
        flags.append(f != null && f.isUninvertible() ? Character.valueOf(FieldFlag.UNINVERTIBLE.getAbbreviation()) : "-");
        flags.append(f != null && f.multiValued() ? FieldFlag.MULTI_VALUED.getAbbreviation() : (char)'-');
        flags.append(f != null && f.storeTermVector() ? FieldFlag.TERM_VECTOR_STORED.getAbbreviation() : (char)'-');
        flags.append(f != null && f.storeTermOffsets() ? FieldFlag.TERM_VECTOR_OFFSET.getAbbreviation() : (char)'-');
        flags.append(f != null && f.storeTermPositions() ? FieldFlag.TERM_VECTOR_POSITION.getAbbreviation() : (char)'-');
        flags.append(f != null && f.storeTermPayloads() ? FieldFlag.TERM_VECTOR_PAYLOADS.getAbbreviation() : (char)'-');
        flags.append(f != null && f.omitNorms() ? FieldFlag.OMIT_NORMS.getAbbreviation() : (char)'-');
        flags.append(f != null && f.omitTermFreqAndPositions() ? FieldFlag.OMIT_TF.getAbbreviation() : (char)'-');
        flags.append(f != null && f.omitPositions() ? FieldFlag.OMIT_POSITIONS.getAbbreviation() : (char)'-');
        flags.append(f != null && f.storeOffsetsWithPositions() ? FieldFlag.STORE_OFFSETS_WITH_POSITIONS.getAbbreviation() : (char)'-');
        flags.append(lazy ? (char)FieldFlag.LAZY.getAbbreviation() : (char)'-');
        flags.append(binary ? (char)FieldFlag.BINARY.getAbbreviation() : (char)'-');
        flags.append(f != null && f.sortMissingFirst() ? FieldFlag.SORT_MISSING_FIRST.getAbbreviation() : (char)'-');
        flags.append(f != null && f.sortMissingLast() ? FieldFlag.SORT_MISSING_LAST.getAbbreviation() : (char)'-');
        return flags.toString();
    }

    public static SimpleOrderedMap<String> getFieldFlagsKey() {
        SimpleOrderedMap key = new SimpleOrderedMap();
        for (FieldFlag f : FieldFlag.values()) {
            key.add(String.valueOf(f.getAbbreviation()), (Object)f.getDisplay());
        }
        return key;
    }

    private static SimpleOrderedMap<Object> getDocumentFieldsInfo(Document doc, int docId, IndexReader reader, IndexSchema schema) throws IOException {
        CharsRefBuilder spare = new CharsRefBuilder();
        SimpleOrderedMap finfo = new SimpleOrderedMap();
        for (Object o : doc.getFields()) {
            Field field = (Field)o;
            SimpleOrderedMap f = new SimpleOrderedMap();
            SchemaField sfield = schema.getFieldOrNull(field.name());
            FieldType ftype = sfield == null ? null : sfield.getType();
            f.add("type", (Object)(ftype == null ? null : ftype.getTypeName()));
            f.add("schema", (Object)LukeRequestHandler.getFieldFlags(sfield));
            f.add("flags", (Object)LukeRequestHandler.getFieldFlags((IndexableField)field));
            f.add("value", ftype == null ? null : ftype.toExternal((IndexableField)field));
            f.add("internal", (Object)field.stringValue());
            BytesRef bytes = field.binaryValue();
            if (bytes != null) {
                f.add("binary", (Object)Base64.byteArrayToBase64((byte[])bytes.bytes, (int)bytes.offset, (int)bytes.length));
            }
            if (ftype != null && !ftype.isPointField()) {
                Term t;
                String s = ftype.storedToIndexed((IndexableField)field);
                if (s == null) {
                    s = "";
                }
                f.add("docFreq", (Object)((t = new Term(field.name(), s)).text() == null ? 0 : reader.docFreq(t)));
            }
            if (field.fieldType().storeTermVectors()) {
                try {
                    Terms v = reader.getTermVector(docId, field.name());
                    if (v != null) {
                        BytesRef text;
                        SimpleOrderedMap tfv = new SimpleOrderedMap();
                        TermsEnum termsEnum = v.iterator();
                        while ((text = termsEnum.next()) != null) {
                            int freq = (int)termsEnum.totalTermFreq();
                            spare.copyUTF8Bytes(text);
                            tfv.add(spare.toString(), (Object)freq);
                        }
                        f.add("termVector", (Object)tfv);
                    }
                }
                catch (Exception ex) {
                    log.warn("error writing term vector", (Throwable)ex);
                }
            }
            finfo.add(field.name(), (Object)f);
        }
        return finfo;
    }

    private static SimpleOrderedMap<Object> getIndexedFieldsInfo(SolrQueryRequest req) throws Exception {
        SolrIndexSearcher searcher = req.getSearcher();
        SolrParams params = req.getParams();
        TreeSet<String> fields = null;
        String fl = params.get("fl");
        if (fl != null) {
            fields = new TreeSet<String>(Arrays.asList(fl.split("[,\\s]+")));
        }
        LeafReader reader = searcher.getSlowAtomicReader();
        IndexSchema schema = searcher.getSchema();
        TreeSet<String> fieldNames = new TreeSet<String>();
        for (FieldInfo fieldInfo : reader.getFieldInfos()) {
            fieldNames.add(fieldInfo.name);
        }
        SimpleOrderedMap finfo = new SimpleOrderedMap();
        for (String fieldName : fieldNames) {
            Terms terms;
            if (fields != null && !fields.contains(fieldName) && !fields.contains("*")) continue;
            SimpleOrderedMap fieldMap = new SimpleOrderedMap();
            SchemaField sfield = schema.getFieldOrNull(fieldName);
            FieldType ftype = sfield == null ? null : sfield.getType();
            fieldMap.add("type", (Object)(ftype == null ? null : ftype.getTypeName()));
            fieldMap.add("schema", (Object)LukeRequestHandler.getFieldFlags(sfield));
            if (sfield != null && schema.isDynamicField(sfield.getName()) && schema.getDynamicPattern(sfield.getName()) != null) {
                fieldMap.add("dynamicBase", (Object)schema.getDynamicPattern(sfield.getName()));
            }
            if ((terms = reader.terms(fieldName)) == null) {
                finfo.add(fieldName, (Object)fieldMap);
                continue;
            }
            if (sfield != null && sfield.indexed()) {
                Document doc;
                if (params.getBool(INCLUDE_INDEX_FIELD_FLAGS, true) && (doc = LukeRequestHandler.getFirstLiveDoc(terms, reader)) != null) {
                    try {
                        IndexableField fld = doc.getField(fieldName);
                        if (fld != null) {
                            fieldMap.add("index", (Object)LukeRequestHandler.getFieldFlags(fld));
                        } else {
                            fieldMap.add("index", (Object)"(unstored field)");
                        }
                    }
                    catch (Exception ex) {
                        log.warn("error reading field: {}", (Object)fieldName);
                    }
                }
                fieldMap.add("docs", (Object)terms.getDocCount());
            }
            if (fields != null && (fields.contains(fieldName) || fields.contains("*"))) {
                LukeRequestHandler.getDetailedFieldInfo(req, fieldName, (SimpleOrderedMap<Object>)fieldMap);
            }
            finfo.add(fieldName, (Object)fieldMap);
        }
        return finfo;
    }

    private static Document getFirstLiveDoc(Terms terms, LeafReader reader) throws IOException {
        PostingsEnum postingsEnum = null;
        TermsEnum termsEnum = terms.iterator();
        for (int idx = 0; idx < 1000 && postingsEnum == null; ++idx) {
            BytesRef text = termsEnum.next();
            if (text == null) {
                return null;
            }
            postingsEnum = termsEnum.postings(postingsEnum, 0);
            Bits liveDocs = reader.getLiveDocs();
            if (postingsEnum.nextDoc() == Integer.MAX_VALUE || liveDocs != null && liveDocs.get(postingsEnum.docID())) continue;
            return reader.document(postingsEnum.docID());
        }
        return null;
    }

    private static SimpleOrderedMap<Object> getSchemaInfo(IndexSchema schema) {
        TreeMap<String, List<String>> typeusemap = new TreeMap<String, List<String>>();
        TreeMap<String, Object> fields = new TreeMap<String, Object>();
        SchemaField uniqueField = schema.getUniqueKeyField();
        for (SchemaField schemaField : schema.getFields().values()) {
            LukeRequestHandler.populateFieldInfo(schema, typeusemap, fields, uniqueField, schemaField);
        }
        TreeMap<String, Object> dynamicFields = new TreeMap<String, Object>();
        for (SchemaField f : schema.getDynamicFieldPrototypes()) {
            LukeRequestHandler.populateFieldInfo(schema, typeusemap, dynamicFields, uniqueField, f);
        }
        SimpleOrderedMap simpleOrderedMap = new SimpleOrderedMap();
        TreeMap<String, FieldType> sortedTypes = new TreeMap<String, FieldType>(schema.getFieldTypes());
        for (FieldType ft : sortedTypes.values()) {
            SimpleOrderedMap field = new SimpleOrderedMap();
            field.add("fields", typeusemap.get(ft.getTypeName()));
            field.add("tokenized", (Object)ft.isTokenized());
            field.add("className", (Object)ft.getClass().getName());
            field.add("indexAnalyzer", LukeRequestHandler.getAnalyzerInfo(ft.getIndexAnalyzer()));
            field.add("queryAnalyzer", LukeRequestHandler.getAnalyzerInfo(ft.getQueryAnalyzer()));
            field.add("similarity", LukeRequestHandler.getSimilarityInfo(ft.getSimilarity()));
            simpleOrderedMap.add(ft.getTypeName(), (Object)field);
        }
        SimpleOrderedMap finfo = new SimpleOrderedMap();
        SimpleOrderedMap fieldsSimple = new SimpleOrderedMap();
        for (Map.Entry entry : fields.entrySet()) {
            fieldsSimple.add((String)entry.getKey(), entry.getValue());
        }
        finfo.add("fields", (Object)fieldsSimple);
        SimpleOrderedMap dynamicSimple = new SimpleOrderedMap();
        for (Map.Entry ent : dynamicFields.entrySet()) {
            dynamicSimple.add((String)ent.getKey(), ent.getValue());
        }
        finfo.add("dynamicFields", (Object)dynamicSimple);
        finfo.add("uniqueKeyField", (Object)(null == uniqueField ? null : uniqueField.getName()));
        finfo.add("similarity", LukeRequestHandler.getSimilarityInfo(schema.getSimilarity()));
        finfo.add("types", (Object)simpleOrderedMap);
        return finfo;
    }

    private static SimpleOrderedMap<Object> getSimilarityInfo(Similarity similarity) {
        SimpleOrderedMap toReturn = new SimpleOrderedMap();
        if (similarity != null) {
            toReturn.add("className", (Object)similarity.getClass().getName());
            toReturn.add("details", (Object)similarity.toString());
        }
        return toReturn;
    }

    private static SimpleOrderedMap<Object> getAnalyzerInfo(Analyzer analyzer) {
        SimpleOrderedMap aninfo = new SimpleOrderedMap();
        aninfo.add("className", (Object)analyzer.getClass().getName());
        if (analyzer instanceof TokenizerChain) {
            TokenizerChain tchain = (TokenizerChain)analyzer;
            CharFilterFactory[] cfiltfacs = tchain.getCharFilterFactories();
            if (0 < cfiltfacs.length) {
                SimpleOrderedMap cfilters = new SimpleOrderedMap();
                for (CharFilterFactory cfiltfac : cfiltfacs) {
                    HashMap<String, Object> tok = new HashMap<String, Object>();
                    String className = cfiltfac.getClass().getName();
                    tok.put("className", className);
                    tok.put("args", cfiltfac.getOriginalArgs());
                    cfilters.add(className.substring(className.lastIndexOf(46) + 1), tok);
                }
                aninfo.add("charFilters", (Object)cfilters);
            }
            SimpleOrderedMap tokenizer = new SimpleOrderedMap();
            TokenizerFactory tfac = tchain.getTokenizerFactory();
            tokenizer.add("className", (Object)tfac.getClass().getName());
            tokenizer.add("args", (Object)tfac.getOriginalArgs());
            aninfo.add("tokenizer", (Object)tokenizer);
            TokenFilterFactory[] filtfacs = tchain.getTokenFilterFactories();
            if (0 < filtfacs.length) {
                SimpleOrderedMap filters = new SimpleOrderedMap();
                for (TokenFilterFactory filtfac : filtfacs) {
                    HashMap<String, Object> tok = new HashMap<String, Object>();
                    String className = filtfac.getClass().getName();
                    tok.put("className", className);
                    tok.put("args", filtfac.getOriginalArgs());
                    filters.add(className.substring(className.lastIndexOf(46) + 1), tok);
                }
                aninfo.add("filters", (Object)filters);
            }
        }
        return aninfo;
    }

    private static void populateFieldInfo(IndexSchema schema, Map<String, List<String>> typeusemap, Map<String, Object> fields, SchemaField uniqueField, SchemaField f) {
        FieldType ft = f.getType();
        SimpleOrderedMap field = new SimpleOrderedMap();
        field.add("type", (Object)ft.getTypeName());
        field.add("flags", (Object)LukeRequestHandler.getFieldFlags(f));
        if (f.isRequired()) {
            field.add("required", (Object)f.isRequired());
        }
        if (f.getDefaultValue() != null) {
            field.add("default", (Object)f.getDefaultValue());
        }
        if (f == uniqueField) {
            field.add("uniqueKey", (Object)true);
        }
        if (ft.getIndexAnalyzer().getPositionIncrementGap(f.getName()) != 0) {
            field.add("positionIncrementGap", (Object)ft.getIndexAnalyzer().getPositionIncrementGap(f.getName()));
        }
        field.add("copyDests", LukeRequestHandler.toListOfStringDests(schema.getCopyFieldsList(f.getName())));
        field.add("copySources", schema.getCopySources(f.getName()));
        fields.put(f.getName(), field);
        List<String> v = typeusemap.get(ft.getTypeName());
        if (v == null) {
            v = new ArrayList<String>();
        }
        v.add(f.getName());
        typeusemap.put(ft.getTypeName(), v);
    }

    public static SimpleOrderedMap<Object> getIndexInfo(DirectoryReader reader) throws IOException {
        Directory dir = reader.directory();
        SimpleOrderedMap indexInfo = new SimpleOrderedMap();
        indexInfo.add("numDocs", (Object)reader.numDocs());
        indexInfo.add("maxDoc", (Object)reader.maxDoc());
        indexInfo.add("deletedDocs", (Object)(reader.maxDoc() - reader.numDocs()));
        indexInfo.add("indexHeapUsageBytes", (Object)LukeRequestHandler.getIndexHeapUsed(reader));
        indexInfo.add("version", (Object)reader.getVersion());
        indexInfo.add("segmentCount", (Object)reader.leaves().size());
        indexInfo.add("current", LukeRequestHandler.closeSafe(() -> ((DirectoryReader)reader).isCurrent()));
        indexInfo.add("hasDeletions", (Object)reader.hasDeletions());
        indexInfo.add("directory", (Object)dir);
        IndexCommit indexCommit = reader.getIndexCommit();
        String segmentsFileName = indexCommit.getSegmentsFileName();
        indexInfo.add("segmentsFile", (Object)segmentsFileName);
        indexInfo.add("segmentsFileSizeInBytes", (Object)LukeRequestHandler.getSegmentsFileLength(indexCommit));
        Map userData = indexCommit.getUserData();
        indexInfo.add("userData", (Object)userData);
        String s = (String)userData.get("commitTimeMSec");
        if (s != null) {
            indexInfo.add("lastModified", (Object)new Date(Long.parseLong(s)));
        }
        return indexInfo;
    }

    private static Object closeSafe(IOSupplier isCurrent) {
        try {
            return isCurrent.get();
        }
        catch (IOException | AlreadyClosedException throwable) {
            return false;
        }
    }

    private static long getSegmentsFileLength(IndexCommit commit) {
        try {
            return commit.getDirectory().fileLength(commit.getSegmentsFileName());
        }
        catch (NoSuchFileException okException) {
            log.debug("Unable to determine the (optional) fileSize for the current IndexReader's segments file because it is no longer in the Directory, this can happen if there are new commits since the Reader was opened", (Throwable)okException);
        }
        catch (IOException strangeException) {
            log.warn("Ignoring IOException wile attempting to determine the (optional) fileSize stat for the current IndexReader's segments file", (Throwable)strangeException);
        }
        return -1L;
    }

    private static long getIndexHeapUsed(DirectoryReader reader) {
        return reader.leaves().stream().map(LeafReaderContext::reader).map(FilterLeafReader::unwrap).map(leafReader -> {
            if (leafReader instanceof Accountable) {
                return ((Accountable)leafReader).ramBytesUsed();
            }
            return -1L;
        }).mapToLong(Long::longValue).reduce(0L, (left, right) -> left == -1L || right == -1L ? -1L : left + right);
    }

    private static void getDetailedFieldInfo(SolrQueryRequest req, String field, SimpleOrderedMap<Object> fieldMap) throws IOException {
        BytesRef text;
        SolrParams params = req.getParams();
        int numTerms = params.getInt(NUMTERMS, 10);
        TopTermQueue tiq = new TopTermQueue(numTerms + 1);
        CharsRefBuilder spare = new CharsRefBuilder();
        Terms terms = MultiTerms.getTerms((IndexReader)req.getSearcher().getIndexReader(), (String)field);
        if (terms == null) {
            return;
        }
        TermsEnum termsEnum = terms.iterator();
        int[] buckets = new int[33];
        while ((text = termsEnum.next()) != null) {
            ++tiq.distinctTerms;
            int freq = termsEnum.docFreq();
            int slot = 32 - Integer.numberOfLeadingZeros(Math.max(0, freq - 1));
            buckets[slot] = buckets[slot] + 1;
            if (numTerms <= 0 || freq <= tiq.minFreq) continue;
            spare.copyUTF8Bytes(text);
            String t = spare.toString();
            tiq.add(new TopTermQueue.TermInfo(new Term(field, t), termsEnum.docFreq()));
            if (tiq.size() <= numTerms) continue;
            tiq.pop();
            tiq.minFreq = tiq.getTopTermInfo().docFreq;
        }
        tiq.histogram.add(buckets);
        fieldMap.add("distinct", (Object)tiq.distinctTerms);
        fieldMap.add("topTerms", tiq.toNamedList(req.getSearcher().getSchema()));
        fieldMap.add("histogram", tiq.histogram.toNamedList());
    }

    private static List<String> toListOfStrings(SchemaField[] raw) {
        ArrayList<String> result = new ArrayList<String>(raw.length);
        for (SchemaField f : raw) {
            result.add(f.getName());
        }
        return result;
    }

    private static List<String> toListOfStringDests(List<CopyField> raw) {
        ArrayList<String> result = new ArrayList<String>(raw.size());
        for (CopyField f : raw) {
            result.add(f.getDestination().getName());
        }
        return result;
    }

    @Override
    public String getDescription() {
        return "Lucene Index Browser.  Inspired and modeled after Luke: http://www.getopt.org/luke/";
    }

    @Override
    public SolrInfoBean.Category getCategory() {
        return SolrInfoBean.Category.ADMIN;
    }

    private static enum ShowStyle {
        ALL,
        DOC,
        SCHEMA,
        INDEX;


        public static ShowStyle get(String v) {
            if (v == null) {
                return null;
            }
            if ("schema".equalsIgnoreCase(v)) {
                return SCHEMA;
            }
            if ("index".equalsIgnoreCase(v)) {
                return INDEX;
            }
            if ("doc".equalsIgnoreCase(v)) {
                return DOC;
            }
            if ("all".equalsIgnoreCase(v)) {
                return ALL;
            }
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unknown Show Style: " + v);
        }
    }

    @FunctionalInterface
    static interface IOSupplier {
        public boolean get() throws IOException;
    }

    private static class TopTermQueue
    extends PriorityQueue {
        public int minFreq = 0;
        public int distinctTerms = 0;
        public TermHistogram histogram = new TermHistogram();

        TopTermQueue(int size) {
            super(size);
        }

        protected final boolean lessThan(Object a, Object b) {
            TermInfo termInfoA = (TermInfo)a;
            TermInfo termInfoB = (TermInfo)b;
            return termInfoA.docFreq < termInfoB.docFreq;
        }

        public NamedList<Integer> toNamedList(IndexSchema schema) {
            LinkedList<TermInfo> aslist = new LinkedList<TermInfo>();
            while (this.size() > 0) {
                aslist.add(0, (TermInfo)this.pop());
            }
            NamedList list = new NamedList();
            for (TermInfo i : aslist) {
                String txt = i.term.text();
                SchemaField ft = schema.getFieldOrNull(i.term.field());
                if (ft != null) {
                    txt = ft.getType().indexedToReadable(txt);
                }
                list.add(txt, (Object)i.docFreq);
            }
            return list;
        }

        public TermInfo getTopTermInfo() {
            return (TermInfo)this.top();
        }

        static class TermInfo {
            int docFreq;
            Term term;

            TermInfo(Term t, int df) {
                this.term = t;
                this.docFreq = df;
            }
        }
    }

    static class TermHistogram {
        int _maxBucket = -1;
        int[] _buckets = new int[33];

        TermHistogram() {
        }

        public void add(int[] buckets) {
            int idx;
            for (idx = 0; idx < buckets.length; ++idx) {
                if (buckets[idx] == 0) continue;
                this._maxBucket = idx;
            }
            for (idx = 0; idx <= this._maxBucket; ++idx) {
                this._buckets[idx] = buckets[idx];
            }
        }

        public NamedList<Integer> toNamedList() {
            NamedList nl = new NamedList();
            for (int bucket = 0; bucket <= this._maxBucket; ++bucket) {
                nl.add("" + (1 << bucket), (Object)this._buckets[bucket]);
            }
            return nl;
        }
    }
}

