/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud.api.collections;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang3.StringUtils;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrResponse;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.cloud.DistribStateManager;
import org.apache.solr.client.solrj.cloud.SolrCloudManager;
import org.apache.solr.client.solrj.cloud.autoscaling.AlreadyExistsException;
import org.apache.solr.client.solrj.cloud.autoscaling.BadVersionException;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.request.AbstractUpdateRequest;
import org.apache.solr.client.solrj.request.UpdateRequest;
import org.apache.solr.client.solrj.response.UpdateResponse;
import org.apache.solr.cloud.LockTree;
import org.apache.solr.cloud.Overseer;
import org.apache.solr.cloud.OverseerMessageHandler;
import org.apache.solr.cloud.OverseerNodePrioritizer;
import org.apache.solr.cloud.OverseerSolrResponse;
import org.apache.solr.cloud.OverseerTaskProcessor;
import org.apache.solr.cloud.Stats;
import org.apache.solr.cloud.api.collections.AddReplicaCmd;
import org.apache.solr.cloud.api.collections.BackupCmd;
import org.apache.solr.cloud.api.collections.CreateAliasCmd;
import org.apache.solr.cloud.api.collections.CreateCollectionCmd;
import org.apache.solr.cloud.api.collections.CreateShardCmd;
import org.apache.solr.cloud.api.collections.CreateSnapshotCmd;
import org.apache.solr.cloud.api.collections.DeleteAliasCmd;
import org.apache.solr.cloud.api.collections.DeleteBackupCmd;
import org.apache.solr.cloud.api.collections.DeleteCollectionCmd;
import org.apache.solr.cloud.api.collections.DeleteNodeCmd;
import org.apache.solr.cloud.api.collections.DeleteReplicaCmd;
import org.apache.solr.cloud.api.collections.DeleteShardCmd;
import org.apache.solr.cloud.api.collections.DeleteSnapshotCmd;
import org.apache.solr.cloud.api.collections.MaintainRoutedAliasCmd;
import org.apache.solr.cloud.api.collections.MigrateCmd;
import org.apache.solr.cloud.api.collections.MoveReplicaCmd;
import org.apache.solr.cloud.api.collections.OverseerRoleCmd;
import org.apache.solr.cloud.api.collections.OverseerStatusCmd;
import org.apache.solr.cloud.api.collections.ReindexCollectionCmd;
import org.apache.solr.cloud.api.collections.RenameCmd;
import org.apache.solr.cloud.api.collections.ReplaceNodeCmd;
import org.apache.solr.cloud.api.collections.RestoreCmd;
import org.apache.solr.cloud.api.collections.SetAliasPropCmd;
import org.apache.solr.cloud.api.collections.SplitShardCmd;
import org.apache.solr.cloud.api.collections.UtilizeNodeCmd;
import org.apache.solr.cloud.overseer.OverseerAction;
import org.apache.solr.common.SolrCloseable;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.DocRouter;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkCoreNodeProps;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.common.params.CoreAdminParams;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ExecutorUtil;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.common.util.SolrNamedThreadFactory;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.common.util.SuppressForbidden;
import org.apache.solr.common.util.TimeSource;
import org.apache.solr.common.util.Utils;
import org.apache.solr.core.backup.BackupId;
import org.apache.solr.core.backup.repository.BackupRepository;
import org.apache.solr.handler.component.HttpShardHandlerFactory;
import org.apache.solr.handler.component.ShardHandler;
import org.apache.solr.handler.component.ShardRequest;
import org.apache.solr.handler.component.ShardResponse;
import org.apache.solr.logging.MDCLoggingContext;
import org.apache.solr.util.RTimer;
import org.apache.solr.util.TimeOut;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OverseerCollectionMessageHandler
implements OverseerMessageHandler,
SolrCloseable {
    public static final String NUM_SLICES = "numShards";
    public static final boolean CREATE_NODE_SET_SHUFFLE_DEFAULT = true;
    public static final String CREATE_NODE_SET_SHUFFLE = "createNodeSet.shuffle";
    public static final String CREATE_NODE_SET_EMPTY = "EMPTY";
    public static final String CREATE_NODE_SET = "createNodeSet";
    public static final String ROUTER = "router";
    public static final String SHARDS_PROP = "shards";
    public static final String REQUESTID = "requestid";
    public static final String COLL_PROP_PREFIX = "property.";
    public static final String ONLY_IF_DOWN = "onlyIfDown";
    public static final String SHARD_UNIQUE = "shardUnique";
    public static final String ONLY_ACTIVE_NODES = "onlyactivenodes";
    static final String SKIP_CREATE_REPLICA_IN_CLUSTER_STATE = "skipCreateReplicaInClusterState";
    public static final Map<String, Object> COLLECTION_PROPS_AND_DEFAULTS = Collections.unmodifiableMap(Utils.makeMap((Object[])new Object[]{"router", "compositeId", "replicationFactor", "1", "nrtReplicas", "1", "tlogReplicas", "0", "pullReplicas", "0", "maxShardsPerNode", "1", "autoAddReplicas", "false", "perReplicaState", null, "rule", null, "policy", null, "snitch", null, "withCollection", null, "COLOCATED_WITH", null}));
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String FAILURE_FIELD = "failure";
    public static final String SUCCESS_FIELD = "success";
    Overseer overseer;
    HttpShardHandlerFactory shardHandlerFactory;
    String adminPath;
    ZkStateReader zkStateReader;
    SolrCloudManager cloudManager;
    String myId;
    Stats stats;
    TimeSource timeSource;
    private final LockTree lockTree = new LockTree();
    ExecutorService tpe = new ExecutorUtil.MDCAwareThreadPoolExecutor(5, 10, 0L, TimeUnit.MILLISECONDS, new SynchronousQueue(), (ThreadFactory)new SolrNamedThreadFactory("OverseerCollectionMessageHandlerThreadFactory"));
    protected static final Random RANDOM;
    final Map<CollectionParams.CollectionAction, Cmd> commandMap;
    private volatile boolean isClosed;
    private long sessionId = -1L;
    private LockTree.Session lockSession;
    @Deprecated
    static boolean INCLUDE_TOP_LEVEL_RESPONSE;

    public OverseerCollectionMessageHandler(ZkStateReader zkStateReader, String myId, HttpShardHandlerFactory shardHandlerFactory, String adminPath, Stats stats, Overseer overseer, OverseerNodePrioritizer overseerPrioritizer) {
        this.zkStateReader = zkStateReader;
        this.shardHandlerFactory = shardHandlerFactory;
        this.adminPath = adminPath;
        this.myId = myId;
        this.stats = stats;
        this.overseer = overseer;
        this.cloudManager = overseer.getSolrCloudManager();
        this.timeSource = this.cloudManager.getTimeSource();
        this.isClosed = false;
        this.commandMap = new ImmutableMap.Builder().put((Object)CollectionParams.CollectionAction.REPLACENODE, (Object)new ReplaceNodeCmd(this)).put((Object)CollectionParams.CollectionAction.DELETENODE, (Object)new DeleteNodeCmd(this)).put((Object)CollectionParams.CollectionAction.BACKUP, (Object)new BackupCmd(this)).put((Object)CollectionParams.CollectionAction.RESTORE, (Object)new RestoreCmd(this)).put((Object)CollectionParams.CollectionAction.DELETEBACKUP, (Object)new DeleteBackupCmd(this)).put((Object)CollectionParams.CollectionAction.CREATESNAPSHOT, (Object)new CreateSnapshotCmd(this)).put((Object)CollectionParams.CollectionAction.DELETESNAPSHOT, (Object)new DeleteSnapshotCmd(this)).put((Object)CollectionParams.CollectionAction.SPLITSHARD, (Object)new SplitShardCmd(this)).put((Object)CollectionParams.CollectionAction.ADDROLE, (Object)new OverseerRoleCmd(this, CollectionParams.CollectionAction.ADDROLE, overseerPrioritizer)).put((Object)CollectionParams.CollectionAction.REMOVEROLE, (Object)new OverseerRoleCmd(this, CollectionParams.CollectionAction.REMOVEROLE, overseerPrioritizer)).put((Object)CollectionParams.CollectionAction.MOCK_COLL_TASK, this::mockOperation).put((Object)CollectionParams.CollectionAction.MOCK_SHARD_TASK, this::mockOperation).put((Object)CollectionParams.CollectionAction.MOCK_REPLICA_TASK, this::mockOperation).put((Object)CollectionParams.CollectionAction.MIGRATESTATEFORMAT, this::migrateStateFormat).put((Object)CollectionParams.CollectionAction.CREATESHARD, (Object)new CreateShardCmd(this)).put((Object)CollectionParams.CollectionAction.MIGRATE, (Object)new MigrateCmd(this)).put((Object)CollectionParams.CollectionAction.CREATE, (Object)new CreateCollectionCmd(this)).put((Object)CollectionParams.CollectionAction.MODIFYCOLLECTION, this::modifyCollection).put((Object)CollectionParams.CollectionAction.ADDREPLICAPROP, this::processReplicaAddPropertyCommand).put((Object)CollectionParams.CollectionAction.DELETEREPLICAPROP, this::processReplicaDeletePropertyCommand).put((Object)CollectionParams.CollectionAction.BALANCESHARDUNIQUE, this::balanceProperty).put((Object)CollectionParams.CollectionAction.REBALANCELEADERS, this::processRebalanceLeaders).put((Object)CollectionParams.CollectionAction.RELOAD, this::reloadCollection).put((Object)CollectionParams.CollectionAction.DELETE, (Object)new DeleteCollectionCmd(this)).put((Object)CollectionParams.CollectionAction.CREATEALIAS, (Object)new CreateAliasCmd(this)).put((Object)CollectionParams.CollectionAction.DELETEALIAS, (Object)new DeleteAliasCmd(this)).put((Object)CollectionParams.CollectionAction.ALIASPROP, (Object)new SetAliasPropCmd(this)).put((Object)CollectionParams.CollectionAction.MAINTAINROUTEDALIAS, (Object)new MaintainRoutedAliasCmd(this)).put((Object)CollectionParams.CollectionAction.OVERSEERSTATUS, (Object)new OverseerStatusCmd(this)).put((Object)CollectionParams.CollectionAction.DELETESHARD, (Object)new DeleteShardCmd(this)).put((Object)CollectionParams.CollectionAction.DELETEREPLICA, (Object)new DeleteReplicaCmd(this)).put((Object)CollectionParams.CollectionAction.ADDREPLICA, (Object)new AddReplicaCmd(this)).put((Object)CollectionParams.CollectionAction.MOVEREPLICA, (Object)new MoveReplicaCmd(this)).put((Object)CollectionParams.CollectionAction.REINDEXCOLLECTION, (Object)new ReindexCollectionCmd(this)).put((Object)CollectionParams.CollectionAction.UTILIZENODE, (Object)new UtilizeNodeCmd(this)).put((Object)CollectionParams.CollectionAction.RENAME, (Object)new RenameCmd(this)).build();
    }

    @Override
    public OverseerSolrResponse processMessage(ZkNodeProps message, String operation) {
        MDCLoggingContext.setCollection(message.getStr("collection"));
        MDCLoggingContext.setShard(message.getStr("shard"));
        MDCLoggingContext.setReplica(message.getStr("replica"));
        log.debug("OverseerCollectionMessageHandler.processMessage : {} , {}", (Object)operation, (Object)message);
        NamedList results = new NamedList();
        try {
            CollectionParams.CollectionAction action = this.getCollectionAction(operation);
            Cmd command = this.commandMap.get(action);
            if (command == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unknown operation:" + operation);
            }
            command.call(this.cloudManager.getClusterStateProvider().getClusterState(), message, results);
        }
        catch (Exception e) {
            String collName = message.getStr("collection");
            if (collName == null) {
                collName = message.getStr("name");
            }
            if (collName == null) {
                SolrException.log((Logger)log, (String)("Operation " + operation + " failed"), (Throwable)e);
            } else {
                SolrException.log((Logger)log, (String)("Collection: " + collName + " operation: " + operation + " failed"), (Throwable)e);
            }
            results.add("Operation " + operation + " caused exception:", (Object)e);
            SimpleOrderedMap nl = new SimpleOrderedMap();
            nl.add("msg", (Object)e.getMessage());
            nl.add("rspCode", (Object)(e instanceof SolrException ? ((SolrException)((Object)e)).code() : -1));
            results.add("exception", (Object)nl);
        }
        return new OverseerSolrResponse(results);
    }

    @SuppressForbidden(reason="Needs currentTimeMillis for mock requests")
    private void mockOperation(ClusterState state, ZkNodeProps message, NamedList results) throws InterruptedException {
        Thread.sleep(message.getInt("sleep", Integer.valueOf(1)).intValue());
        if (log.isInfoEnabled()) {
            log.info("MOCK_TASK_EXECUTED time {} data {}", (Object)System.currentTimeMillis(), (Object)Utils.toJSONString((Object)message));
        }
        results.add("MOCK_FINISHED", (Object)System.currentTimeMillis());
    }

    private CollectionParams.CollectionAction getCollectionAction(String operation) {
        CollectionParams.CollectionAction action = CollectionParams.CollectionAction.get((String)operation);
        if (action == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unknown operation:" + operation);
        }
        return action;
    }

    private void reloadCollection(ClusterState clusterState, ZkNodeProps message, NamedList results) {
        ModifiableSolrParams params = new ModifiableSolrParams();
        params.set("action", new String[]{CoreAdminParams.CoreAdminAction.RELOAD.toString()});
        String asyncId = message.getStr("async");
        this.collectionCmd(message, params, (NamedList<Object>)results, Replica.State.ACTIVE, asyncId, Collections.emptySet());
    }

    private void processRebalanceLeaders(ClusterState clusterState, ZkNodeProps message, NamedList results) throws Exception {
        this.checkRequired(message, "collection", "shard", "core", "election_node", "core_node_name", "node_name", "rejoinAtHead");
        ModifiableSolrParams params = new ModifiableSolrParams();
        params.set("collection", new String[]{message.getStr("collection")});
        params.set("shard", new String[]{message.getStr("shard")});
        params.set("rejoinAtHead", new String[]{message.getStr("rejoinAtHead")});
        params.set("action", new String[]{CoreAdminParams.CoreAdminAction.REJOINLEADERELECTION.toString()});
        params.set("core", new String[]{message.getStr("core")});
        params.set("core_node_name", new String[]{message.getStr("core_node_name")});
        params.set("election_node", new String[]{message.getStr("election_node")});
        params.set("node_name", new String[]{message.getStr("node_name")});
        String baseUrl = message.getStr("base_url");
        if (baseUrl == null) {
            baseUrl = this.zkStateReader.getBaseUrlForNodeName(message.getStr("node_name"));
            params.set("base_url", new String[]{baseUrl});
        }
        ShardRequest sreq = new ShardRequest();
        sreq.nodeName = message.getStr("core");
        params.set("qt", new String[]{this.adminPath});
        sreq.purpose = 1;
        sreq.shards = new String[]{baseUrl};
        sreq.actualShards = sreq.shards;
        sreq.params = params;
        ShardHandler shardHandler = this.shardHandlerFactory.getShardHandler(this.overseer.getCoreContainer().getUpdateShardHandler().getDefaultHttpClient());
        shardHandler.submit(sreq, baseUrl, sreq.params);
    }

    private void processReplicaAddPropertyCommand(ClusterState clusterState, ZkNodeProps message, NamedList results) throws Exception {
        this.checkRequired(message, "collection", "shard", "replica", "property", "property.value");
        SolrZkClient zkClient = this.zkStateReader.getZkClient();
        HashMap<String, String> propMap = new HashMap<String, String>();
        propMap.put("operation", CollectionParams.CollectionAction.ADDREPLICAPROP.toLower());
        propMap.putAll(message.getProperties());
        ZkNodeProps m = new ZkNodeProps(propMap);
        this.overseer.offerStateUpdate(Utils.toJSON((Object)m));
    }

    private void processReplicaDeletePropertyCommand(ClusterState clusterState, ZkNodeProps message, NamedList results) throws Exception {
        this.checkRequired(message, "collection", "shard", "replica", "property");
        SolrZkClient zkClient = this.zkStateReader.getZkClient();
        HashMap<String, String> propMap = new HashMap<String, String>();
        propMap.put("operation", CollectionParams.CollectionAction.DELETEREPLICAPROP.toLower());
        propMap.putAll(message.getProperties());
        ZkNodeProps m = new ZkNodeProps(propMap);
        this.overseer.offerStateUpdate(Utils.toJSON((Object)m));
    }

    private void balanceProperty(ClusterState clusterState, ZkNodeProps message, NamedList results) throws Exception {
        if (StringUtils.isBlank((CharSequence)message.getStr("collection")) || StringUtils.isBlank((CharSequence)message.getStr("property"))) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The 'collection' and 'property' parameters are required for the BALANCESHARDUNIQUE operation, no action taken");
        }
        SolrZkClient zkClient = this.zkStateReader.getZkClient();
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("operation", CollectionParams.CollectionAction.BALANCESHARDUNIQUE.toLower());
        m.putAll(message.getProperties());
        this.overseer.offerStateUpdate(Utils.toJSON(m));
    }

    private Map<String, Object> getCollectionStatus(Map<String, Object> collection, String name, Set<String> requestedShards) {
        if (collection == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Collection: " + name + " not found");
        }
        if (requestedShards == null || requestedShards.isEmpty()) {
            return collection;
        }
        Map shards = (Map)collection.get(SHARDS_PROP);
        HashMap selected = new HashMap();
        for (String selectedShard : requestedShards) {
            if (!shards.containsKey(selectedShard)) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Collection: " + name + " shard: " + selectedShard + " not found");
            }
            selected.put(selectedShard, shards.get(selectedShard));
            collection.put(SHARDS_PROP, selected);
        }
        return collection;
    }

    void deleteReplica(ClusterState clusterState, ZkNodeProps message, NamedList results, Runnable onComplete) throws Exception {
        ((DeleteReplicaCmd)this.commandMap.get(CollectionParams.CollectionAction.DELETEREPLICA)).deleteReplica(clusterState, message, results, onComplete);
    }

    boolean waitForCoreNodeGone(String collectionName, String shard, String replicaName, int timeoutms) throws InterruptedException {
        try {
            this.zkStateReader.waitForState(collectionName, (long)timeoutms, TimeUnit.MILLISECONDS, c -> {
                if (c == null) {
                    return true;
                }
                Slice slice = c.getSlice(shard);
                return slice == null || slice.getReplica(replicaName) == null;
            });
        }
        catch (TimeoutException e) {
            return false;
        }
        return true;
    }

    void deleteCoreNode(String collectionName, String replicaName, Replica replica, String core) throws Exception {
        ZkNodeProps m = new ZkNodeProps(new String[]{"operation", OverseerAction.DELETECORE.toLower(), "core", core, "node_name", replica.getNodeName(), "collection", collectionName, "core_node_name", replicaName});
        this.overseer.offerStateUpdate(Utils.toJSON((Object)m));
    }

    void checkRequired(ZkNodeProps message, String ... props) {
        for (String prop : props) {
            if (message.get(prop) != null) continue;
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, StrUtils.join(Arrays.asList(props), (char)',') + " are required params");
        }
    }

    void checkResults(String label, NamedList<Object> results, boolean failureIsFatal) throws SolrException {
        Object failure = results.get(FAILURE_FIELD);
        if (failure == null) {
            failure = results.get("error");
        }
        if (failure != null) {
            String msg = "Error: " + label + ": " + Utils.toJSONString(results);
            if (failureIsFatal) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, msg);
            }
            log.error(msg);
        }
    }

    private void migrateStateFormat(ClusterState state, ZkNodeProps message, NamedList results) throws Exception {
        String collectionName = message.getStr("collection");
        boolean firstLoop = true;
        TimeOut timeout = new TimeOut(30L, TimeUnit.SECONDS, this.timeSource);
        while (!timeout.hasTimedOut()) {
            DocCollection collection = this.zkStateReader.getClusterState().getCollection(collectionName);
            if (collection == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Collection: " + collectionName + " not found");
            }
            if (collection.getStateFormat() == 2) {
                results.add(SUCCESS_FIELD, (Object)new SimpleOrderedMap());
                return;
            }
            if (firstLoop) {
                firstLoop = false;
                ZkNodeProps m = new ZkNodeProps(new String[]{"operation", CollectionParams.CollectionAction.MIGRATESTATEFORMAT.toLower(), "collection", collectionName});
                this.overseer.offerStateUpdate(Utils.toJSON((Object)m));
            }
            timeout.sleep(100L);
        }
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Could not migrate state format for collection: " + collectionName);
    }

    void commit(NamedList results, String slice, Replica parentShardLeader) {
        log.debug("Calling soft commit to make sub shard updates visible");
        String coreUrl = new ZkCoreNodeProps((ZkNodeProps)parentShardLeader).getCoreUrl();
        UpdateResponse updateResponse = null;
        try {
            updateResponse = OverseerCollectionMessageHandler.softCommit(coreUrl);
            this.processResponse((NamedList<Object>)results, null, coreUrl, (SolrResponse)updateResponse, slice, Collections.emptySet());
        }
        catch (Exception e) {
            this.processResponse((NamedList<Object>)results, e, coreUrl, (SolrResponse)updateResponse, slice, Collections.emptySet());
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unable to call distrib softCommit on: " + coreUrl, (Throwable)e);
        }
    }

    static UpdateResponse softCommit(String url) throws SolrServerException, IOException {
        try (HttpSolrClient client = ((HttpSolrClient.Builder)((HttpSolrClient.Builder)new HttpSolrClient.Builder(url).withConnectionTimeout(30000)).withSocketTimeout(120000)).build();){
            UpdateRequest ureq = new UpdateRequest();
            ureq.setParams(new ModifiableSolrParams());
            ureq.setAction(AbstractUpdateRequest.ACTION.COMMIT, false, true, true);
            UpdateResponse updateResponse = (UpdateResponse)ureq.process((SolrClient)client);
            return updateResponse;
        }
    }

    String waitForCoreNodeName(String collectionName, String msgNodeName, String msgCore) {
        int retryCount = 320;
        while (retryCount-- > 0) {
            DocCollection docCollection = this.zkStateReader.getClusterState().getCollectionOrNull(collectionName);
            if (docCollection != null && docCollection.getSlicesMap() != null) {
                Map slicesMap = docCollection.getSlicesMap();
                for (Slice slice : slicesMap.values()) {
                    for (Replica replica : slice.getReplicas()) {
                        String nodeName = replica.getStr("node_name");
                        String core = replica.getStr("core");
                        if (!nodeName.equals(msgNodeName) || !core.equals(msgCore)) continue;
                        return replica.getName();
                    }
                }
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Could not find coreNodeName");
    }

    ClusterState waitForNewShard(String collectionName, String sliceName) throws KeeperException, InterruptedException {
        log.debug("Waiting for slice {} of collection {} to be available", (Object)sliceName, (Object)collectionName);
        RTimer timer = new RTimer();
        int retryCount = 320;
        while (retryCount-- > 0) {
            ClusterState clusterState = this.zkStateReader.getClusterState();
            DocCollection collection = clusterState.getCollection(collectionName);
            if (collection == null) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unable to find collection: " + collectionName + " in clusterstate");
            }
            Slice slice = collection.getSlice(sliceName);
            if (slice != null) {
                if (log.isDebugEnabled()) {
                    log.debug("Waited for {}ms for slice {} of collection {} to be available", new Object[]{timer.getTime(), sliceName, collectionName});
                }
                return clusterState;
            }
            Thread.sleep(1000L);
        }
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Could not find new slice " + sliceName + " in collection " + collectionName + " even after waiting for " + timer.getTime() + "ms");
    }

    DocRouter.Range intersect(DocRouter.Range a, DocRouter.Range b) {
        if (a == null || b == null || !a.overlaps(b)) {
            return null;
        }
        if (a.isSubsetOf(b)) {
            return a;
        }
        if (b.isSubsetOf(a)) {
            return b;
        }
        if (b.includes(a.max)) {
            return new DocRouter.Range(b.min, a.max);
        }
        return new DocRouter.Range(a.min, b.max);
    }

    void addPropertyParams(ZkNodeProps message, ModifiableSolrParams params) {
        for (String key : message.keySet()) {
            if (!key.startsWith(COLL_PROP_PREFIX)) continue;
            params.set(key, new String[]{message.getStr(key)});
        }
    }

    void addPropertyParams(ZkNodeProps message, Map<String, Object> map) {
        for (String key : message.keySet()) {
            if (!key.startsWith(COLL_PROP_PREFIX)) continue;
            map.put(key, message.getStr(key));
        }
    }

    void modifyCollection(ClusterState clusterState, ZkNodeProps message, NamedList results) throws Exception {
        String collectionName = message.getStr("collection");
        String configName = (String)message.getProperties().remove("collection.configName");
        if (configName != null) {
            this.validateConfigOrThrowSolrException(configName);
            boolean isLegacyCloud = Overseer.isLegacy(this.zkStateReader);
            OverseerCollectionMessageHandler.createConfNode(this.cloudManager.getDistribStateManager(), configName, collectionName, isLegacyCloud);
            this.reloadCollection(null, new ZkNodeProps(new String[]{"name", collectionName}), results);
        }
        this.overseer.offerStateUpdate(Utils.toJSON((Object)message));
        TimeOut timeout = new TimeOut(30L, TimeUnit.SECONDS, this.timeSource);
        boolean areChangesVisible = true;
        while (!timeout.hasTimedOut()) {
            DocCollection collection = this.cloudManager.getClusterStateProvider().getClusterState().getCollection(collectionName);
            areChangesVisible = true;
            for (Map.Entry updateEntry : message.getProperties().entrySet()) {
                String updateKey = (String)updateEntry.getKey();
                if (!(updateKey.equals("collection") || updateKey.equals("operation") || updateKey.equals("async") || updateEntry.getValue() == null || updateEntry.getValue().equals(collection.get(updateKey)))) {
                    areChangesVisible = false;
                    break;
                }
                if (updateEntry.getValue() != null || !collection.containsKey(updateKey)) continue;
                areChangesVisible = false;
                break;
            }
            if (areChangesVisible) break;
            timeout.sleep(100L);
        }
        if (!areChangesVisible) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Could not modify collection " + message);
        }
        if (message.keySet().contains("readOnly")) {
            this.reloadCollection(null, new ZkNodeProps(new String[]{"name", collectionName}), results);
        }
    }

    void cleanupCollection(String collectionName, NamedList results) throws Exception {
        log.error("Cleaning up collection [{}].", (Object)collectionName);
        Map props = Utils.makeMap((Object[])new Object[]{"operation", CollectionParams.CollectionAction.DELETE.toLower(), "name", collectionName});
        this.commandMap.get(CollectionParams.CollectionAction.DELETE).call(this.zkStateReader.getClusterState(), new ZkNodeProps(props), results);
    }

    Map<String, Replica> waitToSeeReplicasInState(String collectionName, Collection<String> coreNames) throws InterruptedException {
        assert (coreNames.size() > 0);
        HashMap<String, Replica> result = new HashMap<String, Replica>();
        TimeOut timeout = new TimeOut(Integer.getInteger("solr.waitToSeeReplicasInStateTimeoutSeconds", 120).intValue(), TimeUnit.SECONDS, this.timeSource);
        while (true) {
            DocCollection coll = this.zkStateReader.getClusterState().getCollection(collectionName);
            for (String coreName : coreNames) {
                if (result.containsKey(coreName)) continue;
                block2: for (Slice slice : coll.getSlices()) {
                    for (Replica replica : slice.getReplicas()) {
                        if (!coreName.equals(replica.getStr("core"))) continue;
                        result.put(coreName, replica);
                        continue block2;
                    }
                }
            }
            if (result.size() == coreNames.size()) {
                return result;
            }
            log.debug("Expecting {} cores but found {}", coreNames, result);
            if (timeout.hasTimedOut()) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Timed out waiting to see all replicas: " + coreNames + " in cluster state. Last state: " + coll);
            }
            Thread.sleep(100L);
        }
    }

    void cleanBackup(BackupRepository repository, URI backupUri, BackupId backupId) throws Exception {
        ((DeleteBackupCmd)this.commandMap.get(CollectionParams.CollectionAction.DELETEBACKUP)).deleteBackupIds(backupUri, repository, Collections.singleton(backupId), new NamedList());
    }

    void deleteBackup(BackupRepository repository, URI backupPath, int maxNumBackup, NamedList results) throws Exception {
        ((DeleteBackupCmd)this.commandMap.get(CollectionParams.CollectionAction.DELETEBACKUP)).keepNumberOfBackup(repository, backupPath, maxNumBackup, results);
    }

    List<ZkNodeProps> addReplica(ClusterState clusterState, ZkNodeProps message, NamedList results, Runnable onComplete) throws Exception {
        return ((AddReplicaCmd)this.commandMap.get(CollectionParams.CollectionAction.ADDREPLICA)).addReplica(clusterState, message, results, onComplete);
    }

    void validateConfigOrThrowSolrException(String configName) throws IOException, KeeperException, InterruptedException {
        boolean isValid = this.cloudManager.getDistribStateManager().hasData("/configs/" + configName);
        if (!isValid) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Can not find the specified config set: " + configName);
        }
    }

    public static void createConfNode(DistribStateManager stateManager, String configName, String coll, boolean isLegacyCloud) throws IOException, AlreadyExistsException, BadVersionException, KeeperException, InterruptedException {
        if (configName != null) {
            String collDir = "/collections/" + coll;
            log.debug("creating collections conf node {} ", (Object)collDir);
            byte[] data = Utils.toJSON((Object)Utils.makeMap((Object[])new Object[]{"configName", configName}));
            if (stateManager.hasData(collDir)) {
                stateManager.setData(collDir, data, -1);
            } else {
                stateManager.makePath(collDir, data, CreateMode.PERSISTENT, false);
            }
        } else if (isLegacyCloud) {
            log.warn("Could not obtain config name");
        } else {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unable to get config name");
        }
    }

    List<Replica> collectionCmd(ZkNodeProps message, ModifiableSolrParams params, NamedList<Object> results, Replica.State stateMatcher, String asyncId, Set<String> okayExceptions) {
        log.info("Executing Collection Cmd={}, asyncId={}", (Object)params, (Object)asyncId);
        String collectionName = message.getStr("name");
        ShardHandler shardHandler = this.shardHandlerFactory.getShardHandler(this.overseer.getCoreContainer().getUpdateShardHandler().getDefaultHttpClient());
        ClusterState clusterState = this.zkStateReader.getClusterState();
        DocCollection coll = clusterState.getCollection(collectionName);
        ArrayList<Replica> notLivesReplicas = new ArrayList<Replica>();
        ShardRequestTracker shardRequestTracker = new ShardRequestTracker(asyncId);
        for (Slice slice : coll.getSlices()) {
            notLivesReplicas.addAll(shardRequestTracker.sliceCmd(clusterState, params, stateMatcher, slice, shardHandler));
        }
        shardRequestTracker.processResponses(results, shardHandler, false, null, okayExceptions);
        return notLivesReplicas;
    }

    private void processResponse(NamedList<Object> results, ShardResponse srsp, Set<String> okayExceptions) {
        Throwable e = srsp.getException();
        String nodeName = srsp.getNodeName();
        SolrResponse solrResponse = srsp.getSolrResponse();
        String shard = srsp.getShard();
        this.processResponse(results, e, nodeName, solrResponse, shard, okayExceptions);
    }

    private void processResponse(NamedList<Object> results, Throwable e, String nodeName, SolrResponse solrResponse, String shard, Set<String> okayExceptions) {
        String rootThrowable = null;
        if (e instanceof HttpSolrClient.RemoteSolrException) {
            rootThrowable = ((HttpSolrClient.RemoteSolrException)e).getRootThrowable();
        }
        if (!(e == null || rootThrowable != null && okayExceptions.contains(rootThrowable))) {
            log.error("Error from shard: {}", (Object)shard, (Object)e);
            OverseerCollectionMessageHandler.addFailure(results, nodeName, e.getClass().getName() + ":" + e.getMessage());
        } else {
            OverseerCollectionMessageHandler.addSuccess(results, nodeName, solrResponse.getResponse());
        }
    }

    private static void addFailure(NamedList<Object> results, String key, Object value) {
        SimpleOrderedMap failure = (SimpleOrderedMap)results.get(FAILURE_FIELD);
        if (failure == null) {
            failure = new SimpleOrderedMap();
            results.add(FAILURE_FIELD, (Object)failure);
        }
        failure.add(key, value);
    }

    private static void addSuccess(NamedList<Object> results, String key, Object value) {
        SimpleOrderedMap success = (SimpleOrderedMap)results.get(SUCCESS_FIELD);
        if (success == null) {
            success = new SimpleOrderedMap();
            results.add(SUCCESS_FIELD, (Object)success);
        }
        success.add(key, value);
    }

    private NamedList<Object> waitForCoreAdminAsyncCallToComplete(String nodeName, String requestId) {
        ShardHandler shardHandler = this.shardHandlerFactory.getShardHandler();
        ModifiableSolrParams params = new ModifiableSolrParams();
        params.set("action", new String[]{CoreAdminParams.CoreAdminAction.REQUESTSTATUS.toString()});
        params.set(REQUESTID, new String[]{requestId});
        int counter = 0;
        block4: while (true) {
            ShardResponse srsp;
            ShardRequest sreq = new ShardRequest();
            params.set("qt", new String[]{this.adminPath});
            sreq.purpose = 1;
            String replica = this.zkStateReader.getBaseUrlForNodeName(nodeName);
            sreq.shards = new String[]{replica};
            sreq.actualShards = sreq.shards;
            sreq.params = params;
            shardHandler.submit(sreq, replica, sreq.params);
            do {
                if ((srsp = shardHandler.takeCompletedOrError()) == null) continue;
                NamedList results = new NamedList();
                this.processResponse((NamedList<Object>)results, srsp, Collections.emptySet());
                if (srsp.getSolrResponse().getResponse() == null) {
                    NamedList response = new NamedList();
                    response.add("STATUS", (Object)"failed");
                    return response;
                }
                String r = (String)srsp.getSolrResponse().getResponse().get("STATUS");
                if (r.equals("running")) {
                    log.debug("The task is still RUNNING, continuing to wait.");
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                    continue;
                }
                if (r.equals("completed")) {
                    log.debug("The task is COMPLETED, returning");
                    return srsp.getSolrResponse().getResponse();
                }
                if (r.equals("failed")) {
                    log.debug("The task is FAILED, returning");
                    return srsp.getSolrResponse().getResponse();
                }
                if (r.equals("notfound")) {
                    log.debug("The task is notfound, retry");
                    if (counter++ < 5) {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {}
                        continue block4;
                    }
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Invalid status request for requestId: " + requestId + "" + srsp.getSolrResponse().getResponse().get("STATUS") + "retried " + counter + "times");
                }
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Invalid status request " + srsp.getSolrResponse().getResponse().get("STATUS"));
            } while (srsp != null);
        }
    }

    @Override
    public String getName() {
        return "Overseer Collection Message Handler";
    }

    @Override
    public String getTimerName(String operation) {
        return "collection_" + operation;
    }

    @Override
    public String getTaskKey(ZkNodeProps message) {
        return message.containsKey("collection") ? message.getStr("collection") : message.getStr("name");
    }

    @Override
    public OverseerMessageHandler.Lock lockTask(ZkNodeProps message, OverseerTaskProcessor.TaskBatch taskBatch) {
        if (this.lockSession == null || this.sessionId != taskBatch.getId()) {
            if (taskBatch.getRunningTasks() == 0) {
                this.lockTree.clear();
            }
            this.lockSession = this.lockTree.getSession();
        }
        return this.lockSession.lock(this.getCollectionAction(message.getStr("operation")), Arrays.asList(this.getTaskKey(message), message.getStr("shard"), message.getStr("replica")));
    }

    public void close() throws IOException {
        this.isClosed = true;
        if (this.tpe != null && !this.tpe.isShutdown()) {
            ExecutorUtil.shutdownAndAwaitTermination((ExecutorService)this.tpe);
        }
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public ShardRequestTracker syncRequestTracker() {
        return new ShardRequestTracker(null);
    }

    public ShardRequestTracker asyncRequestTracker(String asyncId) {
        return new ShardRequestTracker(asyncId);
    }

    static {
        String seed = System.getProperty("tests.seed");
        RANDOM = seed == null ? new Random() : new Random(seed.hashCode());
        INCLUDE_TOP_LEVEL_RESPONSE = true;
    }

    protected static interface Cmd {
        public void call(ClusterState var1, ZkNodeProps var2, NamedList var3) throws Exception;
    }

    public class ShardRequestTracker {
        private final String asyncId;
        private final NamedList<String> shardAsyncIdByNode = new NamedList();

        private ShardRequestTracker(String asyncId) {
            this.asyncId = asyncId;
        }

        public List<Replica> sliceCmd(ClusterState clusterState, ModifiableSolrParams params, Replica.State stateMatcher, Slice slice, ShardHandler shardHandler) {
            ArrayList<Replica> notLiveReplicas = new ArrayList<Replica>();
            for (Replica replica : slice.getReplicas()) {
                if (stateMatcher != null && replica.getState() != stateMatcher) continue;
                if (clusterState.liveNodesContain(replica.getStr("node_name"))) {
                    ModifiableSolrParams cloneParams = new ModifiableSolrParams();
                    cloneParams.add((SolrParams)params);
                    cloneParams.set("core", new String[]{replica.getStr("core")});
                    this.sendShardRequest(replica.getStr("node_name"), cloneParams, shardHandler);
                    continue;
                }
                notLiveReplicas.add(replica);
            }
            return notLiveReplicas;
        }

        public void sendShardRequest(String nodeName, ModifiableSolrParams params, ShardHandler shardHandler) {
            this.sendShardRequest(nodeName, params, shardHandler, OverseerCollectionMessageHandler.this.adminPath, OverseerCollectionMessageHandler.this.zkStateReader);
        }

        public void sendShardRequest(String nodeName, ModifiableSolrParams params, ShardHandler shardHandler, String adminPath, ZkStateReader zkStateReader) {
            if (this.asyncId != null) {
                String coreAdminAsyncId = this.asyncId + Math.abs(System.nanoTime());
                params.set("async", new String[]{coreAdminAsyncId});
                this.track(nodeName, coreAdminAsyncId);
            }
            ShardRequest sreq = new ShardRequest();
            params.set("qt", new String[]{adminPath});
            sreq.purpose = 1;
            String replica = zkStateReader.getBaseUrlForNodeName(nodeName);
            sreq.shards = new String[]{replica};
            sreq.actualShards = sreq.shards;
            sreq.nodeName = nodeName;
            sreq.params = params;
            shardHandler.submit(sreq, replica, sreq.params);
        }

        void processResponses(NamedList<Object> results, ShardHandler shardHandler, boolean abortOnError, String msgOnError) {
            this.processResponses(results, shardHandler, abortOnError, msgOnError, Collections.emptySet());
        }

        void processResponses(NamedList<Object> results, ShardHandler shardHandler, boolean abortOnError, String msgOnError, Set<String> okayExceptions) {
            ShardResponse srsp;
            do {
                if ((srsp = shardHandler.takeCompletedOrError()) == null) continue;
                OverseerCollectionMessageHandler.this.processResponse((NamedList<Object>)results, srsp, okayExceptions);
                Throwable exception = srsp.getException();
                if (!abortOnError || exception == null) continue;
                while (srsp != null) {
                    srsp = shardHandler.takeCompletedOrError();
                }
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, msgOnError, exception);
            } while (srsp != null);
            if (this.asyncId != null) {
                this.waitForAsyncCallsToComplete(results);
                this.shardAsyncIdByNode.clear();
            }
        }

        private void waitForAsyncCallsToComplete(NamedList<Object> results) {
            for (Map.Entry nodeToAsync : this.shardAsyncIdByNode) {
                String node = (String)nodeToAsync.getKey();
                String shardAsyncId = (String)nodeToAsync.getValue();
                log.debug("I am Waiting for :{}/{}", (Object)node, (Object)shardAsyncId);
                NamedList reqResult = OverseerCollectionMessageHandler.this.waitForCoreAdminAsyncCallToComplete(node, shardAsyncId);
                if (INCLUDE_TOP_LEVEL_RESPONSE) {
                    results.add(shardAsyncId, (Object)reqResult);
                }
                if ("failed".equalsIgnoreCase((String)reqResult.get("STATUS"))) {
                    log.error("Error from shard {}: {}", (Object)node, (Object)reqResult);
                    OverseerCollectionMessageHandler.addFailure((NamedList<Object>)results, node, reqResult);
                    continue;
                }
                OverseerCollectionMessageHandler.addSuccess((NamedList<Object>)results, node, reqResult);
            }
        }

        @Deprecated
        void track(String nodeName, String coreAdminAsyncId) {
            this.shardAsyncIdByNode.add(nodeName, (Object)coreAdminAsyncId);
        }
    }
}

