/*
 * Decompiled with CFR 0.152.
 */
package com.drew.lang;

import com.drew.lang.SequentialReader;
import com.drew.lang.annotations.NotNull;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class StreamReader
extends SequentialReader {
    @NotNull
    private final InputStream _stream;

    public StreamReader(@NotNull InputStream inputStream) {
        if (inputStream == null) {
            throw new NullPointerException();
        }
        this._stream = inputStream;
    }

    protected byte getByte() throws IOException {
        int n = this._stream.read();
        if (n == -1) {
            throw new EOFException("End of data reached.");
        }
        return (byte)n;
    }

    @NotNull
    public byte[] getBytes(int n) throws IOException {
        byte[] byArray = new byte[n];
        int n2 = 0;
        while (n2 != n) {
            int n3 = this._stream.read(byArray, n2, n - n2);
            if (n3 == -1) {
                throw new EOFException("End of data reached.");
            }
            assert ((n2 += n3) <= n);
        }
        return byArray;
    }

    public void skip(long l) throws IOException {
        if (l < 0L) {
            throw new IllegalArgumentException("n must be zero or greater.");
        }
        long l2 = this.skipInternal(l);
        if (l2 != l) {
            throw new EOFException(String.format("Unable to skip. Requested %d bytes but skipped %d.", l, l2));
        }
    }

    public boolean trySkip(long l) throws IOException {
        if (l < 0L) {
            throw new IllegalArgumentException("n must be zero or greater.");
        }
        return this.skipInternal(l) == l;
    }

    private long skipInternal(long l) throws IOException {
        long l2;
        long l3;
        for (l2 = 0L; l2 != l; l2 += l3) {
            l3 = this._stream.skip(l - l2);
            assert (l3 >= 0L);
        }
        return l2;
    }
}

