/*
 * Decompiled with CFR 0.152.
 */
package macromedia.slutil;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import macromedia.slutil.UtilByteArray;
import macromedia.slutil.UtilException;
import macromedia.slutil.UtilTransliterator;

public class UtilTransliteratorForASCII
extends UtilTransliterator {
    private int[] rl;
    private InputStream _in;

    public UtilTransliteratorForASCII() {
        this.setDefaultCacheSize();
    }

    public boolean isFixedBytesPerChar() {
        return true;
    }

    public int getMaxBytesPerChar() {
        return 1;
    }

    public int getMaxCharsPerByte() {
        return 1;
    }

    public byte[] encode(String string) throws UtilException {
        if (this.rl == null) {
            this.rl = new int[1];
        }
        return UtilByteArray.duplicate(this.encode(string, this.rl), string.length());
    }

    public byte[] encode(String string, int[] nArray) throws UtilException {
        int n2 = string.length();
        this.setCacheSize(n2);
        string.getChars(0, n2, this.charsCache, 0);
        for (int i2 = 0; i2 < n2; ++i2) {
            this.bytesCache[i2] = (byte)this.charsCache[i2];
        }
        nArray[0] = n2;
        return this.bytesCache;
    }

    public void encode(InputStream inputStream, int n2, OutputStream outputStream) throws UtilException {
        this.setCacheSize(this.streamChunkSize);
        try {
            while (n2 > 0) {
                int n3 = Math.min(n2, this.streamChunkSize);
                int n4 = inputStream.read(this.bytesCache, 0, n3);
                if (n4 == -1) {
                    throw new UtilException(1002);
                }
                outputStream.write(this.bytesCache, 0, n4);
                n2 -= n4;
            }
        }
        catch (IOException iOException) {
            throw UtilException.createTransliterationFailedException(iOException.getMessage());
        }
    }

    public void encode(Reader reader, int n2, OutputStream outputStream) throws UtilException {
        this.setCacheSize(this.streamChunkSize);
        try {
            while (n2 > 0) {
                int n3 = Math.min(n2, this.streamChunkSize);
                int n4 = reader.read(this.charsCache, 0, n3);
                if (n4 == -1) {
                    throw new UtilException(1002);
                }
                for (int i2 = 0; i2 < n4; ++i2) {
                    this.bytesCache[i2] = (byte)this.charsCache[i2];
                }
                outputStream.write(this.bytesCache, 0, n4);
                n2 -= n4;
            }
        }
        catch (IOException iOException) {
            throw UtilException.createTransliterationFailedException(iOException.getMessage());
        }
    }

    private void _decode(byte[] byArray, int n2, char[] cArray, int n3, int n4) {
        for (int i2 = 0; i2 < n4; ++i2) {
            cArray[i2 + n3] = (char)(byArray[i2 + n2] & 0xFF);
        }
    }

    public String decode(byte[] byArray, int n2, int n3) throws UtilException {
        if (n3 == 0) {
            return EMPTY_STRING;
        }
        this.setCacheSize(n3);
        this._decode(byArray, n2, this.charsCache, 0, n3);
        return new String(this.charsCache, 0, n3);
    }

    public int decode(byte[] byArray, int n2, int n3, char[] cArray) throws UtilException {
        if (n3 == 0) {
            return 0;
        }
        if (n3 > cArray.length) {
            n3 = cArray.length;
        }
        this._decode(byArray, n2, cArray, 0, n3);
        return n3;
    }

    public String decode(byte[] byArray, int n2, int n3, int n4) throws UtilException {
        int n5 = StrictMath.max(n3, n4);
        this.setCacheSize(n5);
        this._decode(byArray, n2, this.charsCache, 0, n3);
        for (int i2 = n3; i2 < n4; ++i2) {
            this.charsCache[i2] = 32;
        }
        return new String(this.charsCache, 0, n4);
    }

    public InputStream decodeAsAsciiStream(InputStream inputStream) throws UtilException {
        return inputStream;
    }

    public synchronized Reader decodeAsReader(InputStream inputStream) throws UtilException {
        this._in = inputStream;
        return new Reader(){
            private InputStream in;
            private int length;
            private byte[] cache;
            {
                this.in = UtilTransliteratorForASCII.this._in;
            }

            public int read() throws IOException {
                int n2 = this.in.read();
                if (n2 == -1) {
                    return -1;
                }
                return (char)(n2 & 0xFF);
            }

            public int read(char[] cArray, int n2, int n3) throws IOException {
                int n4;
                if (this.cache == null || this.cache.length < n3) {
                    this.cache = new byte[n3];
                }
                if ((n4 = this.in.read(this.cache, 0, n3)) <= 0) {
                    return n4;
                }
                UtilTransliteratorForASCII.this._decode(this.cache, 0, cArray, n2, n4);
                return n4;
            }

            public void close() throws IOException {
                this.in.close();
            }
        };
    }
}

