/*
 * Decompiled with CFR 0.152.
 */
package macromedia.slutil;

import java.io.IOException;
import java.io.OutputStream;
import macromedia.slutil.UtilException;
import macromedia.slutil.UtilTempBuffer;

public class UtilTempBufferOutputStream
extends OutputStream {
    private UtilTempBuffer tempBuffer;
    private int currentPos;

    public UtilTempBufferOutputStream(UtilTempBuffer utilTempBuffer) {
        this.tempBuffer = utilTempBuffer;
        this.currentPos = 0;
    }

    public void write(int n2) throws IOException {
        try {
            int n3 = this.tempBuffer.write((long)this.currentPos, (byte)n2);
            if (n3 < 0) {
                n3 = -n3;
            }
            this.currentPos += n3;
            if (n3 == 0) {
                throw new IOException(this.getExceptionMessage(1023, "The temp buffer is full"));
            }
        }
        catch (UtilException utilException) {
            throw new IOException(utilException.getMessage());
        }
        catch (NullPointerException nullPointerException) {
            throw new IOException(this.getExceptionMessage(1017));
        }
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n2, int n3) throws IOException {
        try {
            int n4 = this.tempBuffer.write(this.currentPos, byArray, n2, n3);
            if (n4 < 0) {
                n4 = -n4;
            }
            this.currentPos += n4;
            if (n4 == 0) {
                throw new IOException(this.getExceptionMessage(1023, "The temp buffer is full"));
            }
        }
        catch (UtilException utilException) {
            throw new IOException(utilException.getMessage());
        }
        catch (NullPointerException nullPointerException) {
            throw new IOException(this.getExceptionMessage(1017));
        }
    }

    public void close() throws IOException {
        this.tempBuffer = null;
        this.currentPos = -1;
    }

    private String getExceptionMessage(int n2) {
        UtilException utilException = new UtilException(n2);
        return utilException.getMessage();
    }

    private String getExceptionMessage(int n2, String string) {
        UtilException utilException = new UtilException(n2, string);
        return utilException.getMessage();
    }
}

