/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.slbase;

import java.io.InputStream;
import java.sql.SQLException;
import macromedia.jdbc.slbase.BaseExceptions;
import macromedia.jdbc.slbase.BaseImplBlob;
import macromedia.slutil.UtilException;
import macromedia.slutil.UtilPagedTempBuffer;

public class BaseImplBlobEmulated
extends BaseImplBlob {
    private UtilPagedTempBuffer blobData;

    public BaseImplBlobEmulated(BaseExceptions baseExceptions, UtilPagedTempBuffer utilPagedTempBuffer) throws SQLException {
        super(baseExceptions);
        this.blobData = utilPagedTempBuffer;
    }

    public BaseImplBlobEmulated(BaseExceptions baseExceptions, InputStream inputStream) throws SQLException {
        super(baseExceptions);
        try {
            this.blobData = new UtilPagedTempBuffer(2048);
            int n2 = 1024;
            byte[] byArray = new byte[n2];
            int n3 = inputStream.read(byArray);
            long l2 = 0L;
            while (n3 != -1) {
                this.blobData.write(l2, byArray, 0, n3);
                l2 += (long)n3;
                n3 = inputStream.read(byArray);
            }
        }
        catch (Exception exception) {
            throw baseExceptions.getException(exception);
        }
    }

    public boolean supportsSearch() {
        return true;
    }

    public long find(byte[] byArray, long l2) throws SQLException {
        long l3 = this.getLength();
        long l4 = l2 - 1L;
        int n2 = byArray.length;
        int n3 = 0;
        long l5 = l4;
        try {
            while (n3 < n2) {
                byte by2;
                byte by3;
                if (l4 == l3) {
                    return -1L;
                }
                if ((by3 = byArray[n3++]) == (by2 = this.blobData.read(l4++))) continue;
                n3 = 0;
                by3 = byArray[n3++];
                l4 = l5 + 1L;
                do {
                    if (l4 != l3) continue;
                    return -1L;
                } while (by3 != (by2 = this.blobData.read(l4++)));
                l5 = l4 - 1L;
            }
        }
        catch (Exception exception) {
            throw this.exceptions.getException(exception);
        }
        return l5 + 1L;
    }

    public int readData(byte[] byArray, int n2, long l2, int n3) throws SQLException {
        try {
            return this.blobData.read(l2 - 1L, byArray, n2, n3);
        }
        catch (UtilException utilException) {
            throw this.exceptions.getException(utilException);
        }
    }

    public int writeData(long l2, byte[] byArray, int n2, int n3) throws SQLException {
        try {
            return this.blobData.write(l2 - 1L, byArray, n2, n3);
        }
        catch (UtilException utilException) {
            throw this.exceptions.getException(utilException);
        }
    }

    public void truncate(long l2) throws SQLException {
        try {
            this.blobData.truncate(l2);
        }
        catch (UtilException utilException) {
            throw this.exceptions.getException(utilException);
        }
    }

    public long getLength() throws SQLException {
        return this.blobData.getSize();
    }

    public void close() throws SQLException {
        try {
            this.blobData.truncate(true);
        }
        catch (UtilException utilException) {
            throw this.exceptions.getException(utilException);
        }
    }
}

