/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.oracle.externals.org.json;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import macromedia.jdbc.oracle.externals.org.json.XMLXsiTypeConverter;

public class XMLParserConfiguration {
    public static final int UNDEFINED_MAXIMUM_NESTING_DEPTH = -1;
    public static final int DEFAULT_MAXIMUM_NESTING_DEPTH = 512;
    public static final XMLParserConfiguration ORIGINAL = new XMLParserConfiguration();
    public static final XMLParserConfiguration KEEP_STRINGS = new XMLParserConfiguration().withKeepStrings(true);
    private boolean keepStrings;
    private String cDataTagName;
    private boolean convertNilAttributeToNull;
    private Map<String, XMLXsiTypeConverter<?>> xsiTypeMap;
    private Set<String> forceList;
    private int maxNestingDepth = 512;

    public XMLParserConfiguration() {
        this.keepStrings = false;
        this.cDataTagName = "content";
        this.convertNilAttributeToNull = false;
        this.xsiTypeMap = Collections.emptyMap();
        this.forceList = Collections.emptySet();
    }

    @Deprecated
    public XMLParserConfiguration(boolean bl2) {
        this(bl2, "content", false);
    }

    @Deprecated
    public XMLParserConfiguration(String string) {
        this(false, string, false);
    }

    @Deprecated
    public XMLParserConfiguration(boolean bl2, String string) {
        this.keepStrings = bl2;
        this.cDataTagName = string;
        this.convertNilAttributeToNull = false;
    }

    @Deprecated
    public XMLParserConfiguration(boolean bl2, String string, boolean bl3) {
        this.keepStrings = bl2;
        this.cDataTagName = string;
        this.convertNilAttributeToNull = bl3;
    }

    private XMLParserConfiguration(boolean bl2, String string, boolean bl3, Map<String, XMLXsiTypeConverter<?>> map, Set<String> set, int n2) {
        this.keepStrings = bl2;
        this.cDataTagName = string;
        this.convertNilAttributeToNull = bl3;
        this.xsiTypeMap = Collections.unmodifiableMap(map);
        this.forceList = Collections.unmodifiableSet(set);
        this.maxNestingDepth = n2;
    }

    protected XMLParserConfiguration clone() {
        return new XMLParserConfiguration(this.keepStrings, this.cDataTagName, this.convertNilAttributeToNull, this.xsiTypeMap, this.forceList, this.maxNestingDepth);
    }

    public boolean isKeepStrings() {
        return this.keepStrings;
    }

    public XMLParserConfiguration withKeepStrings(boolean bl2) {
        XMLParserConfiguration xMLParserConfiguration = this.clone();
        xMLParserConfiguration.keepStrings = bl2;
        return xMLParserConfiguration;
    }

    public String getcDataTagName() {
        return this.cDataTagName;
    }

    public XMLParserConfiguration withcDataTagName(String string) {
        XMLParserConfiguration xMLParserConfiguration = this.clone();
        xMLParserConfiguration.cDataTagName = string;
        return xMLParserConfiguration;
    }

    public boolean isConvertNilAttributeToNull() {
        return this.convertNilAttributeToNull;
    }

    public XMLParserConfiguration withConvertNilAttributeToNull(boolean bl2) {
        XMLParserConfiguration xMLParserConfiguration = this.clone();
        xMLParserConfiguration.convertNilAttributeToNull = bl2;
        return xMLParserConfiguration;
    }

    public Map<String, XMLXsiTypeConverter<?>> getXsiTypeMap() {
        return this.xsiTypeMap;
    }

    public XMLParserConfiguration withXsiTypeMap(Map<String, XMLXsiTypeConverter<?>> map) {
        XMLParserConfiguration xMLParserConfiguration = this.clone();
        HashMap hashMap = new HashMap(map);
        xMLParserConfiguration.xsiTypeMap = Collections.unmodifiableMap(hashMap);
        return xMLParserConfiguration;
    }

    public Set<String> getForceList() {
        return this.forceList;
    }

    public XMLParserConfiguration withForceList(Set<String> set) {
        XMLParserConfiguration xMLParserConfiguration = this.clone();
        HashSet<String> hashSet = new HashSet<String>(set);
        xMLParserConfiguration.forceList = Collections.unmodifiableSet(hashSet);
        return xMLParserConfiguration;
    }

    public int getMaxNestingDepth() {
        return this.maxNestingDepth;
    }

    public XMLParserConfiguration withMaxNestingDepth(int n2) {
        XMLParserConfiguration xMLParserConfiguration = this.clone();
        xMLParserConfiguration.maxNestingDepth = n2 > -1 ? n2 : -1;
        return xMLParserConfiguration;
    }
}

