/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.oracle.externals.org.bouncycastle.math.raw;

import java.util.Random;
import macromedia.jdbc.oracle.externals.org.bouncycastle.math.raw.Nat;
import macromedia.jdbc.oracle.externals.org.bouncycastle.util.Integers;

public abstract class Mod {
    private static final int M30 = 0x3FFFFFFF;
    private static final long M32L = 0xFFFFFFFFL;

    public static void checkedModOddInverse(int[] nArray, int[] nArray2, int[] nArray3) {
        if (0 == Mod.modOddInverse(nArray, nArray2, nArray3)) {
            throw new ArithmeticException("Inverse does not exist.");
        }
    }

    public static void checkedModOddInverseVar(int[] nArray, int[] nArray2, int[] nArray3) {
        if (!Mod.modOddInverseVar(nArray, nArray2, nArray3)) {
            throw new ArithmeticException("Inverse does not exist.");
        }
    }

    public static int inverse32(int n2) {
        int n3 = n2;
        n3 *= 2 - n2 * n3;
        n3 *= 2 - n2 * n3;
        n3 *= 2 - n2 * n3;
        n3 *= 2 - n2 * n3;
        return n3;
    }

    public static int modOddInverse(int[] nArray, int[] nArray2, int[] nArray3) {
        int n2;
        int n3 = nArray.length;
        int n4 = (n3 << 5) - Integers.numberOfLeadingZeros(nArray[n3 - 1]);
        int n5 = (n4 + 29) / 30;
        int[] nArray4 = new int[4];
        int[] nArray5 = new int[n5];
        int[] nArray6 = new int[n5];
        int[] nArray7 = new int[n5];
        int[] nArray8 = new int[n5];
        int[] nArray9 = new int[n5];
        nArray6[0] = 1;
        Mod.encode30(n4, nArray2, 0, nArray8, 0);
        Mod.encode30(n4, nArray, 0, nArray9, 0);
        System.arraycopy(nArray9, 0, nArray7, 0, n5);
        int n6 = 0;
        int n7 = Mod.inverse32(nArray9[0]);
        int n8 = Mod.getMaximumDivsteps(n4);
        for (n2 = 0; n2 < n8; n2 += 30) {
            n6 = Mod.divsteps30(n6, nArray7[0], nArray8[0], nArray4);
            Mod.updateDE30(n5, nArray5, nArray6, nArray4, n7, nArray9);
            Mod.updateFG30(n5, nArray7, nArray8, nArray4);
        }
        n2 = nArray7[n5 - 1] >> 31;
        Mod.cnegate30(n5, n2, nArray7);
        Mod.cnormalize30(n5, n2, nArray5, nArray9);
        Mod.decode30(n4, nArray5, 0, nArray3, 0);
        return Nat.equalTo(n5, nArray7, 1) & Nat.equalToZero(n5, nArray8);
    }

    public static boolean modOddInverseVar(int[] nArray, int[] nArray2, int[] nArray3) {
        int n2;
        int n3;
        int n4 = nArray.length;
        int n5 = (n4 << 5) - Integers.numberOfLeadingZeros(nArray[n4 - 1]);
        int n6 = (n5 + 29) / 30;
        int[] nArray4 = new int[4];
        int[] nArray5 = new int[n6];
        int[] nArray6 = new int[n6];
        int[] nArray7 = new int[n6];
        int[] nArray8 = new int[n6];
        int[] nArray9 = new int[n6];
        nArray6[0] = 1;
        Mod.encode30(n5, nArray2, 0, nArray8, 0);
        Mod.encode30(n5, nArray, 0, nArray9, 0);
        System.arraycopy(nArray9, 0, nArray7, 0, n6);
        int n7 = Integers.numberOfLeadingZeros(nArray8[n6 - 1] | 1) - (n6 * 30 + 2 - n5);
        int n8 = -1 - n7;
        int n9 = n6;
        int n10 = n6;
        int n11 = Mod.inverse32(nArray9[0]);
        int n12 = Mod.getMaximumDivsteps(n5);
        int n13 = 0;
        while (!Nat.isZero(n10, nArray8)) {
            if (n13 >= n12) {
                return false;
            }
            n13 += 30;
            n8 = Mod.divsteps30Var(n8, nArray7[0], nArray8[0], nArray4);
            Mod.updateDE30(n9, nArray5, nArray6, nArray4, n11, nArray9);
            Mod.updateFG30(n10, nArray7, nArray8, nArray4);
            n3 = nArray7[n10 - 1];
            n2 = nArray8[n10 - 1];
            int n14 = n10 - 2 >> 31;
            n14 |= n3 ^ n3 >> 31;
            if ((n14 |= n2 ^ n2 >> 31) != 0) continue;
            int n15 = n10 - 2;
            nArray7[n15] = nArray7[n15] | n3 << 30;
            int n16 = n10 - 2;
            nArray8[n16] = nArray8[n16] | n2 << 30;
            --n10;
        }
        n3 = nArray7[n10 - 1] >> 31;
        n2 = nArray5[n9 - 1] >> 31;
        if (n2 < 0) {
            n2 = Mod.add30(n9, nArray5, nArray9);
        }
        if (n3 < 0) {
            n2 = Mod.negate30(n9, nArray5);
            n3 = Mod.negate30(n10, nArray7);
        }
        if (!Nat.isOne(n10, nArray7)) {
            return false;
        }
        if (n2 < 0) {
            n2 = Mod.add30(n9, nArray5, nArray9);
        }
        Mod.decode30(n5, nArray5, 0, nArray3, 0);
        return true;
    }

    public static int[] random(int[] nArray) {
        int n2 = nArray.length;
        Random random = new Random();
        int[] nArray2 = Nat.create(n2);
        int n3 = nArray[n2 - 1];
        n3 |= n3 >>> 1;
        n3 |= n3 >>> 2;
        n3 |= n3 >>> 4;
        n3 |= n3 >>> 8;
        n3 |= n3 >>> 16;
        do {
            for (int i2 = 0; i2 != n2; ++i2) {
                nArray2[i2] = random.nextInt();
            }
            int n4 = n2 - 1;
            nArray2[n4] = nArray2[n4] & n3;
        } while (Nat.gte(n2, nArray2, nArray));
        return nArray2;
    }

    private static int add30(int n2, int[] nArray, int[] nArray2) {
        int n3 = 0;
        int n4 = n2 - 1;
        for (int i2 = 0; i2 < n4; ++i2) {
            nArray[i2] = (n3 += nArray[i2] + nArray2[i2]) & 0x3FFFFFFF;
            n3 >>= 30;
        }
        nArray[n4] = n3 += nArray[n4] + nArray2[n4];
        return n3 >>= 30;
    }

    private static void cnegate30(int n2, int n3, int[] nArray) {
        int n4 = 0;
        int n5 = n2 - 1;
        for (int i2 = 0; i2 < n5; ++i2) {
            nArray[i2] = (n4 += (nArray[i2] ^ n3) - n3) & 0x3FFFFFFF;
            n4 >>= 30;
        }
        nArray[n5] = n4 += (nArray[n5] ^ n3) - n3;
    }

    private static void cnormalize30(int n2, int n3, int[] nArray, int[] nArray2) {
        int n4;
        int n5;
        int n6 = n2 - 1;
        int n7 = 0;
        int n8 = nArray[n6] >> 31;
        for (n5 = 0; n5 < n6; ++n5) {
            n4 = nArray[n5] + (nArray2[n5] & n8);
            n4 = (n4 ^ n3) - n3;
            nArray[n5] = (n7 += n4) & 0x3FFFFFFF;
            n7 >>= 30;
        }
        n5 = nArray[n6] + (nArray2[n6] & n8);
        n5 = (n5 ^ n3) - n3;
        nArray[n6] = n7 += n5;
        n7 = 0;
        n8 = nArray[n6] >> 31;
        for (n5 = 0; n5 < n6; ++n5) {
            n4 = nArray[n5] + (nArray2[n5] & n8);
            nArray[n5] = (n7 += n4) & 0x3FFFFFFF;
            n7 >>= 30;
        }
        n5 = nArray[n6] + (nArray2[n6] & n8);
        nArray[n6] = n7 += n5;
    }

    private static void decode30(int n2, int[] nArray, int n3, int[] nArray2, int n4) {
        int n5 = 0;
        long l2 = 0L;
        while (n2 > 0) {
            while (n5 < Math.min(32, n2)) {
                l2 |= (long)nArray[n3++] << n5;
                n5 += 30;
            }
            nArray2[n4++] = (int)l2;
            l2 >>>= 32;
            n5 -= 32;
            n2 -= 32;
        }
    }

    private static int divsteps30(int n2, int n3, int n4, int[] nArray) {
        int n5 = 0x40000000;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0x40000000;
        int n9 = n3;
        int n10 = n4;
        for (int i2 = 0; i2 < 30; ++i2) {
            int n11 = n2 >> 31;
            int n12 = -(n10 & 1);
            int n13 = n9 ^ n11;
            int n14 = n5 ^ n11;
            int n15 = n6 ^ n11;
            n10 -= n13 & n12;
            n7 -= n14 & n12;
            n8 -= n15 & n12;
            n2 = (n2 ^ (n12 &= ~n11)) - (n12 - 1);
            n9 += n10 & n12;
            n5 += n7 & n12;
            n6 += n8 & n12;
            n10 >>= 1;
            n7 >>= 1;
            n8 >>= 1;
        }
        nArray[0] = n5;
        nArray[1] = n6;
        nArray[2] = n7;
        nArray[3] = n8;
        return n2;
    }

    private static int divsteps30Var(int n2, int n3, int n4, int[] nArray) {
        int n5 = 1;
        int n6 = 0;
        int n7 = 0;
        int n8 = 1;
        int n9 = n3;
        int n10 = n4;
        int n11 = 30;
        while (true) {
            int n12;
            int n13;
            int n14;
            int n15 = Integers.numberOfTrailingZeros(n10 | -1 << n11);
            n10 >>= n15;
            n5 <<= n15;
            n6 <<= n15;
            n2 -= n15;
            if ((n11 -= n15) <= 0) break;
            if (n2 < 0) {
                n2 = -n2;
                int n16 = n9;
                n9 = n10;
                n10 = -n16;
                int n17 = n5;
                n5 = n7;
                n7 = -n17;
                int n18 = n6;
                n6 = n8;
                n8 = -n18;
                n14 = n2 + 1 > n11 ? n11 : n2 + 1;
                n13 = -1 >>> 32 - n14 & 0x3F;
                n12 = n9 * n10 * (n9 * n9 - 2) & n13;
            } else {
                n14 = n2 + 1 > n11 ? n11 : n2 + 1;
                n13 = -1 >>> 32 - n14 & 0xF;
                n12 = n9 + ((n9 + 1 & 4) << 1);
                n12 = -n12 * n10 & n13;
            }
            n10 += n9 * n12;
            n7 += n5 * n12;
            n8 += n6 * n12;
        }
        nArray[0] = n5;
        nArray[1] = n6;
        nArray[2] = n7;
        nArray[3] = n8;
        return n2;
    }

    private static void encode30(int n2, int[] nArray, int n3, int[] nArray2, int n4) {
        int n5 = 0;
        long l2 = 0L;
        while (n2 > 0) {
            if (n5 < Math.min(30, n2)) {
                l2 |= ((long)nArray[n3++] & 0xFFFFFFFFL) << n5;
                n5 += 32;
            }
            nArray2[n4++] = (int)l2 & 0x3FFFFFFF;
            l2 >>>= 30;
            n5 -= 30;
            n2 -= 30;
        }
    }

    private static int getMaximumDivsteps(int n2) {
        return (49 * n2 + (n2 < 46 ? 80 : 47)) / 17;
    }

    private static int negate30(int n2, int[] nArray) {
        int n3 = 0;
        int n4 = n2 - 1;
        for (int i2 = 0; i2 < n4; ++i2) {
            nArray[i2] = (n3 -= nArray[i2]) & 0x3FFFFFFF;
            n3 >>= 30;
        }
        nArray[n4] = n3 -= nArray[n4];
        return n3 >>= 30;
    }

    private static void updateDE30(int n2, int[] nArray, int[] nArray2, int[] nArray3, int n3, int[] nArray4) {
        int n4 = nArray3[0];
        int n5 = nArray3[1];
        int n6 = nArray3[2];
        int n7 = nArray3[3];
        int n8 = nArray[n2 - 1] >> 31;
        int n9 = nArray2[n2 - 1] >> 31;
        int n10 = (n4 & n8) + (n5 & n9);
        int n11 = (n6 & n8) + (n7 & n9);
        int n12 = nArray4[0];
        int n13 = nArray[0];
        int n14 = nArray2[0];
        long l2 = (long)n4 * (long)n13 + (long)n5 * (long)n14;
        long l3 = (long)n6 * (long)n13 + (long)n7 * (long)n14;
        n10 -= n3 * (int)l2 + n10 & 0x3FFFFFFF;
        n11 -= n3 * (int)l3 + n11 & 0x3FFFFFFF;
        l2 += (long)n12 * (long)n10;
        l3 += (long)n12 * (long)n11;
        l2 >>= 30;
        l3 >>= 30;
        for (int i2 = 1; i2 < n2; ++i2) {
            n12 = nArray4[i2];
            n13 = nArray[i2];
            n14 = nArray2[i2];
            nArray[i2 - 1] = (int)(l2 += (long)n4 * (long)n13 + (long)n5 * (long)n14 + (long)n12 * (long)n10) & 0x3FFFFFFF;
            l2 >>= 30;
            nArray2[i2 - 1] = (int)(l3 += (long)n6 * (long)n13 + (long)n7 * (long)n14 + (long)n12 * (long)n11) & 0x3FFFFFFF;
            l3 >>= 30;
        }
        nArray[n2 - 1] = (int)l2;
        nArray2[n2 - 1] = (int)l3;
    }

    private static void updateFG30(int n2, int[] nArray, int[] nArray2, int[] nArray3) {
        int n3 = nArray3[0];
        int n4 = nArray3[1];
        int n5 = nArray3[2];
        int n6 = nArray3[3];
        int n7 = nArray[0];
        int n8 = nArray2[0];
        long l2 = (long)n3 * (long)n7 + (long)n4 * (long)n8;
        long l3 = (long)n5 * (long)n7 + (long)n6 * (long)n8;
        l2 >>= 30;
        l3 >>= 30;
        for (int i2 = 1; i2 < n2; ++i2) {
            n7 = nArray[i2];
            n8 = nArray2[i2];
            nArray[i2 - 1] = (int)(l2 += (long)n3 * (long)n7 + (long)n4 * (long)n8) & 0x3FFFFFFF;
            l2 >>= 30;
            nArray2[i2 - 1] = (int)(l3 += (long)n5 * (long)n7 + (long)n6 * (long)n8) & 0x3FFFFFFF;
            l3 >>= 30;
        }
        nArray[n2 - 1] = (int)l2;
        nArray2[n2 - 1] = (int)l3;
    }
}

