/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.oracle.externals.org.bouncycastle.math.ec.custom.djb;

import java.math.BigInteger;
import java.security.SecureRandom;
import macromedia.jdbc.oracle.externals.org.bouncycastle.math.ec.AbstractECLookupTable;
import macromedia.jdbc.oracle.externals.org.bouncycastle.math.ec.ECConstants;
import macromedia.jdbc.oracle.externals.org.bouncycastle.math.ec.ECCurve;
import macromedia.jdbc.oracle.externals.org.bouncycastle.math.ec.ECFieldElement;
import macromedia.jdbc.oracle.externals.org.bouncycastle.math.ec.ECLookupTable;
import macromedia.jdbc.oracle.externals.org.bouncycastle.math.ec.ECPoint;
import macromedia.jdbc.oracle.externals.org.bouncycastle.math.ec.custom.djb.Curve25519Field;
import macromedia.jdbc.oracle.externals.org.bouncycastle.math.ec.custom.djb.Curve25519FieldElement;
import macromedia.jdbc.oracle.externals.org.bouncycastle.math.ec.custom.djb.Curve25519Point;
import macromedia.jdbc.oracle.externals.org.bouncycastle.math.raw.Nat256;
import macromedia.jdbc.oracle.externals.org.bouncycastle.util.encoders.Hex;

public class Curve25519
extends ECCurve.AbstractFp {
    public static final BigInteger q = Curve25519FieldElement.Q;
    private static final BigInteger C_a = new BigInteger(1, Hex.decodeStrict("2AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA984914A144"));
    private static final BigInteger C_b = new BigInteger(1, Hex.decodeStrict("7B425ED097B425ED097B425ED097B425ED097B425ED097B4260B5E9C7710C864"));
    private static final int CURVE25519_DEFAULT_COORDS = 4;
    private static final ECFieldElement[] CURVE25519_AFFINE_ZS = new ECFieldElement[]{new Curve25519FieldElement(ECConstants.ONE), new Curve25519FieldElement(C_a)};
    protected Curve25519Point infinity = new Curve25519Point(this, null, null);

    public Curve25519() {
        super(q);
        this.a = this.fromBigInteger(C_a);
        this.b = this.fromBigInteger(C_b);
        this.order = new BigInteger(1, Hex.decodeStrict("1000000000000000000000000000000014DEF9DEA2F79CD65812631A5CF5D3ED"));
        this.cofactor = BigInteger.valueOf(8L);
        this.coord = 4;
    }

    @Override
    protected ECCurve cloneCurve() {
        return new Curve25519();
    }

    @Override
    public boolean supportsCoordinateSystem(int n2) {
        switch (n2) {
            case 4: {
                return true;
            }
        }
        return false;
    }

    public BigInteger getQ() {
        return q;
    }

    @Override
    public int getFieldSize() {
        return q.bitLength();
    }

    @Override
    public ECFieldElement fromBigInteger(BigInteger bigInteger) {
        return new Curve25519FieldElement(bigInteger);
    }

    @Override
    protected ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2) {
        return new Curve25519Point(this, eCFieldElement, eCFieldElement2);
    }

    @Override
    protected ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, ECFieldElement[] eCFieldElementArray) {
        return new Curve25519Point(this, eCFieldElement, eCFieldElement2, eCFieldElementArray);
    }

    @Override
    public ECPoint getInfinity() {
        return this.infinity;
    }

    @Override
    public ECLookupTable createCacheSafeLookupTable(ECPoint[] eCPointArray, int n2, final int n3) {
        final int[] nArray = new int[n3 * 8 * 2];
        int n4 = 0;
        for (int i2 = 0; i2 < n3; ++i2) {
            ECPoint eCPoint = eCPointArray[n2 + i2];
            Nat256.copy(((Curve25519FieldElement)eCPoint.getRawXCoord()).x, 0, nArray, n4);
            Nat256.copy(((Curve25519FieldElement)eCPoint.getRawYCoord()).x, 0, nArray, n4 += 8);
            n4 += 8;
        }
        return new AbstractECLookupTable(){

            @Override
            public int getSize() {
                return n3;
            }

            @Override
            public ECPoint lookup(int n2) {
                int[] nArray3 = Nat256.create();
                int[] nArray2 = Nat256.create();
                int n32 = 0;
                for (int i2 = 0; i2 < n3; ++i2) {
                    int n4 = (i2 ^ n2) - 1 >> 31;
                    for (int i3 = 0; i3 < 8; ++i3) {
                        int n5 = i3;
                        nArray3[n5] = nArray3[n5] ^ nArray[n32 + i3] & n4;
                        int n6 = i3;
                        nArray2[n6] = nArray2[n6] ^ nArray[n32 + 8 + i3] & n4;
                    }
                    n32 += 16;
                }
                return this.createPoint(nArray3, nArray2);
            }

            @Override
            public ECPoint lookupVar(int n2) {
                int[] nArray3 = Nat256.create();
                int[] nArray2 = Nat256.create();
                int n32 = n2 * 8 * 2;
                for (int i2 = 0; i2 < 8; ++i2) {
                    nArray3[i2] = nArray[n32 + i2];
                    nArray2[i2] = nArray[n32 + 8 + i2];
                }
                return this.createPoint(nArray3, nArray2);
            }

            private ECPoint createPoint(int[] nArray3, int[] nArray2) {
                return Curve25519.this.createRawPoint(new Curve25519FieldElement(nArray3), new Curve25519FieldElement(nArray2), CURVE25519_AFFINE_ZS);
            }
        };
    }

    @Override
    public ECFieldElement randomFieldElement(SecureRandom secureRandom) {
        int[] nArray = Nat256.create();
        Curve25519Field.random(secureRandom, nArray);
        return new Curve25519FieldElement(nArray);
    }

    @Override
    public ECFieldElement randomFieldElementMult(SecureRandom secureRandom) {
        int[] nArray = Nat256.create();
        Curve25519Field.randomMult(secureRandom, nArray);
        return new Curve25519FieldElement(nArray);
    }
}

