/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.oracle.externals.org.bouncycastle.jcajce.provider.digest;

import macromedia.jdbc.oracle.externals.org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import macromedia.jdbc.oracle.externals.org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.CipherKeyGenerator;
import macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.digests.SHA256Digest;
import macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.macs.HMac;
import macromedia.jdbc.oracle.externals.org.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import macromedia.jdbc.oracle.externals.org.bouncycastle.jcajce.provider.digest.BCMessageDigest;
import macromedia.jdbc.oracle.externals.org.bouncycastle.jcajce.provider.digest.DigestAlgorithmProvider;
import macromedia.jdbc.oracle.externals.org.bouncycastle.jcajce.provider.symmetric.util.BaseKeyGenerator;
import macromedia.jdbc.oracle.externals.org.bouncycastle.jcajce.provider.symmetric.util.BaseMac;
import macromedia.jdbc.oracle.externals.org.bouncycastle.jcajce.provider.symmetric.util.PBESecretKeyFactory;

public class SHA256 {
    private SHA256() {
    }

    public static class Digest
    extends BCMessageDigest
    implements Cloneable {
        public Digest() {
            super(new SHA256Digest());
        }

        @Override
        public Object clone() throws CloneNotSupportedException {
            Digest digest = (Digest)super.clone();
            digest.digest = new SHA256Digest((SHA256Digest)this.digest);
            return digest;
        }
    }

    public static class HashMac
    extends BaseMac {
        public HashMac() {
            super(new HMac(new SHA256Digest()));
        }
    }

    public static class KeyGenerator
    extends BaseKeyGenerator {
        public KeyGenerator() {
            super("HMACSHA256", 256, new CipherKeyGenerator());
        }
    }

    public static class Mappings
    extends DigestAlgorithmProvider {
        private static final String PREFIX = SHA256.class.getName();

        @Override
        public void configure(ConfigurableProvider configurableProvider) {
            configurableProvider.addAlgorithm("MessageDigest.SHA-256", PREFIX + "$Digest");
            configurableProvider.addAlgorithm("Alg.Alias.MessageDigest.SHA256", "SHA-256");
            configurableProvider.addAlgorithm("Alg.Alias.MessageDigest." + NISTObjectIdentifiers.id_sha256, "SHA-256");
            configurableProvider.addAlgorithm("SecretKeyFactory.PBEWITHHMACSHA256", PREFIX + "$PBEWithMacKeyFactory");
            configurableProvider.addAlgorithm("Alg.Alias.SecretKeyFactory.PBEWITHHMACSHA-256", "PBEWITHHMACSHA256");
            configurableProvider.addAlgorithm("Alg.Alias.SecretKeyFactory." + NISTObjectIdentifiers.id_sha256, "PBEWITHHMACSHA256");
            configurableProvider.addAlgorithm("Mac.PBEWITHHMACSHA256", PREFIX + "$HashMac");
            this.addHMACAlgorithm(configurableProvider, "SHA256", PREFIX + "$HashMac", PREFIX + "$KeyGenerator");
            this.addHMACAlias(configurableProvider, "SHA256", PKCSObjectIdentifiers.id_hmacWithSHA256);
            this.addHMACAlias(configurableProvider, "SHA256", NISTObjectIdentifiers.id_sha256);
        }
    }

    public static class PBEWithMacKeyFactory
    extends PBESecretKeyFactory {
        public PBEWithMacKeyFactory() {
            super("PBEwithHmacSHA256", null, false, 2, 4, 256, 0);
        }
    }
}

