/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.modes;

import macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.BlockCipher;
import macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.CipherParameters;
import macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.DataLengthException;
import macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.OutputLengthException;
import macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.StreamBlockCipher;
import macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.params.ParametersWithIV;
import macromedia.jdbc.oracle.externals.org.bouncycastle.util.Arrays;

public class KCTRBlockCipher
extends StreamBlockCipher {
    private byte[] iv;
    private byte[] ofbV;
    private byte[] ofbOutV;
    private int byteCount;
    private boolean initialised;
    private BlockCipher engine;

    public KCTRBlockCipher(BlockCipher blockCipher) {
        super(blockCipher);
        this.engine = blockCipher;
        this.iv = new byte[blockCipher.getBlockSize()];
        this.ofbV = new byte[blockCipher.getBlockSize()];
        this.ofbOutV = new byte[blockCipher.getBlockSize()];
    }

    @Override
    public void init(boolean bl2, CipherParameters cipherParameters) throws IllegalArgumentException {
        this.initialised = true;
        if (!(cipherParameters instanceof ParametersWithIV)) {
            throw new IllegalArgumentException("invalid parameter passed");
        }
        ParametersWithIV parametersWithIV = (ParametersWithIV)cipherParameters;
        byte[] byArray = parametersWithIV.getIV();
        int n2 = this.iv.length - byArray.length;
        Arrays.fill(this.iv, (byte)0);
        System.arraycopy(byArray, 0, this.iv, n2, byArray.length);
        cipherParameters = parametersWithIV.getParameters();
        if (cipherParameters != null) {
            this.engine.init(true, cipherParameters);
        }
        this.reset();
    }

    @Override
    public String getAlgorithmName() {
        return this.engine.getAlgorithmName() + "/KCTR";
    }

    @Override
    public int getBlockSize() {
        return this.engine.getBlockSize();
    }

    @Override
    protected byte calculateByte(byte by2) {
        if (this.byteCount == 0) {
            this.incrementCounterAt(0);
            this.checkCounter();
            this.engine.processBlock(this.ofbV, 0, this.ofbOutV, 0);
            return (byte)(this.ofbOutV[this.byteCount++] ^ by2);
        }
        byte by3 = (byte)(this.ofbOutV[this.byteCount++] ^ by2);
        if (this.byteCount == this.ofbV.length) {
            this.byteCount = 0;
        }
        return by3;
    }

    @Override
    public int processBlock(byte[] byArray, int n2, byte[] byArray2, int n3) throws DataLengthException, IllegalStateException {
        if (byArray.length - n2 < this.getBlockSize()) {
            throw new DataLengthException("input buffer too short");
        }
        if (byArray2.length - n3 < this.getBlockSize()) {
            throw new OutputLengthException("output buffer too short");
        }
        this.processBytes(byArray, n2, this.getBlockSize(), byArray2, n3);
        return this.getBlockSize();
    }

    @Override
    public void reset() {
        if (this.initialised) {
            this.engine.processBlock(this.iv, 0, this.ofbV, 0);
        }
        this.engine.reset();
        this.byteCount = 0;
    }

    private void incrementCounterAt(int n2) {
        int n3 = n2;
        while (n3 < this.ofbV.length) {
            int n4 = n3++;
            this.ofbV[n4] = (byte)(this.ofbV[n4] + 1);
            if (this.ofbV[n4] == 0) continue;
            break;
        }
    }

    private void checkCounter() {
    }
}

