/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.fpe;

import java.math.BigInteger;
import macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.BlockCipher;
import macromedia.jdbc.oracle.externals.org.bouncycastle.util.Arrays;
import macromedia.jdbc.oracle.externals.org.bouncycastle.util.BigIntegers;
import macromedia.jdbc.oracle.externals.org.bouncycastle.util.Pack;

class SP80038G {
    static final String FPE_DISABLED = "org.bouncycastle.fpe.disable";
    static final String FF1_DISABLED = "org.bouncycastle.fpe.disable_ff1";
    protected static final int BLOCK_SIZE = 16;
    protected static final double LOG2 = Math.log(2.0);
    protected static final double TWO_TO_96 = Math.pow(2.0, 96.0);

    SP80038G() {
    }

    static byte[] decryptFF1(BlockCipher blockCipher, int n2, byte[] byArray, byte[] byArray2, int n3, int n4) {
        SP80038G.checkArgs(blockCipher, true, n2, byArray2, n3, n4);
        int n5 = n4;
        int n6 = n5 / 2;
        int n7 = n5 - n6;
        short[] sArray = SP80038G.toShort(byArray2, n3, n6);
        short[] sArray2 = SP80038G.toShort(byArray2, n3 + n6, n7);
        short[] sArray3 = SP80038G.decFF1(blockCipher, n2, byArray, n5, n6, n7, sArray, sArray2);
        return SP80038G.toByte(sArray3);
    }

    static short[] decryptFF1w(BlockCipher blockCipher, int n2, byte[] byArray, short[] sArray, int n3, int n4) {
        SP80038G.checkArgs(blockCipher, true, n2, sArray, n3, n4);
        int n5 = n4;
        int n6 = n5 / 2;
        int n7 = n5 - n6;
        short[] sArray2 = new short[n6];
        short[] sArray3 = new short[n7];
        System.arraycopy(sArray, n3, sArray2, 0, n6);
        System.arraycopy(sArray, n3 + n6, sArray3, 0, n7);
        return SP80038G.decFF1(blockCipher, n2, byArray, n5, n6, n7, sArray2, sArray3);
    }

    static short[] decFF1(BlockCipher blockCipher, int n2, byte[] byArray, int n3, int n4, int n5, short[] sArray, short[] sArray2) {
        int n6 = byArray.length;
        int n7 = ((int)Math.ceil(Math.log(n2) * (double)n5 / LOG2) + 7) / 8;
        int n8 = (n7 + 3) / 4 * 4 + 4;
        byte[] byArray2 = SP80038G.calculateP_FF1(n2, (byte)n4, n3, n6);
        BigInteger bigInteger = BigInteger.valueOf(n2);
        BigInteger[] bigIntegerArray = SP80038G.calculateModUV(bigInteger, n4, n5);
        int n9 = n4;
        for (int i2 = 9; i2 >= 0; --i2) {
            BigInteger bigInteger2 = SP80038G.calculateY_FF1(blockCipher, bigInteger, byArray, n7, n8, i2, byArray2, sArray);
            n9 = n3 - n9;
            BigInteger bigInteger3 = bigIntegerArray[i2 & 1];
            BigInteger bigInteger4 = SP80038G.num(bigInteger, sArray2).subtract(bigInteger2).mod(bigInteger3);
            short[] sArray3 = sArray2;
            sArray2 = sArray;
            sArray = sArray3;
            SP80038G.str(bigInteger, bigInteger4, n9, sArray3, 0);
        }
        return Arrays.concatenate(sArray, sArray2);
    }

    static byte[] decryptFF3(BlockCipher blockCipher, int n2, byte[] byArray, byte[] byArray2, int n3, int n4) {
        SP80038G.checkArgs(blockCipher, false, n2, byArray2, n3, n4);
        if (byArray.length != 8) {
            throw new IllegalArgumentException();
        }
        return SP80038G.implDecryptFF3(blockCipher, n2, byArray, byArray2, n3, n4);
    }

    static byte[] decryptFF3_1(BlockCipher blockCipher, int n2, byte[] byArray, byte[] byArray2, int n3, int n4) {
        SP80038G.checkArgs(blockCipher, false, n2, byArray2, n3, n4);
        if (byArray.length != 7) {
            throw new IllegalArgumentException("tweak should be 56 bits");
        }
        byte[] byArray3 = SP80038G.calculateTweak64_FF3_1(byArray);
        return SP80038G.implDecryptFF3(blockCipher, n2, byArray3, byArray2, n3, n4);
    }

    static short[] decryptFF3_1w(BlockCipher blockCipher, int n2, byte[] byArray, short[] sArray, int n3, int n4) {
        SP80038G.checkArgs(blockCipher, false, n2, sArray, n3, n4);
        if (byArray.length != 7) {
            throw new IllegalArgumentException("tweak should be 56 bits");
        }
        byte[] byArray2 = SP80038G.calculateTweak64_FF3_1(byArray);
        return SP80038G.implDecryptFF3w(blockCipher, n2, byArray2, sArray, n3, n4);
    }

    static byte[] encryptFF1(BlockCipher blockCipher, int n2, byte[] byArray, byte[] byArray2, int n3, int n4) {
        SP80038G.checkArgs(blockCipher, true, n2, byArray2, n3, n4);
        int n5 = n4;
        int n6 = n5 / 2;
        int n7 = n5 - n6;
        short[] sArray = SP80038G.toShort(byArray2, n3, n6);
        short[] sArray2 = SP80038G.toShort(byArray2, n3 + n6, n7);
        return SP80038G.toByte(SP80038G.encFF1(blockCipher, n2, byArray, n5, n6, n7, sArray, sArray2));
    }

    static short[] encryptFF1w(BlockCipher blockCipher, int n2, byte[] byArray, short[] sArray, int n3, int n4) {
        SP80038G.checkArgs(blockCipher, true, n2, sArray, n3, n4);
        int n5 = n4;
        int n6 = n5 / 2;
        int n7 = n5 - n6;
        short[] sArray2 = new short[n6];
        short[] sArray3 = new short[n7];
        System.arraycopy(sArray, n3, sArray2, 0, n6);
        System.arraycopy(sArray, n3 + n6, sArray3, 0, n7);
        return SP80038G.encFF1(blockCipher, n2, byArray, n5, n6, n7, sArray2, sArray3);
    }

    private static short[] encFF1(BlockCipher blockCipher, int n2, byte[] byArray, int n3, int n4, int n5, short[] sArray, short[] sArray2) {
        int n6 = byArray.length;
        int n7 = ((int)Math.ceil(Math.log(n2) * (double)n5 / LOG2) + 7) / 8;
        int n8 = (n7 + 3) / 4 * 4 + 4;
        byte[] byArray2 = SP80038G.calculateP_FF1(n2, (byte)n4, n3, n6);
        BigInteger bigInteger = BigInteger.valueOf(n2);
        BigInteger[] bigIntegerArray = SP80038G.calculateModUV(bigInteger, n4, n5);
        int n9 = n5;
        for (int i2 = 0; i2 < 10; ++i2) {
            BigInteger bigInteger2 = SP80038G.calculateY_FF1(blockCipher, bigInteger, byArray, n7, n8, i2, byArray2, sArray2);
            n9 = n3 - n9;
            BigInteger bigInteger3 = bigIntegerArray[i2 & 1];
            BigInteger bigInteger4 = SP80038G.num(bigInteger, sArray).add(bigInteger2).mod(bigInteger3);
            short[] sArray3 = sArray;
            sArray = sArray2;
            sArray2 = sArray3;
            SP80038G.str(bigInteger, bigInteger4, n9, sArray3, 0);
        }
        return Arrays.concatenate(sArray, sArray2);
    }

    static byte[] encryptFF3(BlockCipher blockCipher, int n2, byte[] byArray, byte[] byArray2, int n3, int n4) {
        SP80038G.checkArgs(blockCipher, false, n2, byArray2, n3, n4);
        if (byArray.length != 8) {
            throw new IllegalArgumentException();
        }
        return SP80038G.implEncryptFF3(blockCipher, n2, byArray, byArray2, n3, n4);
    }

    static short[] encryptFF3w(BlockCipher blockCipher, int n2, byte[] byArray, short[] sArray, int n3, int n4) {
        SP80038G.checkArgs(blockCipher, false, n2, sArray, n3, n4);
        if (byArray.length != 8) {
            throw new IllegalArgumentException();
        }
        return SP80038G.implEncryptFF3w(blockCipher, n2, byArray, sArray, n3, n4);
    }

    static short[] encryptFF3_1w(BlockCipher blockCipher, int n2, byte[] byArray, short[] sArray, int n3, int n4) {
        SP80038G.checkArgs(blockCipher, false, n2, sArray, n3, n4);
        if (byArray.length != 7) {
            throw new IllegalArgumentException("tweak should be 56 bits");
        }
        byte[] byArray2 = SP80038G.calculateTweak64_FF3_1(byArray);
        return SP80038G.encryptFF3w(blockCipher, n2, byArray2, sArray, n3, n4);
    }

    static byte[] encryptFF3_1(BlockCipher blockCipher, int n2, byte[] byArray, byte[] byArray2, int n3, int n4) {
        SP80038G.checkArgs(blockCipher, false, n2, byArray2, n3, n4);
        if (byArray.length != 7) {
            throw new IllegalArgumentException("tweak should be 56 bits");
        }
        byte[] byArray3 = SP80038G.calculateTweak64_FF3_1(byArray);
        return SP80038G.encryptFF3(blockCipher, n2, byArray3, byArray2, n3, n4);
    }

    protected static BigInteger[] calculateModUV(BigInteger bigInteger, int n2, int n3) {
        BigInteger[] bigIntegerArray;
        bigIntegerArray = new BigInteger[]{bigInteger.pow(n2), bigIntegerArray[0]};
        if (n3 != n2) {
            bigIntegerArray[1] = bigIntegerArray[1].multiply(bigInteger);
        }
        return bigIntegerArray;
    }

    protected static byte[] calculateP_FF1(int n2, byte by2, int n3, int n4) {
        byte[] byArray = new byte[16];
        byArray[0] = 1;
        byArray[1] = 2;
        byArray[2] = 1;
        byArray[3] = 0;
        byArray[4] = (byte)(n2 >> 8);
        byArray[5] = (byte)n2;
        byArray[6] = 10;
        byArray[7] = by2;
        Pack.intToBigEndian(n3, byArray, 8);
        Pack.intToBigEndian(n4, byArray, 12);
        return byArray;
    }

    protected static byte[] calculateTweak64_FF3_1(byte[] byArray) {
        byte[] byArray2 = new byte[]{byArray[0], byArray[1], byArray[2], (byte)(byArray[3] & 0xF0), byArray[4], byArray[5], byArray[6], (byte)(byArray[3] << 4)};
        return byArray2;
    }

    protected static BigInteger calculateY_FF1(BlockCipher blockCipher, BigInteger bigInteger, byte[] byArray, int n2, int n3, int n4, byte[] byArray2, short[] sArray) {
        byte[] byArray3;
        int n5 = byArray.length;
        BigInteger bigInteger2 = SP80038G.num(bigInteger, sArray);
        byte[] byArray4 = BigIntegers.asUnsignedByteArray(bigInteger2);
        int n6 = -(n5 + n2 + 1) & 0xF;
        byte[] byArray5 = new byte[n5 + n6 + 1 + n2];
        System.arraycopy(byArray, 0, byArray5, 0, n5);
        byArray5[n5 + n6] = (byte)n4;
        System.arraycopy(byArray4, 0, byArray5, byArray5.length - byArray4.length, byArray4.length);
        byte[] byArray6 = byArray3 = SP80038G.prf(blockCipher, Arrays.concatenate(byArray2, byArray5));
        if (n3 > 16) {
            int n7 = (n3 + 16 - 1) / 16;
            byArray6 = new byte[n7 * 16];
            System.arraycopy(byArray3, 0, byArray6, 0, 16);
            byte[] byArray7 = new byte[4];
            for (int i2 = 1; i2 < n7; ++i2) {
                int n8 = i2 * 16;
                System.arraycopy(byArray3, 0, byArray6, n8, 16);
                Pack.intToBigEndian(i2, byArray7, 0);
                SP80038G.xor(byArray7, 0, byArray6, n8 + 16 - 4, 4);
                blockCipher.processBlock(byArray6, n8, byArray6, n8);
            }
        }
        return SP80038G.num(byArray6, 0, n3);
    }

    protected static BigInteger calculateY_FF3(BlockCipher blockCipher, BigInteger bigInteger, byte[] byArray, int n2, int n3, short[] sArray) {
        byte[] byArray2 = new byte[16];
        Pack.intToBigEndian(n3, byArray2, 0);
        SP80038G.xor(byArray, n2, byArray2, 0, 4);
        BigInteger bigInteger2 = SP80038G.num(bigInteger, sArray);
        byte[] byArray3 = BigIntegers.asUnsignedByteArray(bigInteger2);
        if (byArray2.length - byArray3.length < 4) {
            throw new IllegalStateException("input out of range");
        }
        System.arraycopy(byArray3, 0, byArray2, byArray2.length - byArray3.length, byArray3.length);
        SP80038G.rev(byArray2);
        blockCipher.processBlock(byArray2, 0, byArray2, 0);
        SP80038G.rev(byArray2);
        byte[] byArray4 = byArray2;
        return SP80038G.num(byArray4, 0, byArray4.length);
    }

    protected static void checkArgs(BlockCipher blockCipher, boolean bl2, int n2, short[] sArray, int n3, int n4) {
        SP80038G.checkCipher(blockCipher);
        if (n2 < 2 || n2 > 65536) {
            throw new IllegalArgumentException();
        }
        SP80038G.checkData(bl2, n2, sArray, n3, n4);
    }

    protected static void checkArgs(BlockCipher blockCipher, boolean bl2, int n2, byte[] byArray, int n3, int n4) {
        SP80038G.checkCipher(blockCipher);
        if (n2 < 2 || n2 > 256) {
            throw new IllegalArgumentException();
        }
        SP80038G.checkData(bl2, n2, byArray, n3, n4);
    }

    protected static void checkCipher(BlockCipher blockCipher) {
        if (16 != blockCipher.getBlockSize()) {
            throw new IllegalArgumentException();
        }
    }

    protected static void checkData(boolean bl2, int n2, short[] sArray, int n3, int n4) {
        SP80038G.checkLength(bl2, n2, n4);
        for (int i2 = 0; i2 < n4; ++i2) {
            int n5 = sArray[n3 + i2] & 0xFFFF;
            if (n5 < n2) continue;
            throw new IllegalArgumentException("input data outside of radix");
        }
    }

    protected static void checkData(boolean bl2, int n2, byte[] byArray, int n3, int n4) {
        SP80038G.checkLength(bl2, n2, n4);
        for (int i2 = 0; i2 < n4; ++i2) {
            int n5 = byArray[n3 + i2] & 0xFF;
            if (n5 < n2) continue;
            throw new IllegalArgumentException("input data outside of radix");
        }
    }

    private static void checkLength(boolean bl2, int n2, int n3) {
        int n4;
        if (n3 < 2 || Math.pow(n2, n3) < 1000000.0) {
            throw new IllegalArgumentException("input too short");
        }
        if (!bl2 && n3 > (n4 = 2 * (int)Math.floor(Math.log(TWO_TO_96) / Math.log(n2)))) {
            throw new IllegalArgumentException("maximum input length is " + n4);
        }
    }

    protected static byte[] implDecryptFF3(BlockCipher blockCipher, int n2, byte[] byArray, byte[] byArray2, int n3, int n4) {
        byte[] byArray3 = byArray;
        int n5 = n4;
        int n6 = n5 / 2;
        int n7 = n5 - n6;
        short[] sArray = SP80038G.toShort(byArray2, n3, n7);
        short[] sArray2 = SP80038G.toShort(byArray2, n3 + n7, n6);
        short[] sArray3 = SP80038G.decFF3_1(blockCipher, n2, byArray3, n5, n6, n7, sArray, sArray2);
        return SP80038G.toByte(sArray3);
    }

    protected static short[] implDecryptFF3w(BlockCipher blockCipher, int n2, byte[] byArray, short[] sArray, int n3, int n4) {
        byte[] byArray2 = byArray;
        int n5 = n4;
        int n6 = n5 / 2;
        int n7 = n5 - n6;
        short[] sArray2 = new short[n7];
        short[] sArray3 = new short[n6];
        System.arraycopy(sArray, n3, sArray2, 0, n7);
        System.arraycopy(sArray, n3 + n7, sArray3, 0, n6);
        return SP80038G.decFF3_1(blockCipher, n2, byArray2, n5, n6, n7, sArray2, sArray3);
    }

    private static short[] decFF3_1(BlockCipher blockCipher, int n2, byte[] byArray, int n3, int n4, int n5, short[] sArray, short[] sArray2) {
        BigInteger bigInteger = BigInteger.valueOf(n2);
        BigInteger[] bigIntegerArray = SP80038G.calculateModUV(bigInteger, n4, n5);
        int n6 = n5;
        SP80038G.rev(sArray);
        SP80038G.rev(sArray2);
        for (int i2 = 7; i2 >= 0; --i2) {
            n6 = n3 - n6;
            BigInteger bigInteger2 = bigIntegerArray[1 - (i2 & 1)];
            int n7 = 4 - (i2 & 1) * 4;
            BigInteger bigInteger3 = SP80038G.calculateY_FF3(blockCipher, bigInteger, byArray, n7, i2, sArray);
            BigInteger bigInteger4 = SP80038G.num(bigInteger, sArray2).subtract(bigInteger3).mod(bigInteger2);
            short[] sArray3 = sArray2;
            sArray2 = sArray;
            sArray = sArray3;
            SP80038G.str(bigInteger, bigInteger4, n6, sArray3, 0);
        }
        SP80038G.rev(sArray);
        SP80038G.rev(sArray2);
        return Arrays.concatenate(sArray, sArray2);
    }

    protected static byte[] implEncryptFF3(BlockCipher blockCipher, int n2, byte[] byArray, byte[] byArray2, int n3, int n4) {
        byte[] byArray3 = byArray;
        int n5 = n4;
        int n6 = n5 / 2;
        int n7 = n5 - n6;
        short[] sArray = SP80038G.toShort(byArray2, n3, n7);
        short[] sArray2 = SP80038G.toShort(byArray2, n3 + n7, n6);
        short[] sArray3 = SP80038G.encFF3_1(blockCipher, n2, byArray3, n5, n6, n7, sArray, sArray2);
        return SP80038G.toByte(sArray3);
    }

    protected static short[] implEncryptFF3w(BlockCipher blockCipher, int n2, byte[] byArray, short[] sArray, int n3, int n4) {
        byte[] byArray2 = byArray;
        int n5 = n4;
        int n6 = n5 / 2;
        int n7 = n5 - n6;
        short[] sArray2 = new short[n7];
        short[] sArray3 = new short[n6];
        System.arraycopy(sArray, n3, sArray2, 0, n7);
        System.arraycopy(sArray, n3 + n7, sArray3, 0, n6);
        return SP80038G.encFF3_1(blockCipher, n2, byArray2, n5, n6, n7, sArray2, sArray3);
    }

    private static short[] encFF3_1(BlockCipher blockCipher, int n2, byte[] byArray, int n3, int n4, int n5, short[] sArray, short[] sArray2) {
        BigInteger bigInteger = BigInteger.valueOf(n2);
        BigInteger[] bigIntegerArray = SP80038G.calculateModUV(bigInteger, n4, n5);
        int n6 = n4;
        SP80038G.rev(sArray);
        SP80038G.rev(sArray2);
        for (int i2 = 0; i2 < 8; ++i2) {
            n6 = n3 - n6;
            BigInteger bigInteger2 = bigIntegerArray[1 - (i2 & 1)];
            int n7 = 4 - (i2 & 1) * 4;
            BigInteger bigInteger3 = SP80038G.calculateY_FF3(blockCipher, bigInteger, byArray, n7, i2, sArray2);
            BigInteger bigInteger4 = SP80038G.num(bigInteger, sArray).add(bigInteger3).mod(bigInteger2);
            short[] sArray3 = sArray;
            sArray = sArray2;
            sArray2 = sArray3;
            SP80038G.str(bigInteger, bigInteger4, n6, sArray3, 0);
        }
        SP80038G.rev(sArray);
        SP80038G.rev(sArray2);
        return Arrays.concatenate(sArray, sArray2);
    }

    protected static BigInteger num(byte[] byArray, int n2, int n3) {
        return new BigInteger(1, Arrays.copyOfRange(byArray, n2, n2 + n3));
    }

    protected static BigInteger num(BigInteger bigInteger, short[] sArray) {
        BigInteger bigInteger2 = BigIntegers.ZERO;
        for (int i2 = 0; i2 < sArray.length; ++i2) {
            bigInteger2 = bigInteger2.multiply(bigInteger).add(BigInteger.valueOf(sArray[i2] & 0xFFFF));
        }
        return bigInteger2;
    }

    protected static byte[] prf(BlockCipher blockCipher, byte[] byArray) {
        if (byArray.length % 16 != 0) {
            throw new IllegalArgumentException();
        }
        int n2 = byArray.length / 16;
        byte[] byArray2 = new byte[16];
        for (int i2 = 0; i2 < n2; ++i2) {
            SP80038G.xor(byArray, i2 * 16, byArray2, 0, 16);
            blockCipher.processBlock(byArray2, 0, byArray2, 0);
        }
        return byArray2;
    }

    protected static void rev(byte[] byArray) {
        int n2 = byArray.length / 2;
        int n3 = byArray.length - 1;
        for (int i2 = 0; i2 < n2; ++i2) {
            byte by2 = byArray[i2];
            byArray[i2] = byArray[n3 - i2];
            byArray[n3 - i2] = by2;
        }
    }

    protected static void rev(short[] sArray) {
        int n2 = sArray.length / 2;
        int n3 = sArray.length - 1;
        for (int i2 = 0; i2 < n2; ++i2) {
            short s2 = sArray[i2];
            sArray[i2] = sArray[n3 - i2];
            sArray[n3 - i2] = s2;
        }
    }

    protected static void str(BigInteger bigInteger, BigInteger bigInteger2, int n2, short[] sArray, int n3) {
        if (bigInteger2.signum() < 0) {
            throw new IllegalArgumentException();
        }
        for (int i2 = 1; i2 <= n2; ++i2) {
            BigInteger[] bigIntegerArray = bigInteger2.divideAndRemainder(bigInteger);
            sArray[n3 + n2 - i2] = (short)bigIntegerArray[1].intValue();
            bigInteger2 = bigIntegerArray[0];
        }
        if (bigInteger2.signum() != 0) {
            throw new IllegalArgumentException();
        }
    }

    protected static void xor(byte[] byArray, int n2, byte[] byArray2, int n3, int n4) {
        for (int i2 = 0; i2 < n4; ++i2) {
            int n5 = n3 + i2;
            byArray2[n5] = (byte)(byArray2[n5] ^ byArray[n2 + i2]);
        }
    }

    private static byte[] toByte(short[] sArray) {
        byte[] byArray = new byte[sArray.length];
        for (int i2 = 0; i2 != byArray.length; ++i2) {
            byArray[i2] = (byte)sArray[i2];
        }
        return byArray;
    }

    private static short[] toShort(byte[] byArray, int n2, int n3) {
        short[] sArray = new short[n3];
        for (int i2 = 0; i2 != sArray.length; ++i2) {
            sArray[i2] = (short)(byArray[n2 + i2] & 0xFF);
        }
        return sArray;
    }
}

