/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.rx3;

import com.apollographql.apollo.ApolloCall;
import com.apollographql.apollo.ApolloPrefetch;
import com.apollographql.apollo.ApolloQueryWatcher;
import com.apollographql.apollo.ApolloSubscriptionCall;
import com.apollographql.apollo.api.Response;
import com.apollographql.apollo.api.internal.Utils;
import com.apollographql.apollo.cache.normalized.ApolloStoreOperation;
import com.apollographql.apollo.exception.ApolloException;
import com.apollographql.apollo.internal.subscription.ApolloSubscriptionTerminatedException;
import com.apollographql.apollo.internal.util.Cancelable;
import io.reactivex.rxjava3.annotations.CheckReturnValue;
import io.reactivex.rxjava3.core.BackpressureStrategy;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableEmitter;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.FlowableEmitter;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.ObservableEmitter;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.Exceptions;
import org.jetbrains.annotations.NotNull;

public class Rx3Apollo {
    private Rx3Apollo() {
        throw new AssertionError((Object)"This class cannot be instantiated");
    }

    @CheckReturnValue
    @NotNull
    public static <T> Observable<Response<T>> from(@NotNull ApolloQueryWatcher<T> watcher) {
        Utils.checkNotNull(watcher, "watcher == null");
        return Observable.create(emitter -> {
            ApolloQueryWatcher clone = watcher.clone();
            Rx3Apollo.cancelOnObservableDisposed(emitter, clone);
            clone.enqueueAndWatch(new ApolloCall.Callback<T>(){

                @Override
                public void onResponse(@NotNull Response<T> response) {
                    if (!emitter.isDisposed()) {
                        emitter.onNext(response);
                    }
                }

                @Override
                public void onFailure(@NotNull ApolloException e) {
                    Exceptions.throwIfFatal(e);
                    if (!emitter.isDisposed()) {
                        emitter.onError(e);
                    }
                }
            });
        });
    }

    @CheckReturnValue
    @NotNull
    public static <T> Observable<Response<T>> from(@NotNull ApolloCall<T> call) {
        Utils.checkNotNull(call, "call == null");
        return Observable.create(emitter -> {
            ApolloCall clone = call.toBuilder().build();
            Rx3Apollo.cancelOnObservableDisposed(emitter, clone);
            clone.enqueue(new ApolloCall.Callback<T>(){

                @Override
                public void onResponse(@NotNull Response<T> response) {
                    if (!emitter.isDisposed()) {
                        emitter.onNext(response);
                    }
                }

                @Override
                public void onFailure(@NotNull ApolloException e) {
                    Exceptions.throwIfFatal(e);
                    if (!emitter.isDisposed()) {
                        emitter.onError(e);
                    }
                }

                @Override
                public void onStatusEvent(@NotNull ApolloCall.StatusEvent event) {
                    if (event == ApolloCall.StatusEvent.COMPLETED && !emitter.isDisposed()) {
                        emitter.onComplete();
                    }
                }
            });
        });
    }

    @CheckReturnValue
    @NotNull
    public static Completable from(@NotNull ApolloPrefetch prefetch) {
        Utils.checkNotNull(prefetch, "prefetch == null");
        return Completable.create(emitter -> {
            ApolloPrefetch clone = prefetch.clone();
            Rx3Apollo.cancelOnCompletableDisposed(emitter, clone);
            clone.enqueue(new ApolloPrefetch.Callback(){

                @Override
                public void onSuccess() {
                    if (!emitter.isDisposed()) {
                        emitter.onComplete();
                    }
                }

                @Override
                public void onFailure(@NotNull ApolloException e) {
                    Exceptions.throwIfFatal(e);
                    if (!emitter.isDisposed()) {
                        emitter.onError(e);
                    }
                }
            });
        });
    }

    @CheckReturnValue
    @NotNull
    public static <T> Flowable<Response<T>> from(@NotNull ApolloSubscriptionCall<T> call) {
        return Rx3Apollo.from(call, BackpressureStrategy.LATEST);
    }

    @CheckReturnValue
    @NotNull
    public static <T> Flowable<Response<T>> from(@NotNull ApolloSubscriptionCall<T> call, @NotNull BackpressureStrategy backpressureStrategy) {
        Utils.checkNotNull(call, "originalCall == null");
        Utils.checkNotNull(backpressureStrategy, "backpressureStrategy == null");
        return Flowable.create(emitter -> {
            ApolloSubscriptionCall clone = call.clone();
            Rx3Apollo.cancelOnFlowableDisposed(emitter, clone);
            clone.execute(new ApolloSubscriptionCall.Callback<T>(){

                @Override
                public void onResponse(@NotNull Response<T> response) {
                    if (!emitter.isCancelled()) {
                        emitter.onNext(response);
                    }
                }

                @Override
                public void onFailure(@NotNull ApolloException e) {
                    Exceptions.throwIfFatal(e);
                    if (!emitter.isCancelled()) {
                        emitter.onError(e);
                    }
                }

                @Override
                public void onCompleted() {
                    if (!emitter.isCancelled()) {
                        emitter.onComplete();
                    }
                }

                @Override
                public void onTerminated() {
                    this.onFailure(new ApolloSubscriptionTerminatedException("Subscription server unexpectedly terminated connection"));
                }

                @Override
                public void onConnected() {
                }
            });
        }, backpressureStrategy);
    }

    @CheckReturnValue
    @NotNull
    public static <T> Single<T> from(@NotNull ApolloStoreOperation<T> operation) {
        Utils.checkNotNull(operation, "operation == null");
        return Single.create(emitter -> operation.enqueue(new ApolloStoreOperation.Callback<T>(){

            @Override
            public void onSuccess(T result) {
                if (!emitter.isDisposed()) {
                    emitter.onSuccess(result);
                }
            }

            @Override
            public void onFailure(@NotNull Throwable t) {
                if (!emitter.isDisposed()) {
                    emitter.onError(t);
                }
            }
        }));
    }

    private static void cancelOnCompletableDisposed(CompletableEmitter emitter, Cancelable cancelable) {
        emitter.setDisposable(Rx3Apollo.getRx3Disposable(cancelable));
    }

    private static <T> void cancelOnObservableDisposed(ObservableEmitter<T> emitter, Cancelable cancelable) {
        emitter.setDisposable(Rx3Apollo.getRx3Disposable(cancelable));
    }

    private static <T> void cancelOnFlowableDisposed(FlowableEmitter<T> emitter, Cancelable cancelable) {
        emitter.setDisposable(Rx3Apollo.getRx3Disposable(cancelable));
    }

    private static Disposable getRx3Disposable(final Cancelable cancelable) {
        return new Disposable(){

            @Override
            public void dispose() {
                cancelable.cancel();
            }

            @Override
            public boolean isDisposed() {
                return cancelable.isCanceled();
            }
        };
    }
}

