/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.net.exchange;

import coldfusion.exchange.ExchangeFolderExtendedInfo;
import coldfusion.exchange.FolderPermissionInfo;
import coldfusion.exchange.FolderPermissionLevel;
import coldfusion.exchange.FolderPermissionReadAccess;
import coldfusion.exchange.ManagedFolderInfo;
import coldfusion.exchange.PermissionScope;
import coldfusion.exchange.StandardUser;
import coldfusion.exchange.UserIdInfo;
import coldfusion.runtime.Struct;
import coldfusion.sql.QueryTable;
import coldfusion.tagext.net.exchange.ConnectionConstants;
import coldfusion.tagext.net.exchange.ExchangeFolderExtendedInfoQueryMetaData;
import coldfusion.util.CaseInsensitiveMap;
import coldfusion.util.Key;
import java.util.ArrayList;
import java.util.List;

public class ExchangeFolderExtendedInfoQuery
extends QueryTable
implements ConnectionConstants {
    public void populate(ArrayList resultArray) {
        this.meta = new ExchangeFolderExtendedInfoQueryMetaData();
        this.col_count = this.meta.getColumnCount();
        this.col_names = this.meta.getColumnLabels();
        if (resultArray == null || resultArray.size() == 0) {
            this.row_count = 0;
            return;
        }
        this.ensureCapacity(resultArray.size());
        for (ExchangeFolderExtendedInfo folder : resultArray) {
            List<FolderPermissionInfo> permissions;
            Object[] colData = new Object[this.col_count];
            colData[0] = folder.getDisplayName();
            colData[1] = folder.getFolderClass();
            colData[2] = folder.getChildFolderCount();
            colData[3] = folder.getTotalCount();
            colData[4] = folder.getUnreadCount();
            colData[5] = folder.getId();
            colData[6] = folder.getParentFolderId();
            ManagedFolderInfo managedFolderInformation = folder.getManagedFolderInformation();
            if (null != managedFolderInformation) {
                Struct managedFolderInformationStruct = new Struct();
                managedFolderInformationStruct.put((Object)"CanDelete", (Object)managedFolderInformation.getCanDelete());
                managedFolderInformationStruct.put((Object)"CanRenameOrMove", (Object)managedFolderInformation.getCanRenameOrMove());
                managedFolderInformationStruct.put((Object)"MustDisplayComment", (Object)managedFolderInformation.getMustDisplayComment());
                managedFolderInformationStruct.put((Object)"HasQuota", (Object)managedFolderInformation.getHasQuota());
                managedFolderInformationStruct.put((Object)"IsManagedFoldersRoot", (Object)managedFolderInformation.getIsManagedFoldersRoot());
                managedFolderInformationStruct.put((Object)"ManagedFolderId", (Object)managedFolderInformation.getManagedFolderId());
                managedFolderInformationStruct.put((Object)"Comment", (Object)managedFolderInformation.getComment());
                managedFolderInformationStruct.put((Object)"StorageQuota", (Object)managedFolderInformation.getStorageQuota());
                managedFolderInformationStruct.put((Object)"FolderSize", (Object)managedFolderInformation.getFolderSize());
                managedFolderInformationStruct.put((Object)"HomePage", (Object)managedFolderInformation.getHomePage());
                colData[7] = managedFolderInformationStruct;
            }
            if (null != (permissions = folder.getPermissions())) {
                ArrayList<CaseInsensitiveMap> list = new ArrayList<CaseInsensitiveMap>();
                for (FolderPermissionInfo folderPermissionInfo : permissions) {
                    list.add(this.createStructMap(folderPermissionInfo));
                }
                colData[8] = list;
            }
            colData[9] = folder.getFolderPath();
            this.addRow(colData);
        }
    }

    private CaseInsensitiveMap createStructMap(FolderPermissionInfo folderPermissionInfo) {
        UserIdInfo userId;
        FolderPermissionReadAccess readItems;
        PermissionScope editItems;
        FolderPermissionLevel displayPermissionLevel;
        CaseInsensitiveMap map = new CaseInsensitiveMap();
        map.put(Key.getInstance((String)"CanCreateItems"), (Object)folderPermissionInfo.getCanCreateItems());
        map.put(Key.getInstance((String)"CanCreateSubFolders"), (Object)folderPermissionInfo.getCanCreateSubFolders());
        PermissionScope deleteItems = folderPermissionInfo.getDeleteItems();
        if (null != deleteItems) {
            map.put(Key.getInstance((String)"DeleteItems"), (Object)deleteItems.toString());
        }
        if (null != (displayPermissionLevel = folderPermissionInfo.getDisplayPermissionLevel())) {
            map.put(Key.getInstance((String)"DisplayPermissionLevel"), (Object)displayPermissionLevel.toString());
        }
        if (null != (editItems = folderPermissionInfo.getEditItems())) {
            map.put(Key.getInstance((String)"EditItems"), (Object)editItems.toString());
        }
        map.put(Key.getInstance((String)"IsFolderContact"), (Object)folderPermissionInfo.getIsFolderContact());
        map.put(Key.getInstance((String)"IsFolderOwner"), (Object)folderPermissionInfo.getIsFolderOwner());
        map.put(Key.getInstance((String)"IsFolderVisible"), (Object)folderPermissionInfo.getIsFolderVisible());
        FolderPermissionLevel permissionLevel = folderPermissionInfo.getPermissionLevel();
        if (null != permissionLevel) {
            map.put(Key.getInstance((String)"PermissionLevel"), (Object)permissionLevel.toString());
        }
        if (null != (readItems = folderPermissionInfo.getReadItems())) {
            map.put(Key.getInstance((String)"ReadItems"), (Object)readItems.toString());
        }
        if (null != (userId = folderPermissionInfo.getUserId())) {
            map.put(Key.getInstance((String)"UserIdDisplayName"), (Object)userId.getDisplayName());
            map.put(Key.getInstance((String)"UserIdPrimarySmtpAddress"), (Object)userId.getPrimarySmtpAddress());
            map.put(Key.getInstance((String)"UserIdSID"), (Object)userId.getSID());
            StandardUser standardUser = userId.getstandardUser();
            if (null != standardUser) {
                map.put(Key.getInstance((String)"UserIdStandardUser"), (Object)standardUser.toString());
            }
        }
        return map;
    }
}

