/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.orm.hibernate;

import coldfusion.cfc.ComponentProxyFactory;
import coldfusion.filter.FusionContext;
import coldfusion.orm.EntityMappingNotFoundException;
import coldfusion.orm.ORMProvider;
import coldfusion.orm.ORMSettings;
import coldfusion.orm.ORMUtils;
import coldfusion.orm.PersistenceManager;
import coldfusion.orm.PersistentTemplateProxy;
import coldfusion.orm.hibernate.CFCMetadataImpl;
import coldfusion.orm.hibernate.CriteriaBuilder;
import coldfusion.orm.hibernate.HibernateConfiguration;
import coldfusion.orm.hibernate.HibernateSessionException;
import coldfusion.orm.hibernate.HibernateSessionManager;
import coldfusion.orm.hibernate.SessionWrapper;
import coldfusion.runtime.AbortException;
import coldfusion.runtime.ApplicationException;
import coldfusion.runtime.Cast;
import coldfusion.runtime.EventListeners;
import coldfusion.runtime.NeoException;
import coldfusion.runtime.NeoPageContext;
import coldfusion.runtime.RequestEventListener;
import coldfusion.runtime.TemplateProxy;
import coldfusion.runtime.TransactionEventListener;
import coldfusion.runtime.UDFMethod;
import coldfusion.server.ORMSearchService;
import coldfusion.server.ServiceFactory;
import coldfusion.tagext.sql.TransactionTag;
import coldfusion.thread.CFThreadEventListener;
import coldfusion.util.RuntimeWrapper;
import java.io.FilePermission;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.jsp.PageContext;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.JDBCException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Example;
import org.hibernate.engine.query.spi.HQLQueryPlan;
import org.hibernate.internal.SessionFactoryImpl;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.query.Query;
import org.hibernate.query.internal.ParameterMetadataImpl;
import org.hibernate.type.Type;

public class HibernatePersistenceManager
implements PersistenceManager {
    public static final String MAX_RESULTS = "maxResults";
    public static final String OFFSET = "offset";
    public static final String READ_ONLY = "readonly";
    public static final String CACHEABLE = "cacheable";
    public static final String TIMEOUT = "timeout";
    public static final String IGNORECASE = "ignorecase";
    public static final String CACHE_REGION = "cachename";
    private static final int SAVE = 0;
    private static final int UPDATE = 1;
    private static final int SAVEUPDATE = 2;
    private static final Object[] noArgs = new Object[0];
    private static final boolean IS_JVM_SECURITY_ENABLED = System.getSecurityManager() != null;
    private static final FilePermission ALL_FILES_PERMISSION = new FilePermission("<<ALL FILES>>", "read,write,delete");
    private HibernateConfiguration config;
    private HibernateSessionManager sessionManager = HibernateSessionManager.getInstance();

    public HibernatePersistenceManager(HibernateConfiguration config) {
        this.config = config;
    }

    @Override
    public void save(Object obj) {
        this.save(obj, false);
    }

    @Override
    public void save(Object obj, boolean insert) {
        if (insert) {
            this.save(obj, 0);
        } else {
            this.save(obj, 2);
        }
    }

    private void save(Object obj, int state) {
        String entityName = this.getEntityNameForCFC(obj);
        if (entityName == null) {
            throw new EntityMappingNotFoundException(ORMUtils.getCFCName(obj));
        }
        String datasource = this.config.getDataSource(entityName);
        Session session = this.sessionManager.getSession(datasource);
        try {
            switch (state) {
                case 0: {
                    session.save(entityName, obj);
                    break;
                }
                case 1: {
                    session.update(entityName, obj);
                    break;
                }
                case 2: {
                    session.saveOrUpdate(entityName, obj);
                }
            }
        }
        catch (HibernateException e) {
            this.sessionManager.discardSession(session);
            throw new HibernateSessionException(e);
        }
    }

    @Override
    public List load(String componentName) {
        String entityName = this.getEntityName(componentName);
        String datasource = this.config.getDataSource(entityName);
        Session session = this.sessionManager.getSession(datasource);
        String hql = "from " + entityName;
        Query query = session.createQuery(hql);
        try {
            return query.list();
        }
        catch (HibernateException e) {
            throw new EntityLoadException(e);
        }
    }

    private String getEntityName(String componentName) {
        String entityName = this.config.getExactEntityName(componentName);
        if (entityName == null) {
            throw new EntityMappingNotFoundException(componentName);
        }
        return entityName;
    }

    @Override
    public Object loadByPK(String componentName, Object id) {
        String entityName = this.getEntityName(componentName);
        id = this.getIdObject(entityName, id);
        String datasource = this.config.getDataSource(entityName);
        Session session = this.sessionManager.getSession(datasource);
        try {
            return session.get(entityName, (Serializable)id);
        }
        catch (HibernateException e) {
            throw new HibernateSessionException(e);
        }
    }

    private Object getIdObject(String entityName, Object id) {
        CFCMetadataImpl cfcMetadata = (CFCMetadataImpl)this.config.getCFCMetadataForEntity(entityName);
        if (cfcMetadata.hasCompositePrimaryKey()) {
            if (!(id instanceof Map)) {
                throw new InvalidPKObjectException();
            }
            Map map = (Map)id;
            String[] pkFields = map.keySet().toArray(new String[0]);
            HashMap<String, Object> keyMap = new HashMap<String, Object>();
            for (String pkField : pkFields) {
                String pkFieldName = cfcMetadata.getPKFieldName(pkField);
                if (pkFieldName == null) {
                    throw new InvalidPKObjectException();
                }
                Class typeClass = cfcMetadata.getPropertyType(pkField);
                Object typedValue = ORMUtils.getTypedValue(map.get(pkField), typeClass);
                keyMap.put(pkFieldName, typedValue);
            }
            return keyMap;
        }
        if (id instanceof Map) {
            Map map = (Map)id;
            String[] pkfields = map.keySet().toArray(new String[0]);
            if (pkfields.length != 1) {
                throw new InvalidPKObjectException();
            }
            String pkfield = pkfields[0];
            if (!cfcMetadata.isPKField(pkfield)) {
                throw new InvalidPKObjectException();
            }
            id = map.get(pkfield);
        }
        String datasource = this.config.getDataSource(entityName);
        ClassMetadata metaData = this.config.getSessionFactory(datasource).getClassMetadata(entityName);
        Class idClass = metaData.getIdentifierType().getReturnedClass();
        return ORMUtils.getTypedValue(id, idClass);
    }

    private boolean isIDObject(String componentName, Map nameVsValue) {
        String entityName = this.getEntityName(componentName);
        CFCMetadataImpl cfcMetadata = (CFCMetadataImpl)this.config.getCFCMetadataForEntity(entityName);
        List<String> pkFieldNames = cfcMetadata.getPKFieldNames();
        if (nameVsValue == null || pkFieldNames == null || pkFieldNames.size() != nameVsValue.size()) {
            return false;
        }
        for (Object propNameObj : nameVsValue.keySet()) {
            String propName = (String)propNameObj;
            if (cfcMetadata.isPKField(propName)) continue;
            return false;
        }
        return true;
    }

    @Override
    public List load(String componentName, Map nameVsValue) {
        return (List)this.load(componentName, nameVsValue, false);
    }

    @Override
    public Object load(String componentName, Map nameVsValue, boolean unique) {
        if (this.isIDObject(componentName, nameVsValue)) {
            Object obj = this.loadByPK(componentName, nameVsValue);
            if (unique) {
                return obj;
            }
            ArrayList<Object> list = new ArrayList<Object>(1);
            if (obj != null) {
                list.add(obj);
            }
            return list;
        }
        return this.load(componentName, nameVsValue, null, null, unique);
    }

    @Override
    public List load(String componentName, Map nameVsValue, String orderBy, Map options) {
        return (List)this.load(componentName, nameVsValue, orderBy, options, false);
    }

    public Object load(String componentName, Map nameVsValue, String orderBy, Map options, boolean unique) {
        String entityName = this.getEntityName(componentName);
        CFCMetadataImpl cfcMetadata = (CFCMetadataImpl)this.config.getCFCMetadataForEntity(entityName);
        CriteriaBuilder criteriaBuilder = new CriteriaBuilder(cfcMetadata, this.config.getDataSource(entityName));
        if (nameVsValue != null) {
            criteriaBuilder.addFields(nameVsValue);
        }
        if (orderBy != null && orderBy.length() > 0) {
            Object ignoreStr;
            boolean ignoreCase = false;
            if (options != null && (ignoreStr = options.get(IGNORECASE)) != null) {
                ignoreCase = Cast._boolean(ignoreStr, (boolean)false);
            }
            criteriaBuilder.addOrderBy(orderBy, ignoreCase);
        }
        if (options != null) {
            criteriaBuilder.addOptions(options);
        }
        Criteria criteria = criteriaBuilder.getCriteria();
        try {
            if (unique) {
                return criteria.uniqueResult();
            }
            return criteria.list();
        }
        catch (HibernateException e) {
            throw new EntityLoadException(e);
        }
    }

    @Override
    public List loadByExample(Object obj) {
        return (List)this.loadByExample(obj, null, "excludeNull", false);
    }

    @Override
    public Object loadByExample(Object obj, boolean unique) {
        return this.loadByExample(obj, null, "excludeNull", unique);
    }

    @Override
    public Object loadByExample(Object obj, String option, boolean unique) {
        return this.loadByExample(obj, null, option, unique);
    }

    @Override
    public List loadByExample(Object obj, List excludeFields) {
        return (List)this.loadByExample(obj, excludeFields, "excludeNull", false);
    }

    public Object loadByExample(Object obj, List excludeFields, String option, boolean unique) {
        Criteria criteria;
        CFCMetadataImpl cfcMetadata = null;
        if (obj instanceof PersistentTemplateProxy) {
            PersistentTemplateProxy cfc = (PersistentTemplateProxy)((Object)obj);
            String cfcName = cfc.getName();
            String entityName = this.config.getEntityName(cfcName);
            if (entityName == null) {
                throw new EntityMappingNotFoundException(cfcName);
            }
            cfcMetadata = (CFCMetadataImpl)this.config.getCFCMetadataForEntity(entityName);
            String datasource = this.config.getDataSource(entityName);
            CriteriaBuilder builder = new CriteriaBuilder(cfcMetadata, datasource);
            List<String> pkFieldNames = cfcMetadata.getPKFieldNames();
            if (pkFieldNames != null) {
                for (String pkField : pkFieldNames) {
                    Object value = cfc.getProperty(pkField);
                    if (value == null) continue;
                    builder.addField(pkField, value);
                }
            }
            criteria = builder.getCriteria();
        } else {
            if (obj == null || obj instanceof TemplateProxy) {
                throw new ObjectNotPersistentException();
            }
            Session session = this.sessionManager.getSession();
            criteria = session.createCriteria(obj.getClass());
        }
        Example criterion = Example.create((Object)obj);
        if ("all".equalsIgnoreCase(option)) {
            criterion.excludeNone();
        } else if ("excludeNullZero".equalsIgnoreCase(option)) {
            criterion.excludeZeroes();
        }
        if (excludeFields != null) {
            for (Object field : excludeFields) {
                String propertyName = cfcMetadata != null ? cfcMetadata.getPropertyName((String)field) : (String)field;
                criterion.excludeProperty(propertyName);
            }
        }
        criteria.add((Criterion)criterion);
        try {
            if (unique) {
                return criteria.uniqueResult();
            }
            return criteria.list();
        }
        catch (HibernateException e) {
            throw new EntityLoadException(e);
        }
    }

    @Override
    public void reload(Object obj) {
        String entityName = this.getEntityNameForCFC(obj);
        if (entityName == null) {
            throw new EntityMappingNotFoundException(ORMUtils.getCFCName(obj));
        }
        String datasource = this.config.getDataSource(entityName);
        Session session = this.sessionManager.getSession(datasource);
        if (session.contains(obj)) {
            session.refresh(obj);
        } else if (Boolean.getBoolean("coldfusion.flexormbatch.invoke")) {
            if (session.contains(obj)) {
                session.refresh(obj);
            }
        } else {
            throw new TransientObjectReloadException();
        }
    }

    @Override
    public void delete(Object obj) {
        String entityName = this.getEntityNameForCFC(obj);
        if (entityName == null) {
            throw new EntityMappingNotFoundException(ORMUtils.getCFCName(obj));
        }
        String datasource = this.config.getDataSource(entityName);
        Session session = this.sessionManager.getSession(datasource);
        try {
            session.delete(entityName, obj);
        }
        catch (HibernateException e) {
            this.sessionManager.discardSession(session);
            throw e;
        }
    }

    @Override
    public Object merge(Object obj) {
        String entityName = this.getEntityNameForCFC(obj);
        if (entityName == null) {
            throw new EntityMappingNotFoundException(ORMUtils.getCFCName(obj));
        }
        String datasource = this.config.getDataSource(entityName);
        Session session = this.sessionManager.getSession(datasource);
        try {
            return session.merge(entityName, obj);
        }
        catch (HibernateException e) {
            this.sessionManager.discardSession(session);
            throw e;
        }
    }

    @Override
    public Object executeQuery(String hql, String datasource, boolean unique, Map queryOptions) {
        return this.executeHQL(hql, datasource, null, unique, queryOptions);
    }

    @Override
    public Object executeQuery(String hql, String datasource, List params, boolean unique, Map queryOptions) {
        return this.executeHQL(hql, datasource, params, unique, queryOptions);
    }

    @Override
    public Object executeQueryWithNamedParams(String hql, String datasource, Map map, boolean unique, Map queryOptions) {
        return this.executeHQL(hql, datasource, map, unique, queryOptions);
    }

    @Override
    public void evictEntity(String componentName) {
        String entityName = this.getEntityName(componentName);
        String datasource = this.config.getDataSource(entityName);
        this.config.getSessionFactory(datasource).getCache().evictEntityRegion(entityName);
    }

    @Override
    public void evictEntity(String componentName, Object id) {
        String entityName = this.getEntityName(componentName);
        String datasource = this.config.getDataSource(entityName);
        id = this.getIdObject(entityName, id);
        this.config.getSessionFactory(datasource).getCache().evictEntity(entityName, (Serializable)id);
    }

    @Override
    public void evictCollection(String componentName, String relationName) {
        String entityName = this.getEntityName(componentName);
        CFCMetadataImpl cfcMetadata = (CFCMetadataImpl)this.config.getCFCMetadataForEntity(entityName);
        String relationFieldName = cfcMetadata.getPropertyName(relationName);
        if (relationFieldName != null) {
            relationName = entityName + "." + relationFieldName;
            String datasource = this.config.getDataSource(entityName);
            this.config.getSessionFactory(datasource).getCache().evictCollectionRegion(relationName);
        }
    }

    @Override
    public void evictCollection(String componentName, String relationName, Object id) {
        String entityName = this.getEntityName(componentName);
        CFCMetadataImpl cfcMetadata = (CFCMetadataImpl)this.config.getCFCMetadataForEntity(entityName);
        String relationFieldName = cfcMetadata.getPropertyName(relationName);
        if (relationFieldName != null) {
            relationName = entityName + "." + relationFieldName;
            id = this.getIdObject(entityName, id);
            String datasource = this.config.getDataSource(entityName);
            this.config.getSessionFactory(datasource).getCache().evictCollection(relationName, (Serializable)id);
        }
    }

    @Override
    public void evictQueries() {
        this.config.getSessionFactory().getCache().evictDefaultQueryRegion();
    }

    @Override
    public void evictQueries(String cacheName) {
        this.config.getSessionFactory().getCache().evictQueryRegion(cacheName);
    }

    @Override
    public void evictQueries(String cacheName, String datasource) {
        if (cacheName == null || cacheName.length() == 0) {
            this.config.getSessionFactory(datasource).getCache().evictDefaultQueryRegion();
        } else {
            this.config.getSessionFactory(datasource).getCache().evictQueryRegion(cacheName);
        }
    }

    @Override
    public Object entityNew(String entityName) {
        String cfcName = this.config.getCFCName(entityName);
        if (cfcName == null) {
            throw new EntityNotFoundException(entityName);
        }
        try {
            Object o;
            NeoPageContext pageContext = FusionContext.getCurrent().pageContext;
            TemplateProxy cfc = (TemplateProxy)ComponentProxyFactory.getProxy((String)cfcName, (NeoPageContext)pageContext, null, null);
            Map metadata = (Map)cfc.getMetadata();
            String initMethod = (String)metadata.get("ormInitMethod");
            initMethod = initMethod == null ? (String)metadata.get("initmethod") : initMethod;
            initMethod = initMethod == null ? "init" : initMethod;
            Object methodObj = cfc.get((Object)initMethod);
            if (methodObj instanceof UDFMethod && (o = cfc.invoke(initMethod, noArgs, (PageContext)pageContext)) != null) {
                return o;
            }
            return cfc;
        }
        catch (Throwable th) {
            throw new RuntimeWrapper(th);
        }
    }

    private Object executeHQL(String hql, String datasource, Object params, boolean unique, Map queryOptions) {
        try {
            return this._executeHQL(hql, datasource, params, unique, queryOptions);
        }
        catch (HibernateException e) {
            throw new QueryExecuteException(e);
        }
    }

    private static String sanitizeHQL(String hql) {
        StringBuilder sb = new StringBuilder();
        int hqlLength = hql.length();
        char quoteType = '\u0000';
        boolean hqlInQuotes = false;
        int index = 1;
        for (int i = 0; i < hqlLength; ++i) {
            char chr = hql.charAt(i);
            if (chr == '\"' || chr == '\'') {
                if (hqlInQuotes) {
                    if (chr == quoteType) {
                        hqlInQuotes = false;
                    }
                } else {
                    quoteType = chr;
                    hqlInQuotes = true;
                }
            }
            if (!hqlInQuotes && chr == '?') {
                if (hqlLength > i + 1 && HibernatePersistenceManager.isInteger(hql.charAt(i + 1))) {
                    return hql;
                }
                sb.append(chr).append(index++);
                continue;
            }
            sb.append(chr);
        }
        return sb.toString();
    }

    private static final boolean isInteger(char c) {
        return c >= '0' && c <= '9';
    }

    private Object _executeHQL(String hql, String datasource, Object params, final boolean unique, Map queryOptions) {
        Transaction transaction;
        hql = HibernatePersistenceManager.sanitizeHQL(hql);
        datasource = datasource == null ? this.config.getDataSource() : datasource;
        Session session = this.sessionManager.getSession(datasource);
        boolean isSelectQuery = this.isSelectQuery(hql);
        if (!isSelectQuery && !(transaction = session.getTransaction()).isActive()) {
            session.beginTransaction();
        }
        final Query query = session.createQuery(hql);
        if (params != null) {
            SessionFactory sf = this.config.getSessionFactory(datasource);
            ParameterMetadataImpl paramMetaDataImpl = null;
            if (sf instanceof SessionFactoryImpl) {
                HQLQueryPlan queryPlan = ((SessionFactoryImpl)sf).getQueryPlanCache().getHQLQueryPlan(hql, false, Collections.EMPTY_MAP);
                paramMetaDataImpl = queryPlan.getParameterMetadata();
            }
            if (params instanceof List) {
                List paramList = (List)params;
                if (paramMetaDataImpl != null && paramList.size() != paramMetaDataImpl.getOrdinalParameterCount()) {
                    throw new InvalidQueryParamException();
                }
                this.setQueryParams(query, paramList, paramMetaDataImpl);
            } else if (params instanceof Map) {
                Set namedParamSet;
                Map passedParams = (Map)params;
                if (paramMetaDataImpl != null && (namedParamSet = paramMetaDataImpl.getNamedParameterNames()) != null && passedParams.size() != namedParamSet.size()) {
                    throw new InvalidQueryParamException();
                }
                this.setQueryParams(query, passedParams, paramMetaDataImpl);
            }
        }
        if (queryOptions != null) {
            Object cacheable;
            Object readOnly;
            Object timeout;
            Object offset;
            Object maxResults = queryOptions.get(MAX_RESULTS);
            if (maxResults != null) {
                query.setMaxResults(Cast._int(maxResults));
            }
            if ((offset = queryOptions.get(OFFSET)) != null) {
                query.setFirstResult(Cast._int(offset));
            }
            if ((timeout = queryOptions.get(TIMEOUT)) != null) {
                query.setTimeout(Cast._int(timeout));
            }
            if ((readOnly = queryOptions.get(READ_ONLY)) != null) {
                query.setReadOnly(Cast._boolean(readOnly));
            }
            if ((cacheable = queryOptions.get(CACHEABLE)) != null) {
                query.setCacheable(Cast._boolean(cacheable));
                String cacheRegion = (String)queryOptions.get(CACHE_REGION);
                if (cacheRegion != null && cacheRegion.length() != 0) {
                    query.setCacheRegion(cacheRegion);
                }
            }
        }
        if (isSelectQuery) {
            if (IS_JVM_SECURITY_ENABLED && query.getCacheRegion() != null) {
                return AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        return unique ? query.uniqueResult() : query.list();
                    }
                }, null, ALL_FILES_PERMISSION);
            }
            return unique ? query.uniqueResult() : query.list();
        }
        return query.executeUpdate();
    }

    private void setQueryParams(Query query, List params, ParameterMetadataImpl paramMetaDataImpl) {
        for (int i = 0; i < params.size(); ++i) {
            Object param = params.get(i);
            if (paramMetaDataImpl != null) {
                Type hibernateType = paramMetaDataImpl.getOrdinalParameterDescriptor(i + 1).getExpectedType();
                Object typedValue = param;
                if (hibernateType != null) {
                    Class type = hibernateType.getReturnedClass();
                    typedValue = ORMUtils.getTypedValue(param, type);
                }
                query.setParameter(i + 1, typedValue, hibernateType);
                continue;
            }
            query.setParameter(i + 1, param);
        }
    }

    private void setQueryParams(Query query, Map map, ParameterMetadataImpl paramMetaDataImpl) {
        for (Object o : map.keySet()) {
            String key = (String)o;
            Object val = map.get(key);
            if (paramMetaDataImpl != null) {
                Set paramNames = paramMetaDataImpl.getNamedParameterNames();
                String paramName = this.getActualParamName(key, paramNames);
                Type hibernateType = paramMetaDataImpl.getNamedParameterExpectedType(paramName);
                Object typedValue = val;
                if (hibernateType != null) {
                    Class type = hibernateType.getReturnedClass();
                    typedValue = val instanceof List ? ORMUtils.getTypedList((List)val, type) : ORMUtils.getTypedValue(val, type);
                }
                if (val instanceof List) {
                    query.setParameterList(paramName, (Collection)((List)typedValue));
                    continue;
                }
                query.setParameter(paramName, typedValue, hibernateType);
                continue;
            }
            query.setParameter(key, val);
        }
    }

    private String getActualParamName(String key, Set paramNames) {
        if (paramNames != null) {
            for (Object paramName : paramNames) {
                String name = (String)paramName;
                if (!name.equalsIgnoreCase(key)) continue;
                return name;
            }
        }
        return key;
    }

    private boolean isSelectQuery(String query) {
        query = query.trim();
        String action = query.split("\\W+")[0];
        return (action = action.toLowerCase()).equals("select") || action.equals("from");
    }

    private String getEntityNameForCFC(Object obj) {
        String cfcName = ORMUtils.getCFCName(obj);
        if (cfcName != null) {
            return this.config.getEntityName(cfcName);
        }
        throw new InvalidEntityException();
    }

    public void beforeTransactionBegin() {
        if (this.config.getORMSettings().isAutoSessionManagementEnabled()) {
            this.sessionManager.flushAllCurrentSessions();
        }
    }

    public void onCommit() {
        TransactionTag transaction = TransactionTag.getCurrent();
        String transactionDataSource = transaction.getDatasource();
        Map<String, Session> sessionMap = this.sessionManager.getORMSession();
        Session validSession = null;
        if (sessionMap != null && transactionDataSource != null) {
            validSession = sessionMap.get(transactionDataSource);
        }
        if (transactionDataSource == null || validSession != null) {
            Session session = this.getDirtySessionForTransaction();
            if (session == null) {
                return;
            }
            if (session instanceof SessionWrapper) {
                ((SessionWrapper)session).attachTransactionToSession();
            }
            session.flush();
        }
    }

    public void onRollback() {
        Session session = this.getDirtySessionForTransaction();
        if (session == null) {
            return;
        }
        if (this.config.getORMSettings().isAutoSessionManagementEnabled()) {
            this.sessionManager.clearSession(session);
        }
    }

    public void onSetSavePoint(String name) {
        Session session = this.getDirtySessionForTransaction();
        if (session == null) {
            return;
        }
        if (session instanceof SessionWrapper) {
            ((SessionWrapper)session).attachTransactionToSession();
        }
        session.flush();
    }

    public void afterTransactionCompletion() {
    }

    private Session getDirtySessionForTransaction() {
        Iterator<Session> sessionIter;
        Map<String, Session> ormSessions = this.sessionManager.getORMSession();
        if (ormSessions != null && ormSessions.size() == 1 && (sessionIter = ormSessions.values().iterator()).hasNext()) {
            return sessionIter.next();
        }
        List<Session> dirtySessions = this.sessionManager.getAllDirtySessions();
        if (dirtySessions == null || dirtySessions.size() == 0) {
            return this.sessionManager.getSessionInTransaction();
        }
        if (dirtySessions.size() > 1) {
            throw new DistributedTransactionNotSupportedException();
        }
        return dirtySessions.get(0);
    }

    public void onPageRequestEnd(Throwable t) {
        boolean flush = t == null || t instanceof AbortException;
        boolean bl = flush = flush && !this.isFlushAtRequestEndDisabled();
        if (flush) {
            this.sessionManager.flushAllCurrentSessions();
        }
        this.sessionManager.closeAllCurrentSessions(false);
    }

    private boolean isFlushAtRequestEndDisabled() {
        ORMSettings ormSettings = this.config.getORMSettings();
        return !ormSettings.isAutoSessionManagementEnabled() || !ormSettings.shouldFlushAtRequestEnd();
    }

    public void cleanup() {
        this.sessionManager.closeAllCurrentSessions(false);
    }

    static {
        HibernateEventListener listener = new HibernateEventListener();
        EventListeners.addTransactionEventListener((TransactionEventListener)listener);
        EventListeners.addRequestEventListener((RequestEventListener)listener);
        EventListeners.addCFThreadEventListener((CFThreadEventListener)listener);
    }

    public static class TransientObjectReloadException
    extends ApplicationException {
    }

    public static class DistributedTransactionNotSupportedException
    extends ApplicationException {
    }

    public static class InvalidEntityException
    extends ApplicationException {
    }

    public static class EntityNotFoundException
    extends ApplicationException {
        public String entityName;

        public EntityNotFoundException(String entityName) {
            this.entityName = entityName;
        }
    }

    public static class InvalidQueryParamException
    extends ApplicationException {
    }

    public static class QueryExecuteException
    extends ApplicationException {
        public QueryExecuteException(HibernateException e) {
            super((Throwable)e);
            if (e instanceof JDBCException) {
                this.rootCause = ((JDBCException)e).getSQLException();
            }
        }
    }

    public static class EntityLoadException
    extends ApplicationException {
        public EntityLoadException(HibernateException e) {
            super((Throwable)e);
            if (e instanceof JDBCException) {
                this.rootCause = ((JDBCException)e).getSQLException();
            }
        }
    }

    public static class ObjectNotPersistentException
    extends NeoException {
    }

    public static class InvalidPKObjectException
    extends ApplicationException {
    }

    static class HibernateEventListener
    implements TransactionEventListener,
    RequestEventListener,
    CFThreadEventListener {
        HibernateEventListener() {
        }

        private HibernatePersistenceManager getCurrentPersistenceManager() {
            PersistenceManager persistenceManager = ORMProvider.getDefault().getCurrentPersistenceManager();
            if (persistenceManager instanceof HibernatePersistenceManager) {
                return (HibernatePersistenceManager)persistenceManager;
            }
            return null;
        }

        public void afterTransactionBegin() {
        }

        public void afterTransactionCompletion() {
        }

        public void beforeTransactionBegin() {
            HibernatePersistenceManager pm = this.getCurrentPersistenceManager();
            if (pm != null) {
                pm.beforeTransactionBegin();
            }
        }

        public void onCommit() {
            ORMSearchService ormSearchService;
            HibernatePersistenceManager pm = this.getCurrentPersistenceManager();
            if (pm != null) {
                pm.onCommit();
            }
            if ((ormSearchService = ServiceFactory.getOrmSearchService()) != null) {
                ormSearchService.onCommit();
            }
        }

        public void onRollback() {
            ORMSearchService ormSearchService;
            HibernatePersistenceManager pm = this.getCurrentPersistenceManager();
            if (pm != null) {
                pm.onRollback();
            }
            if ((ormSearchService = ServiceFactory.getOrmSearchService()) != null) {
                ormSearchService.onRollBack();
            }
        }

        public void onRollback(String savePointName) {
            ORMSearchService ormSearchService;
            HibernatePersistenceManager pm = this.getCurrentPersistenceManager();
            if (pm != null) {
                pm.onRollback();
            }
            if ((ormSearchService = ServiceFactory.getOrmSearchService()) != null) {
                ormSearchService.onRollBack();
            }
        }

        public void onSetSavePoint(String name) {
            HibernatePersistenceManager pm = this.getCurrentPersistenceManager();
            if (pm != null) {
                pm.onSetSavePoint(name);
            }
        }

        public void onPageRequestEnd(Throwable t) {
            ORMSearchService ormSearchService;
            HibernatePersistenceManager pm = this.getCurrentPersistenceManager();
            if (pm != null) {
                pm.onPageRequestEnd(t);
            }
            if ((ormSearchService = ServiceFactory.getOrmSearchService()) != null) {
                ormSearchService.onPageRequestEnd(t);
            }
        }

        public void onPageRequestStart() {
        }

        public void onRequestEnd() {
            ORMSearchService ormSearchService = ServiceFactory.getOrmSearchService();
            if (ormSearchService != null) {
                ormSearchService.onRequestEnd();
            }
        }

        public void onRequestStart() {
        }

        public void onCFThreadStart() {
        }

        public void onCFThreadEnd(Throwable t) {
            HibernatePersistenceManager pm = this.getCurrentPersistenceManager();
            if (pm != null) {
                pm.onPageRequestEnd(t);
            }
        }
    }
}

