/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.sasl;

import java.io.IOException;
import org.jivesoftware.smack.SASLAuthentication;
import org.jivesoftware.smack.util.StringUtils;

public abstract class SASLMechanism {
    private SASLAuthentication saslAuthentication;

    public SASLMechanism(SASLAuthentication saslAuthentication) {
        this.saslAuthentication = saslAuthentication;
    }

    public void authenticate(String username, String host, String password) throws IOException {
        StringBuffer stanza = new StringBuffer();
        stanza.append("<auth mechanism=\"").append(this.getName());
        stanza.append("\" xmlns=\"urn:ietf:params:xml:ns:xmpp-sasl\">");
        String authenticationText = this.getAuthenticationText(username, host, password);
        if (authenticationText != null) {
            stanza.append(StringUtils.encodeBase64(authenticationText));
        }
        stanza.append("</auth>");
        this.getSASLAuthentication().send(stanza.toString());
    }

    public void challengeReceived(String challenge) throws IOException {
        StringBuffer stanza = new StringBuffer();
        stanza.append("<response xmlns=\"urn:ietf:params:xml:ns:xmpp-sasl\">");
        String authenticationText = this.getChallengeResponse(StringUtils.decodeBase64(challenge));
        stanza.append(StringUtils.encodeBase64(authenticationText));
        stanza.append("</response>");
        this.getSASLAuthentication().send(stanza.toString());
    }

    protected abstract String getChallengeResponse(byte[] var1);

    protected abstract String getName();

    protected abstract String getAuthenticationText(String var1, String var2, String var3);

    protected SASLAuthentication getSASLAuthentication() {
        return this.saslAuthentication;
    }
}

