/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.graphql.graphqlClient;

import coldfusion.graphql.client.GraphQLClient;
import coldfusion.graphql.graphqlClient.CFGraphQLClientException;
import coldfusion.graphql.graphqlClient.CFGraphQLClientImpl;
import coldfusion.graphql.graphqlClient.CFGraphQLUtils;
import coldfusion.graphql.graphqlClient.PMTGraphQlApis;
import coldfusion.graphql.graphqlClient.PMTUtilsForGraphQlClient;
import coldfusion.log.CFLogs;
import coldfusion.monitor.beans.TagAttributeList;
import coldfusion.runtime.Struct;
import coldfusion.util.RB;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.json.JSONObject;

public class GraphQLHTTPClient
implements GraphQLClient {
    public static final String MEDIA_TYPE = "application/json; charset=utf-8";
    private OkHttpClient okHttpClient;
    private String serverURL;
    private Map<String, String> headers;
    private String clientName;
    private String serviceName;

    public GraphQLHTTPClient(Object config) {
        if (!(config instanceof Struct) && !(config instanceof Map)) {
            throw new CFGraphQLClientException(RB.getString(GraphQLHTTPClient.class, (String)"Invalid Client Config Exception"));
        }
        this.getCFGraphQLClient((Map)config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OkHttpClient getCFGraphQLClient(Map<String, Object> serverConfiguration) {
        OkHttpClient currentClient = this.okHttpClient;
        if (currentClient == null) {
            GraphQLHTTPClient graphQLHTTPClient = this;
            synchronized (graphQLHTTPClient) {
                currentClient = this.okHttpClient;
                if (currentClient == null) {
                    this.okHttpClient = currentClient = new OkHttpClient();
                    this.initializeServerConfiguration(serverConfiguration);
                }
            }
        }
        return currentClient;
    }

    private void initializeServerConfiguration(Map<String, Object> configSettings) {
        if (CFGraphQLUtils.isNullOrEmpty((String)configSettings.get("service_url"))) {
            throw new CFGraphQLClientException(RB.getString(GraphQLHTTPClient.class, (String)"INVALID_CONFIG_PARAM_EXCEPTION", (Object)"service_url"));
        }
        this.serverURL = (String)configSettings.get("service_url");
        if (configSettings.get("headers") != null) {
            try {
                this.headers = (Map)configSettings.get("headers");
            }
            catch (Exception exception) {
                throw new CFGraphQLClientException(exception.getMessage(), exception);
            }
            this.clientName = (String)configSettings.get("client_name");
            this.serviceName = (String)configSettings.get("service_name");
        }
    }

    private String getGraphQLQuery(String gqlQueryorFile) {
        String gql = gqlQueryorFile.trim();
        if (gql.endsWith(".graphql")) {
            try {
                gql = new String(Files.readAllBytes(Paths.get(gqlQueryorFile, new String[0])));
            }
            catch (IOException ioException) {
                throw new CFGraphQLClientException(ioException.getMessage());
            }
            return gql;
        }
        return gql;
    }

    public Map fetchResponse(String gqlQueryorFile) {
        if (gqlQueryorFile == null || gqlQueryorFile.isEmpty()) {
            throw new CFGraphQLClientException(RB.getString(GraphQLHTTPClient.class, (String)"EMPTY_GRAPHQL_QUERY"));
        }
        return this.fetchResponse(gqlQueryorFile, new HashMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map fetchResponse(String gqlQueryorFile, Map params) {
        TagAttributeList tempAttributeList = null;
        String operationName = "";
        Response response = null;
        String responseData = "";
        String gqlQuery = this.getGraphQLQuery(gqlQueryorFile.trim());
        JSONObject variables = new JSONObject();
        params = CFGraphQLUtils.serializeStruct(params);
        int requestSize = 0;
        try {
            tempAttributeList = PMTUtilsForGraphQlClient.startGraphQlMonitoring(PMTGraphQlApis.GraphQL_fetchResponse, tagAttributeList, this.serviceName, this.clientName, this.serverURL);
            operationName = PMTUtilsForGraphQlClient.extractOperationNameAndType(gqlQueryorFile.trim(), tempAttributeList);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("query", (Object)gqlQuery);
            for (Map.Entry<String, Object> parameter : params.entrySet()) {
                variables.put(parameter.getKey().toString(), parameter.getValue());
            }
            jsonObject.put("variables", (Object)variables);
            RequestBody requestBody = RequestBody.create((String)jsonObject.toString(), (MediaType)MediaType.parse((String)MEDIA_TYPE));
            Request.Builder requestBuilder = new Request.Builder().url(this.serverURL).post(requestBody);
            if (this.headers != null) {
                for (Map.Entry<String, String> entry : this.headers.entrySet()) {
                    requestBuilder.addHeader(entry.getKey(), entry.getValue());
                }
            }
            Request request = requestBuilder.build();
            requestSize = request.toString().getBytes().length;
            response = this.okHttpClient.newCall(request).execute();
            responseData = response.body().string();
            if (!response.isSuccessful()) {
                this.logThrowMonitorException(operationName, new CFGraphQLClientException(response.message()), response.message(), tempAttributeList);
            }
        }
        catch (IOException ioException) {
            responseData = ioException.getMessage();
            this.logThrowMonitorException(operationName, ioException, ioException.toString(), tempAttributeList);
        }
        finally {
            HashMap<String, Object> queryResult = new HashMap<String, Object>();
            queryResult.put("QueryDocument", gqlQuery);
            queryResult.put("service_url", this.serverURL);
            queryResult.put("variables", variables.toString());
            queryResult.put("Message", response.message());
            queryResult.put("Response_code", response.code());
            queryResult.put("SentRequestAtMillis", response.sentRequestAtMillis());
            queryResult.put("ReceivedResponseAtMillis", response.receivedResponseAtMillis());
            queryResult.put("Data", responseData);
            queryResult.put("ResponseSize (Bytes)", responseData.getBytes().length);
            queryResult.put("RequestSize (Bytes)", requestSize);
            PMTUtilsForGraphQlClient.endGraphQlmonitoring(PMTGraphQlApis.GraphQL_fetchResponse, tempAttributeList, operationName, params, queryResult);
            return queryResult;
        }
    }

    private void logThrowMonitorException(String opName, Throwable ex, String key, TagAttributeList pmtAttributeList) {
        CFGraphQLClientException exception = this.logException(opName, ex, key);
        if (pmtAttributeList != null) {
            PMTUtilsForGraphQlClient.catchErrorMetrics(exception, pmtAttributeList);
        }
        throw exception;
    }

    private CFGraphQLClientException logException(String opName, Throwable ex, String key) {
        String message = RB.getString(CFGraphQLClientImpl.class, (String)key, (Object)(opName + ":" + ex.getMessage()));
        CFGraphQLClientException exception = new CFGraphQLClientException(ex.getClass().getName(), message, ex);
        CFLogs.APPLICATION_LOG.error((Throwable)exception);
        return exception;
    }
}

