/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.graphql.graphqlClient;

import coldfusion.cloud.util.ValidatorFiller;
import coldfusion.graphql.client.GraphQLClient;
import coldfusion.graphql.graphqlClient.CFGraphQLClientImpl;
import coldfusion.graphql.graphqlClient.GraphQLHTTPClient;
import coldfusion.graphql.graphqlClient.PMTUtilsForGraphQlClient;
import coldfusion.graphql.graphqlClient.config.CFGraphQLConfig;
import coldfusion.graphql.graphqlClient.metadata.CFGraphQLConfigMetadata;
import coldfusion.log.CFLogs;
import coldfusion.monitor.Configuration;
import coldfusion.monitor.datastore.JSONConverter;
import coldfusion.runtime.Struct;
import coldfusion.util.RB;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class GraphQLClientProducer {
    private static final Map<String, GraphQLClient> graphQLClientMap = new HashMap<String, GraphQLClient>();

    public static GraphQLClient getClient(Struct inputConfig) {
        CFGraphQLConfig cfGraphQLConfig = new CFGraphQLConfig();
        ValidatorFiller.INSTANCE.fillObject((Object)cfGraphQLConfig, (Map)inputConfig, CFGraphQLConfigMetadata.getInstance().getConsumerMap());
        boolean isRawHttpClient = cfGraphQLConfig.isRawHttpClient();
        String graphQLClientId = Integer.toString(Objects.hash(inputConfig.hashCode()));
        Object cfGraphQLClient = graphQLClientMap.get(graphQLClientId);
        if (cfGraphQLClient == null) {
            cfGraphQLClient = isRawHttpClient ? new GraphQLHTTPClient(inputConfig) : new CFGraphQLClientImpl(inputConfig);
            graphQLClientMap.put(graphQLClientId, (GraphQLClient)cfGraphQLClient);
            if (Configuration.INSTANCE.getMonitorSettings().isMonitoringEnabled()) {
                try {
                    Map mapOfConfig = JSONConverter.toMap((Object)((Object)cfGraphQLConfig));
                    PMTUtilsForGraphQlClient.persistClientMonitoringMetrics(mapOfConfig, graphQLClientId);
                    PMTUtilsForGraphQlClient.persistServerMonitoringMetrics(inputConfig);
                }
                catch (Exception e) {
                    CFLogs.MONITOR_LOG.error((Object)RB.getString(GraphQLClientProducer.class, (String)"MONITORING_DATA_PERSISTENCE_ERROR"), (Throwable)e);
                }
            }
        }
        return cfGraphQLClient;
    }
}

