/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.im;

import com.lotus.sametime.community.Channel;
import com.lotus.sametime.community.ChannelEvent;
import com.lotus.sametime.community.ChannelService;
import com.lotus.sametime.community.ChannelServiceListener;
import com.lotus.sametime.community.CommunityService;
import com.lotus.sametime.community.Login;
import com.lotus.sametime.core.comparch.DuplicateObjectException;
import com.lotus.sametime.core.comparch.STComp;
import com.lotus.sametime.core.comparch.STCompApi;
import com.lotus.sametime.core.comparch.STSession;
import com.lotus.sametime.core.constants.EncLevel;
import com.lotus.sametime.core.types.STId;
import com.lotus.sametime.core.types.STUser;
import com.lotus.sametime.core.types.STUserInstance;
import com.lotus.sametime.core.types.STUserStatus;
import com.lotus.sametime.core.util.NdrInputStream;
import com.lotus.sametime.core.util.NdrOutputStream;
import com.lotus.sametime.im.Im;
import com.lotus.sametime.im.ImEvent;
import com.lotus.sametime.im.ImServiceListener;
import com.lotus.sametime.im.InstantMessagingService;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ImComp
extends STComp
implements InstantMessagingService {
    private Vector m_listeners = new Vector();
    private ChannelService m_channelService;
    private ChannelServiceListener m_chServiceListener;
    private CommunityService m_comm;
    private Vector m_supportedImTypes = new Vector();
    private static final int OM_DATA_TYPE_INFO = 1;
    private static final int OM_DATA_TYPE_STATUS = 2;
    private Logger m_logger = Logger.getLogger("com.lotus.sametime.im");

    public ImComp(STSession sTSession) throws DuplicateObjectException {
        super("com.lotus.sametime.im.ImComp", sTSession);
        sTSession.registerComponent(this.getName(), this);
        this.m_chServiceListener = new ChannelServiceListener(){

            public void channelReceived(ChannelEvent channelEvent) {
                ImComp.this.channelReceived(channelEvent);
            }
        };
        this.m_channelService = (ChannelService)sTSession.getCompApi("com.lotus.sametime.community.STBase");
        if (null != this.m_channelService) {
            this.m_channelService.addChannelServiceListener(this.m_chServiceListener);
        }
        this.m_comm = (CommunityService)sTSession.getCompApi("com.lotus.sametime.community.STBase");
    }

    protected void start() {
        if (this.m_logger.isLoggable(Level.FINER)) {
            this.m_logger.logp(Level.FINER, this.getClass().getName(), "start", this + " Started");
        }
    }

    protected void stop() {
        if (this.m_logger.isLoggable(Level.FINER)) {
            this.m_logger.logp(Level.FINER, this.getClass().getName(), "stop", this + " Stopped");
        }
    }

    protected void componentLoaded(STCompApi sTCompApi) {
        if (null == this.m_channelService && sTCompApi instanceof ChannelService) {
            this.m_channelService = (ChannelService)sTCompApi;
            this.m_channelService.addChannelServiceListener(this.m_chServiceListener);
        }
        if (null == this.m_comm && sTCompApi instanceof CommunityService) {
            this.m_comm = (CommunityService)sTCompApi;
        }
    }

    public synchronized void addImServiceListener(ImServiceListener imServiceListener) {
        Vector vector = (Vector)this.m_listeners.clone();
        vector.addElement(imServiceListener);
        this.m_listeners = vector;
    }

    public synchronized void removeImServiceListener(ImServiceListener imServiceListener) {
        Vector vector = (Vector)this.m_listeners.clone();
        vector.removeElement(imServiceListener);
        this.m_listeners = vector;
    }

    public Im createIm(STUser sTUser, EncLevel encLevel, int n) {
        return this.createIm(sTUser, encLevel, n, false);
    }

    public Im createIm(STUser sTUser, EncLevel encLevel, int n, boolean bl) {
        Im im = null;
        STId sTId = sTUser.getId();
        if (bl && sTUser instanceof STUserInstance && ((STUserInstance)sTUser).getLoginId() != null) {
            sTId = ((STUserInstance)sTUser).getLoginId();
        }
        NdrOutputStream ndrOutputStream = new NdrOutputStream();
        try {
            ndrOutputStream.writeInt(1);
            ndrOutputStream.writeInt(n);
            Channel channel = this.m_channelService.createChannel(4096, 4096, 3, encLevel, ndrOutputStream.toByteArray(), sTId);
            im = new Im(channel, n, false, this, sTUser);
        }
        catch (IOException iOException) {
            if (this.m_logger.isLoggable(Level.FINER)) {
                this.m_logger.logp(Level.FINER, this.getClass().getName(), "createIm", this + ": Failed on createMessage" + iOException.getMessage(), iOException);
            }
            iOException.printStackTrace();
        }
        return im;
    }

    private void channelReceived(ChannelEvent channelEvent) {
        Channel channel = channelEvent.getChannel();
        if (channel.getServiceType() != 4096) {
            return;
        }
        int n = channel.getProtocolType();
        if (n != 4096 && n != 4097) {
            return;
        }
        Login login = this.m_comm.getLogin();
        if (null == login) {
            return;
        }
        STUserStatus sTUserStatus = login.getMyStatus();
        if (null == sTUserStatus) {
            return;
        }
        try {
            NdrInputStream ndrInputStream = new NdrInputStream(channel.getCreateData());
            ndrInputStream.readInt();
            int n2 = ndrInputStream.readInt();
            short s = sTUserStatus.getStatusType();
            if (!this.isTypeSupported(n2)) {
                channel.close(-2147475451, null);
            } else {
                NdrOutputStream ndrOutputStream = new NdrOutputStream();
                ndrOutputStream.writeInt(1);
                ndrOutputStream.writeInt(n2);
                ndrOutputStream.writeInt(2);
                ndrOutputStream.writeChar(s);
                ndrOutputStream.writeInt(0);
                ndrOutputStream.writeUTF(sTUserStatus.getStatusDescription());
                channel.accept(channel.getEncLevel(), ndrOutputStream.toByteArray());
                new Im(channel, n2, true, this, channel.getRemoteInfo());
            }
        }
        catch (IOException iOException) {
            if (this.m_logger.isLoggable(Level.FINER)) {
                this.m_logger.logp(Level.FINER, this.getClass().getName(), "channelReceived", this + "Failed on channelAccepted" + iOException.getMessage(), iOException);
            }
            iOException.printStackTrace();
        }
    }

    private boolean isTypeSupported(int n) {
        return this.m_supportedImTypes.contains(new Integer(n));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int registerImType(int n) {
        Vector vector = this.m_supportedImTypes;
        synchronized (vector) {
            if (this.m_supportedImTypes.contains(new Integer(n))) {
                return -2147475452;
            }
            this.m_supportedImTypes.addElement(new Integer(n));
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int unregisterImType(int n) {
        Vector vector = this.m_supportedImTypes;
        synchronized (vector) {
            if (!this.m_supportedImTypes.removeElement(new Integer(n))) {
                return -2147475451;
            }
            return 0;
        }
    }

    void notifyImReceived(Im im) {
        Vector vector = (Vector)this.m_listeners.clone();
        Enumeration enumeration = vector.elements();
        ImEvent imEvent = new ImEvent(im, 6);
        while (enumeration.hasMoreElements()) {
            ((ImServiceListener)enumeration.nextElement()).imReceived(imEvent);
        }
    }
}

