/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.guiutils.tree;

import java.awt.Color;
import java.awt.Font;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.util.Vector;

public class TreeNode {
    protected static Font FONT = new Font("Dialog", 0, 12);
    protected static Color BACKGROUND = SystemColor.window;
    protected static Color FOREGROUND;
    protected static Color SELECTION_BACKGROUND;
    protected static Color SELECTION_FOREGROUND;
    protected Object m_key;
    protected String m_value;
    protected String m_desc;
    protected Image m_icon;
    private boolean m_selected = false;
    protected Rectangle m_area = new Rectangle();
    private boolean m_expanded = true;
    protected int m_nbOfLeftColumns = 0;
    protected int m_nbOfRightColumns = 0;
    protected Vector m_leftData = null;
    protected Vector m_rightData = null;

    protected TreeNode(Object object, String string) {
        this.m_key = object;
        this.m_value = string;
    }

    protected TreeNode(Object object, String string, Image image) {
        this(object, string);
        this.m_icon = image;
    }

    protected TreeNode(Object object, String string, Image image, Vector vector, Vector vector2) {
        this(object, string, image);
        if (vector == null) {
            vector = new Vector();
        }
        this.m_nbOfLeftColumns = vector.size();
        if (vector2 == null) {
            vector2 = new Vector();
        }
        this.m_nbOfRightColumns = vector2.size();
        this.m_leftData = vector;
        this.m_rightData = vector2;
    }

    protected boolean isExpanded() {
        return this.m_expanded;
    }

    public void setExpanded(boolean bl) {
        this.m_expanded = bl;
    }

    protected void setSelected(boolean bl) {
        this.m_selected = bl;
    }

    protected boolean isSelected() {
        return this.m_selected;
    }

    protected void setArea(int n, int n2, int n3, int n4) {
        this.m_area.x = n;
        this.m_area.y = n2;
        this.m_area.width = n3;
        this.m_area.height = n4;
    }

    public void setIcon(Image image) {
        this.m_icon = image;
    }

    public void setValue(String string) {
        this.m_value = string;
    }

    public void setKey(Object object) {
        this.m_key = object;
    }

    protected boolean contains(Point point) {
        return this.m_area.contains(point);
    }

    public Object getKey() {
        return this.m_key;
    }

    public String getValue() {
        return this.m_value;
    }

    protected int getLevel() {
        return 0;
    }

    protected Font getFont() {
        return FONT;
    }

    protected Color getBackground() {
        if (this.m_selected) {
            return FOREGROUND;
        }
        return BACKGROUND;
    }

    protected Color getForeground() {
        if (this.m_selected) {
            return BACKGROUND;
        }
        return FOREGROUND;
    }

    protected int getNbOfLeftColumns() {
        return this.m_nbOfLeftColumns;
    }

    protected int getNbOfRightColumns() {
        return this.m_nbOfRightColumns;
    }

    public Vector getLeftData() {
        return this.m_leftData;
    }

    public Vector getRightData() {
        return this.m_rightData;
    }

    public String getDescription() {
        return this.m_value;
    }

    public boolean equals(TreeNode treeNode) {
        return treeNode.m_key.equals(this.m_key) && treeNode.m_value.equals(this.m_value);
    }

    static {
        SELECTION_BACKGROUND = FOREGROUND = Color.black;
        SELECTION_FOREGROUND = BACKGROUND;
    }
}

