/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.guiutils.chat;

import com.lotus.sametime.guiutils.chat.ChatArea;
import com.lotus.sametime.guiutils.chat.ChatLine;
import com.lotus.sametime.guiutils.chat.ChatSelection;
import com.lotus.sametime.guiutils.chat.ChatTranscript;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.lang.reflect.Method;
import java.text.BreakIterator;
import java.util.Locale;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ChatParagraph {
    private static final boolean LEFT_TO_RIGHT = false;
    private static final boolean RIGHT_TO_LEFT = true;
    private static final String HTTP_STRING = "http";
    private static final String HTTPS_STRING = "https";
    private static final String FTP_STRING = "ftp";
    private static final String FILE_STRING = "file";
    private static final String URL_PREFIX = "://";
    private static final String WWW_STRING = "www.";
    protected ChatTranscript m_transcript;
    protected int m_transcriptWidth = 0;
    protected Color m_paraColor;
    protected boolean m_paraDirection;
    protected String m_paraText;
    protected Vector m_paraLines = new Vector();
    protected int m_paraIdx;
    private Logger m_logger = Logger.getLogger("com.lotus.sametime.guiutils.chat");

    protected ChatParagraph(ChatTranscript chatTranscript, Color color, String string, String string2, int n, boolean bl) {
        this.m_transcript = chatTranscript;
        this.m_paraColor = color;
        this.m_paraDirection = bl;
        this.m_paraIdx = n;
        chatTranscript.m_paraArray[n] = this;
        if (string.equals("")) {
            this.m_paraText = string2;
            this.addLine(0, string2.length());
        } else {
            this.m_paraText = string + " " + string2;
            this.addLine(0, string.length() + 1);
        }
        this.calcLines();
    }

    protected ChatParagraph(ChatTranscript chatTranscript, Color color, String string, String string2, int n) {
        this(chatTranscript, color, string, string2, n, false);
    }

    protected void recalcLines() {
        ChatLine chatLine = this.getParaLine(0);
        this.m_paraLines.removeAllElements();
        Point point = new Point(this.m_transcript.computeLineXPos(0), this.m_transcript.computeLineYPos(this.m_paraIdx, 0));
        chatLine.setLinePosition(point);
        this.m_paraLines.addElement(chatLine);
        this.calcLines();
    }

    private void calcLines() {
        int n = this.m_transcript.getTranscriptWidth();
        if (n <= 0) {
            return;
        }
        if (this.m_transcriptWidth != n) {
            this.m_transcriptWidth = n;
            BreakIterator breakIterator = this.getLineBreakIterator();
            int n2 = this.getParaLine(0).getLineLength();
            String string = this.m_paraText.substring(n2, this.m_paraText.length());
            breakIterator.setText(string);
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = breakIterator.next();
            int n7 = 0;
            FontMetrics fontMetrics = this.m_transcript.getFontMetrics();
            while (n6 != -1) {
                boolean bl;
                String string2 = string.substring(n5, n6);
                n4 = fontMetrics.stringWidth(string2);
                boolean bl2 = bl = n3 + n4 <= this.m_transcriptWidth;
                if (bl && (string2.endsWith("\n") || string2.endsWith("\r"))) {
                    this.addLine(n7, n6);
                    n3 = 0;
                    n7 = n6;
                } else {
                    if (!bl) {
                        if (n4 > this.m_transcriptWidth) {
                            BreakIterator breakIterator2 = this.getCharBreakIterator();
                            string2 = string.substring(n7, n6);
                            breakIterator2.setText(string2);
                            int n8 = n6;
                            n5 = n7;
                            n6 = breakIterator2.next() + n7;
                            String string3 = string.substring(n5, n6);
                            n4 = fontMetrics.stringWidth(string3);
                            if (n6 < n8) {
                                int n9 = breakIterator2.next() + n7;
                                string3 = string.substring(n5, n9);
                                int n10 = fontMetrics.stringWidth(string3);
                                while (n10 < this.m_transcriptWidth) {
                                    n6 = n9;
                                    n9 = breakIterator2.next() + n7;
                                    string3 = string.substring(n5, n9);
                                    n10 = fontMetrics.stringWidth(string3);
                                }
                                if (n10 > this.m_transcriptWidth) {
                                    --n6;
                                }
                            }
                            this.addLine(n7, n6);
                            n7 = n6;
                            n3 = 0;
                            n5 = n6;
                            n6 = n8;
                            continue;
                        }
                        this.addLine(n7, n5);
                        n7 = n5;
                        n3 = 0;
                        if (string2.endsWith("\n") || string2.endsWith("\r")) {
                            this.addLine(n7, n6);
                            n7 = n6;
                            n4 = 0;
                        }
                    }
                    n3 += n4;
                }
                n5 = n6;
                n6 = breakIterator.next();
            }
            if (n3 > 0) {
                this.addLine(n7, n5);
            }
            this.m_transcript.setTextHeight(this);
        }
    }

    private void addLine(int n, int n2) {
        int n3 = this.m_paraLines.size();
        Point point = new Point(this.m_transcript.computeLineXPos(n3), this.m_transcript.computeLineYPos(this.m_paraIdx, n3));
        ChatLine chatLine = new ChatLine(this, point, n, n2);
        if (n3 > 0) {
            Vector vector = this.buildLineSegments(n3);
            chatLine.setLineSegments(vector);
        }
    }

    protected void paintParagraph(Graphics graphics) {
        FontMetrics fontMetrics = this.m_transcript.getFontMetrics();
        int n = fontMetrics.getAscent();
        for (int i = 0; i < this.m_paraLines.size(); ++i) {
            String string = this.getLineTextByLineNo(i);
            Point point = this.getLinePosByLineNo(i);
            ChatLine chatLine = this.getParaLine(i);
            Vector vector = chatLine.getLineSegments();
            if (vector != null) {
                int n2 = point.y + n;
                int n3 = point.x;
                for (int j = 0; j < vector.size(); ++j) {
                    int n4 = chatLine.getSegmentStart(j);
                    int n5 = chatLine.getSegmentStart(j + 1);
                    boolean bl = chatLine.segmentIsURL(j);
                    if (bl) {
                        this.m_transcript.getArea();
                        graphics.setColor(ChatArea.m_urlColor);
                    } else {
                        graphics.setColor(this.m_paraColor);
                    }
                    String string2 = string.substring(n4, n5);
                    graphics.drawString(string2, n3, n2);
                    int n6 = fontMetrics.stringWidth(string2);
                    if (bl) {
                        graphics.drawLine(n3, n2 + 2, n3 + n6, n2 + 2);
                    }
                    n3 += n6;
                }
                continue;
            }
            graphics.setColor(this.m_paraColor);
            graphics.drawString(string.trim(), point.x, point.y + n);
        }
    }

    private Vector buildLineSegments(int n) {
        int n2;
        String string;
        int n3;
        Object object;
        Vector vector;
        Vector<ChatSelection> vector2 = null;
        String string2 = this.getLineTextByLineNo(n);
        int n4 = this.getParaLine(n).getLineLength();
        String string3 = string2.toLowerCase();
        int n5 = string3.indexOf(HTTP_STRING);
        int n6 = string3.indexOf(HTTPS_STRING);
        int n7 = string3.indexOf(FTP_STRING);
        int n8 = string3.indexOf(FILE_STRING);
        int n9 = string3.indexOf(WWW_STRING);
        boolean bl = n5 > -1 || n7 > -1 || n8 > -1;
        int n10 = 0;
        boolean bl2 = false;
        if (n > 0 && (vector = ((ChatLine)(object = this.getParaLine(n - 1))).getLineSegments()) != null) {
            ChatSelection chatSelection = (ChatSelection)vector.lastElement();
            n10 = chatSelection.getParaIdx();
            n3 = n10 > 0 ? 1 : 0;
            string = this.getLineTextByLineNo(n - 1);
            n2 = this.getParaLine(n - 1).getLineLength();
            boolean bl3 = Character.isWhitespace(string.charAt(n2 - 1));
            boolean bl4 = bl2 = n3 != 0 && !bl3;
        }
        if (bl2 || bl || n9 > -1) {
            object = this.getWordBreakIterator();
            ((BreakIterator)object).setText(string3);
            int n11 = 0;
            int n12 = ((BreakIterator)object).next();
            n3 = 0;
            n2 = 0;
            while (n12 != -1) {
                string = string3.substring(n11, n12);
                n2 = string.startsWith(HTTP_STRING) || string.startsWith(HTTPS_STRING) || string.startsWith(FTP_STRING) || string.startsWith(FILE_STRING) ? 1 : 0;
                int n13 = n2 = n2 != 0 && string3.length() > n12 + 3 && string3.regionMatches(n12, URL_PREFIX, 0, 3) ? 1 : 0;
                if (n2 != 0 || bl2 || string.startsWith(WWW_STRING)) {
                    ChatSelection chatSelection;
                    if (n2 != 0) {
                        n12 = ((BreakIterator)object).next();
                        n12 = ((BreakIterator)object).next();
                        n12 = ((BreakIterator)object).next();
                    }
                    while (n12 < n4 && !Character.isWhitespace(string3.charAt(n12))) {
                        n12 = ((BreakIterator)object).next();
                    }
                    if (vector2 == null) {
                        vector2 = new Vector<ChatSelection>();
                    }
                    if (bl2) {
                        chatSelection = new ChatSelection(n10 + 1, n3);
                        vector2.addElement(chatSelection);
                        bl2 = false;
                    } else {
                        if (n11 > n3) {
                            ChatSelection chatSelection2 = new ChatSelection(0, n3);
                            vector2.addElement(chatSelection2);
                        }
                        n3 = n11;
                        chatSelection = new ChatSelection(1, n3);
                        vector2.addElement(chatSelection);
                    }
                    n3 = n12;
                }
                n11 = n12;
                n12 = ((BreakIterator)object).next();
            }
            if (n11 > n3 && vector2 != null) {
                ChatSelection chatSelection = new ChatSelection(0, n3);
                vector2.addElement(chatSelection);
            }
        }
        return vector2;
    }

    protected ChatTranscript getTranscript() {
        return this.m_transcript;
    }

    protected String getParaText() {
        return this.m_paraText;
    }

    protected int getParaLength() {
        return this.m_paraText.length();
    }

    protected Color getParaColor() {
        return this.m_paraColor;
    }

    protected boolean getParaDirection() {
        return this.m_paraDirection;
    }

    protected Vector getParaLines() {
        return this.m_paraLines;
    }

    protected void setParaColor(Color color) {
        this.m_paraColor = color;
    }

    protected void setParaDirection(boolean bl) {
        this.m_paraDirection = bl;
    }

    protected ChatLine getParaLine(int n) {
        return (ChatLine)this.m_paraLines.elementAt(n);
    }

    protected Point getLinePosByLineNo(int n) {
        ChatLine chatLine = this.getParaLine(n);
        return chatLine.getLinePosition();
    }

    protected ChatLine getLineByPos(Point point) {
        ChatLine chatLine;
        int n = 0;
        if (this.m_paraLines.size() > 1) {
            chatLine = (ChatLine)this.m_paraLines.elementAt(1);
            if (chatLine.getLinePosition().x <= point.x) {
                n = 1;
            } else {
                chatLine = (ChatLine)this.m_paraLines.elementAt(0);
            }
        } else {
            chatLine = (ChatLine)this.m_paraLines.elementAt(0);
        }
        while (point.y > chatLine.getLinePosition().y + this.m_transcript.getLineHeight()) {
            if (++n == this.m_paraLines.size()) {
                chatLine = null;
                break;
            }
            chatLine = (ChatLine)this.m_paraLines.elementAt(n);
        }
        return chatLine;
    }

    protected String getLineTextByLineNo(int n) {
        ChatLine chatLine = this.getParaLine(n);
        return this.m_paraText.substring(chatLine.getStartOffset(), chatLine.getEndOffset());
    }

    protected String getTextByOffsets(int n, int n2) {
        return this.m_paraText.substring(n, n2);
    }

    protected int getNbOfLines() {
        return this.m_paraLines.size();
    }

    protected int getParaIdx() {
        return this.m_paraIdx;
    }

    protected void updatePara(int n, int n2) {
        this.m_paraIdx -= n;
        for (int i = 0; i < this.m_paraLines.size(); ++i) {
            ChatLine chatLine = this.getParaLine(i);
            chatLine.adjustLinePositionY(n2);
        }
    }

    protected boolean IsVisible(int n, int n2) {
        int n3 = this.getLinePosByLineNo((int)0).y;
        int n4 = this.m_transcript.computeLineYPos(this.m_paraIdx + 1, 0);
        return n3 >= n && n3 < n2 || n4 <= n2 && n4 > n || n3 <= n && n4 >= n2;
    }

    Point getPosInParaByOffset(int n, boolean bl) {
        int n2;
        if (bl) {
            n2 = 0;
            if (n > 0) {
                n2 = this.findLineIdxByStartOffset(n);
            }
        } else {
            n2 = this.findLineIdxByEndOffset(n, 0);
        }
        ChatLine chatLine = (ChatLine)this.m_paraLines.elementAt(n2);
        return chatLine.getPosInLineByOffset(this.m_transcript.getFontMetrics(), n);
    }

    protected void highlightPara(Graphics graphics, int n, int n2) {
        int n3 = 0;
        int n4 = this.m_paraLines.size() - 1;
        if (n > 0) {
            n3 = this.findLineIdxByStartOffset(n);
        }
        if (n2 != -1) {
            n4 = this.findLineIdxByEndOffset(n2, n3);
        }
        int n5 = n;
        int n6 = -1;
        FontMetrics fontMetrics = this.m_transcript.getFontMetrics();
        for (int i = n3; i <= n4; ++i) {
            if (i > n3) {
                n5 = -1;
            }
            if (i == n4) {
                n6 = n2;
            }
            ChatLine chatLine = (ChatLine)this.m_paraLines.elementAt(i);
            chatLine.highlightLine(graphics, fontMetrics, n5, n6);
        }
    }

    public int findLineIdxByStartOffset(int n) {
        int n2 = 0;
        int n3 = this.m_paraLines.size() - 1;
        if (n > 0) {
            ChatLine chatLine = (ChatLine)this.m_paraLines.elementAt(n2);
            while (n2 < n3 && chatLine.getEndOffset() <= n) {
                chatLine = (ChatLine)this.m_paraLines.elementAt(++n2);
            }
        }
        return n2;
    }

    protected int findLineIdxByEndOffset(int n, int n2) {
        int n3 = n2;
        int n4 = this.m_paraLines.size() - 1;
        if (n3 < n4) {
            ChatLine chatLine = (ChatLine)this.m_paraLines.elementAt(n3);
            while (n3 < n4 && chatLine.getEndOffset() < n) {
                chatLine = (ChatLine)this.m_paraLines.elementAt(++n3);
            }
        }
        return n3;
    }

    public BreakIterator getCharBreakIterator() {
        BreakIterator breakIterator = this.loadDynamic("getCharacterInstance");
        if (null == breakIterator) {
            breakIterator = BreakIterator.getCharacterInstance();
        }
        return breakIterator;
    }

    public BreakIterator getLineBreakIterator() {
        BreakIterator breakIterator = this.loadDynamic("getLineInstance");
        if (null == breakIterator) {
            breakIterator = BreakIterator.getLineInstance();
        }
        return breakIterator;
    }

    public BreakIterator getWordBreakIterator() {
        BreakIterator breakIterator = this.loadDynamic("getWordInstance");
        if (null == breakIterator) {
            breakIterator = BreakIterator.getWordInstance();
        }
        return breakIterator;
    }

    private BreakIterator loadDynamic(String string) {
        BreakIterator breakIterator;
        block4: {
            breakIterator = null;
            try {
                Class<?> clazz = Class.forName("lotus.fc.util.cbreak.CBreakIterator");
                if (this.m_logger.isLoggable(Level.FINEST)) {
                    this.m_logger.logp(Level.FINEST, this.getClass().getName(), "loadDynamic", "Class Loaded for generating Iterator: " + clazz.toString());
                }
                Class[] classArray = new Class[]{Locale.class};
                Method method = clazz.getMethod(string, classArray);
                Object[] objectArray = new Object[]{Locale.getDefault()};
                breakIterator = (BreakIterator)method.invoke(null, objectArray);
                if (this.m_logger.isLoggable(Level.FINEST)) {
                    this.m_logger.logp(Level.FINEST, this.getClass().getName(), "loadDynamic", "Iterator class: " + breakIterator.getClass().toString());
                }
            }
            catch (Exception exception) {
                if (!this.m_logger.isLoggable(Level.FINEST)) break block4;
                this.m_logger.logp(Level.FINEST, this.getClass().getName(), "loadDynamic", "Exception in loading BreakIterator: " + exception);
            }
        }
        return breakIterator;
    }
}

