/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.filetransferui;

import com.lotus.sametime.awareness.AttributeAdapter;
import com.lotus.sametime.awareness.AttributeEvent;
import com.lotus.sametime.awareness.AwarenessService;
import com.lotus.sametime.awareness.STWatchedUser;
import com.lotus.sametime.awareness.WatchList;
import com.lotus.sametime.community.CommunityService;
import com.lotus.sametime.community.LoginAdapter;
import com.lotus.sametime.community.LoginEvent;
import com.lotus.sametime.core.comparch.DuplicateObjectException;
import com.lotus.sametime.core.comparch.STComp;
import com.lotus.sametime.core.comparch.STCompApi;
import com.lotus.sametime.core.comparch.STSession;
import com.lotus.sametime.core.types.STExtendedAttribute;
import com.lotus.sametime.core.types.STUser;
import com.lotus.sametime.core.types.STUserStatus;
import com.lotus.sametime.filetransfer.FileTransfer;
import com.lotus.sametime.filetransfer.FileTransferEvent;
import com.lotus.sametime.filetransfer.FileTransferService;
import com.lotus.sametime.filetransfer.FileTransferServiceListener;
import com.lotus.sametime.filetransferui.FileTransferUI;
import com.lotus.sametime.filetransferui.FileTransferUIEvent;
import com.lotus.sametime.filetransferui.FileTransferUIListener;
import com.lotus.sametime.filetransferui.ReceiveFileDialog;
import com.lotus.sametime.filetransferui.SendFileDialog;
import com.lotus.sametime.guiutils.misc.UbqDialog;
import com.lotus.sametime.resourceloader.ResourceLoaderService;
import com.lotus.sametime.resourceloader.STBundle;
import java.awt.Frame;
import java.awt.Image;
import java.util.Enumeration;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FileTransferUIComp
extends STComp
implements FileTransferUI {
    public static final int FILE_TRANSFER_NOT_SUPPORTED = 0;
    public static final int FILE_TRANSFER_UNLIMITED = -1;
    private static String BUNDLE_FILE_NAME = "properties/filetransferui";
    private Vector m_listeners = new Vector();
    private STSession m_session;
    private STBundle m_resource;
    private FileTransferService m_fileTransSvc;
    private AwarenessService m_awarenessSvc;
    private CommunityService m_comm;
    private ResourceLoaderService m_resourceSvc;
    private FileTransferServiceEventHandler m_ftServiceListener;
    private WatchList m_watchList;
    private AttributeEventHandler m_attrEventHandler;
    private LoginEventHandler m_loginEventHandler;
    private boolean m_loggedIn;
    private boolean m_fileTransferAllowed;
    private Logger m_logger = Logger.getLogger("com.lotus.sametime.filetransferui");

    public FileTransferUIComp(STSession sTSession) throws DuplicateObjectException {
        super("com.lotus.sametime.filetransferui.FileTransferUIComp", sTSession);
        this.m_session = sTSession;
        this.m_session.registerComponent(this.getName(), this);
        try {
            this.m_session.setSessionProperty("defaultSendDir", System.getProperty("user.home"));
            this.m_session.setSessionProperty("defaultSaveDir", System.getProperty("user.home"));
        }
        catch (SecurityException securityException) {
            System.out.println("FileTransferUI - No privilege to get property user.home");
        }
        this.m_session.setSessionProperty("fileTransferMaxFileSize", new Integer(0));
        this.m_fileTransSvc = (FileTransferService)this.m_session.getCompApi("com.lotus.sametime.filetransfer.FileTransferComp");
        this.m_ftServiceListener = new FileTransferServiceEventHandler();
        this.m_fileTransSvc.addFileTransferServiceListener(this.m_ftServiceListener);
        this.m_resourceSvc = (ResourceLoaderService)((Object)this.m_session.getCompApi("com.lotus.sametime.resourceloader.ResourceLoaderComp"));
        this.m_awarenessSvc = (AwarenessService)this.m_session.getCompApi("com.lotus.sametime.awareness.AwarenessComp");
        if (this.m_awarenessSvc != null) {
            this.m_watchList = this.m_awarenessSvc.createWatchList();
            this.m_attrEventHandler = new AttributeEventHandler();
            this.m_watchList.addAttrListener(this.m_attrEventHandler);
            STExtendedAttribute sTExtendedAttribute = new STExtendedAttribute(6);
            this.m_awarenessSvc.changeMyAttr(sTExtendedAttribute);
        }
        this.m_loggedIn = false;
        this.m_fileTransferAllowed = false;
        this.m_comm = (CommunityService)this.m_session.getCompApi("com.lotus.sametime.community.STBase");
        this.m_loginEventHandler = new LoginEventHandler();
        if (this.m_comm != null) {
            this.m_comm.addLoginListener(this.m_loginEventHandler);
        }
    }

    protected void start() {
        if (this.m_logger.isLoggable(Level.FINER)) {
            this.m_logger.logp(Level.FINER, this.getClass().getName(), "start", this + " Started");
        }
        if (this.m_resourceSvc != null) {
            this.m_resource = this.m_resourceSvc.getBundle(BUNDLE_FILE_NAME);
        }
    }

    protected void componentLoaded(STCompApi sTCompApi) {
        if (this.m_fileTransSvc == null && sTCompApi instanceof FileTransferService) {
            this.m_fileTransSvc = (FileTransferService)sTCompApi;
            if (this.m_fileTransSvc != null && this.m_awarenessSvc != null && this.m_loggedIn) {
                this.checkIfServerSupportsFileTransfer();
            }
        }
        if (this.m_awarenessSvc == null && sTCompApi instanceof AwarenessService) {
            this.m_awarenessSvc = (AwarenessService)sTCompApi;
            this.m_watchList = this.m_awarenessSvc.createWatchList();
            this.m_attrEventHandler = new AttributeEventHandler();
            this.m_watchList.addAttrListener(this.m_attrEventHandler);
            if (this.m_fileTransSvc != null && this.m_awarenessSvc != null && this.m_loggedIn) {
                this.checkIfServerSupportsFileTransfer();
            }
            STExtendedAttribute sTExtendedAttribute = new STExtendedAttribute(6);
            this.m_awarenessSvc.changeMyAttr(sTExtendedAttribute);
        }
        if (this.m_comm == null && sTCompApi instanceof CommunityService) {
            this.m_comm = (CommunityService)sTCompApi;
            if (this.m_comm != null) {
                this.m_comm.addLoginListener(this.m_loginEventHandler);
            }
        }
        if (this.m_resourceSvc == null && sTCompApi instanceof ResourceLoaderService) {
            this.m_resourceSvc = (ResourceLoaderService)((Object)this.m_session.getCompApi("com.lotus.sametime.resourceloader.ResourceLoaderComp"));
            if (this.m_resourceSvc != null) {
                this.m_resource = this.m_resourceSvc.getBundle(BUNDLE_FILE_NAME);
            }
        }
    }

    protected void stop() {
        if (this.m_logger.isLoggable(Level.FINER)) {
            this.m_logger.logp(Level.FINER, this.getClass().getName(), "stop", this + " Stopped");
        }
        this.m_watchList.reset();
        this.m_watchList.removeAttrListener(this.m_attrEventHandler);
        this.m_fileTransSvc.removeFileTransferServiceListener(this.m_ftServiceListener);
    }

    private void checkIfServerSupportsFileTransfer() {
        int[] nArray = new int[]{9009};
        this.m_awarenessSvc.addToAttrFilter(nArray);
        this.m_watchList.addItem(this.m_comm.getLogin().getServer());
    }

    private void fileTransferAllowed(Integer n) {
        if (!this.m_fileTransferAllowed) {
            this.m_fileTransferAllowed = true;
            if (n <= 0) {
                this.m_session.setSessionProperty("fileTransferMaxFileSize", new Integer(-1));
            } else {
                this.m_session.setSessionProperty("fileTransferMaxFileSize", n);
            }
        }
    }

    private void fileTransferNotAllowed() {
        this.m_fileTransferAllowed = false;
        this.m_session.setSessionProperty("fileTransferMaxFileSize", new Integer(0));
    }

    public void addFileTransferUIListener(FileTransferUIListener fileTransferUIListener) {
        Vector vector = (Vector)this.m_listeners.clone();
        vector.addElement(fileTransferUIListener);
        this.m_listeners = vector;
    }

    public void removeFileTransferUIListener(FileTransferUIListener fileTransferUIListener) {
        Vector vector = (Vector)this.m_listeners.clone();
        vector.removeElement(fileTransferUIListener);
        this.m_listeners = vector;
    }

    public void sendFile(STUser sTUser) {
        int n = (Integer)this.m_session.getSessionProperty("fileTransferMaxFileSize");
        if (n == 0) {
            if (this.m_logger.isLoggable(Level.FINER)) {
                this.m_logger.logp(Level.FINER, this.getClass().getName(), "sendFile", "FTUI: Send file request with no server support?");
            }
            return;
        }
        if (sTUser instanceof STWatchedUser) {
            this.sendFileToWatchedUser((STWatchedUser)sTUser);
            return;
        }
        STUserStatus sTUserStatus = this.m_awarenessSvc.findUserStatus(sTUser);
        if (sTUserStatus != null && sTUserStatus.isStatus((short)128)) {
            this.showDndError();
            return;
        }
        this.openSendFileDialog(sTUser);
    }

    private void sendFileToWatchedUser(STWatchedUser sTWatchedUser) {
        if (sTWatchedUser.getStatus().isStatus((short)128)) {
            this.showDndError();
            return;
        }
        if (!sTWatchedUser.getAttributes().containsKey(new Integer(6))) {
            this.showOldUserError();
            return;
        }
        this.openSendFileDialog(sTWatchedUser);
    }

    private void openSendFileDialog(STUser sTUser) {
        SendFileDialog sendFileDialog = new SendFileDialog(this.getMainFrame(), this.m_session, sTUser);
    }

    void showErrorMessage(String string, String string2, String string3, boolean bl, boolean bl2) {
        Image image = this.m_resourceSvc.getImage("images/alert.gif");
        UbqDialog ubqDialog = new UbqDialog(this.getMainFrame(), this.m_resource.getString(string), this.m_resource.formatStringArray(string2), this.m_resource.formatStringArray(string3));
        if (bl) {
            ubqDialog.setImage(image);
        }
        ubqDialog.setModal(bl2);
        ubqDialog.setVisible(true);
    }

    private void showDndError() {
        this.showErrorMessage("NO_FILE_TRANSFER_TO_DND_TITLE", "NO_FILE_TRANSFER_TO_DND_TEXT", "NO_FILE_TRANSFER_TO_DND_BTN_OK", true, false);
    }

    private void showOldUserError() {
        this.showErrorMessage("FT_NOT_SUPPORTED_TITLE", "FT_NOT_SUPPORTED_TEXT", "FT_NOT_SUPPORTED_BTN_OK", true, false);
    }

    private Frame getMainFrame() {
        Frame frame = (Frame)this.m_session.getSessionProperty("mainFrame");
        return frame == null ? new Frame() : frame;
    }

    protected static String[] fileSizeToString(int n, STBundle sTBundle) {
        String string;
        String string2;
        String string3 = sTBundle.getString("KB");
        String string4 = sTBundle.getString("MB");
        if (n < 1000) {
            string2 = new Integer(n).toString();
            string = string3;
        } else {
            float f = n / 10;
            string2 = new Float((double)f / 100.0).toString();
            string = string4;
        }
        String[] stringArray = new String[]{string2, string};
        return stringArray;
    }

    void transferCompleted(FileTransfer fileTransfer, STUser sTUser, STUser sTUser2) {
        FileTransferUIEvent fileTransferUIEvent = new FileTransferUIEvent(this, 1, fileTransfer.getFileName(), sTUser, sTUser2, fileTransfer.getFileSize());
        this.dispatchEvent(fileTransferUIEvent);
    }

    void transferFailed(FileTransfer fileTransfer, STUser sTUser, STUser sTUser2, int n) {
        FileTransferUIEvent fileTransferUIEvent = new FileTransferUIEvent(this, 2, fileTransfer.getFileName(), sTUser, sTUser2, fileTransfer.getFileSize(), n);
        this.dispatchEvent(fileTransferUIEvent);
    }

    private void dispatchEvent(FileTransferUIEvent fileTransferUIEvent) {
        Enumeration enumeration = this.m_listeners.elements();
        while (enumeration.hasMoreElements()) {
            FileTransferUIListener fileTransferUIListener = (FileTransferUIListener)enumeration.nextElement();
            switch (fileTransferUIEvent.getId()) {
                case 1: {
                    fileTransferUIListener.fileTransferCompleted(fileTransferUIEvent);
                    break;
                }
                case 2: {
                    fileTransferUIListener.fileTransferFailed(fileTransferUIEvent);
                }
            }
        }
    }

    public void setDefaultSaveDirectory(String string) {
        this.m_session.setSessionProperty("defaultSaveDir", string);
    }

    private class FileTransferServiceEventHandler
    implements FileTransferServiceListener {
        private FileTransferServiceEventHandler() {
        }

        public void FileTransferInitiated(FileTransferEvent fileTransferEvent) {
            if (!FileTransferUIComp.this.m_fileTransferAllowed) {
                fileTransferEvent.getFileTransfer().decline(-2147483510);
            } else {
                ReceiveFileDialog receiveFileDialog = new ReceiveFileDialog(FileTransferUIComp.this.getMainFrame(), FileTransferUIComp.this.m_session, fileTransferEvent.getFileTransfer());
            }
        }
    }

    private class LoginEventHandler
    extends LoginAdapter {
        private LoginEventHandler() {
        }

        public void loggedIn(LoginEvent loginEvent) {
            FileTransferUIComp.this.m_loggedIn = true;
            if (FileTransferUIComp.this.m_fileTransSvc != null && FileTransferUIComp.this.m_awarenessSvc != null) {
                FileTransferUIComp.this.checkIfServerSupportsFileTransfer();
            }
        }

        public void loggedOut(LoginEvent loginEvent) {
            FileTransferUIComp.this.m_loggedIn = false;
            FileTransferUIComp.this.m_watchList.reset();
            FileTransferUIComp.this.fileTransferNotAllowed();
        }
    }

    private class AttributeEventHandler
    extends AttributeAdapter {
        private AttributeEventHandler() {
        }

        public void attrRemoved(AttributeEvent attributeEvent) {
            if (attributeEvent.getAttributeKey() == 9009) {
                FileTransferUIComp.this.fileTransferNotAllowed();
            }
        }

        public void attrChanged(AttributeEvent attributeEvent) {
            STExtendedAttribute[] sTExtendedAttributeArray = attributeEvent.getAttributeList();
            for (int i = 0; i < sTExtendedAttributeArray.length; ++i) {
                if (sTExtendedAttributeArray[i].getKey() != 9009) continue;
                FileTransferUIComp.this.fileTransferAllowed(new Integer(sTExtendedAttributeArray[i].getInt()));
            }
        }
    }
}

