/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.directoryui;

import com.lotus.sametime.community.CommunityService;
import com.lotus.sametime.community.LoginEvent;
import com.lotus.sametime.community.LoginListener;
import com.lotus.sametime.core.comparch.STSession;
import com.lotus.sametime.core.types.STGroup;
import com.lotus.sametime.core.types.STObject;
import com.lotus.sametime.core.types.STObjectImpl;
import com.lotus.sametime.core.types.STUser;
import com.lotus.sametime.directory.Directory;
import com.lotus.sametime.directory.DirectoryEvent;
import com.lotus.sametime.directory.DirectoryListener;
import com.lotus.sametime.directory.DirectoryService;
import com.lotus.sametime.directory.DirectoryServiceListener;
import com.lotus.sametime.directoryui.DirectoryListModel;
import com.lotus.sametime.directoryui.DirectoryListView;
import com.lotus.sametime.directoryui.DirectoryListViewEvent;
import com.lotus.sametime.directoryui.DirectoryListViewListener;
import com.lotus.sametime.directoryui.DirectoryNode;
import com.lotus.sametime.guiutils.accessibility.KeyAction;
import com.lotus.sametime.guiutils.misc.ButtonsPanel;
import com.lotus.sametime.guiutils.misc.ImageButton;
import com.lotus.sametime.guiutils.misc.STTextField;
import com.lotus.sametime.guiutils.misc.UbqDialog;
import com.lotus.sametime.guiutils.tree.CellData;
import com.lotus.sametime.guiutils.tree.ColumnAttributes;
import com.lotus.sametime.guiutils.tree.ContentProvider;
import com.lotus.sametime.guiutils.tree.McListView;
import com.lotus.sametime.guiutils.tree.TreeNode;
import com.lotus.sametime.guiutils.tree.ViewListener;
import com.lotus.sametime.resourceloader.ResourceLoaderService;
import com.lotus.sametime.resourceloader.STBundle;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.text.BreakIterator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DirectoryPanel
extends Panel
implements ContentProvider {
    private int PADDING = 5;
    private static String BUNDLE_FILE_NAME = "properties/directoryui";
    private static String COMM_BUNDLE_FILE_NAME = "properties/commui";
    private STBundle m_res;
    private ResourceLoaderService m_resService;
    private Choice m_dirsTitles;
    private STTextField m_tfSearch;
    private Button m_searchBtn;
    private String m_lastFirstNames = " ";
    private DirectoryListModel m_listModel;
    private DirectoryListView m_listView;
    private McListView m_mcListView;
    private ColumnAttributes m_fullNameColumn;
    private ImageButton m_nextBtn;
    private ImageButton m_prevBtn;
    private DirectoryService m_dirService;
    private Integer m_request;
    private Directory[] m_dirs;
    private Directory m_openDir;
    private short m_chunkSize = (short)-1;
    private Image m_groupImage;
    private Image m_userImage;
    private Vector m_listeners = new Vector();
    private CommunityService m_comm;
    private UbqDialog m_ubqDialog;
    private ActionListener m_actionListener;
    private TextListener m_textListener;
    private DirectoryListener m_directoryListener;
    private DirectoryServiceListener m_directorySrvListener;
    private ViewListener m_viewListener;
    private LoginListener m_loginListener;
    private boolean m_selectionEmpty = true;
    private Logger m_logger = Logger.getLogger("com.lotus.sametime.directoryui");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DirectoryPanel(STSession sTSession, String string) {
        this.createListeners();
        this.m_dirService = (DirectoryService)sTSession.getCompApi("com.lotus.sametime.directory.DirectoryComp");
        this.m_dirService.addDirectoryServiceListener(this.m_directorySrvListener);
        this.m_resService = (ResourceLoaderService)((Object)sTSession.getCompApi("com.lotus.sametime.resourceloader.ResourceLoaderComp"));
        this.m_res = this.m_resService.getBundle(string);
        this.m_comm = (CommunityService)sTSession.getCompApi("com.lotus.sametime.community.STBase");
        this.m_groupImage = this.m_resService.getImage("images/shortcut.gif");
        this.m_userImage = this.m_resService.getImage("images/user.gif");
        this.m_listModel = new DirectoryListModel();
        this.m_listModel.sortOnOff(false);
        this.m_mcListView = new McListView(true, null, null);
        this.m_listView = new DirectoryListView(this.m_mcListView, this.m_listModel, sTSession);
        this.m_listView.setMinNameWidth(this.m_res.getInt("SHORT_NAME_MIN_WIDTH"));
        this.m_mcListView.setTreeView(this.m_listView);
        this.m_fullNameColumn = new ColumnAttributes(null, 1, this, this.m_res.getInt("FULL_NAME_DEFAULT_WIDTH"));
        this.m_mcListView.addColumn(1, this.m_fullNameColumn);
        CellData cellData = new CellData(this.m_res.getString("SHORT_NAME"));
        this.m_mcListView.getTitleView().setNameColData(cellData);
        this.initializeUI();
        this.m_listModel.addTreeModelListener(this.m_listView);
        this.m_listView.addViewListener(this.m_viewListener);
        DirectoryPanel directoryPanel = this;
        synchronized (directoryPanel) {
            if (this.m_comm.isLoggedIn()) {
                this.m_dirService.queryAllDirectories();
                this.setCursor(Cursor.getPredefinedCursor(3));
            }
            this.m_comm.addLoginListener(this.m_loginListener);
        }
    }

    public DirectoryPanel(STSession sTSession) {
        this(sTSession, BUNDLE_FILE_NAME);
    }

    public Vector getSelectedEntries() {
        Vector vector = this.m_listView.getSelectedNodes();
        Vector<STObjectImpl> vector2 = new Vector<STObjectImpl>();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            DirectoryNode directoryNode = (DirectoryNode)enumeration.nextElement();
            if (directoryNode.getType() == 1) {
                vector2.addElement((STGroup)directoryNode.getSTObject());
                continue;
            }
            if (directoryNode.getType() != 0) continue;
            vector2.addElement((STUser)directoryNode.getSTObject());
        }
        return vector2;
    }

    protected void initializeUI() {
        Label label = new Label(this.m_res.getString("ADDRESS_BOOK"));
        this.m_dirsTitles = new Choice();
        this.m_dirsTitles.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                DirectoryPanel.this.itemStateChanged(itemEvent);
            }
        });
        Label label2 = new Label(this.m_res.getString("SEARCH_FOR_PERSON_OR_GROUP"));
        this.m_tfSearch = new STTextField();
        this.m_tfSearch.setBackground(SystemColor.window);
        this.m_tfSearch.addActionListener(this.m_actionListener);
        this.m_tfSearch.addTextListener(this.m_textListener);
        String string = this.m_res.getString("SEARCH");
        ButtonsPanel buttonsPanel = new ButtonsPanel(new String[]{string}, this.m_actionListener);
        this.m_searchBtn = buttonsPanel.getButton(string);
        Image image = this.m_resService.getImage("images/BtnNext.gif");
        Image image2 = this.m_resService.getImage("images/BtnNextD.gif");
        Image image3 = this.m_resService.getImage("images/BtnNextPressed.gif");
        this.m_nextBtn = new ImageButton(image, image2, image3, image, "");
        this.m_nextBtn.addActionListener(this.m_actionListener);
        this.m_nextBtn.setEnabled(false);
        image = this.m_resService.getImage("images/BtnPrev.gif");
        image2 = this.m_resService.getImage("images/BtnPrevD.gif");
        image3 = this.m_resService.getImage("images/BtnPrevPressed.gif");
        this.m_prevBtn = new ImageButton(image, image2, image3, image, "");
        this.m_prevBtn.setEnabled(false);
        this.m_prevBtn.addActionListener(this.m_actionListener);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        this.setLayout(gridBagLayout);
        Panel panel = new Panel(new BorderLayout());
        panel.add("North", label);
        panel.add("Center", this.m_dirsTitles);
        panel.add("South", new Panel());
        this.add(panel);
        gridBagLayout.setConstraints(panel, gridBagConstraints);
        Panel panel2 = new Panel(new BorderLayout());
        ((BorderLayout)panel2.getLayout()).setHgap(this.PADDING);
        panel2.add("North", label2);
        panel2.add("Center", this.m_tfSearch);
        panel2.add("East", buttonsPanel);
        this.add(panel2);
        gridBagLayout.setConstraints(panel2, gridBagConstraints);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.fill = 0;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.insets = new Insets(this.PADDING, 0, this.PADDING, 0);
        this.add(this.m_prevBtn);
        gridBagLayout.setConstraints(this.m_prevBtn, gridBagConstraints2);
        gridBagConstraints2.anchor = 13;
        gridBagConstraints2.gridwidth = 0;
        this.add(this.m_nextBtn);
        gridBagLayout.setConstraints(this.m_nextBtn, gridBagConstraints2);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 3 * this.PADDING, 0);
        this.add(this.m_mcListView);
        gridBagLayout.setConstraints(this.m_mcListView, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
    }

    public void cleanup() {
        if (null != this.m_ubqDialog) {
            this.m_ubqDialog.dispose();
            this.m_ubqDialog = null;
        }
        if (null != this.m_openDir) {
            this.m_openDir.close();
            this.m_openDir = null;
        }
    }

    protected void enableSubComponents(boolean bl) {
        this.m_dirsTitles.setEnabled(bl);
        this.m_listView.setEnabled(bl);
        this.m_nextBtn.setEnabled(bl);
        this.m_prevBtn.setEnabled(bl);
        this.m_tfSearch.setEnabled(bl);
        this.m_searchBtn.setEnabled(bl & this.m_dirsTitles.getSelectedItem() != null);
        if (!bl) {
            DirectoryListViewEvent directoryListViewEvent = new DirectoryListViewEvent((Object)this, 1, new Vector());
            this.sendEvent(directoryListViewEvent);
        }
    }

    public synchronized void addDirectoryListViewListener(DirectoryListViewListener directoryListViewListener) {
        Vector vector = (Vector)this.m_listeners.clone();
        vector.addElement(directoryListViewListener);
        this.m_listeners = vector;
    }

    public synchronized void removeDirectoryListViewListener(DirectoryListViewListener directoryListViewListener) {
        Vector vector = (Vector)this.m_listeners.clone();
        vector.removeElement(directoryListViewListener);
        this.m_listeners = vector;
    }

    protected void sendEvent(DirectoryListViewEvent directoryListViewEvent) {
        Vector vector = this.m_listeners;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            DirectoryListViewListener directoryListViewListener = (DirectoryListViewListener)enumeration.nextElement();
            switch (directoryListViewEvent.getId()) {
                case 2: {
                    directoryListViewListener.nodeDoubleClicked(directoryListViewEvent);
                    break;
                }
                case 1: {
                    directoryListViewListener.selectionChanged(directoryListViewEvent);
                }
            }
        }
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        int n = 10;
        Rectangle rectangle = this.m_prevBtn.getBounds();
        Rectangle rectangle2 = this.m_nextBtn.getBounds();
        int n2 = rectangle.x + rectangle.width + n;
        int n3 = rectangle.y;
        int n4 = rectangle2.x - n2 - n;
        int n5 = rectangle.height;
        graphics.setColor(Color.gray);
        graphics.drawLine(n2, n3, n2 + n4 - 1, n3);
        graphics.drawLine(n2, n3, n2, n3 + n5 - 1);
        graphics.setColor(Color.white);
        graphics.drawLine(n2 + n4 - 1, n3, n2 + n4 - 1, n3 + n5 - 1);
        graphics.drawLine(n2, n3 + n5 - 1, n2 + n4 - 1, n3 + n5 - 1);
        Font font = this.getFont();
        graphics.setFont(font);
        int n6 = this.getFontMetrics(font).stringWidth(this.m_lastFirstNames);
        if (n4 > 0) {
            while (n6 > n4 && this.m_lastFirstNames.length() > 1) {
                this.m_lastFirstNames = this.m_lastFirstNames.substring(this.m_lastFirstNames.length() - 1);
                n6 = this.getFontMetrics(font).stringWidth(this.m_lastFirstNames);
            }
            int n7 = (n4 - n6) / 2;
            graphics.setColor(Color.black);
            graphics.drawString(this.m_lastFirstNames, n2 + n7, n3 + this.getFontMetrics(font).getHeight());
        }
    }

    protected void actionPerformed(ActionEvent actionEvent) {
        if ((actionEvent.getSource() == this.m_searchBtn || actionEvent.getSource() == this.m_tfSearch) && this.m_tfSearch.getText().trim().length() > 0) {
            this.m_request = this.m_openDir.queryEntries(this.m_tfSearch.getText());
            this.setCursor(Cursor.getPredefinedCursor(3));
        }
        if (actionEvent.getSource() == this.m_nextBtn) {
            this.m_request = this.m_openDir.queryEntries(false);
            this.setCursor(Cursor.getPredefinedCursor(3));
        }
        if (actionEvent.getSource() == this.m_prevBtn) {
            this.m_request = this.m_openDir.queryEntries(true);
            this.setCursor(Cursor.getPredefinedCursor(3));
        }
    }

    protected void selectionChanged(Vector vector) {
        Vector<STObject> vector2 = new Vector<STObject>();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            DirectoryNode directoryNode = (DirectoryNode)enumeration.nextElement();
            if (directoryNode.getType() != 0 && directoryNode.getType() != 1) continue;
            vector2.addElement(directoryNode.getSTObject());
        }
        if (vector2.size() > 0 || !this.m_selectionEmpty) {
            DirectoryListViewEvent directoryListViewEvent = new DirectoryListViewEvent((Object)this, 1, vector2);
            this.sendEvent(directoryListViewEvent);
        }
        this.m_selectionEmpty = vector2.size() > 0;
    }

    protected void nodeDoubleClicked(TreeNode treeNode) {
        if (treeNode instanceof DirectoryNode) {
            switch (((DirectoryNode)treeNode).getType()) {
                case 2: {
                    this.m_request = this.m_openDir.queryEntries(false);
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    break;
                }
                case 3: {
                    this.m_request = this.m_openDir.queryEntries(true);
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    break;
                }
                default: {
                    DirectoryListViewEvent directoryListViewEvent = new DirectoryListViewEvent((Object)this, 2, ((DirectoryNode)treeNode).getSTObject());
                    this.sendEvent(directoryListViewEvent);
                }
            }
        }
    }

    protected void itemStateChanged(ItemEvent itemEvent) {
        String string = (String)itemEvent.getItem();
        for (int i = 0; i < this.m_dirs.length; ++i) {
            if (!this.m_dirs[i].getTitle().equals(string)) continue;
            this.m_openDir.removeDirectoryListener(this.m_directoryListener);
            this.m_openDir.close();
            this.m_openDir = this.m_dirs[i];
            this.m_openDir.addDirectoryListener(this.m_directoryListener);
            this.m_openDir.open();
            this.setCursor(Cursor.getPredefinedCursor(3));
            break;
        }
    }

    protected void allDirectoriesQueried(DirectoryEvent directoryEvent) {
        this.enableSubComponents(true);
        this.setCursor(Cursor.getDefaultCursor());
        Directory[] directoryArray = directoryEvent.getDirectories();
        this.m_dirsTitles.removeAll();
        this.m_listModel.resetTree();
        for (int i = 0; i < directoryArray.length; ++i) {
            this.m_dirsTitles.addItem(directoryArray[i].getTitle());
        }
        this.m_dirs = directoryArray;
        if (directoryArray.length > 0) {
            this.m_openDir = this.m_dirs[0];
            this.m_openDir.addDirectoryListener(this.m_directoryListener);
            this.m_openDir.open();
            this.setCursor(Cursor.getPredefinedCursor(3));
        }
    }

    protected void allDirectoriesQueryFailed(DirectoryEvent directoryEvent) {
        this.setCursor(Cursor.getDefaultCursor());
        this.enableSubComponents(false);
        if (this.m_logger.isLoggable(Level.FINER)) {
            this.m_logger.logp(Level.FINER, this.getClass().getName(), "allDirectoriesQueryFailed", "DirectoryPanel.onAllDirectoriesQueriedFailed Reason:" + directoryEvent.getReason());
        }
        String string = this.m_res.getString("QUERY_ALL_FAILED");
        this.displayErrorMessage(string);
    }

    protected void serviceAvailable(DirectoryEvent directoryEvent) {
        this.m_dirService.queryAllDirectories();
    }

    protected void serviceUnavailable(DirectoryEvent directoryEvent) {
        this.setCursor(Cursor.getDefaultCursor());
        this.enableSubComponents(false);
        String string = directoryEvent.getReason() == -2147483645 ? this.m_res.getString("NOT_AUTHORIZED") : this.m_res.getString("SERVICE_NOT_AVAILABLE");
        this.displayErrorMessage(string);
    }

    protected void directoryOpened(DirectoryEvent directoryEvent) {
        if (this.m_chunkSize > -1) {
            this.m_openDir.setMaxEntries(this.m_chunkSize);
        }
        this.m_request = directoryEvent.getDirectory().queryEntries(false);
    }

    protected void directoryOpenFailed(DirectoryEvent directoryEvent) {
        if (this.m_logger.isLoggable(Level.FINER)) {
            this.m_logger.logp(Level.FINER, this.getClass().getName(), "directoryOpenFailed", "DirectoryPanel.onOpenFailed Reason:" + directoryEvent.getReason());
        }
        this.setCursor(Cursor.getDefaultCursor());
        String string = this.m_res.getString("OPEN_DIR_FAILED");
        this.displayErrorMessage(string);
    }

    protected void entriesQueried(DirectoryEvent directoryEvent) {
        if (directoryEvent.getRequestId().equals(this.m_request)) {
            this.m_listModel.resetTree();
            Vector<DirectoryNode> vector = new Vector<DirectoryNode>();
            Vector<CellData> vector2 = new Vector<CellData>();
            vector2.addElement(new CellData(""));
            STObject[] sTObjectArray = directoryEvent.getEntries();
            for (int i = 0; i < sTObjectArray.length; ++i) {
                if (sTObjectArray[i] instanceof STGroup) {
                    vector.addElement(new DirectoryNode((STGroup)sTObjectArray[i], sTObjectArray[i].getName(), this.m_groupImage, null, vector2, 1));
                    continue;
                }
                Vector<CellData> vector3 = new Vector<CellData>();
                vector3.addElement(new CellData(sTObjectArray[i].getName()));
                vector.addElement(new DirectoryNode((STUser)sTObjectArray[i], ((STUser)sTObjectArray[i]).getNickName(), this.m_userImage, null, vector3, 0));
            }
            this.m_listModel.insertNodes(vector, directoryEvent.isAtEnd(), directoryEvent.isAtStart());
            this.updateStartEndLabel(sTObjectArray);
            this.enableSubComponents(true);
            this.m_nextBtn.setEnabled(!directoryEvent.isAtEnd());
            this.m_prevBtn.setEnabled(!directoryEvent.isAtStart());
            this.repaint();
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    protected void updateStartEndLabel(STObject[] sTObjectArray) {
        if (sTObjectArray.length > 0) {
            String string = sTObjectArray[0] instanceof STUser ? ((STUser)sTObjectArray[0]).getDisplayName() : sTObjectArray[0].getName();
            String string2 = sTObjectArray[sTObjectArray.length - 1] instanceof STUser ? ((STUser)sTObjectArray[sTObjectArray.length - 1]).getDisplayName() : sTObjectArray[sTObjectArray.length - 1].getName();
            BreakIterator breakIterator = BreakIterator.getWordInstance();
            breakIterator.setText(string);
            int n = breakIterator.next();
            string = string.substring(0, n);
            breakIterator.setText(string2);
            n = breakIterator.next();
            string2 = string2.substring(0, n);
            this.m_lastFirstNames = string + " " + this.m_res.getString("SEPERATOR") + " " + string2;
        } else {
            this.m_lastFirstNames = " ";
        }
    }

    protected void entriesQueryFailed(DirectoryEvent directoryEvent) {
        if (this.m_logger.isLoggable(Level.FINER)) {
            this.m_logger.logp(Level.FINER, this.getClass().getName(), "entriesQueryFailed", "DirectoryPanel.onEntriesQueryFailed Reason: " + directoryEvent.getReason());
        }
        String string = this.m_res.getString("QUERY_ENTERIES_FAILED");
        this.displayErrorMessage(string);
        this.setCursor(Cursor.getDefaultCursor());
    }

    protected synchronized void loggedIn(LoginEvent loginEvent) {
        this.m_dirService.queryAllDirectories();
        this.setEnabled(true);
        this.setCursor(Cursor.getPredefinedCursor(3));
    }

    protected synchronized void loggedOut(LoginEvent loginEvent) {
        this.setEnabled(false);
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    public void removeServiceListeners() {
        if (null != this.m_openDir) {
            this.m_openDir.close();
            this.m_openDir.removeDirectoryListener(this.m_directoryListener);
            this.m_openDir = null;
        }
        this.m_comm.removeLoginListener(this.m_loginListener);
        this.m_dirService.removeDirectoryServiceListener(this.m_directorySrvListener);
        this.m_listeners.removeAllElements();
    }

    public void addNotify() {
        super.addNotify();
        if (null == this.m_ubqDialog) {
            this.createErrorDialog();
        }
    }

    public void removeNotify() {
        if (null != this.m_ubqDialog) {
            this.m_ubqDialog = null;
        }
        if (null != this.m_openDir) {
            this.m_openDir.close();
            this.m_openDir = null;
        }
        super.removeNotify();
    }

    protected synchronized void createErrorDialog() {
        Frame frame = new Frame();
        for (Container container = this.getParent(); container != null; container = container.getParent()) {
            if (!(container instanceof Frame)) continue;
            frame = (Frame)container;
            break;
        }
        if (this.m_logger.isLoggable(Level.FINEST)) {
            this.m_logger.logp(Level.FINEST, this.getClass().getName(), "createErrorDialog", "UbqDialog Parent: " + frame);
        }
        this.m_ubqDialog = new UbqDialog(frame);
    }

    protected void displayErrorMessage(String string) {
        if (null == this.m_ubqDialog) {
            this.createErrorDialog();
        }
        String string2 = this.m_res.getString("ERROR_DIALOG_TITLE");
        String[] stringArray = new String[]{this.m_res.getString("BTN_LBL_OK")};
        this.m_ubqDialog.resetDialog(string2, string, stringArray, false, "");
        this.m_ubqDialog.setVisible(true);
    }

    public void setMaxEntries(short s) {
        this.m_chunkSize = s;
        this.m_openDir.setMaxEntries(this.m_chunkSize);
    }

    protected void textValueChanged(TextEvent textEvent) {
        boolean bl = this.m_tfSearch.getText().trim().length() > 0;
        this.m_searchBtn.setEnabled(bl);
    }

    public void enableMultiSelection(boolean bl) {
        this.m_listView.enableMultiSelection(bl);
    }

    public Enumeration getActionKeys() {
        STBundle sTBundle = this.m_resService.getBundle(COMM_BUNDLE_FILE_NAME);
        Vector<KeyAction> vector = new Vector<KeyAction>();
        vector.addElement(new KeyAction(KeyAction.getKeyCodeByString(sTBundle.getString("MN_DROP_DOWN_DIRECTORY"))){

            public void executeKeyMethod() {
                DirectoryPanel.this.m_dirsTitles.requestFocus();
            }
        });
        vector.addElement(new KeyAction(KeyAction.getKeyCodeByString(sTBundle.getString("MN_TEXT_SEARCH_ITEM"))){

            public void executeKeyMethod() {
                DirectoryPanel.this.m_tfSearch.requestFocus();
            }
        });
        vector.addElement(new KeyAction(KeyAction.getKeyCodeByString(sTBundle.getString("MN_BTN_SEARCH"))){

            public void executeKeyMethod() {
                if (DirectoryPanel.this.m_tfSearch.getText().trim().length() > 0) {
                    DirectoryPanel.this.m_request = DirectoryPanel.this.m_openDir.queryEntries(DirectoryPanel.this.m_tfSearch.getText());
                    DirectoryPanel.this.setCursor(Cursor.getPredefinedCursor(3));
                }
            }
        });
        return vector.elements();
    }

    protected void createListeners() {
        this.m_actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DirectoryPanel.this.actionPerformed(actionEvent);
            }
        };
        this.m_textListener = new TextListener(){

            public void textValueChanged(TextEvent textEvent) {
                DirectoryPanel.this.textValueChanged(textEvent);
            }
        };
        this.m_directoryListener = new DirectoryListener(){

            public void directoryOpened(DirectoryEvent directoryEvent) {
                DirectoryPanel.this.directoryOpened(directoryEvent);
            }

            public void directoryOpenFailed(DirectoryEvent directoryEvent) {
                DirectoryPanel.this.directoryOpenFailed(directoryEvent);
            }

            public void entriesQueried(DirectoryEvent directoryEvent) {
                DirectoryPanel.this.entriesQueried(directoryEvent);
            }

            public void entriesQueryFailed(DirectoryEvent directoryEvent) {
                DirectoryPanel.this.entriesQueryFailed(directoryEvent);
            }
        };
        this.m_directorySrvListener = new DirectoryServiceListener(){

            public void allDirectoriesQueried(DirectoryEvent directoryEvent) {
                DirectoryPanel.this.allDirectoriesQueried(directoryEvent);
            }

            public void allDirectoriesQueryFailed(DirectoryEvent directoryEvent) {
                DirectoryPanel.this.allDirectoriesQueryFailed(directoryEvent);
            }

            public void serviceAvailable(DirectoryEvent directoryEvent) {
                DirectoryPanel.this.serviceAvailable(directoryEvent);
            }

            public void serviceUnavailable(DirectoryEvent directoryEvent) {
                DirectoryPanel.this.serviceUnavailable(directoryEvent);
            }
        };
        this.m_viewListener = new ViewListener(){

            public void nodeDoubleClicked(TreeNode treeNode) {
                DirectoryPanel.this.nodeDoubleClicked(treeNode);
            }

            public void selectionChanged(Vector vector) {
                DirectoryPanel.this.selectionChanged(vector);
            }

            public void deletePressed(Vector vector) {
            }

            public void popupMenuRequest(MouseEvent mouseEvent, Vector vector) {
            }

            public void nodeExpanded(TreeNode treeNode) {
            }

            public void nodeCollapsed(TreeNode treeNode) {
            }
        };
        this.m_loginListener = new LoginListener(){

            public void loggedOut(LoginEvent loginEvent) {
                DirectoryPanel.this.loggedOut(loginEvent);
            }

            public void loggedIn(LoginEvent loginEvent) {
                DirectoryPanel.this.loggedIn(loginEvent);
            }
        };
    }

    public CellData getColumnHeader(ColumnAttributes columnAttributes) {
        return new CellData(this.m_res.getString("FULL_NAME"));
    }

    public CellData getContent(ColumnAttributes columnAttributes, Hashtable hashtable) {
        return null;
    }

    public CellData getEmptyContent(ColumnAttributes columnAttributes) {
        return null;
    }

    public void setShowGroups(boolean bl) {
        this.m_listModel.setShowGroups(bl);
    }
}

