/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.core.util.connection;

import com.lotus.sametime.core.util.Debug;
import com.lotus.sametime.core.util.connection.ClosedListener;
import com.lotus.sametime.core.util.connection.Connection;
import com.lotus.sametime.core.util.connection.ConnectionInitializer;
import com.lotus.sametime.core.util.connection.DataListener;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class SocksConnection
extends Connection {
    private String m_proxyServer;
    private int m_proxyPort;
    private String m_userId;
    private String m_proxyPassword;
    private short m_resolveOption;
    private int m_remotePort;
    private Connection m_impl;
    private ClosedListener m_closedListener;
    private ClosedListener m_innerClosedListener;
    private boolean m_connectionEstablished = false;
    private InetAddress[] m_ipsToTry;
    private ConnectionInitializer m_connectionIntializer;
    private boolean m_dnsCalled = false;
    private int m_ipIndex = 0;
    public static final short RESOLVE_LOCALLY = 0;
    public static final short RESOLVE_ON_SERVER = 1;
    public static final short RESOLVE_LOCALLY_THEN_ON_SERVER = 2;
    private boolean m_keepTrying = true;
    private Logger m_logger = Logger.getLogger("com.lotus.sametime.core.util.connection");

    public SocksConnection(String string, int n, String string2, int n2, String string3, String string4, long l, short s) {
        super(l);
        this.setHost(string);
        this.m_remotePort = n;
        this.m_proxyServer = string2;
        this.m_proxyPort = n2;
        this.m_proxyPassword = string4;
        this.m_userId = string3;
        this.m_resolveOption = s;
        this.m_innerClosedListener = new ClosedListener(){

            public void onConnectionClosed(int n, Connection connection) {
                SocksConnection.this.onConnectionClosed(n, connection);
            }
        };
    }

    public SocksConnection(int n, String string, int n2, String string2, String string3, long l, short s) {
        this(null, n, string, n2, string2, string3, l, s);
    }

    protected void initializeConnection(String string, ConnectionInitializer connectionInitializer) throws IOException {
        if (this.getHost() == null) {
            this.setHost(string);
        }
        Debug.stAssert(this.getHost() != null);
        this.m_connectionIntializer = connectionInitializer;
        InetAddress inetAddress = null;
        if (this.m_resolveOption != 1) {
            inetAddress = this.getNextIp();
        }
        this.m_impl = this.getConnectionImpl(inetAddress);
        this.m_impl.setClosedListener(this.m_innerClosedListener);
        this.m_impl.initializeConnection(this.getHost(), connectionInitializer);
    }

    protected abstract Connection getConnectionImpl(InetAddress var1);

    public void setKeepAliveParams(long l, byte[] byArray) {
        this.m_impl.setKeepAliveParams(l, byArray);
    }

    public void setBytesToReceive(int n) {
        this.m_impl.setBytesToReceive(n);
    }

    public void sendMessage(byte[] byArray, byte by) {
        this.m_impl.sendMessage(byArray, by);
    }

    public void close(int n) {
        this.m_impl.close(n);
    }

    public void close() {
        this.m_impl.close();
    }

    protected void setClosedListener(ClosedListener closedListener) {
        this.m_closedListener = closedListener;
    }

    protected ClosedListener getClosedListener() {
        return this.m_closedListener;
    }

    protected void setDataListener(DataListener dataListener) {
        this.m_keepTrying = false;
        this.m_impl.setDataListener(dataListener);
    }

    protected DataListener getDataListener() {
        return this.m_impl.m_dataListener;
    }

    protected synchronized boolean isReady() {
        boolean bl = this.m_impl.isReady();
        if (bl) {
            this.m_connectionEstablished = true;
        }
        return bl;
    }

    protected synchronized boolean isReadyForInitialSend() {
        return this.m_impl.isReadyForInitialSend();
    }

    private synchronized void onConnectionClosed(int n, Connection connection) {
        if (this.m_keepTrying && this.m_ipsToTry != null && this.m_ipIndex < this.m_ipsToTry.length) {
            this.m_impl.setClosedListener(null);
            this.m_impl.setDataListener(null);
            try {
                this.initializeConnection(this.getHost(), this.m_connectionIntializer);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                this.notifyOnConnectionClosed(n);
            }
        } else {
            this.notifyOnConnectionClosed(n);
        }
    }

    private void notifyOnConnectionClosed(int n) {
        this.m_connectionEstablished = false;
        this.m_ipsToTry = null;
        this.m_ipIndex = 0;
        this.m_dnsCalled = false;
        this.m_closedListener.onConnectionClosed(n, this);
    }

    private InetAddress[] getIps(String string) {
        InetAddress[] inetAddressArray;
        block4: {
            inetAddressArray = null;
            try {
                inetAddressArray = InetAddress.getAllByName(string);
            }
            catch (UnknownHostException unknownHostException) {
                if (this.m_logger.isLoggable(Level.FINER)) {
                    this.m_logger.logp(Level.FINER, this.getClass().getName(), "getIps", "getIps - Unknow Host", unknownHostException);
                }
            }
            catch (SecurityException securityException) {
                if (!this.m_logger.isLoggable(Level.FINER)) break block4;
                this.m_logger.logp(Level.FINER, this.getClass().getName(), "getIps", "getIps - Security Exception", securityException);
            }
        }
        return inetAddressArray;
    }

    private InetAddress getNextIp() {
        InetAddress inetAddress = null;
        if (!this.m_dnsCalled) {
            this.m_ipsToTry = this.getIps(this.getHost());
            this.m_dnsCalled = true;
        }
        if (this.m_ipsToTry != null && this.m_ipIndex < this.m_ipsToTry.length) {
            inetAddress = this.m_ipsToTry[this.m_ipIndex++];
        }
        return inetAddress;
    }

    protected int getProxyPort() {
        return this.m_proxyPort;
    }

    protected String getProxyServer() {
        return this.m_proxyServer;
    }

    protected int getRemotePort() {
        return this.m_remotePort;
    }

    protected short getResolveOption() {
        return this.m_resolveOption;
    }

    protected String getUserId() {
        return this.m_userId;
    }

    protected String getProxyPassword() {
        return this.m_proxyPassword;
    }
}

