/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.core.util.connection;

import com.lotus.sametime.core.util.Debug;
import com.lotus.sametime.core.util.connection.Connection;
import com.lotus.sametime.core.util.connection.ConnectionInfo;
import com.lotus.sametime.core.util.connection.ConnectionInitializer;
import com.lotus.sametime.core.util.connection.SocketReceiver;
import com.lotus.sametime.core.util.connection.SocketSender;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SocketConnection
extends Connection {
    private int m_port;
    private Socket m_socket;
    private int m_initialBytesToReceive = -1;
    private boolean m_tryAllIps = true;
    private Logger m_logger = Logger.getLogger("com.lotus.sametime.core.util.connection");

    public SocketConnection(String string, int n, long l) {
        super(l);
        this.setHost(string);
        this.m_port = n;
    }

    public SocketConnection(int n, long l) {
        this(null, n, l);
    }

    protected void initializeConnection(String string, ConnectionInitializer connectionInitializer) throws IOException {
        if (this.getHost() == null) {
            this.setHost(string);
        }
        Debug.stAssert(this.getHost() != null);
        this.m_socket = this.safeGetSocket(this.getHost(), this.getPort(), connectionInitializer);
        try {
            this.m_receiver = new SocketReceiver(this.m_socket, this);
            if (this.m_initialBytesToReceive > 0) {
                this.m_receiver.setBytesToReceive(this.m_initialBytesToReceive);
            }
            this.m_receiver.startReceiver();
        }
        catch (IOException iOException) {
            if (this.m_logger.isLoggable(Level.FINER)) {
                this.m_logger.logp(Level.FINER, this.getClass().getName(), "initializeConnection", "Can't create receiver: ", iOException);
            }
            this.m_socket.close();
            throw iOException;
        }
        try {
            this.m_sender = new SocketSender(this.m_socket);
            this.m_sender.startSender();
        }
        catch (IOException iOException) {
            if (this.m_logger.isLoggable(Level.FINER)) {
                this.m_logger.logp(Level.FINER, this.getClass().getName(), "initializeConnection", "Can't create sender: ", iOException);
            }
            this.m_receiver.stopReceiver();
            this.m_socket.close();
            throw iOException;
        }
    }

    public void setBytesToReceive(int n) {
        if (this.m_receiver != null) {
            super.setBytesToReceive(n);
        } else {
            this.m_initialBytesToReceive = n;
        }
    }

    protected Socket safeGetSocket(String string, int n, ConnectionInitializer connectionInitializer) throws IOException {
        try {
            return this.getSocket(string, n);
        }
        catch (SecurityException securityException) {
            if (this.m_logger.isLoggable(Level.FINER)) {
                this.m_logger.logp(Level.FINER, this.getClass().getName(), "safeGetSocket", "Failed to create a socket. Trying to get privilage");
            }
            return this.getSocket(string, n);
        }
    }

    private Socket getSocket(String string, int n) throws IOException, SecurityException {
        Socket socket = null;
        InetAddress[] inetAddressArray = null;
        if (this.m_tryAllIps) {
            inetAddressArray = this.getIps(string);
        }
        if (null == inetAddressArray) {
            socket = new Socket(string, n);
        } else {
            boolean bl = false;
            int n2 = 0;
            while (!bl && n2 < inetAddressArray.length) {
                try {
                    if (this.m_logger.isLoggable(Level.FINER)) {
                        this.m_logger.logp(Level.FINER, this.getClass().getName(), "getSocket", "Trying to connect to: " + inetAddressArray[n2]);
                    }
                    socket = new Socket(inetAddressArray[n2], n);
                    bl = true;
                }
                catch (IOException iOException) {
                    if (this.m_logger.isLoggable(Level.FINEST)) {
                        this.m_logger.logp(Level.FINEST, this.getClass().getName(), "getSocket", "getSocket IOException", iOException);
                    }
                    if (++n2 != inetAddressArray.length) continue;
                    if (this.m_logger.isLoggable(Level.FINER)) {
                        this.m_logger.logp(Level.FINER, this.getClass().getName(), "getSocket", "Throwing exception : " + iOException.toString());
                    }
                    throw iOException;
                }
            }
        }
        return socket;
    }

    private InetAddress[] getIps(String string) {
        InetAddress[] inetAddressArray;
        block6: {
            inetAddressArray = null;
            try {
                inetAddressArray = InetAddress.getAllByName(string);
            }
            catch (UnknownHostException unknownHostException) {
                if (this.m_logger.isLoggable(Level.FINER)) {
                    this.m_logger.logp(Level.FINER, this.getClass().getName(), "getIps", "getIps - Unknown Host", unknownHostException);
                }
            }
            catch (SecurityException securityException) {
                if (!this.m_logger.isLoggable(Level.FINER)) break block6;
                this.m_logger.logp(Level.FINER, this.getClass().getName(), "getIps", "getIps - Security Exception", securityException);
            }
        }
        if (this.m_logger.isLoggable(Level.FINER)) {
            this.m_logger.logp(Level.FINER, this.getClass().getName(), "getIps", "IPs from Dns:");
        }
        for (int i = 0; null != inetAddressArray && i < inetAddressArray.length; ++i) {
            if (!this.m_logger.isLoggable(Level.FINER)) continue;
            this.m_logger.logp(Level.FINER, this.getClass().getName(), "getIps", "IP (" + i + ")" + inetAddressArray[i]);
        }
        return inetAddressArray;
    }

    protected void setPort(int n) {
        this.m_port = n;
    }

    public int getPort() {
        return this.m_port;
    }

    public ConnectionInfo getConnectionInfo() {
        return new ConnectionInfo(0, this.getPort(), null, 0, null, null);
    }

    public void setTryAllIps(boolean bl) {
        this.m_tryAllIps = bl;
    }

    public InetAddress getLocalAddress() {
        return this.m_socket.getLocalAddress();
    }
}

