/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.core.util.connection;

import com.lotus.sametime.core.util.Debug;
import com.lotus.sametime.core.util.PriorityQueue;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

abstract class Sender
implements Runnable {
    private static final String THREAD_NAME = "Uncle Egad's VP Sender ";
    private static int c_threadCount = 0;
    protected boolean m_stopped = false;
    protected PriorityQueue m_queue = new PriorityQueue(15);
    protected Thread m_thread = null;
    private long m_keepAliveTime = 0L;
    private byte[] m_keepAliveMessage = null;
    private Logger m_logger = Logger.getLogger("com.lotus.sametime.core.util.connection");

    protected Sender() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Sender sender = this;
        synchronized (sender) {
            if (!this.flush()) {
                this.m_stopped = true;
            }
            while (!this.m_stopped) {
                block10: {
                    try {
                        if (this.m_keepAliveTime != 0L && this.m_keepAliveMessage != null) {
                            this.wait(this.m_keepAliveTime);
                        } else {
                            this.wait();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        if (!this.m_logger.isLoggable(Level.FINER)) break block10;
                        this.m_logger.logp(Level.FINER, this.getClass().getName(), "run", "vpSender run: wait interrupted: ", interruptedException);
                    }
                }
                if (this.m_queue.isEmpty() && !this.m_stopped) {
                    if (this.sendKeepAlive()) continue;
                    this.m_stopped = true;
                    continue;
                }
                if (this.flush()) continue;
                this.m_stopped = true;
            }
        }
        this.cleanup();
        this.m_thread = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopSender() {
        if (this.m_stopped) {
            return;
        }
        this.m_stopped = true;
        Sender sender = this;
        synchronized (sender) {
            this.notifyAll();
        }
    }

    public void startSender() throws IOException {
        Debug.stAssert(this.m_thread == null);
        if (this.m_thread != null) {
            return;
        }
        this.m_thread = new Thread((Runnable)this, THREAD_NAME + ++c_threadCount);
        this.initialize();
        this.m_thread.start();
    }

    protected abstract void initialize() throws IOException;

    protected abstract void cleanup();

    protected abstract void send(byte[] var1) throws IOException;

    public boolean flush() {
        boolean bl = true;
        while (!this.m_queue.isEmpty() && bl) {
            try {
                byte[] byArray = this.buildCompoundMessage();
                this.send(byArray);
            }
            catch (Exception exception) {
                if (this.m_logger.isLoggable(Level.FINEST)) {
                    this.m_logger.logp(Level.FINEST, this.getClass().getName(), "flush", "vpSender flush: IO Exception.", exception);
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueMessage(byte[] byArray, byte by) {
        this.m_queue.put(byArray, by);
        Sender sender = this;
        synchronized (sender) {
            this.notifyAll();
        }
    }

    protected boolean sendKeepAlive() {
        boolean bl = true;
        if (this.m_keepAliveMessage != null) {
            try {
                this.send(this.m_keepAliveMessage);
            }
            catch (IOException iOException) {
                bl = false;
            }
        }
        return bl;
    }

    public boolean isStopped() {
        return this.m_stopped;
    }

    public void setKeepAliveParams(long l, byte[] byArray) {
        this.m_keepAliveMessage = byArray;
        this.m_keepAliveTime = l;
    }

    public long getKeepAliveRate() {
        return this.m_keepAliveTime;
    }

    public byte[] buildCompoundMessage() throws IOException {
        return (byte[])this.m_queue.getNext();
    }
}

