/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.core.util;

import com.lotus.sametime.core.util.Debug;
import com.lotus.sametime.core.util.TimerListener;

public class Timer
implements Runnable {
    private static final String THREAD_NAME = "White Rabbit (Timer). ";
    private static final int OP_TICK = 0;
    private static final int OP_STOP_TIMER = 1;
    private static final int OP_RESTART_TIMER = 2;
    private static int c_threadCount = 0;
    private int m_timerOp;
    private TimerListener m_listener;
    private long m_rate;
    Thread m_timerThread;

    public Timer(long l, TimerListener timerListener) {
        this.m_rate = l;
        this.m_listener = timerListener;
    }

    public void start() {
        if (this.m_timerThread == null) {
            this.m_timerThread = new Thread((Runnable)this, THREAD_NAME + ++c_threadCount);
            this.m_timerThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Timer timer = this;
        synchronized (timer) {
            boolean bl = false;
            while (!bl) {
                this.m_timerOp = 0;
                try {
                    this.wait(this.m_rate);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                switch (this.m_timerOp) {
                    case 0: {
                        if (this.m_listener == null) break;
                        bl = !this.m_listener.timerTick();
                        break;
                    }
                    case 1: {
                        bl = true;
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
            }
            this.m_timerThread = null;
        }
    }

    public synchronized void stop() {
        this.m_timerOp = 1;
        this.notifyAll();
    }

    public synchronized void restart() {
        Debug.stAssert(this.m_timerThread != null);
        this.m_timerOp = 2;
        this.notifyAll();
    }

    public synchronized void tick() {
        Debug.stAssert(this.m_timerThread != null);
        this.m_timerOp = 0;
        this.notifyAll();
    }

    public void setTimerListener(TimerListener timerListener) {
        this.m_listener = timerListener;
    }

    public void setTimerRate(long l) {
        this.m_rate = l;
    }

    public long getTimerRate() {
        return this.m_rate;
    }

    public boolean isStarted() {
        boolean bl = false;
        if (null != this.m_timerThread && this.m_timerThread.isAlive()) {
            bl = true;
        }
        return bl;
    }
}

