/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.core.util;

import com.lotus.sametime.core.util.Debug;
import com.lotus.sametime.core.util.NdrOutputStream;
import java.io.IOException;

public class Base64Encoder {
    private static final char[] UU_CODES = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};

    public static String encode(byte[] byArray) {
        int n;
        int n2;
        int n3 = (byArray.length + 2) / 3 * 4;
        StringBuffer stringBuffer = new StringBuffer(n3);
        for (n2 = 0; n2 < byArray.length; n2 += 3) {
            n = byArray[n2];
            byte by = n2 + 1 < byArray.length ? byArray[n2 + 1] : (byte)0;
            byte by2 = n2 + 2 < byArray.length ? byArray[n2 + 2] : (byte)0;
            stringBuffer.append(UU_CODES[n >> 2 & 0x3F]);
            stringBuffer.append(UU_CODES[n << 4 & 0x30 | by >> 4 & 0xF]);
            stringBuffer.append(UU_CODES[by << 2 & 0x3C | by2 >> 6 & 3]);
            stringBuffer.append(UU_CODES[by2 & 0x3F]);
        }
        n2 = (3 - byArray.length % 3) % 3;
        for (n = stringBuffer.length() - n2; n < stringBuffer.length(); ++n) {
            stringBuffer.setCharAt(n, '=');
        }
        return stringBuffer.toString();
    }

    public static byte[] decode(String string) {
        char[] cArray = string.toCharArray();
        int n = 0;
        try {
            NdrOutputStream ndrOutputStream = new NdrOutputStream();
            block8: for (int i = 0; i < cArray.length && cArray[i] != '='; ++i) {
                int n2 = Base64Encoder.charToPackedVal(cArray[i]);
                switch (i % 4) {
                    case 0: {
                        n = (n2 & 0x3F) << 2;
                        continue block8;
                    }
                    case 1: {
                        ndrOutputStream.write(n |= (n2 & 0x30) >> 4);
                        n = (n2 & 0xF) << 4;
                        continue block8;
                    }
                    case 2: {
                        ndrOutputStream.write(n |= (n2 & 0x3C) >> 2);
                        n = (n2 & 3) << 6;
                        continue block8;
                    }
                    case 3: {
                        ndrOutputStream.write(n |= n2 & 0x3F);
                        n = 0;
                    }
                }
            }
            return ndrOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            Debug.stAssert(false);
            return null;
        }
    }

    private static int charToPackedVal(char c) {
        int n;
        if (c >= 'A' && c <= 'Z') {
            n = c - 65;
        } else if (c >= 'a' && c <= 'z') {
            n = c - 97 + 26;
        } else if (c >= '0' && c <= '9') {
            n = c - 48 + 52;
        } else if (c == '+') {
            n = 62;
        } else {
            n = 63;
            Debug.stAssert(c == '/');
        }
        return n;
    }
}

