/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.core.logging;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class TkLogger
extends Logger {
    private static TkLogger m_logger;
    private boolean m_useSysErr = false;

    protected TkLogger(String string, String string2) {
        super(string, string2);
        try {
            this.setParent(Logger.getLogger(""));
            this.setupConfig();
        }
        catch (SecurityException securityException) {
            this.m_useSysErr = true;
        }
    }

    protected TkLogger(String string) {
        super(string, null);
        try {
            this.setParent(Logger.getLogger(""));
            this.setupConfig();
        }
        catch (SecurityException securityException) {
            this.m_useSysErr = true;
        }
    }

    public static TkLogger getTkLogger(String string) {
        if (m_logger == null) {
            m_logger = new TkLogger(string);
        }
        return m_logger;
    }

    public void setupConfig() {
        String string = System.getProperty("user.home") + System.getProperty("file.separator") + "stjavatk.properties";
        File file = new File(string);
        if (file.exists()) {
            try {
                BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
                LogManager.getLogManager().readConfiguration(bufferedInputStream);
            }
            catch (IOException iOException) {
                System.out.println("Error loading stjavatk.properties: " + iOException.getMessage());
                iOException.printStackTrace();
            }
        }
    }

    public void log(LogRecord logRecord) {
        logRecord.setMessage("[ " + Thread.currentThread().getName() + " ]" + "   " + logRecord.getMessage());
        if (this.m_useSysErr) {
            System.err.println(logRecord.getMessage());
        } else {
            super.log(logRecord);
        }
    }

    private static String formatByte(byte by) {
        int n = by & 0xFF;
        String string = Integer.toHexString(n);
        if (string.length() < 2) {
            string = "0" + string;
        }
        return string;
    }

    public void logByte(Level level, String string, String string2, byte by) {
        this.logp(level, string, string2, TkLogger.formatByte(by));
    }

    public static String formatBytes(byte[] byArray) {
        if (byArray == null) {
            return "<null>";
        }
        StringBuffer stringBuffer = new StringBuffer("");
        for (int i = 0; i < byArray.length; i += 16) {
            int n;
            stringBuffer.append(System.getProperty("line.separator"));
            stringBuffer.append(TkLogger.formatByte((byte)(i >> 8)));
            stringBuffer.append(TkLogger.formatByte((byte)(i & 0xFF)));
            stringBuffer.append(" -  ");
            int n2 = byArray.length - i;
            int n3 = n2 > 16 ? 16 : n2;
            for (n = 0; n < n3; ++n) {
                stringBuffer.append(TkLogger.formatByte(byArray[i + n]));
                stringBuffer.append(" ");
            }
            if (n3 < 16) {
                while (n < 16) {
                    stringBuffer.append("   ");
                    ++n;
                }
            }
            for (n = 0; n < n3; ++n) {
                if (byArray[i + n] > 32 && byArray[i + n] <= 127) {
                    stringBuffer.append("" + (char)byArray[i + n]);
                    continue;
                }
                stringBuffer.append(".");
            }
        }
        stringBuffer.append(System.getProperty("line.separator"));
        return stringBuffer.toString();
    }

    public void logByte(Level level, String string, String string2, byte[] byArray) {
        this.logp(level, string, string2, TkLogger.formatBytes(byArray));
    }
}

