/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.configuration;

import com.lotus.sametime.configuration.ConfigChangeEvent;
import com.lotus.sametime.configuration.ConfigImpl;
import com.lotus.sametime.configuration.ConfigService;
import com.lotus.sametime.configuration.ConfigServiceEvent;
import com.lotus.sametime.configuration.ConfigServiceListener;
import com.lotus.sametime.core.comparch.DuplicateObjectException;
import com.lotus.sametime.core.comparch.STComp;
import com.lotus.sametime.core.comparch.STEvent;
import com.lotus.sametime.core.comparch.STSession;
import java.util.Enumeration;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ConfigComp
extends STComp
implements ConfigService {
    private ConfigImpl m_impl = null;
    private Vector m_serviceListeners;
    private Logger m_logger = Logger.getLogger("com.lotus.sametime.configuration");

    public ConfigComp(STSession sTSession) throws DuplicateObjectException {
        super("com.lotus.sametime.configuration.ConfigComp", sTSession);
        this.m_serviceListeners = new Vector();
        this.m_impl = new ConfigImpl(sTSession);
        sTSession.registerComponent(this.getName(), this);
    }

    protected void start() {
        if (this.m_logger.isLoggable(Level.FINER)) {
            this.m_logger.logp(Level.FINER, this.getClass().getName(), "start", this + " Started");
        }
    }

    protected void stop() {
        if (this.m_logger.isLoggable(Level.FINER)) {
            this.m_logger.logp(Level.FINER, this.getClass().getName(), "stop", this + " Stopped");
        }
    }

    public void subscribe(String string) {
        this.m_impl.subscribe(string);
    }

    public void unsubscribe(String string) {
        this.m_impl.unsubscribe(string);
    }

    public synchronized void addConfigServiceListener(ConfigServiceListener configServiceListener) {
        Vector vector = (Vector)this.m_serviceListeners.clone();
        vector.addElement(configServiceListener);
        this.m_serviceListeners = vector;
        if (this.isServiceAvailable()) {
            this.sendEvent(new ConfigServiceEvent(this, -2147483647));
        }
    }

    public synchronized void removeConfigServiceListener(ConfigServiceListener configServiceListener) {
        Vector vector = (Vector)this.m_serviceListeners.clone();
        vector.removeElement(configServiceListener);
        this.m_serviceListeners = vector;
    }

    protected void processSTEvent(STEvent sTEvent) {
        if (sTEvent instanceof ConfigChangeEvent) {
            this.processChangeEvent((ConfigChangeEvent)sTEvent);
            sTEvent.setConsumed(true);
        } else if (sTEvent instanceof ConfigServiceEvent) {
            this.processServiceEvent((ConfigServiceEvent)sTEvent);
            sTEvent.setConsumed(true);
        } else {
            super.processSTEvent(sTEvent);
        }
    }

    private void processServiceEvent(ConfigServiceEvent configServiceEvent) {
        Enumeration enumeration = this.m_serviceListeners.elements();
        switch (configServiceEvent.getId()) {
            default: {
                break;
            }
            case -2147483647: {
                while (enumeration.hasMoreElements()) {
                    ConfigServiceListener configServiceListener = (ConfigServiceListener)enumeration.nextElement();
                    configServiceListener.onServiceAvailable(configServiceEvent);
                }
                break;
            }
            case -2147483646: {
                while (enumeration.hasMoreElements()) {
                    ConfigServiceListener configServiceListener = (ConfigServiceListener)enumeration.nextElement();
                    configServiceListener.onServiceUnavailable(configServiceEvent);
                }
                break block0;
            }
        }
    }

    private void processChangeEvent(ConfigChangeEvent configChangeEvent) {
        if (configChangeEvent.getId() == -2147483647) {
            Enumeration enumeration = this.m_serviceListeners.elements();
            while (enumeration.hasMoreElements()) {
                ConfigServiceListener configServiceListener = (ConfigServiceListener)enumeration.nextElement();
                configServiceListener.onConfigChanged(configChangeEvent);
            }
        }
    }

    public boolean isServiceAvailable() {
        return this.m_impl.isServiceUp();
    }

    public void subscribe(String[] stringArray) {
        this.m_impl.subscribe(stringArray);
    }

    public void unsubscribe(String[] stringArray) {
        this.m_impl.unsubscribe(stringArray);
    }
}

