/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.chatui.invitation;

import com.lotus.sametime.chatui.ChatConstants;
import com.lotus.sametime.chatui.ChatFactory;
import com.lotus.sametime.chatui.ChatUIComp;
import com.lotus.sametime.chatui.MeetingInfo;
import com.lotus.sametime.chatui.invitation.InviteDialog;
import com.lotus.sametime.chatui.invitation.InviteDialogListener;
import com.lotus.sametime.chatui.invitation.Inviter;
import com.lotus.sametime.chatui.invitation.InviterListener;
import com.lotus.sametime.community.CommunityService;
import com.lotus.sametime.core.comparch.STSession;
import com.lotus.sametime.core.constants.EncLevel;
import com.lotus.sametime.core.types.STUser;
import com.lotus.sametime.core.types.STUserInstance;
import com.lotus.sametime.core.util.NdrInputStream;
import com.lotus.sametime.core.util.NdrOutputStream;
import com.lotus.sametime.im.Im;
import com.lotus.sametime.im.ImEvent;
import com.lotus.sametime.im.ImListener;
import com.lotus.sametime.im.InstantMessagingService;
import com.lotus.sametime.places.Place;
import com.lotus.sametime.places.PlaceAdapter;
import com.lotus.sametime.places.PlaceMemberEvent;
import java.awt.Dialog;
import java.awt.Frame;
import java.io.IOException;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MeetingInviter
extends PlaceAdapter
implements InviterListener,
ImListener,
InviteDialogListener {
    private STSession m_session;
    InstantMessagingService m_imService;
    STUserInstance m_myInfo;
    STUser[] m_invitees;
    String m_inviteText;
    ChatFactory m_factory;
    Place m_place;
    int m_meetingId = -1;
    MeetingInfo m_meetingInfo;
    boolean m_autoInvite;
    Inviter m_inviter;
    boolean m_leavePlace;
    private Logger m_logger = Logger.getLogger("com.lotus.sametime.chatui.invitation");

    public MeetingInviter(MeetingInfo meetingInfo, Place place, String string, STUser[] sTUserArray, boolean bl, boolean bl2, boolean bl3, STSession sTSession) {
        this.m_session = sTSession;
        this.m_meetingInfo = meetingInfo;
        this.m_autoInvite = bl2;
        this.m_place = place;
        this.m_leavePlace = bl3;
        this.m_invitees = sTUserArray;
        this.m_inviteText = string;
        this.m_imService = (InstantMessagingService)sTSession.getCompApi("com.lotus.sametime.im.ImComp");
        CommunityService communityService = (CommunityService)sTSession.getCompApi("com.lotus.sametime.community.STBase");
        this.m_myInfo = communityService.getLogin().getMyUserInstance();
        ChatUIComp chatUIComp = (ChatUIComp)sTSession.getCompApi("com.lotus.sametime.chatui.ChatUIComp");
        this.m_inviter = chatUIComp.getInvitationManager().createInviter();
        this.m_inviter.setListener(this);
        this.m_factory = chatUIComp.getChatFactory();
        if (bl) {
            Vector vector = ChatConstants.getActivities(meetingInfo.getType(), false);
            Frame frame = (Frame)sTSession.getSessionProperty("mainFrame");
            if (frame == null) {
                frame = new Frame();
            }
            InviteDialog inviteDialog = new InviteDialog(frame, sTSession, meetingInfo.getDisplayName(), string, meetingInfo.getEncLevel(), sTUserArray, vector, false);
            inviteDialog.setListener(this);
            inviteDialog.setVisible(true);
        }
        this.m_place.addPlaceListener(this);
    }

    public void attributeChanged(PlaceMemberEvent placeMemberEvent) {
        if (placeMemberEvent.getAttributeKey() == 9010) {
            byte[] byArray = placeMemberEvent.getAttribute().getValue();
            NdrInputStream ndrInputStream = new NdrInputStream(byArray);
            try {
                this.m_meetingId = ndrInputStream.readInt();
                if (this.m_leavePlace) {
                    this.m_place.close();
                }
                this.invite();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    void invite() {
        this.m_inviter.invite(this.m_meetingInfo, this.m_inviteText, this.m_invitees, this.m_autoInvite, this.m_autoInvite);
    }

    public void invitationToOldClient(Inviter inviter, STUser sTUser) {
        if (this.m_meetingId == -1) {
            if (this.m_logger.isLoggable(Level.FINER)) {
                this.m_logger.logp(Level.FINER, this.getClass().getName(), "invitationToOldClient", "Meeting ID attribute doesn't exist. Can't invite old clients.");
            }
            this.invitationDeclined(inviter, sTUser, -2130247680);
            return;
        }
        Im im = this.m_imService.createIm(sTUser, EncLevel.ENC_LEVEL_NONE, 3);
        im.addImListener(this);
        im.open();
    }

    public void invitationDeclined(Inviter inviter, STUser sTUser, int n) {
        this.m_factory.displayErrorMessage(this.m_session, n, false);
    }

    public void inviteDlgSendClicked(Dialog dialog, String string, String string2, STUser[] sTUserArray, EncLevel encLevel, Vector vector) {
        this.m_meetingInfo.setDisplayName(string);
        this.m_autoInvite = false;
        this.m_inviteText = string2;
        this.invite();
    }

    public void inviteDialogCanceled(Dialog dialog) {
    }

    public void imOpened(ImEvent imEvent) {
        Im im = imEvent.getIm();
        String string = this.constructMeetingHandle();
        EncLevel encLevel = this.m_meetingInfo.getEncLevel();
        boolean bl = !encLevel.isLower(EncLevel.ENC_LEVEL_ALL);
        NdrOutputStream ndrOutputStream = new NdrOutputStream();
        try {
            ndrOutputStream.writeUTF(this.m_meetingInfo.getDisplayName());
            ndrOutputStream.writeUTF(string);
            ndrOutputStream.writeInt(string.length());
            ndrOutputStream.writeUTF(this.m_myInfo.getDisplayName());
            ndrOutputStream.writeUTF(this.m_myInfo.getId().getId());
            ndrOutputStream.writeUTF(this.m_inviteText);
            ndrOutputStream.writeBoolean(bl);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
        im.sendData(false, 2, 0, ndrOutputStream.toByteArray());
        im.close(0);
    }

    public void openImFailed(ImEvent imEvent) {
        Im im = imEvent.getIm();
        this.invitationDeclined(this.m_inviter, im.getPartner(), imEvent.getReason());
    }

    private String constructMeetingHandle() {
        String string = ",";
        String string2 = "LJ01000001" + string;
        string2 = string2 + this.m_place.getServer().getName() + string;
        string2 = string2 + 8081 + string;
        string2 = string2 + this.m_meetingId + string;
        string2 = string2 + this.m_myInfo.getDisplayName();
        string2 = string2 + this.m_meetingInfo.getDisplayName();
        return string2;
    }

    public void imClosed(ImEvent imEvent) {
    }

    public void textReceived(ImEvent imEvent) {
    }

    public void dataReceived(ImEvent imEvent) {
    }
}

