/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.awarenessui.tree;

import com.lotus.sametime.awareness.STWatchedUser;
import com.lotus.sametime.awarenessui.AwarenessNode;
import com.lotus.sametime.awarenessui.tree.STPublicGroup;
import com.lotus.sametime.awarenessui.tree.STTreeGroup;
import com.lotus.sametime.awarenessui.tree.STTreeModel;
import com.lotus.sametime.core.comparch.STSession;
import com.lotus.sametime.core.types.STUser;
import com.lotus.sametime.core.util.ImageResources;
import com.lotus.sametime.guiutils.misc.UbqDialog;
import com.lotus.sametime.guiutils.tree.ModelNode;
import com.lotus.sametime.guiutils.tree.TreeNode;
import com.lotus.sametime.resourceloader.STBundle;
import java.awt.Frame;
import java.awt.Image;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

final class STTreeControllerUtil {
    static STTreeModel m_model;
    static STBundle m_resource;

    STTreeControllerUtil() {
    }

    static final void removeSelectedNodes(Vector vector) {
        Vector vector2;
        boolean bl = false;
        boolean bl2 = false;
        Hashtable<STTreeGroup, Vector<AwarenessNode>> hashtable = new Hashtable<STTreeGroup, Vector<AwarenessNode>>();
        Object object = vector.elements();
        while (object.hasMoreElements()) {
            AwarenessNode awarenessNode = (AwarenessNode)object.nextElement();
            if (m_model.isGroup(awarenessNode)) continue;
            ModelNode modelNode = awarenessNode.getParent();
            STTreeGroup sTTreeGroup = (STTreeGroup)modelNode.getKey();
            if (sTTreeGroup instanceof STPublicGroup) {
                bl = true;
                continue;
            }
            vector2 = (Vector)hashtable.get(sTTreeGroup);
            if (vector2 == null) {
                vector2 = new Vector();
            }
            bl2 = true;
            vector2.addElement(awarenessNode);
            hashtable.put(sTTreeGroup, vector2);
        }
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            object = (STTreeGroup)enumeration.nextElement();
            vector2 = (Vector)hashtable.get(object);
            STUser[] sTUserArray = m_model.getUsersFromNodes(vector2);
            STWatchedUser[] sTWatchedUserArray = new STWatchedUser[sTUserArray.length];
            for (int i = 0; i < sTUserArray.length; ++i) {
                sTWatchedUserArray[i] = (STWatchedUser)sTUserArray[i];
            }
            m_model.removeUsers(sTWatchedUserArray, (STTreeGroup)object);
        }
        STTreeGroup[] sTTreeGroupArray = m_model.getSelectedGroups(vector);
        m_model.removeGroups(sTTreeGroupArray, true);
        if (bl) {
            String string = bl2 ? "REMOVE_PUBLIC_USERS_ALSO" : "REMOVE_PUBLIC_USERS";
            Image image = ImageResources.getInstance().getImage("images/alert.gif");
            UbqDialog ubqDialog = new UbqDialog(STTreeControllerUtil.getMainFrame(), m_resource.getString("SAMETIME_TITLE"), m_resource.formatStringArray(string), m_resource.formatStringArray("BTN_LBL_OK"));
            ubqDialog.setImage(image);
            ubqDialog.setVisible(true);
        }
    }

    static final void nodeExpanded(TreeNode treeNode) {
        ModelNode modelNode = (ModelNode)treeNode;
        if (m_model.isGroup(modelNode)) {
            m_model.changeGroupState(true, modelNode);
        }
    }

    static final void nodeCollapsed(TreeNode treeNode) {
        ModelNode modelNode = (ModelNode)treeNode;
        if (m_model.isGroup(modelNode)) {
            m_model.changeGroupState(false, modelNode);
        }
    }

    static final void deletePressed(Vector vector, boolean bl) {
        if (bl) {
            STTreeControllerUtil.removeSelectedNodes(vector);
        }
    }

    static final boolean doesGroupContainOnlineUsers(AwarenessNode awarenessNode) {
        AwarenessNode[] awarenessNodeArray = m_model.getChilds(awarenessNode);
        if (awarenessNodeArray == null) {
            return false;
        }
        for (int i = 0; i < awarenessNodeArray.length; ++i) {
            if (!awarenessNodeArray[i].isOnline()) continue;
            return true;
        }
        return false;
    }

    static final int numOfOnlineUsersInGroup(AwarenessNode awarenessNode) {
        int n = 0;
        AwarenessNode[] awarenessNodeArray = m_model.getChilds(awarenessNode);
        if (awarenessNodeArray == null) {
            return 0;
        }
        for (int i = 0; i < awarenessNodeArray.length; ++i) {
            if (!awarenessNodeArray[i].isOnline()) continue;
            ++n;
        }
        return n;
    }

    static final int numOfOnlineExternalUsersInGroup(AwarenessNode awarenessNode) {
        int n = 0;
        AwarenessNode[] awarenessNodeArray = m_model.getChilds(awarenessNode);
        if (awarenessNodeArray == null) {
            return 0;
        }
        for (int i = 0; i < awarenessNodeArray.length; ++i) {
            if (!awarenessNodeArray[i].isOnline() || !((STUser)awarenessNodeArray[i].getKey()).isExternalUser()) continue;
            ++n;
        }
        return n;
    }

    static Frame getMainFrame() {
        STSession sTSession = m_model.getSession();
        Frame frame = (Frame)sTSession.getSessionProperty("mainFrame");
        return frame == null ? new Frame() : frame;
    }
}

