/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.awareness;

import com.lotus.sametime.awareness.AttributeEvent;
import com.lotus.sametime.awareness.AttributeProtocol;
import com.lotus.sametime.awareness.AwarenessServiceEvent;
import com.lotus.sametime.awareness.STWatchedObject;
import com.lotus.sametime.awareness.STWatchedUser;
import com.lotus.sametime.awareness.Session;
import com.lotus.sametime.awareness.StatusEvent;
import com.lotus.sametime.awareness.WatchedObjectsFactory;
import com.lotus.sametime.awareness.WioEntityTable;
import com.lotus.sametime.awareness.WioGroup;
import com.lotus.sametime.awareness.WioObject;
import com.lotus.sametime.community.Channel;
import com.lotus.sametime.community.ChannelEvent;
import com.lotus.sametime.community.ChannelListener;
import com.lotus.sametime.community.ChannelService;
import com.lotus.sametime.community.CommunityService;
import com.lotus.sametime.community.LoginEvent;
import com.lotus.sametime.community.LoginListener;
import com.lotus.sametime.community.ServiceEvent;
import com.lotus.sametime.community.ServiceListener;
import com.lotus.sametime.core.comparch.DuplicateObjectException;
import com.lotus.sametime.core.comparch.STCompApi;
import com.lotus.sametime.core.comparch.STCompImpl;
import com.lotus.sametime.core.comparch.STEvent;
import com.lotus.sametime.core.comparch.STSession;
import com.lotus.sametime.core.constants.EncLevel;
import com.lotus.sametime.core.types.STGroup;
import com.lotus.sametime.core.types.STId;
import com.lotus.sametime.core.types.STObject;
import com.lotus.sametime.core.types.STUser;
import com.lotus.sametime.core.types.STUserInstance;
import com.lotus.sametime.core.types.STUserStatus;
import com.lotus.sametime.core.util.Debug;
import com.lotus.sametime.core.util.Dumpable;
import com.lotus.sametime.core.util.NdrInputStream;
import com.lotus.sametime.core.util.NdrOutputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AwarenessImpl
extends STCompImpl
implements ChannelListener,
LoginListener,
ServiceListener {
    static final short REQUEST_NO_REQUEST = 0;
    static final short REQUEST_ADD = 104;
    static final short REQUEST_REMOVE = 105;
    static final short RECIEVE_NO_EVENT = 0;
    static final short RECIEVE_SNAPSHOT = 500;
    static final short RECIEVE_UPDATE = 501;
    static final short CLEAR_GROUP_CONTENT = 502;
    private static final int PROT_VERSION_WIO_WITH_ATTS = 196613;
    private static final int PROT_VERSION_WIO_WITH_NET_ICON = 196614;
    Channel m_channel;
    WioEntityTable m_watchedEntities;
    STUserInstance m_loginInfo;
    private String m_serverName = "";
    private boolean m_serviceRequested = false;
    private ChannelService m_channelService;
    private CommunityService m_comm;
    private boolean m_serviceUp = false;
    int m_maxAttributeSize;
    WatchedObjectsFactory m_objectFactory = new WatchedObjectsFactory();
    private AttributeProtocol m_attribImpl;
    private boolean m_isNetIconSupported = false;
    private Logger m_logger = Logger.getLogger("com.lotus.sametime.awareness");

    public AwarenessImpl(STSession sTSession) throws DuplicateObjectException {
        super("com.lotus.sametime.awareness.AwarenessComp", sTSession);
        this.m_comm = (CommunityService)sTSession.getCompApi("com.lotus.sametime.community.STBase");
        if (null != this.m_comm) {
            this.m_comm.addLoginListener(this);
            this.m_comm.addServiceListener(this);
        }
        this.m_channelService = (ChannelService)sTSession.getCompApi("com.lotus.sametime.community.STBase");
        this.m_watchedEntities = new WioEntityTable(this);
        this.loadProtocolImpl();
    }

    public void start() {
        if (this.m_logger.isLoggable(Level.FINER)) {
            this.m_logger.logp(Level.FINER, this.getClass().getName(), "start", this + ": Start Called.");
        }
        Debug.stAssert(this.m_comm != null);
    }

    public void stop() {
        if (this.m_logger.isLoggable(Level.FINER)) {
            this.m_logger.logp(Level.FINER, this.getClass().getName(), "stop", this + ": Stop Called.");
        }
        this.m_comm.removeLoginListener(this);
        this.m_comm.removeServiceListener(this);
        if (null != this.m_channel) {
            this.destroyWIOChannel();
        }
    }

    public void componentLoaded(STCompApi sTCompApi) {
        if (null == this.m_comm && sTCompApi instanceof CommunityService) {
            this.m_comm = (CommunityService)sTCompApi;
            this.m_comm.addLoginListener(this);
            this.m_comm.addServiceListener(this);
        }
        if (null == this.m_channelService && sTCompApi instanceof ChannelService) {
            this.m_channelService = (ChannelService)sTCompApi;
        }
    }

    public void createList(Integer n) {
        if (this.m_watchedEntities.isSessionExists(n)) {
            return;
        }
        Session session = new Session(n, true);
        this.m_watchedEntities.addSession(session);
    }

    public void destroyList(Integer n) {
        if (!this.m_watchedEntities.isSessionExists(n)) {
            return;
        }
        this.resetList(n);
        this.m_watchedEntities.removeSession(n);
    }

    void watchObjects(Integer n, STObject[] sTObjectArray) {
        if (!this.m_watchedEntities.isSessionExists(n)) {
            return;
        }
        Vector<WioObject> vector = new Vector<WioObject>();
        Dumpable dumpable = null;
        for (int i = 0; i < sTObjectArray.length; ++i) {
            if (sTObjectArray[i] != null) {
                dumpable = sTObjectArray[i] instanceof STGroup ? this.watchGroup(n, (STGroup)sTObjectArray[i]) : this.watchObject(n, sTObjectArray[i]);
            }
            if (null == dumpable) continue;
            vector.addElement((WioObject)dumpable);
        }
        this.submitList(vector, (short)104);
    }

    private WioObject watchObject(Integer n, STObject sTObject) {
        WioObject wioObject = null;
        WioObject wioObject2 = this.m_watchedEntities.getObj(sTObject.getId());
        if (wioObject2 != null && wioObject2.isWatchedBySession()) {
            wioObject2.addWatch(n);
            if (this.m_watchedEntities.getSession(n).isVisible()) {
                STWatchedObject sTWatchedObject;
                if (wioObject2.getWatchedObject() instanceof STWatchedUser && (sTWatchedObject = (STWatchedUser)wioObject2.getWatchedObject()).getStatus() != null) {
                    STWatchedUser[] sTWatchedUserArray = new STWatchedUser[]{(STWatchedUser)sTWatchedObject.clone()};
                    this.sendEvent(new StatusEvent((Object)this, -2147483647, n, sTWatchedUserArray));
                }
                if (null != this.m_attribImpl && wioObject2.getWatchedObject().getAttributes().size() > 0) {
                    sTWatchedObject = (STWatchedObject)wioObject2.getWatchedObject().clone();
                    this.m_attribImpl.sendAttributesSnapshot(sTWatchedObject, n);
                }
            }
        } else {
            STWatchedObject sTWatchedObject = this.m_objectFactory.getWatchedObject(sTObject);
            wioObject = this.m_watchedEntities.addObjWatch(sTWatchedObject, this.m_objectFactory.getType(sTObject), n);
        }
        return wioObject;
    }

    private WioGroup watchGroup(Integer n, STGroup sTGroup) {
        WioGroup wioGroup = null;
        WioGroup wioGroup2 = this.m_watchedEntities.getGroup(sTGroup.getId());
        if (wioGroup2 == null) {
            wioGroup = this.m_watchedEntities.addGroupWatch(sTGroup, n);
            Session session = new Session(AwarenessImpl.getUniqueId(), false);
            this.m_watchedEntities.addSession(session);
            wioGroup.setInvisibleSession(session.getId());
        } else {
            wioGroup2.addWatch(n);
            WioObject[] wioObjectArray = this.m_watchedEntities.getUsersInGroups(sTGroup);
            if (null != wioObjectArray) {
                int n2;
                STWatchedUser[] sTWatchedUserArray = new STWatchedUser[wioObjectArray.length];
                for (n2 = 0; n2 < wioObjectArray.length; ++n2) {
                    sTWatchedUserArray[n2] = (STWatchedUser)wioObjectArray[n2].getWatchedObject().clone();
                    sTWatchedUserArray[n2].setGroup(sTGroup);
                }
                this.sendEvent(new StatusEvent((Object)this, -2147483647, n, sTWatchedUserArray));
                if (null != this.m_attribImpl) {
                    for (n2 = 0; n2 < wioObjectArray.length; ++n2) {
                        this.m_attribImpl.sendAttributesSnapshot(sTWatchedUserArray[n2], n);
                    }
                }
            }
        }
        return wioGroup;
    }

    void stopWatch(Integer n, STObject[] sTObjectArray) {
        Vector<WioObject> vector = new Vector<WioObject>();
        Dumpable dumpable = null;
        for (int i = 0; i < sTObjectArray.length; ++i) {
            dumpable = sTObjectArray[i] instanceof STGroup ? this.stopGroupWatch(n, (STGroup)sTObjectArray[i]) : this.stopObjectWatch(n, sTObjectArray[i]);
            if (null == dumpable) continue;
            vector.addElement((WioObject)dumpable);
        }
        this.submitList(vector, (short)105);
    }

    private WioObject stopObjectWatch(Integer n, STObject sTObject) {
        WioObject wioObject = null;
        WioObject wioObject2 = this.m_watchedEntities.removeObjWatch(sTObject, n);
        if (null != wioObject2 && !wioObject2.isWatchedBySession()) {
            wioObject = wioObject2;
        }
        return wioObject;
    }

    private WioGroup stopGroupWatch(Integer n, STGroup sTGroup) {
        WioGroup wioGroup = null;
        WioGroup wioGroup2 = this.m_watchedEntities.removeGroupWatch(sTGroup, n);
        if (null != wioGroup2 && this.m_watchedEntities.getGroup(sTGroup.getId()) == null) {
            wioGroup = wioGroup2;
            this.resetList(wioGroup2.getInvisibleSessionId());
        }
        return wioGroup;
    }

    private void submitList(Vector vector, short s) {
        if (null != this.m_channel && this.m_channel.isOpen() && vector.size() > 0) {
            byte[] byArray = this.generateWatchMessage(vector);
            this.m_channel.sendMsg(s, byArray, false);
        }
    }

    public void resetList(Integer n) {
        if (!this.m_watchedEntities.isSessionExists(n)) {
            return;
        }
        Vector vector = this.m_watchedEntities.sessionUsers(n);
        Vector vector2 = this.m_watchedEntities.sessionGroups(n);
        Object[] objectArray = new STObject[vector.size()];
        vector.copyInto(objectArray);
        this.stopWatch(n, (STObject[])objectArray);
        objectArray = new STObject[vector2.size()];
        vector2.copyInto(objectArray);
        this.stopWatch(n, (STObject[])objectArray);
    }

    protected boolean isServiceAvailable() {
        return this.m_serviceUp;
    }

    public void channelOpened(ChannelEvent channelEvent) {
        Channel channel = channelEvent.getChannel();
        Debug.stAssert(this.m_channel == channel);
        this.m_serverName = this.m_channel.getRemoteInfo().getCommunityName();
        boolean bl = this.m_isNetIconSupported = this.m_channel.getProtocolVersion() >= 196614;
        if (this.m_logger.isLoggable(Level.FINEST)) {
            this.m_logger.logp(Level.FINEST, this.getClass().getName(), "channelOpened", "AwarenessService: m_isNeticonSupported = " + this.m_isNetIconSupported);
        }
        if (this.m_channel.getProtocolVersion() >= 196613) {
            try {
                NdrInputStream ndrInputStream = new NdrInputStream(this.m_channel.getCreateData());
                ndrInputStream.loadMark();
                this.m_maxAttributeSize = ndrInputStream.readInt();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            if (null != this.m_attribImpl) {
                this.m_attribImpl.setFilter();
            }
        }
        this.sendEvent(new AwarenessServiceEvent(this, -2147483644));
        if (this.m_logger.isLoggable(Level.FINER)) {
            this.m_logger.logp(Level.FINER, this.getClass().getName(), "channelOpened", "WIO: SERVICE-UP");
        }
        this.m_serviceUp = true;
        if (!this.m_watchedEntities.isEmpty()) {
            this.rewatchEntities();
            if (null != this.m_attribImpl) {
                this.m_attribImpl.resendAttributes();
            }
        }
    }

    public void channelMsgReceived(ChannelEvent channelEvent) {
        Channel channel = channelEvent.getChannel();
        Debug.stAssert(this.m_channel == channel);
        boolean bl = true;
        switch (channelEvent.getMessageType()) {
            case 502: {
                this.clearGroup(channelEvent.getData());
                break;
            }
            case 500: 
            case 501: {
                this.changeUsersStatus(channelEvent.getMessageType(), channelEvent.getData());
                break;
            }
            default: {
                bl = false;
            }
        }
        if (!bl && null != this.m_attribImpl) {
            this.m_attribImpl.handleMsg(channelEvent.getMessageType(), channelEvent.getData(), channelEvent.isEncrypted());
        }
    }

    public void channelOpenFailed(ChannelEvent channelEvent) {
        Channel channel = channelEvent.getChannel();
        Debug.stAssert(this.m_channel == channel);
        boolean bl = channelEvent.getReason() != -2147483643;
        this.channelDestroyed(channelEvent.getReason(), channelEvent.getData(), bl);
    }

    public void channelClosed(ChannelEvent channelEvent) {
        Channel channel = channelEvent.getChannel();
        Debug.stAssert(this.m_channel == channel);
        this.channelDestroyed(channelEvent.getReason(), channelEvent.getData(), true);
    }

    private void channelDestroyed(int n, byte[] byArray, boolean bl) {
        this.m_channel = null;
        this.m_serviceUp = false;
        this.sendEvent(new AwarenessServiceEvent(this, -2147483643));
        Enumeration enumeration = this.m_watchedEntities.getUsers();
        STUserStatus sTUserStatus = new STUserStatus(0, 0, "");
        while (enumeration.hasMoreElements()) {
            WioObject wioObject = (WioObject)enumeration.nextElement();
            if (!(wioObject.getWatchedObject() instanceof STWatchedUser)) continue;
            ((STWatchedUser)wioObject.getWatchedObject()).setStatus(sTUserStatus);
        }
        enumeration = this.m_watchedEntities.getGroups();
        while (enumeration.hasMoreElements()) {
            WioGroup wioGroup = (WioGroup)enumeration.nextElement();
            this.m_watchedEntities.clearGroupContent(wioGroup.getSTGroup());
        }
        if (bl) {
            this.requestBLService();
        }
    }

    public void serviceAvailable(ServiceEvent serviceEvent) {
        if (serviceEvent.getServiceType() != 17) {
            return;
        }
        if (null == this.m_channel && this.m_comm.isLoggedIn()) {
            this.createWIOChannel();
        }
    }

    public void loggedIn(LoginEvent loginEvent) {
        Debug.stAssert(this.m_channel == null);
        if (!this.m_serviceRequested) {
            this.requestBLService();
        }
        this.m_loginInfo = this.m_comm.getLogin().getMyUserInstance();
    }

    public void loggedOut(LoginEvent loginEvent) {
        this.m_serviceRequested = false;
    }

    public void communitiesQueried(String[] stringArray) {
    }

    private void changeUsersStatus(short s, byte[] byArray) {
        NdrInputStream ndrInputStream = new NdrInputStream(byArray);
        Vector<STWatchedUser> vector = new Vector<STWatchedUser>();
        Vector<STWatchedUser> vector2 = new Vector<STWatchedUser>();
        String string = null;
        int n = 1;
        try {
            if (s == 500) {
                n = ndrInputStream.readInt();
            }
            while (n > 0) {
                ndrInputStream.loadMark();
                short s2 = ndrInputStream.readShort();
                if (s2 == 2) {
                    WioGroup wioGroup;
                    String string2;
                    String string3;
                    short s3;
                    boolean bl;
                    STId sTId = new STId(ndrInputStream);
                    STId sTId2 = new STId(ndrInputStream.readUTF(), sTId.getCommunityName());
                    boolean bl2 = bl = ndrInputStream.readByte() != 0;
                    if (bl) {
                        ndrInputStream.readUTF();
                        s3 = ndrInputStream.readShort();
                        if (s3 == 0) {
                            s3 = Short.MIN_VALUE;
                        }
                        ndrInputStream.readInt();
                        string3 = ndrInputStream.readUTF();
                        string2 = ndrInputStream.readUTF();
                    } else {
                        s3 = 0;
                        string3 = "";
                        string2 = "";
                    }
                    if (this.m_isNetIconSupported) {
                        string = ndrInputStream.readUTF();
                    }
                    boolean bl3 = false;
                    if (null != this.m_attribImpl && s == 500) {
                        bl3 = this.checkNeedForAttributeDispatch(sTId, sTId2, bl);
                    }
                    WioObject wioObject = this.m_watchedEntities.setUserStatus(sTId, sTId2, string2, s3, string3, string);
                    if (!bl) {
                        wioObject.getWatchedObject().getAttributes().clear();
                    }
                    STWatchedUser sTWatchedUser = this.createObjForDispatch(wioObject, sTId2);
                    vector.addElement(sTWatchedUser);
                    if (!sTId2.getId().equalsIgnoreCase("") && !wioObject.isWatched((wioGroup = this.m_watchedEntities.getGroup(sTId2)).getInvisibleSessionId())) {
                        this.watchObjects(wioGroup.getInvisibleSessionId(), new STObject[]{wioObject.getWatchedObject()});
                    }
                    if (bl3) {
                        vector2.addElement(sTWatchedUser);
                    }
                }
                ndrInputStream.skipMarks();
                --n;
            }
            this.notifyStatusChange(vector);
            if (vector2.size() > 0) {
                this.m_attribImpl.sendAttributesSnapshot(vector2);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private boolean checkNeedForAttributeDispatch(STId sTId, STId sTId2, boolean bl) {
        WioObject wioObject;
        boolean bl2 = false;
        if (bl && null != (wioObject = this.m_watchedEntities.getObj(sTId)) && wioObject.getWatchedObject().getAttributes().size() > 0 && !wioObject.isWatched(sTId2)) {
            bl2 = true;
        }
        return bl2;
    }

    private void rewatchEntities() {
        Vector vector = this.m_watchedEntities.getAllWatchedEntities();
        byte[] byArray = this.generateWatchMessage(vector);
        this.m_channel.sendMsg((short)104, byArray, false);
    }

    private STWatchedUser createObjForDispatch(WioObject wioObject, STId sTId) {
        STWatchedUser sTWatchedUser = (STWatchedUser)wioObject.getWatchedObject().clone();
        if (null != sTId && !sTId.getId().equalsIgnoreCase("")) {
            WioGroup wioGroup = this.m_watchedEntities.getGroup(sTId);
            sTWatchedUser.setGroup(wioGroup.getSTGroup());
        }
        return sTWatchedUser;
    }

    private void notifyStatusChange(Vector vector) {
        Integer n;
        Hashtable<Integer, Vector<STWatchedUser>> hashtable = new Hashtable<Integer, Vector<STWatchedUser>>();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            STWatchedUser sTWatchedUser = (STWatchedUser)enumeration.nextElement();
            Enumeration enumeration2 = null != sTWatchedUser.getGroup() ? this.m_watchedEntities.getGroupWatchingSessions(sTWatchedUser.getGroup().getId()) : this.m_watchedEntities.getObjWatchingSessions(sTWatchedUser.getId());
            while (null != enumeration2 && enumeration2.hasMoreElements()) {
                n = (Integer)enumeration2.nextElement();
                if (!this.m_watchedEntities.getSession(n).isVisible()) continue;
                Vector<STWatchedUser> vector2 = (Vector<STWatchedUser>)hashtable.get(n);
                if (null == vector2) {
                    vector2 = new Vector<STWatchedUser>();
                    hashtable.put(n, vector2);
                }
                vector2.addElement(sTWatchedUser);
            }
        }
        Enumeration enumeration3 = hashtable.keys();
        while (enumeration3.hasMoreElements()) {
            n = (Integer)enumeration3.nextElement();
            Vector vector3 = (Vector)hashtable.get(n);
            Object[] objectArray = new STWatchedUser[vector3.size()];
            vector3.copyInto(objectArray);
            StatusEvent statusEvent = new StatusEvent((Object)this, -2147483647, n, (STWatchedUser[])objectArray);
            this.sendEvent(statusEvent);
        }
    }

    private void clearGroup(byte[] byArray) {
        STId sTId = null;
        NdrInputStream ndrInputStream = new NdrInputStream(byArray);
        try {
            ndrInputStream.readShort();
            sTId = new STId(ndrInputStream);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        Enumeration enumeration = this.m_watchedEntities.getGroupWatchingSessions(sTId);
        if (enumeration == null) {
            return;
        }
        STGroup sTGroup = this.m_watchedEntities.getGroup(sTId).getSTGroup();
        while (enumeration.hasMoreElements()) {
            Integer n = (Integer)enumeration.nextElement();
            StatusEvent statusEvent = new StatusEvent((Object)this, -2147483642, n, sTGroup);
            this.sendEvent(statusEvent);
        }
        this.m_watchedEntities.clearGroupContent(sTGroup);
    }

    private void requestBLService() {
        if (this.m_comm.isLoggedIn()) {
            this.m_serviceRequested = true;
            this.m_comm.senseService(17);
        }
    }

    private void createWIOChannel() {
        this.m_channel = this.m_channelService.createChannel(17, 17, 196614, EncLevel.ENC_LEVEL_NONE, null, null);
        this.m_channel.addChannelListener(this);
        this.m_channel.open();
    }

    private void destroyWIOChannel() {
        this.m_channel.close(0, null);
        this.m_serviceRequested = false;
    }

    private byte[] generateWatchMessage(Vector vector) {
        NdrOutputStream ndrOutputStream = new NdrOutputStream();
        try {
            ndrOutputStream.writeInt(vector.size());
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                Dumpable dumpable = (Dumpable)enumeration.nextElement();
                dumpable.dumpToStream(ndrOutputStream);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return ndrOutputStream.toByteArray();
    }

    public void processSTEvent(STEvent sTEvent) {
        if (sTEvent instanceof StatusEvent) {
            this.processStatusEvent((StatusEvent)sTEvent);
        } else if (sTEvent instanceof AttributeEvent && null != this.m_attribImpl) {
            this.m_attribImpl.processSTEvent(sTEvent);
        } else {
            super.processSTEvent(sTEvent);
        }
    }

    protected void processStatusEvent(StatusEvent statusEvent) {
        switch (statusEvent.getId()) {
            case 1: {
                this.createList(statusEvent.getListId());
                statusEvent.setConsumed(true);
                break;
            }
            case 2: {
                this.destroyList(statusEvent.getListId());
                statusEvent.setConsumed(true);
                break;
            }
            case 5: {
                this.watchObjects(statusEvent.getListId(), statusEvent.getSTObjects());
                statusEvent.setConsumed(true);
                break;
            }
            case 6: {
                this.stopWatch(statusEvent.getListId(), statusEvent.getSTObjects());
                statusEvent.setConsumed(true);
                break;
            }
            case 3: {
                this.resetList(statusEvent.getListId());
                statusEvent.setConsumed(true);
            }
        }
    }

    private void loadProtocolImpl() {
        try {
            Class<?> clazz = Class.forName("com.lotus.sametime.awareness.AttribProtocolImpl");
            Class[] classArray = new Class[]{this.getClass()};
            Constructor<?> constructor = clazz.getConstructor(classArray);
            Object[] objectArray = new Object[]{this};
            this.m_attribImpl = (AttributeProtocol)constructor.newInstance(objectArray);
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("Failed to load Attribute Protocol Implementation WIO Component is functional but with limited features");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected boolean isChannelOpen() {
        boolean bl = false;
        if (null != this.m_channel && this.m_channel.isOpen()) {
            bl = true;
        }
        return bl;
    }

    protected STUserStatus findUserStatus(STUser sTUser) {
        STUserStatus sTUserStatus = null;
        WioObject wioObject = this.m_watchedEntities.getObj(sTUser.getId());
        if (null != wioObject && wioObject.getWatchedObject() instanceof STWatchedUser) {
            sTUserStatus = ((STWatchedUser)wioObject.getWatchedObject()).getStatus();
        }
        return sTUserStatus;
    }
}

