/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.announcementui;

import com.lotus.sametime.announcement.AnnouncementEvent;
import com.lotus.sametime.chatui.ChatUI;
import com.lotus.sametime.core.comparch.STSession;
import com.lotus.sametime.guiutils.accessibility.AccessibilityHelpers;
import com.lotus.sametime.guiutils.accessibility.KeyAction;
import com.lotus.sametime.guiutils.accessibility.KeyHandler;
import com.lotus.sametime.guiutils.misc.ButtonsPanel;
import com.lotus.sametime.guiutils.statusbar.Statusbar;
import com.lotus.sametime.resourceloader.ResourceLoaderService;
import com.lotus.sametime.resourceloader.STBundle;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.SystemColor;
import java.awt.TextArea;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.DateFormat;
import java.util.Date;
import java.util.Vector;

public class AnnouncementDialog
extends Frame {
    private static final long serialVersionUID = 1L;
    private static final short PADDING = 5;
    private static String BUNDLE_FILE_NAME = "properties/announcementui";
    private STSession m_session;
    private AnnouncementEvent m_event;
    private ResourceLoaderService m_loader;
    private STBundle m_resourceFile;
    private ChatUI m_chatui;

    public AnnouncementDialog(STSession sTSession, AnnouncementEvent announcementEvent) {
        this.m_session = sTSession;
        this.m_event = announcementEvent;
        this.addWindowListener(new WindowEventHandler());
        this.m_loader = (ResourceLoaderService)((Object)this.m_session.getCompApi("com.lotus.sametime.resourceloader.ResourceLoaderComp"));
        this.m_resourceFile = this.m_loader.getBundle(BUNDLE_FILE_NAME);
        this.m_chatui = (ChatUI)this.m_session.getCompApi("com.lotus.sametime.chatui.ChatUIComp");
        this.showDialog();
        Toolkit.getDefaultToolkit().beep();
    }

    private void showDialog() {
        ButtonsPanel buttonsPanel;
        Object object;
        Object[] objectArray = new String[]{this.m_event.getSender().getName()};
        this.setTitle(this.m_resourceFile.formatString("ANN_DLG_TITLE", objectArray));
        this.setBackground(SystemColor.control);
        this.setFont(Font.decode(Toolkit.getDefaultToolkit().getFontList()[0]));
        this.setLayout(new BorderLayout(0, 20));
        ButtonEventHandler buttonEventHandler = new ButtonEventHandler();
        Panel panel = new Panel(new BorderLayout(0, 20));
        Object[] objectArray2 = new Object[]{this.m_event.getSender().getDisplayName(), DateFormat.getTimeInstance(3).format(new Date(System.currentTimeMillis()))};
        Label label = new Label(this.m_resourceFile.formatString("ANN_DLG_DETAILS", objectArray2));
        TextArea textArea = new TextArea(this.m_event.getMsgText(), 3, 30, 1);
        textArea.setEditable(false);
        if (this.m_event.isResponseAllowed()) {
            object = new String[]{this.m_resourceFile.getString("ANN_DLG_BTN_RESPOND"), this.m_resourceFile.getString("ANN_DLG_BTN_CLOSE")};
            buttonsPanel = new ButtonsPanel((String[])object, buttonEventHandler, 2);
        } else {
            object = new String[]{this.m_resourceFile.getString("ANN_DLG_BTN_CLOSE")};
            buttonsPanel = new ButtonsPanel((String[])object, buttonEventHandler, 2);
        }
        panel.add((Component)label, "North");
        panel.add((Component)textArea, "Center");
        panel.add((Component)buttonsPanel, "South");
        object = new Statusbar("", this.m_resourceFile.getFont("FONT_PLAIN_NAME", "FONT_PLAIN_STYLE", "FONT_PLAIN_SIZE"), this.m_resourceFile.getInt("STATUSBAR_HEIGHT"), this.m_loader.getImage("images/no_encrypt_key.gif"));
        this.add((Component)panel, "Center");
        this.add((Component)object, "South");
        Dimension dimension = this.getSize();
        Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension2.width - dimension.width) / 2, (dimension2.height - dimension.height) / 2);
        KeyHandler keyHandler = this.createKeyHandler();
        AccessibilityHelpers.addKeyListenerToSubComponents(this, keyHandler);
        this.pack();
        this.setResizable(false);
        this.setVisible(true);
        this.show();
    }

    private KeyHandler createKeyHandler() {
        Vector<KeyAction> vector = new Vector<KeyAction>();
        vector.addElement(new KeyAction(10){

            public void executeKeyMethod() {
                AnnouncementDialog.this.dispose();
            }
        });
        vector.addElement(new KeyAction(27){

            public void executeKeyMethod() {
                AnnouncementDialog.this.dispose();
            }
        });
        vector.addElement(new KeyAction(KeyAction.getKeyCodeByString(this.m_resourceFile.getString("MN_BTN_CLOSE"))){

            public void executeKeyMethod() {
                AnnouncementDialog.this.dispose();
            }
        });
        vector.addElement(new KeyAction(KeyAction.getKeyCodeByString(this.m_resourceFile.getString("MN_BTN_RESPOND"))){

            public void executeKeyMethod() {
                if (AnnouncementDialog.this.m_event.isResponseAllowed()) {
                    AnnouncementDialog.this.m_chatui.create1On1ChatById(AnnouncementDialog.this.m_event.getSender());
                }
            }
        });
        return new KeyHandler(vector);
    }

    public Insets getInsets() {
        Insets insets = super.getInsets();
        return new Insets(insets.top + 5 + 5, insets.left + 5, insets.bottom + 5, insets.right + 5);
    }

    private class WindowEventHandler
    extends WindowAdapter {
        private WindowEventHandler() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            AnnouncementDialog.this.dispose();
        }
    }

    private class ButtonEventHandler
    implements ActionListener {
        private ButtonEventHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = ((Button)actionEvent.getSource()).getLabel();
            if (string == AnnouncementDialog.this.m_resourceFile.getString("ANN_DLG_BTN_RESPOND")) {
                AnnouncementDialog.this.m_chatui.create1On1ChatById(AnnouncementDialog.this.m_event.getSender());
            } else if (string == AnnouncementDialog.this.m_resourceFile.getString("ANN_DLG_BTN_CLOSE")) {
                AnnouncementDialog.this.dispose();
            }
        }
    }
}

