/*
 * Decompiled with CFR 0.152.
 */
package com.zerog.util.nativelib.macos;

import com.apple.mrj.macos.generated.FSSpecStruct;
import com.apple.mrj.macos.generated.FileFunctions;
import com.apple.mrj.macos.toolbox.FSSpec;
import com.apple.mrj.macos.toolbox.MacOSError;
import com.apple.mrj.macos.toolbox.Toolbox;
import com.zerog.ia.installer.util.mrj.MRJOSType;
import java.io.File;
import java.io.IOException;

public class MacFile
extends Flexeraavu {
    public static final short FinderInfo_Length = 16;
    public static final short FinderInfo_Off_Beginning = 0;
    public static final short FinderInfo_Off_Type = 0;
    public static final short FinderInfo_Off_Creator = 4;
    public static final short FinderInfo_Off_LowFlags = 9;
    public static final short FinderInfo_Off_HighFlags = 8;
    public static final short FinderInfo_Off_WindowPosition = 10;
    public static final short FinderInfo_Off_FolderID = 14;
    public static final short kMaxMacFileNameLength = 63;
    private static final int fnfErr = -43;
    private static final int dirNFErr = -120;
    private static final int connectionInvalid = -609;
    public FSSpec spec;
    public FSSpecStruct specStruct;
    private boolean specMade = false;

    private static native short iGetFSSpec(String var0, byte[] var1);

    private static native int iGetFileCreator(byte[] var0);

    private static native void iSetFileCreator(byte[] var0, int var1);

    private static native short iSetCreatorInBNDL(byte[] var0, int var1, int var2);

    public MacFile(String string) throws IOException {
        super(string);
    }

    public MacFile(File file) throws IOException {
        this(file.getPath());
    }

    private static native boolean iIsAlias(byte[] var0);

    public boolean isAlias() {
        try {
            return MacFile.iIsAlias(this.getFSSpec().getBytes());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    private static native boolean iIsLocal(short var0);

    public static boolean isLocal(short s) {
        return MacFile.iIsLocal(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLocal() {
        try {
            Toolbox toolbox = Toolbox.LOCK;
            synchronized (toolbox) {
                return MacFile.iIsLocal(this.getFSSpec().getVRefNum());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    private static native boolean iIsLocked(short var0);

    public static boolean isLocked(short s) {
        return MacFile.iIsLocked(s);
    }

    private static native short iFreeSpace(short var0, long[] var1, long[] var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void freeSpace(short s, long[] lArray, long[] lArray2) {
        long l = 0L;
        try {
            Toolbox toolbox = Toolbox.LOCK;
            synchronized (toolbox) {
                Flexeraawy.ac(MacFile.iFreeSpace(s, lArray, lArray2));
            }
        }
        catch (Throwable throwable) {
            System.err.println("Couldn't get free space for volume: " + s);
            throwable.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long freeSpaceInBytes(short s) {
        long[] lArray = new long[1];
        long[] lArray2 = new long[1];
        try {
            Toolbox toolbox = Toolbox.LOCK;
            synchronized (toolbox) {
                Flexeraawy.ac(MacFile.iFreeSpace(s, lArray, lArray2));
            }
        }
        catch (Flexeraawy flexeraawy) {
            return -1L;
        }
        return lArray[0] * lArray2[0];
    }

    public long freeSpace() {
        try {
            short s = this.getFSSpec().getVRefNum();
            long l = MacFile.freeSpaceInBytes(s);
            return l;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return -1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFileCreator() throws IOException, Flexeraawy {
        Toolbox toolbox = Toolbox.LOCK;
        synchronized (toolbox) {
            return MacFile.iGetFileCreator(this.getFSSpec().getBytes());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFileCreator(int n) throws IOException {
        try {
            Toolbox toolbox = Toolbox.LOCK;
            synchronized (toolbox) {
                MacFile.iSetFileCreator(this.getFSSpec().getBytes(), n);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCreatorInBNDL(int n, int n2) throws IOException, Flexeraawy {
        try {
            Toolbox toolbox = Toolbox.LOCK;
            synchronized (toolbox) {
                Flexeraawy.ac(MacFile.iSetCreatorInBNDL(this.getFSSpec().getBytes(), n, n2));
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw new IOException("Couldn't change bndl resource: " + this.getPath() + "  BNDL ID: " + n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIcon(int[] nArray) throws IOException {
        if (!this.exists()) {
            throw new IOException(this.getPath() + " does not exist!");
        }
        if (nArray.length != 1024) {
            System.err.println("largeIcon " + nArray.length + " bytes and not 32 by 32!");
        }
        Toolbox toolbox = Toolbox.LOCK;
        synchronized (toolbox) {
            this.setIconLarge(this.getPath(), nArray);
        }
    }

    private native void setIconLarge(String var1, int[] var2) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIcon(int[] nArray, int[] nArray2) throws IOException {
        if (!this.exists()) {
            throw new IOException(this.getPath() + " does not exist!");
        }
        if (nArray.length != 1024) {
            System.err.println("largeIcon " + nArray.length + " bytes and not 32 by 32!");
        }
        if (nArray2.length != 256) {
            System.err.println("smallIcon " + nArray.length + " bytes and not 16 by 16!");
        }
        Toolbox toolbox = Toolbox.LOCK;
        synchronized (toolbox) {
            this.setIconLargeSmall(this.getPath(), nArray, nArray2);
        }
    }

    private native void setIconLargeSmall(String var1, int[] var2, int[] var3) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIcon(int[] nArray, int n) throws IOException {
        if (!this.exists()) {
            throw new IOException(this.getPath() + " does not exist!");
        }
        if (nArray.length != 1024) {
            System.err.println("largeIcon " + nArray.length + " bytes and not 32 by 32!");
        }
        Toolbox toolbox = Toolbox.LOCK;
        synchronized (toolbox) {
            this.addIconLarge(this.getPath(), nArray, n);
        }
    }

    private native void addIconLarge(String var1, int[] var2, int var3) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIcon(int[] nArray, int[] nArray2, int n) throws IOException {
        if (!this.exists()) {
            throw new IOException(this.getPath() + " does not exist!");
        }
        if (nArray.length != 1024) {
            System.err.println("largeIcon " + nArray.length + " bytes and not 32 by 32!");
        }
        if (nArray2.length != 256) {
            System.err.println("smallIcon " + nArray.length + " bytes and not 16 by 16!");
        }
        Toolbox toolbox = Toolbox.LOCK;
        synchronized (toolbox) {
            this.addIconLargeSmall(this.getPath(), nArray, nArray2, n);
        }
    }

    private native void addIconLargeSmall(String var1, int[] var2, int[] var3, int var4) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void linkIconToType(int n, int n2) throws IOException {
        if (!this.exists()) {
            throw new IOException(this.getPath() + " does not exist!");
        }
        Toolbox toolbox = Toolbox.LOCK;
        synchronized (toolbox) {
            this.linkIconToType(this.getPath(), n, n2);
        }
    }

    private native void linkIconToType(String var1, int var2, int var3) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String findApplication(MRJOSType mRJOSType) throws IOException {
        Toolbox toolbox = Toolbox.LOCK;
        synchronized (toolbox) {
            return MacFile.iFindApplication(mRJOSType.toInt());
        }
    }

    private static native String iFindApplication(int var0);

    public int sendExpandEvent(MRJOSType mRJOSType, Flexeraavu flexeraavu, boolean bl) throws IOException, Flexeraawy {
        return MacFile.sendExpandEvent(mRJOSType, this, flexeraavu, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int sendExpandEvent(MRJOSType mRJOSType, Flexeraavu flexeraavu, Flexeraavu flexeraavu2, boolean bl) throws IOException, Flexeraawy {
        int n = 0;
        Toolbox toolbox = Toolbox.LOCK;
        synchronized (toolbox) {
            n = MacFile.iSendExpandEvent(mRJOSType.toInt(), Flexeraavv.aa(flexeraavu.getAbsolutePath()), Flexeraavv.aa(flexeraavu2.getAbsolutePath()), bl);
        }
        Flexeraawy.ab(n);
        return n;
    }

    private static native int iSendExpandEvent(int var0, String var1, String var2, boolean var3);

    public int launch(boolean bl) throws IOException, Flexeraawy {
        return MacFile.launch(this, bl);
    }

    public static int launch(Flexeraavu flexeraavu, boolean bl) throws IOException, Flexeraawy {
        Toolbox toolbox = Toolbox.LOCK;
        synchronized (toolbox) {
            int n = 0;
            n = MacFile.iLaunch(flexeraavu.getAbsolutePath(), bl);
            try {
                Flexeraawy.ab(n);
                return n;
            }
            catch (MacOSError macOSError) {
                macOSError.printStackTrace();
                throw new Flexeraawy(macOSError);
            }
        }
    }

    private static native int iLaunch(String var0, boolean var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int sendQuitEvent(MRJOSType mRJOSType) throws IOException {
        Toolbox toolbox = Toolbox.LOCK;
        synchronized (toolbox) {
            return MacFile.iSendQuitEvent(mRJOSType.toInt());
        }
    }

    private static native int iSendQuitEvent(int var0);

    private static native int iMoveToTrash(byte[] var0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveToTrash() throws IOException {
        this.iMakeFSSpec();
        try {
            Toolbox toolbox = Toolbox.LOCK;
            synchronized (toolbox) {
                Flexeraawy.ab(MacFile.iMoveToTrash(this.specStruct.getByteArray()));
            }
        }
        catch (Flexeraawy flexeraawy) {
            throw new IOException("Could not move " + this.getPath() + " to trash : " + flexeraawy.aa());
        }
    }

    private boolean isVolume(String string) {
        int n = string.indexOf(File.separator);
        int n2 = string.indexOf(File.separator, n + 1);
        int n3 = string.lastIndexOf(File.separator);
        boolean bl = false;
        if (n == 0) {
            if (n2 > 0) {
                if (n2 == n3 && string.endsWith(File.separator)) {
                    bl = true;
                }
            } else {
                bl = true;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void iMakeFSSpec() {
        if (!this.specMade) {
            if (!this.exists()) {
                this.ah();
            }
            this.specStruct = new FSSpecStruct();
            try {
                String string = this.isVolume(this.getAbsolutePath()) ? this.getCanonicalPath() : this.getAbsolutePath();
                string = MacFile.getMacStylePath(string);
                Toolbox toolbox = Toolbox.LOCK;
                synchronized (toolbox) {
                    Flexeraawy.ac(MacFile.iGetFSSpec(string, this.specStruct.getByteArray()));
                    this.spec = new FSSpec(this.specStruct);
                }
                this.specMade = true;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private static String getMacStylePath(String string) {
        String string2 = ":";
        char c = ':';
        String string3 = "/";
        char c2 = '/';
        Object object = string.replace(c2, c);
        object = ((String)object).startsWith(string2) ? ((String)object).substring(1) : string2 + (String)object;
        object = MacFile.replacePercent2f((String)object);
        return object;
    }

    private static String replacePercent2f(String string) {
        String string2 = "%2f";
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n = 0;
        int n2 = 0;
        do {
            if ((n = string.indexOf(string2, n2)) <= -1) continue;
            stringBuffer.append(string.substring(n2, n));
            stringBuffer.append("/");
            n2 = n + string2.length();
        } while (n != -1);
        stringBuffer.append(string.substring(n2));
        return stringBuffer.toString();
    }

    public FSSpec getFSSpec() {
        this.iMakeFSSpec();
        return this.spec;
    }

    @Override
    public boolean delete() {
        this.iMakeFSSpec();
        short s = FileFunctions.FSpDelete(this.specStruct);
        return s == 0;
    }
}

