/*
 * Decompiled with CFR 0.152.
 */
package com.zerog.util.nativelib.macos;

import com.apple.MacOS.MacOSError;
import com.apple.NativeObject;
import com.zerog.util.ZGUtil;
import com.zerog.util.nativelib.macos.MacFile;
import java.io.File;
import java.io.IOException;

public class MacAliasMaker
implements NativeObject {
    private static String kAliasExtension = new String(" alias");

    private static native int nativeCreateFinderAlias(String var0, String var1, String var2);

    public static File create(File file) throws IOException {
        return MacAliasMaker.create(file, file.getParent());
    }

    public static File create(File file, String string) throws IOException {
        return MacAliasMaker.create(file, file, string);
    }

    public static File create(File file, File file2) throws IOException {
        return MacAliasMaker.create(file, file, file2);
    }

    public static MacFile create(File file, File file2, String string) throws IOException {
        if (!file.exists()) {
            throw new IOException("Source file does not exist!");
        }
        String string2 = Flexeraavu.aa(file);
        String string3 = ZGUtil.removeTrailingSlashes(string2);
        String string4 = ZGUtil.removeTrailingSlashes(string) + "/";
        MacFile macFile = new MacFile(string4 + string3);
        int n = 63 - (string3.length() + kAliasExtension.length());
        int n2 = 0;
        while (macFile.exists()) {
            String string5 = n2 == 0 ? string3 + kAliasExtension : string3 + kAliasExtension + " " + n2;
            macFile = new MacFile(string4 + string5);
            if (++n2 <= (0xA ^ n + 1) - 1) continue;
            throw new IOException("Cannot make alias. All filenames taken");
        }
        return MacAliasMaker.create(file, file2, macFile);
    }

    public static MacFile create(File file, File file2, File file3) throws IOException {
        if (!file.exists()) {
            throw new IOException("Source file does not exist!");
        }
        String string = MacAliasMaker.makeRealPath(file);
        String string2 = MacAliasMaker.makeRealPath(file2);
        try {
            MacOSError.CheckResult(MacAliasMaker.nativeCreateFinderAlias(string, string2, file3.getPath()));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw new IOException("Couldn't create alias at " + file3.getPath());
        }
        return new MacFile(file3);
    }

    private static String makeRealPath(File file) {
        Object object = file.getPath();
        if (file.isDirectory()) {
            if (!((String)object).endsWith(File.separator)) {
                object = (String)object + File.separator;
            }
        } else if (((String)object).endsWith(File.separator)) {
            object = ((String)object).substring(0, ((String)object).length() - File.separator.length());
        }
        return object;
    }
}

