/*
 * Decompiled with CFR 0.152.
 */
package com.zerog.ia.project.file.base.jelly;

import com.zerog.util.ZGUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import org.apache.commons.jelly.JellyContext;
import org.apache.commons.jelly.JellyException;
import org.apache.commons.jelly.XMLOutput;
import org.xml.sax.SAXException;

public abstract class JellyGenerator {
    private static final String CDATA_BEGIN = "<![CDATA[";
    private static final String CDATA_END = "]]>";
    private static final String COMMENT_BEGIN = "<!-- ";
    private static final String COMMENT_END = " -->";
    private static final String POST_REPLACE_BEGIN = "@@";
    private static final String POST_REPLACE_END = "@@";
    private int spacerStartPos = 0;
    private Set postReplace = new HashSet();

    public void generateIAProject(File file) throws IOException {
        if (file.exists()) {
            file.delete();
        }
        new File(file.getAbsolutePath()).getParentFile().mkdirs();
        file.createNewFile();
        this.runScript(this.getVariables(), this.getScript(), file);
    }

    public abstract Hashtable getVariables();

    public abstract File getScript();

    public void runScript(Hashtable hashtable, File file, File file2) throws IOException {
        FileWriter fileWriter = new FileWriter(file2);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XMLOutput xMLOutput = XMLOutput.createXMLOutput((OutputStream)byteArrayOutputStream);
        try {
            xMLOutput.processingInstruction("xml", "version=\"1.0\" encoding=\"UTF-8\"");
            JellyContext jellyContext = new JellyContext();
            if (hashtable != null) {
                jellyContext.setVariables((Map)hashtable);
            }
            jellyContext.runScript(file, xMLOutput);
            byteArrayOutputStream.flush();
            String string = ((Object)byteArrayOutputStream).toString();
            for (String string2 : this.postReplace) {
                String string3 = jellyContext.getVariable(string2).toString();
                if (string3 == null) {
                    string3 = "";
                }
                string = string.replaceAll("@@" + string2 + "@@", string3);
            }
            fileWriter.write(string);
        }
        catch (JellyException jellyException) {
            throw new IOException(jellyException.getMessage());
        }
        catch (SAXException sAXException) {
            throw new IOException(sAXException.getMessage());
        }
        finally {
            xMLOutput.close();
            ((OutputStream)byteArrayOutputStream).close();
            fileWriter.close();
        }
    }

    public String postReplace(String string) {
        this.postReplace.add(string);
        return "@@" + string + "@@";
    }

    public String makeComment(Object object) {
        return COMMENT_BEGIN + object.toString() + COMMENT_END;
    }

    public String makeCData(Object object) {
        return CDATA_BEGIN + this.normalizeString(object) + CDATA_END;
    }

    public String normalizeString(Object object) {
        return ZGUtil.normalizeLineEndings(object.toString(), true, true, true, "\n");
    }

    public void setSpacerStartPos(int n) {
        this.spacerStartPos = n;
    }

    public int getSpacerStartPos() {
        return this.spacerStartPos;
    }

    public String spaceBy(int n) {
        n += this.spacerStartPos;
        StringBuffer stringBuffer = new StringBuffer("\n");
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("    ");
        }
        return stringBuffer.toString();
    }
}

